/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.exp;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.zip.ZipFile;
import org.apache.commons.beanutils.ConvertUtils;

public class ImportFileRepoTask {
    private static final Log logger = LogFactory.getLog(ImportFileRepoTask.class);
    private String repoFilePath;
    private String attachmentsZipPath;
    Map<String, String> mapColType = new LinkedHashMap<String, String>();

    public ImportFileRepoTask(String repoFilePath, String attachmentsZipPath) {
        this.attachmentsZipPath = attachmentsZipPath;
        this.repoFilePath = repoFilePath;
    }

    public void importData() {
        logger.info("\u6587\u6863\u77e5\u8bc6\u5e93\u3010gai_repo_info\u3011\u5f00\u59cb\u5f15\u5165\u3002");
        this.importBillData();
        logger.info("\u6587\u6863\u77e5\u8bc6\u5e93\u3010gai_repo_info\u3011\u5f15\u5165\u5b8c\u6210\u3002");
        logger.info("\u6587\u6863\u77e5\u8bc6\u5e93\u3010gai_repo_info\u3011\u7684\u5206\u5f55\u9644\u4ef6 \u5f00\u59cb\u5f15\u5165\u3002");
        this.importAttachments();
        logger.info("\u6587\u6863\u77e5\u8bc6\u5e93\u3010gai_repo_info\u3011\u7684\u5206\u5f55\u9644\u4ef6 \u5f15\u5165\u5b8c\u6210\u3002");
    }

    private void importAttachments() {
        try {
            File zipFile = new File(this.attachmentsZipPath);
            File parentFile = zipFile.getParentFile();
            ZipFile attachZipFile = new ZipFile(this.attachmentsZipPath);
            attachZipFile.extractAll(parentFile.getPath());
            File attaDirectory = new File(parentFile, "attachments");
            File[] attachFiles = attaDirectory.listFiles();
            if (attachFiles == null) {
                return;
            }
            LinkedHashMap<Long, Path> mapUploadFiles = new LinkedHashMap<Long, Path>(20);
            logger.info("\u5f85\u5f15\u5165\u603b\u9644\u4ef6\u6570" + attachFiles.length);
            for (int i = 0; i < attachFiles.length; ++i) {
                File attachmentFile = attachFiles[i];
                int splitIndex = attachmentFile.getName().indexOf("_");
                long entryPkId = Long.parseLong(attachmentFile.getName().substring(0, splitIndex));
                mapUploadFiles.put(entryPkId, attachmentFile.toPath());
                if ((i + 1) % 20 != 0) continue;
                this.batchImportAttachments(mapUploadFiles);
                mapUploadFiles = new LinkedHashMap(20);
            }
            if (!mapUploadFiles.isEmpty()) {
                this.batchImportAttachments(mapUploadFiles);
            }
        }
        catch (Exception ex) {
            logger.error("\u5f15\u5165\u77e5\u8bc6\u5e93\u7684\u6587\u6863\u9644\u4ef6\u5931\u8d25", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchImportAttachments(Map<Long, Path> mapEntryFiles) throws IOException {
        ArrayList<Long> allEntryPkIds = new ArrayList<Long>(mapEntryFiles.keySet());
        DynamicObjectCollection dRepoPkObjs = QueryServiceHelper.query((String)"gai_repo_info", (String)"id,doc_manage.id,doc_manage.file_name,doc_manage.file_path,doc_manage.log", (QFilter[])new QFilter[]{new QFilter("doc_manage.id", "in", allEntryPkIds)}, (String)"id desc");
        HashMap<Long, Long> mapEntryPkId = new HashMap<Long, Long>();
        ArrayList<Long> repoPkIds = new ArrayList<Long>();
        HashMap<Long, String> mapDeleteFiles = new HashMap<Long, String>();
        LinkedHashMap<Long, FileItem> mapUploadFileItem = new LinkedHashMap<Long, FileItem>();
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        try {
            for (DynamicObject dObjRepo : dRepoPkObjs) {
                long entryPkId = dObjRepo.getLong("doc_manage.id");
                long repoPkId = dObjRepo.getLong("id");
                String fileName = dObjRepo.getString("doc_manage.file_name");
                String filePath = dObjRepo.getString("doc_manage.file_path");
                String uuid = UUID.randomUUID().toString().replace("-", "");
                if (dObjRepo.getString("doc_manage.log").equals("import success")) {
                    mapDeleteFiles.put(entryPkId, filePath);
                }
                repoPkIds.add(repoPkId);
                mapEntryPkId.put(entryPkId, repoPkId);
                String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)"gai", (String)"gai_repo_info", (Object)entryPkId, (String)(uuid + "/" + fileName));
                FileItem fileItem = new FileItem(fileName, path, Files.newInputStream(mapEntryFiles.get(entryPkId), new OpenOption[0]));
                mapUploadFileItem.put(entryPkId, fileItem);
            }
            if (mapUploadFileItem.isEmpty()) {
                logger.info("\u6587\u6863\u77e5\u8bc6\u5e93\u3010gai_repo_info\u3011\u9644\u4ef6\u6279\u6b21\u4e0a\u4f20\uff1a\u6ca1\u6709\u9644\u4ef6\u9700\u8981\u5bfc\u5165\u3002");
                return;
            }
            ArrayList entryPkIds = new ArrayList(mapUploadFileItem.keySet());
            ArrayList uploadFileItems = new ArrayList(mapUploadFileItem.values());
            logger.info(String.format("\u6587\u6863\u77e5\u8bc6\u5e93\u3010gai_repo_info\u3011\u9644\u4ef6\u6279\u6b21\u4e0a\u4f20\uff1a\u5171%s\u4e2a\u9644\u4ef6\u3002\n\u6587\u4ef6\u5217\u8868\u4fe1\u606f\uff1a\n%s", uploadFileItems.size(), JSON.toJSONString(uploadFileItems)));
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            List uploadPathList = fileService.upload(uploadFileItems.toArray(new FileItem[0]));
            logger.info("\u9644\u4ef6\u4e0a\u4f20\u6210\u529f");
            Map repoDatas = BusinessDataServiceHelper.loadFromCache((Object[])repoPkIds.toArray(), (String)"gai_repo_info");
            block7: for (int i = 0; i < entryPkIds.size(); ++i) {
                long entryPkId = (Long)entryPkIds.get(i);
                String path = (String)uploadPathList.get(i);
                DynamicObject repo = (DynamicObject)repoDatas.get(mapEntryPkId.get(entryPkId));
                DynamicObjectCollection entryRows = repo.getDynamicObjectCollection("doc_manage");
                for (DynamicObject row : entryRows) {
                    if (!row.getPkValue().equals(entryPkId)) continue;
                    row.set("file_path", (Object)path);
                    row.set("log", (Object)"import success");
                    continue block7;
                }
            }
            logger.info(String.format("\u5171\u9700%s\u4e2a\u77e5\u8bc6\u5e93\u7684\u5206\u5f55\u9644\u4ef6\u4fe1\u606f", repoDatas.size()));
            logger.info(String.format("\u9700\u66f4\u65b0\u7684\u77e5\u8bc6\u5e93ID\u5217\u8868\uff1a%s", JSON.toJSONString(repoDatas.keySet())));
            SaveServiceHelper.save((DynamicObject[])repoDatas.values().toArray(new DynamicObject[0]));
            logger.info("\u66f4\u65b0\u77e5\u8bc6\u5e93\u5206\u5f55\u7684\u9644\u4ef6\u4fe1\u606f\u6210\u529f\u3002");
            try {
                logger.info(String.format("\u6587\u6863\u77e5\u8bc6\u5e93\u3010gai_repo_info\u3011\u9644\u4ef6\u6279\u6b21\u4e0a\u4f20\uff1a\u5171%s\u4e2a\u9644\u4ef6\uff0c\u5df2\u88ab\u5bfc\u5165\u6210\u529f\u8fc7\uff0c\u5220\u9664\u9644\u4ef6\u3002", mapDeleteFiles.size()));
                logger.info(String.format("\u5df2\u88ab\u5bfc\u5165\u6210\u529f\u8fc7\u7684\u5206\u5f55ID\uff1a%s", JSON.toJSONString(mapDeleteFiles)));
                for (String oldPath : mapDeleteFiles.values()) {
                    fileService.delete(oldPath);
                }
            }
            catch (Exception ex) {
                logger.error("\u5220\u9664\u65e7\u7684\u9644\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)ex);
            }
        }
        finally {
            if (!mapUploadFileItem.isEmpty()) {
                for (Map.Entry entry : mapUploadFileItem.entrySet()) {
                    ((FileItem)entry.getValue()).close();
                }
            }
        }
    }

    private void importBillData() {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.repoFilePath));){
            String line;
            int rowIndex = 0;
            String colNames = "";
            ArrayList<DynamicObject> importDataRows = new ArrayList<DynamicObject>();
            DynamicObject preBill = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (rowIndex == 0) {
                    colNames = line;
                } else if (rowIndex == 1) {
                    String[] arrColNames = colNames.split(",");
                    String[] arrColTypes = line.split(",");
                    for (int i = 0; i < arrColNames.length; ++i) {
                        this.mapColType.put(arrColNames[i], arrColTypes[i]);
                    }
                } else {
                    String[] colValues = line.split(",");
                    if (StringUtils.isNotEmpty((CharSequence)colValues[0])) {
                        DynamicObject rowData = this.createDynamicObject("gai_repo_info", colValues);
                        this.addEntryRowData(rowData, colValues);
                        importDataRows.add(rowData);
                        preBill = rowData;
                    } else if (preBill != null) {
                        this.addEntryRowData(preBill, colValues);
                    }
                }
                if ((++rowIndex + 1) % 100 != 0) continue;
                SaveServiceHelper.save((DynamicObject[])importDataRows.toArray(new DynamicObject[0]));
                logger.info(String.format("\u6587\u6863\u77e5\u8bc6\u5e93\u3010gai_repo_info\u3011\u6210\u529f\u5f15\u5165%s\u6570\u636e", importDataRows.size()));
                importDataRows = new ArrayList();
            }
            if (!importDataRows.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])importDataRows.toArray(new DynamicObject[0]));
                logger.info(String.format("\u6587\u6863\u77e5\u8bc6\u5e93\u3010gai_repo_info\u3011\u6210\u529f\u5f15\u5165%s\u6570\u636e", importDataRows.size()));
            }
        }
        catch (Exception ex) {
            logger.error("\u5199\u5165\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
    }

    private void addEntryRowData(DynamicObject preBill, String[] colValues) {
        HashMap<Object, Object> mapEntryFiledValues = new HashMap<Object, Object>();
        int colIndex = 0;
        for (Map.Entry<String, String> entry : this.mapColType.entrySet()) {
            String fielName = entry.getKey();
            if (fielName.contains(".")) {
                String entryFieldName = fielName.split("\\.")[1];
                mapEntryFiledValues.put(entryFieldName, this.convertValue(colValues[colIndex], entry.getValue()));
            }
            ++colIndex;
        }
        Object entryPkId = mapEntryFiledValues.get("id");
        DynamicObjectCollection entryRows = preBill.getDynamicObjectCollection("doc_manage");
        DynamicObject targetRow = null;
        for (DynamicObject row : entryRows) {
            if (!row.getPkValue().equals(entryPkId)) continue;
            targetRow = row;
            break;
        }
        if (targetRow == null) {
            int seq = entryRows.size() + 1;
            targetRow = entryRows.addNew();
            targetRow.set("seq", (Object)seq);
        }
        for (Map.Entry fieldValue : mapEntryFiledValues.entrySet()) {
            targetRow.set((String)fieldValue.getKey(), fieldValue.getValue());
        }
    }

    private DynamicObject createDynamicObject(String entityNumber, String[] colValues) {
        Map.Entry<String, String> entry;
        String fielName;
        DynamicObject data;
        long pkId = Long.parseLong(colValues[0]);
        if (QueryServiceHelper.exists((String)entityNumber, (Object)pkId)) {
            data = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityNumber);
        } else {
            data = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
            data.set("useorg", (Object)RequestContext.get().getOrgId());
        }
        int colIndex = 0;
        Iterator<Map.Entry<String, String>> iterator = this.mapColType.entrySet().iterator();
        while (iterator.hasNext() && !(fielName = (entry = iterator.next()).getKey()).contains(".")) {
            data.set(fielName, this.convertValue(colValues[colIndex], entry.getValue()));
            ++colIndex;
        }
        return data;
    }

    private Object convertValue(String value, String targetClassName) {
        if (targetClassName.contains("Timestamp")) {
            return this.convertToDate(value);
        }
        Class<?> targetClass = null;
        try {
            targetClass = Class.forName(targetClassName);
            Constructor<?> stringConstructor = targetClass.getConstructor(String.class);
            return stringConstructor.newInstance(value);
        }
        catch (Exception ex) {
            logger.error(String.format("\u503c[%s]\u8f6c\u6362\u4e3a\u7c7b\u578b[%s]\u5931\u8d25", value, targetClassName), (Throwable)ex);
            if (targetClass != null) {
                return ConvertUtils.convert((String)value, targetClass);
            }
            return null;
        }
    }

    private Object convertToDate(String value) {
        Object newValue = null;
        if (StringUtils.isNumeric((CharSequence)value)) {
            long longTime = Long.parseLong(value);
            newValue = ConvertUtils.convert((Object)longTime, Date.class);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                newValue = sdf.parse(value);
            }
            catch (ParseException ex) {
                logger.error(String.format("\u503c[%s]\u8f6c\u6362\u4e3a\u7c7b\u578b[%s]\u5931\u8d25", value, Date.class.getName()), (Throwable)ex);
            }
        }
        return newValue;
    }

    public String getRepoFilePath() {
        return this.repoFilePath;
    }

    public void setRepoFilePath(String repoFilePath) {
        this.repoFilePath = repoFilePath;
    }

    public String getAttachmentsZipPath() {
        return this.attachmentsZipPath;
    }

    public void setAttachmentsZipPath(String attachmentsZipPath) {
        this.attachmentsZipPath = attachmentsZipPath;
    }
}

