/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.exp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.entity.StructRepo;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ImportTableRepoDataTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ImportTableRepoDataTask.class);
    private long structRepoId;
    private StructRepo structRepo;
    private boolean isAutoImportBySchedule;
    private Map<String, Object> result = new HashMap<String, Object>(2);
    private DynamicObject createOrg;

    private void fail(String message) {
        this.result.put("error", message);
        this.result.put("success", "false");
        this.feedbackCustomdata(this.result);
    }

    private void success() {
        this.result.put("success", "true");
        this.feedbackCustomdata(this.result);
    }

    private void setAllCount(int count) {
        this.result.put("count", count);
    }

    private void success(int dealCount) {
        this.result.put("dealCount", dealCount);
    }

    private int getDealCount() {
        return Integer.parseInt(this.result.getOrDefault("dealCount", 0).toString());
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.verifyParams(map);
        this.isAutoImportBySchedule = (Boolean)map.getOrDefault("isAutoImportBySchedule", false);
        try {
            String entityNumber = this.structRepo.getSourceBizObjectNumber();
            ILocaleString name = this.structRepo.getSourceBizObjectName();
            this.feedbackProgress(1, String.format("\u6b63\u5728\u67e5\u8be2\u5f85\u5bfc\u5165\u7684[%s]\u6570\u636e", name.getLocaleValue()), null);
            if (map.containsKey("bizObjectFilterString")) {
                this.importDataByFilter(entityNumber, map);
            } else {
                this.importDataByPKIDS(entityNumber, map);
            }
            this.success();
        }
        catch (KDException ex) {
            this.fail(ex.getErrorCode().getMessage());
            throw ex;
        }
        catch (Exception ex) {
            logger.error("\u5bfc\u5165\u6570\u636e\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)ex);
            String sMessage = String.format("\u5bfc\u5165\u6570\u636e\u53d1\u751f\u5f02\u5e38:%s", StringUtils.isEmpty((CharSequence)ex.getMessage()) ? ex.toString() : ex.getMessage());
            this.fail(sMessage);
            throw new KDException(new ErrorCode("gai.TableRepo.importTableData", sMessage), new Object[]{ex});
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    private void importDataByPKIDS(String entityNumber, Map<String, Object> map) {
        int count = Integer.parseInt(map.getOrDefault("selectedCount", "0").toString());
        String[] batchKeys = map.getOrDefault("batchKeys", "").toString().split(",");
        this.feedbackProgress(2, String.format("\u5f85\u5bfc\u5165[%s]\u6761\u6570\u636e\uff0c\u5206%s\u6279\u5904\u7406\u3002", count, batchKeys.length), null);
        if (count <= 0) {
            this.feedbackProgress(100, "\u5f85\u5bfc\u51650\u6761\u6570\u636e\uff0c\u65e0\u9700\u5904\u7406\u3002", null);
            return;
        }
        this.setAllCount(count);
        int dealCount = 0;
        int pageSize = 0;
        List<StructRepoField> repoFieldList = this.structRepo.getFields();
        StringBuilder sbSelectFields = new StringBuilder();
        sbSelectFields.append(String.format("%s,", "id"));
        for (StructRepoField field : repoFieldList) {
            if (!StringUtils.isNotEmpty((CharSequence)field.getSourceFieldKey()) || field.getSourceFieldKey().equals("id")) continue;
            sbSelectFields.append(String.format("%s,", field.getSourceFieldKey()));
        }
        if (sbSelectFields.indexOf("modifytime") < 0) {
            sbSelectFields.append(String.format("%s,", "modifytime"));
        }
        sbSelectFields.deleteCharAt(sbSelectFields.length() - 1);
        ORM queryOrm = ORM.create();
        for (int i = 1; i <= batchKeys.length; ++i) {
            dealCount = this.getDealCount();
            this.checkIsStop();
            this.feedbackProgress(i, count, dealCount);
            String pkIdsString = map.getOrDefault(batchKeys[i - 1], "").toString();
            String[] pkIds = pkIdsString.split(",");
            ArrayList<Long> pkIdList = new ArrayList<Long>(pkIds.length);
            for (String pkId : pkIds) {
                pkIdList.add(Long.parseLong(pkId));
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pkIdList)};
            DataSet dataSet = queryOrm.queryDataSet(String.format("AlgoKey_%s_%s", ((Object)((Object)this)).getClass().getName(), "queryData"), entityNumber, sbSelectFields.toString(), qFilters, String.format("%s asc", "modifytime"));
            pageSize = pkIds.length;
            this.saveDataFromDataSet(dataSet, i, count, dealCount, pageSize);
        }
    }

    private void saveDataFromDataSet(DataSet dataSet, int batchIndex, int allCount, int dealCount, int pageSize) {
        List<StructRepoField> repoFieldList = this.structRepo.getFields();
        HashMap<Object, DynamicObject> mapRepoDatas = new HashMap<Object, DynamicObject>(pageSize);
        int curSaveCount = 0;
        while (dataSet.hasNext()) {
            this.checkIsStop();
            Row row = dataSet.next();
            Object rowId = row.get("id");
            mapRepoDatas.put(rowId, this.buildNewTableRepoData(row, repoFieldList));
            this.feedbackProgress(batchIndex, allCount, dealCount + ++curSaveCount);
            if (curSaveCount % 1000 != 0) continue;
            this.batchSaveData(mapRepoDatas, repoFieldList);
            this.feedbackProgress(batchIndex, allCount, dealCount += curSaveCount);
            this.success(dealCount);
            curSaveCount = 0;
            mapRepoDatas.clear();
        }
        if (!mapRepoDatas.isEmpty()) {
            this.batchSaveData(mapRepoDatas, repoFieldList);
            this.feedbackProgress(batchIndex, allCount, dealCount += curSaveCount);
            this.success(dealCount);
        }
    }

    private void importDataByFilter(String entityNumber, Map<String, Object> map) throws Exception {
        String filterString = map.getOrDefault("bizObjectFilterString", "").toString();
        List filterStringList = (List)JSON.parseObject((String)filterString, (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(filterStringList.size());
        filterStringList.forEach(strFilter -> qFilterList.add(QFilter.fromSerializedString((String)strFilter)));
        if (map.containsKey("lastUpdateTime")) {
            Date lastUpdateTime = (Date)map.get("lastUpdateTime");
            qFilterList.add(new QFilter("modifytime", ">=", (Object)lastUpdateTime));
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        ORM queryOrm = ORM.create();
        int count = queryOrm.count(String.format("AlgoKey_%s_%s", ((Object)((Object)this)).getClass().getName(), "count"), entityNumber, qFilters);
        if (count <= 0) {
            this.feedbackProgress(100, "\u67e5\u8be2\u52300\u6761\u6570\u636e\uff0c\u65e0\u9700\u5904\u7406\u3002", null);
            return;
        }
        this.setAllCount(count);
        int pageSize = 10000;
        int batchCount = count / pageSize + (count % pageSize > 0 ? 1 : 0);
        this.feedbackProgress(2, String.format("\u67e5\u8be2\u5230[%s]\u6761\u6570\u636e\uff0c\u5206%s\u6279\u5904\u7406\u3002", count, batchCount), null);
        int dealCount = 0;
        int fromIndex = 0;
        List<StructRepoField> repoFieldList = this.structRepo.getFields();
        StringBuilder sbSelectFields = new StringBuilder();
        sbSelectFields.append(String.format("%s,", "id"));
        for (StructRepoField field : repoFieldList) {
            if (!StringUtils.isNotEmpty((CharSequence)field.getSourceFieldKey()) || field.getSourceFieldKey().equals("id")) continue;
            sbSelectFields.append(String.format("%s,", field.getSourceFieldKey()));
        }
        if (sbSelectFields.indexOf("modifytime") < 0) {
            sbSelectFields.append(String.format("%s,", "modifytime"));
        }
        sbSelectFields.deleteCharAt(sbSelectFields.length() - 1);
        for (int i = 1; i <= batchCount; ++i) {
            this.checkIsStop();
            dealCount = this.getDealCount();
            this.feedbackProgress(i, count, dealCount);
            DataSet dataSet = queryOrm.queryDataSet(String.format("AlgoKey_%s_%s", ((Object)((Object)this)).getClass().getName(), "queryData"), entityNumber, sbSelectFields.toString(), qFilters, String.format("%s asc", "modifytime"), fromIndex, pageSize);
            this.saveDataFromDataSet(dataSet, i, count, dealCount, pageSize);
            fromIndex += pageSize;
        }
    }

    private void feedbackProgress(int batchNum, int allCount, int dealcount) {
        String curBatchDesc = String.format("\u6b63\u5728\u5bfc\u5165\u7b2c%s\u6279\u6570\u636e\u3002%s/%s", batchNum, dealcount, allCount);
        this.feedbackProgress(dealcount * 100 / allCount, curBatchDesc, null);
    }

    private void verifyParams(Map<String, Object> map) {
        this.feedbackProgress(0, "\u6b63\u5728\u6821\u9a8c\u5bfc\u5165\u4efb\u52a1\u7684\u53c2\u6570", null);
        long structRepoPkId = 0L;
        Object structRepoPkValue = map.getOrDefault("StructRepoID", null);
        if (structRepoPkValue != null) {
            structRepoPkId = Long.parseLong(structRepoPkValue.toString());
        }
        if (structRepoPkId <= 0L) {
            throw new KDBizException("\u77e5\u8bc6\u5e93ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        this.structRepoId = structRepoPkId;
        this.structRepo = GaiStructRepoHelper.queryStructRepo(structRepoPkId);
        if (!this.structRepo.getRepoType().equals(RepoConstant.RepoType.TABLE.getType())) {
            throw new KDBizException("\u8be5\u77e5\u8bc6\u5e93\u4e0d\u662f\u8868\u683c\u77e5\u8bc6\u5e93\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)this.structRepo.getSourceBizObjectNumber())) {
            throw new KDBizException("\u8be5\u77e5\u8bc6\u5e93\u672a\u8bbe\u7f6e\u6765\u6e90\u4e1a\u52a1\u5bf9\u8c61\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\u3002");
        }
    }

    private void batchSaveData(Map<Object, DynamicObject> mapNewDatas, List<StructRepoField> repoFieldList) {
        Map mapOldDatas = BusinessDataServiceHelper.loadFromCache((String)"gai_table_repo", (QFilter[])new QFilter[]{new QFilter("srcid", "in", (Object)mapNewDatas.keySet().toArray()), new QFilter("structrepo", "=", (Object)this.structRepoId)});
        for (Map.Entry entry : mapOldDatas.entrySet()) {
            DynamicObject oldData = (DynamicObject)entry.getValue();
            Long srcId = oldData.getLong("srcid");
            DynamicObject newData = mapNewDatas.get(srcId);
            if (newData.get("autosrcmodifytime") != null) {
                oldData.set("autosrcmodifytime", newData.get("autosrcmodifytime"));
            }
            for (StructRepoField field : repoFieldList) {
                if (StringUtils.isEmpty((CharSequence)field.getSourceFieldKey())) continue;
                String fieldName = field.getFieldName();
                String fieldName_tag = field.getFieldName() + "_tag";
                oldData.set(fieldName, newData.get(fieldName));
                oldData.set(fieldName_tag, newData.get(fieldName_tag));
            }
            mapNewDatas.put(srcId, oldData);
        }
        OperationResult result = SaveServiceHelper.saveOperate((String)"gai_table_repo", (DynamicObject[])mapNewDatas.values().toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        int successCount = result.getSuccessPkIds().size();
        if (result.isSuccess()) {
            logger.info(String.format("\u6210\u529f\u5bfc\u5165%s\u6761\u6570\u636e", successCount));
        } else {
            logger.info(String.format("\u6210\u529f\u5bfc\u5165%s\u6761\u6570\u636e,\u5931\u8d25%s\u6761\u6570\u636e\u3002", successCount, mapNewDatas.size() - successCount));
            logger.info(String.format("\u5bfc\u5165\u5931\u8d25\u539f\u56e0\uff1a%s", this.getOperationResultMessage(result)));
        }
    }

    private DynamicObject buildNewTableRepoData(Row row, List<StructRepoField> repoFieldList) {
        DynamicObject repoData = BusinessDataServiceHelper.newDynamicObject((String)"gai_table_repo");
        repoData.set("srcid", (Object)row.getLong("id"));
        if (this.isAutoImportBySchedule) {
            repoData.set("autosrcmodifytime", (Object)row.getDate("modifytime"));
        }
        repoData.set("name", (Object)"\u77e5\u8bc6\u6570\u636e");
        repoData.set("structrepo", (Object)this.structRepoId);
        repoData.set("datastatus", (Object)RepoConstant.RepoDataStatus.NONE.getStatus());
        repoData.set("enable", (Object)"1");
        repoData.set("creator", (Object)RequestContext.get().getCurrUserId());
        repoData.set("modifier", (Object)RequestContext.get().getCurrUserId());
        repoData.set("createorg", (Object)this.getCreateOrg());
        repoData.set("ctrlstrategy", (Object)5);
        repoData.set("operation", (Object)"add");
        for (StructRepoField field : repoFieldList) {
            Object objValue;
            if (StringUtils.isEmpty((CharSequence)field.getSourceFieldKey()) || (objValue = row.get(field.getSourceFieldKey())) == null) continue;
            repoData.set(field.getFieldName(), (Object)objValue.toString());
            repoData.set(field.getFieldName() + "_tag", (Object)objValue.toString());
        }
        return repoData;
    }

    private DynamicObject getCreateOrg() {
        if (this.createOrg == null) {
            this.createOrg = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getOrgId(), (String)"bos_org", (String)String.format("%s,%s,%s", "id", "name", "number"));
        }
        return this.createOrg;
    }

    public String getOperationResultMessage(OperationResult opResult) {
        StringBuilder sbMessage = new StringBuilder();
        sbMessage.append(opResult.getMessage());
        List operateInfos = opResult.getAllErrorOrValidateInfo();
        for (IOperateInfo info : operateInfos) {
            sbMessage.append('\n');
            sbMessage.append(info.getMessage());
        }
        return sbMessage.toString();
    }
}

