/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.exp;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;

public class ImportTableRepoDataTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        IFormView parentView = this.getParentView();
        if (taskInfo.isTaskEnd()) {
            this.showTaskResult(parentView, taskInfo);
        } else {
            this.showProgressForm(parentView);
        }
    }

    private void showTaskResult(IFormView parentView, TaskInfo taskInfo) {
        boolean bNeedSendAction = true;
        if (parentView == null) {
            parentView = this.getMainView();
            bNeedSendAction = false;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
        boolean bSuccess = data.getOrDefault("success", "false").equals("true");
        int dealCount = Integer.parseInt(data.getOrDefault("dealCount", "0").toString());
        int count = Integer.parseInt(data.getOrDefault("count", "0").toString());
        String error = data.getOrDefault("error", "").toString();
        if (bSuccess) {
            parentView.showMessage(String.format("\u5bfc\u5165\u5b8c\u6210\u3002\u5171%s\u6761\u8bb0\u5f55\uff0c\u5bfc\u5165%s\u6761\u8bb0\u5f55\u3002", count, dealCount));
        } else {
            parentView.showErrMessage(String.format("\u5bfc\u5165\u5931\u8d25\u3002\n%s", error), String.format("\u5931\u8d25\u8be6\u7ec6\u4fe1\u606f:\ntraceId:%s\n%s", taskInfo.getTraceId(), taskInfo.getFailureReason()));
        }
        if (bNeedSendAction) {
            this.getMainView().sendFormAction(parentView);
        }
    }

    private void showProgressForm(IFormView parentView) {
        if (parentView == null) {
            this.getMainView().showMessage("\u542f\u52a8\u4efb\u52a1\u7684\u9875\u9762\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u80fd\u518d\u6253\u5f00\u8fdb\u5ea6\u754c\u9762");
            return;
        }
        if (!this.isExistProgressForm()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("sch_taskprogress");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            if (StringUtils.isBlank((CharSequence)this.getJobFormInfo().getCaption())) {
                showParameter.setCaption(this.getJobFormInfo().getCaption());
            }
            showParameter.getCustomParams().put("ServiceAppId", this.getJobFormInfo().getJobInfo().getAppId());
            String jobInfoStr = SerializationUtils.toJsonString((Object)this.getJobFormInfo());
            showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
            showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
            showParameter.setCloseCallBack(this.getJobFormInfo().getCloseCallBack());
            parentView.showForm(showParameter);
            this.getMainView().sendFormAction(parentView);
            this.setProgressPageId(showParameter.getPageId());
        }
    }
}

