/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.exp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;

public class ZipUtil {
    private static byte[] ZIP_HEADER_1 = new byte[]{80, 75, 3, 4};
    private static byte[] ZIP_HEADER_2 = new byte[]{80, 75, 5, 6};
    private static byte[] RAR_HEADER = new byte[]{82, 97, 114, 33, 26, 7};

    public static String getArchiveFileType(File file) {
        if (ZipUtil.isZipArchiveFile(file)) {
            return "zip";
        }
        if (ZipUtil.isRarArchiveFile(file)) {
            return "rar";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipArchiveFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        boolean isArchive = false;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            byte[] buffer = new byte[4];
            int length = ((InputStream)input).read(buffer, 0, 4);
            if (length == 4) {
                isArchive = Arrays.equals(ZIP_HEADER_1, buffer) || Arrays.equals(ZIP_HEADER_2, buffer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
        }
        return isArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRarArchiveFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        boolean isArchive = false;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            byte[] buffer = new byte[6];
            int length = ((InputStream)input).read(buffer, 0, 6);
            if (length == 6) {
                isArchive = Arrays.equals(RAR_HEADER, buffer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
        }
        return isArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(File sourceFile, File destDir) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(sourceFile));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = ZipUtil.newFile(destDir, zipEntry);
                FileOutputStream fos = null;
                try {
                    int len;
                    fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                catch (Exception exception) {
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (Exception exception) {
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = FileUtils.getFile((File)destinationDir, (String[])new String[]{zipEntry.getName()});
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("\u8be5\u89e3\u538b\u9879\u5728\u76ee\u6807\u6587\u4ef6\u5939\u4e4b\u5916: " + zipEntry.getName());
        }
        return destFile;
    }
}

