/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.helper;

import io.milvus.grpc.QueryResults;
import io.milvus.param.R;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.response.QueryResultsWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.repo.RepoFulltextData;
import kd.ai.gai.core.domain.dto.repo.RepoFulltextDeleteParam;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.rag.milvus.MilvusBaseDao;
import kd.ai.gai.core.rag.milvus.MilvusClientFactory;
import kd.ai.gai.core.rag.milvus.MilvusService;
import kd.ai.gai.core.rag.service.RepoFulltextService;
import kd.ai.gai.core.repo.entity.FileRepoChunkExportData;
import kd.ai.gai.core.repo.entity.FileRepoExportChunkDataParam;
import kd.ai.gai.core.repo.entity.FileRepoExportVectorDataParam;
import kd.ai.gai.core.repo.entity.FileRepoVectorExportData;
import kd.ai.gai.core.repo.entity.QueryDataResult;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.vdb.VDBServiceManager;
import kd.ai.gai.core.service.vdb.service.VDBService;
import kd.ai.vdb.Filter;
import kd.ai.vdb.QueryParameters;
import kd.ai.vdb.objects.CollectionData;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GaiFileRepoDataServiceHelper {
    private static final Log logger = LogFactory.getLog(GaiFileRepoDataServiceHelper.class);
    private static final int batchSiz = 1000;
    private static final String[] selectFields = new String[]{"repoId", "vector"};

    public static QueryDataResult<List<FileRepoChunkExportData>> queryExportChunkData(FileRepoExportChunkDataParam exportDataParam) {
        logger.info("\u3010\u6587\u6863\u578b\u77e5\u8bc6\u5e93\u3011\u5206\u5757\u6570\u636e\u5bfc\u51fa-\u6570\u636e\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JsonUtil.toJson(exportDataParam));
        Long repoId = exportDataParam.getRepoId();
        Long pageSize = exportDataParam.getPageSize();
        Long startNum = exportDataParam.getStartNum();
        if (repoId == null) {
            throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u51fa-\u6570\u636e\u67e5\u8be2\u53c2\u6570\uff0crepoId\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (pageSize < 1L) {
            throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u51fa-\u6570\u636e\u67e5\u8be2\u53c2\u6570\uff0cpageSize>0\uff0c\u8bf7\u68c0\u67e5");
        }
        if (startNum < 1L) {
            throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u51fa-\u6570\u636e\u67e5\u8be2\u53c2\u6570\uff0cstartNum>0\uff0c\u8bf7\u68c0\u67e5");
        }
        startNum = startNum - 1L;
        String selectFields = "id,repoid,fileid,pageid,order,content_tag,title,url,source,businessId,status,code_content_tag,strigtotal";
        String sql = "select id,repoid,fileid,pageid,order,content_tag,title,url,source,businessId,status,code_content_tag,strigtotal";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)GaiFileRepoDataServiceHelper.class.getName(), (String)"gai_text_chunk", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("repoid", "=", (Object)repoId)}, (String)"id");
        dataSet = dataSet.limit(startNum.intValue(), pageSize.intValue()).orderBy(new String[]{"id"}).executeSql(sql);
        ArrayList<FileRepoChunkExportData> dataList = new ArrayList<FileRepoChunkExportData>();
        for (Row rowData : dataSet) {
            Long id = rowData.getLong("id");
            rowData.getLong("repoId");
            Long fileid = rowData.getLong("fileid");
            Integer pageid = rowData.getInteger("pageid");
            Integer order = rowData.getInteger("order");
            String content = rowData.getString("content_tag");
            String title = rowData.getString("title");
            String url = rowData.getString("url");
            String source = rowData.getString("source");
            Long businessId = rowData.getLong("businessId");
            String status = rowData.getString("status");
            String code_content = rowData.getString("code_content_tag");
            Long strigtotal = rowData.getLong("strigtotal");
            FileRepoChunkExportData exportData = new FileRepoChunkExportData(id, fileid, repoId, pageid, order, content, title, url, source, businessId, status, strigtotal, code_content);
            dataList.add(exportData);
        }
        QueryDataResult<List<FileRepoChunkExportData>> queryDataResult = new QueryDataResult<List<FileRepoChunkExportData>>();
        DataSet dataSetCount = QueryServiceHelper.queryDataSet((String)GaiFileRepoDataServiceHelper.class.getName(), (String)"gai_text_chunk", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("repoid", "=", (Object)repoId)}, (String)"id");
        int tatal = dataSetCount.count("id", false);
        queryDataResult.setTotalNum(Long.parseLong(String.valueOf(tatal)));
        queryDataResult.setPageSize(pageSize);
        queryDataResult.setStartNum(startNum);
        queryDataResult.setData(dataList);
        logger.info("\u3010\u6587\u6863\u578b\u77e5\u8bc6\u5e93\u3011\u5bfc\u51fa\u6570\u636e\u67e5\u8be2 \u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(queryDataResult));
        return queryDataResult;
    }

    public static boolean importChunkData(List<FileRepoChunkExportData> chunkExportDataList) {
        logger.info("\u3010\u6587\u6863\u578b\u77e5\u8bc6\u5e93\u3011\u5757\u6570\u636e\u5bfc\u5165 \u5f00\u59cb - \u5f85\u5904\u7406\u6570\u636e\u603b\u6570\uff1a{}", (Object)(chunkExportDataList != null ? chunkExportDataList.size() : 0));
        if (null == chunkExportDataList || chunkExportDataList.isEmpty()) {
            throw new RuntimeException("\u5757\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u5f85\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        Object[] chunkIds = chunkExportDataList.stream().map(FileRepoChunkExportData::getChunkId).collect(Collectors.toList()).toArray(new Long[0]);
        long repoId = chunkExportDataList.get(0).getRepoId();
        RepoVO repoInfo = RepoService.queryRepoMainInfo(repoId);
        Boolean enbaleFT = repoInfo.getEnbaleFT();
        MainEntityType chunkEntryType = EntityMetadataCache.getDataEntityType((String)"gai_text_chunk");
        DeleteServiceHelper.delete((IDataEntityType)chunkEntryType, (Object[])chunkIds);
        if (enbaleFT.booleanValue()) {
            RepoFulltextDeleteParam deleteParam = new RepoFulltextDeleteParam(repoId, null, (Long[])chunkIds);
            long fulltextDel = RepoFulltextService.getInstance().deleteByQuery(deleteParam);
            logger.info("\u3010\u77e5\u8bc6\u5e93\u3011\u5220\u9664-ES\u6570\u636e,\u6267\u884c\u6570\uff1a{} ,repoId:{},chunkIds:{}", new Object[]{fulltextDel, repoId, chunkIds});
            List<RepoFulltextData> ftdatas = chunkExportDataList.stream().map(o -> new RepoFulltextData(o.getRepoId(), o.getFileId(), o.getChunkId(), o.getContent())).collect(Collectors.toList());
            boolean save = RepoFulltextService.getInstance().batchSave(ftdatas);
            if (!save) {
                throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u5165-ES\u5168\u6587\u7d22\u5f15\u5199\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5ES\u670d\u52a1\u662f\u5426\u6b63\u5e38");
            }
        }
        DynamicObject[] objects = new DynamicObject[chunkExportDataList.size()];
        for (int i = 0; i < chunkExportDataList.size(); ++i) {
            FileRepoChunkExportData chunk = chunkExportDataList.get(i);
            DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)"gai_text_chunk");
            dObj.set("id", (Object)chunk.getChunkId());
            dObj.set("repoid", (Object)chunk.getRepoId());
            dObj.set("fileid", (Object)chunk.getFileId());
            dObj.set("pageid", (Object)chunk.getPageId());
            dObj.set("order", (Object)chunk.getOrder());
            dObj.set("source", (Object)chunk.getSource());
            dObj.set("businessId", (Object)chunk.getBusinessid());
            dObj.set("title", (Object)chunk.getTitle());
            dObj.set("url", (Object)chunk.getUrl());
            dObj.set("status", (Object)chunk.getStatus());
            dObj.set("content_tag", (Object)chunk.getContent());
            dObj.set("code_content_tag", (Object)chunk.getCodeContent());
            dObj.set("strigtotal", (Object)chunk.getStrigtotal());
            objects[i] = dObj;
        }
        SaveServiceHelper.save((DynamicObject[])objects);
        logger.info("\u3010\u6587\u6863\u578b\u77e5\u8bc6\u5e93\u3011\u5757\u6570\u636e\u5bfc\u5165 \u5b8c\u6210 - repoId:\u3010{}\u3011 \u5904\u7406\u6570\u636e\u603b\u6570\uff1a{}", (Object)repoId, (Object)chunkExportDataList.size());
        return true;
    }

    public static QueryDataResult<FileRepoVectorExportData> queryExportVectorData(FileRepoExportVectorDataParam exportDataParam) {
        logger.info("\u3010\u6587\u6863\u578b\u77e5\u8bc6\u5e93\u3011\u5206\u5757\u5411\u91cf\u6570\u636e\u5bfc\u51fa-\u6570\u636e\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JsonUtil.toJson(exportDataParam));
        Long repoId = exportDataParam.getRepoId();
        Long pageSize = exportDataParam.getPageSize();
        Long startNum = exportDataParam.getStartNum();
        if (repoId == null) {
            throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u51fa-\u6570\u636e\u67e5\u8be2\u53c2\u6570\uff0crepoId\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (pageSize < 1L) {
            throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u51fa-\u6570\u636e\u67e5\u8be2\u53c2\u6570\uff0cpageSize>0\uff0c\u8bf7\u68c0\u67e5");
        }
        if (startNum < 1L) {
            throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u51fa-\u6570\u636e\u67e5\u8be2\u53c2\u6570\uff0cstartNum>0\uff0c\u8bf7\u68c0\u67e5");
        }
        startNum = startNum - 1L;
        ArrayList<String> search_output_fields = new ArrayList<String>();
        search_output_fields.add("id");
        search_output_fields.add("repoId");
        search_output_fields.add("vector");
        RepoVO repoInfo = RepoService.getRepoInfo(repoId);
        VectorMetricType vectorMetricType = repoInfo.getVectorMetricType();
        LLM llm = repoInfo.getLlm();
        FileRepoVectorExportData chunkExportData = new FileRepoVectorExportData();
        QueryDataResult<FileRepoVectorExportData> queryDataResult = new QueryDataResult<FileRepoVectorExportData>();
        Long total = 0L;
        if (MilvusService.enableVDB()) {
            logger.info("queryExportVectorData vdb type gai-vdb");
            VDBService store = VDBServiceManager.getStore(llm, vectorMetricType);
            String collectionName = store.getCollectionName();
            QueryParameters queryParameters = new QueryParameters(collectionName, startNum.intValue(), pageSize.intValue(), selectFields);
            queryParameters.setFilter(Filter.equal((String)"repoId", (Object)repoId));
            CollectionData collectionData = store.query(queryParameters);
            ArrayList<Long> ids = new ArrayList<Long>(collectionData.size());
            ArrayList<Long> repoIds = new ArrayList<Long>(collectionData.size());
            ArrayList<List<Float>> vectors = new ArrayList<List<Float>>(collectionData.size());
            for (int i = 0; i < collectionData.size(); ++i) {
                try {
                    Object idObj = null;
                    if (collectionData.getMeta().getIdField() != null) {
                        idObj = collectionData.getId(i);
                    } else if (collectionData.getMeta().contains("_id")) {
                        idObj = collectionData.getValue(i, "_id");
                    }
                    if (idObj != null) {
                        if (idObj instanceof String) {
                            try {
                                ids.add(Long.parseLong((String)idObj));
                            }
                            catch (NumberFormatException e) {
                                ids.add(Long.valueOf(idObj.hashCode()));
                            }
                        } else if (idObj instanceof Number) {
                            ids.add(((Number)idObj).longValue());
                        }
                    }
                }
                catch (Exception e) {
                    logger.debug("Unable to get ID for row {}: {}", (Object)i, (Object)e.getMessage());
                }
                try {
                    Object knowledgeIdObj;
                    if (collectionData.getMeta().contains("repoId") && (knowledgeIdObj = collectionData.getValue(i, "repoId")) instanceof Number) {
                        repoIds.add(((Number)knowledgeIdObj).longValue());
                    }
                }
                catch (Exception e) {
                    logger.debug("Unable to get knowledgeId for row {}: {}", (Object)i, (Object)e.getMessage());
                }
                try {
                    if (collectionData.getMeta().contains("vector")) {
                        float[] vectorObj = (float[])collectionData.getValue(i, "vector");
                        ArrayList<Float> vector = new ArrayList<Float>(vectorObj.length);
                        for (float v : vectorObj) {
                            vector.add(Float.valueOf(v));
                        }
                        vectors.addAll(Collections.singleton(vector));
                    }
                }
                catch (Exception e) {
                    logger.debug("Unable to get knowledgeId for row {}: {}", (Object)i, (Object)e.getMessage());
                }
                chunkExportData.setChunkIds(ids);
                chunkExportData.setRepoIds(repoIds);
                chunkExportData.setVectors(vectors);
            }
            logger.info("bos-vdb search result {}", (Object)JsonUtil.toJson(chunkExportData));
            queryDataResult.setData(chunkExportData);
            queryDataResult.setStartNum(startNum);
            queryDataResult.setTotalNum(total);
            queryDataResult.setPageSize(pageSize);
        } else {
            StringBuilder exprBuilder = new StringBuilder();
            exprBuilder.append("repoId == ").append(repoId);
            MilvusBaseDao milvusService = MilvusService.getExecutor(llm, vectorMetricType);
            String collectionName = milvusService.getCollectionName();
            QueryParam queryParam = QueryParam.newBuilder().withCollectionName(collectionName).withExpr(exprBuilder.toString()).withOutFields(search_output_fields).withLimit(pageSize).withOffset(startNum).build();
            R queryResults = milvusService.getClient().query(queryParam);
            if (queryResults.getStatus() == 0) {
                QueryResults data = (QueryResults)queryResults.getData();
                QueryResultsWrapper resultsWrapper = new QueryResultsWrapper(data);
                List ids = resultsWrapper.getFieldWrapper("id").getFieldData();
                List repoIds = resultsWrapper.getFieldWrapper("repoId").getFieldData();
                List vectors = resultsWrapper.getFieldWrapper("vector").getFieldData();
                chunkExportData.setChunkIds(ids);
                chunkExportData.setRepoIds(repoIds);
                chunkExportData.setVectors(vectors);
                logger.info("milvus search result {}", (Object)JsonUtil.toJson(chunkExportData));
            }
            queryDataResult.setData(chunkExportData);
            queryDataResult.setStartNum(startNum);
            queryDataResult.setTotalNum(total);
            queryDataResult.setPageSize(pageSize);
        }
        return queryDataResult;
    }

    public static boolean importVectorData(FileRepoVectorExportData vectorExportData) {
        if (vectorExportData == null) {
            throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u5165-\u6570\u636e\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        List<Long> repoIds = vectorExportData.getRepoIds();
        Long repoId = repoIds.get(0);
        List<Long> chunkIds = vectorExportData.getChunkIds();
        List<List<Float>> vectors = vectorExportData.getVectors();
        if (chunkIds == null || chunkIds.isEmpty()) {
            throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u5165-\u5206\u5757IDS\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (vectors == null || vectors.isEmpty()) {
            throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u5165-\u5206\u5757\u5411\u91cf\u503c\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (repoId == null) {
            throw new RuntimeException("\u5206\u5757\u6570\u636e\u5bfc\u51fa-\u6570\u636e\u67e5\u8be2\u53c2\u6570\uff0crepoId\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        RepoVO repoInfo = RepoService.queryRepoMainInfo(repoId);
        LLM llm = repoInfo.getLlm();
        VectorMetricType vectorMetricType = repoInfo.getVectorMetricType();
        if (MilvusService.enableVDB()) {
            logger.info("batch vdb data import bos-vdb");
            VDBService store = VDBServiceManager.getStore(llm, vectorMetricType);
            boolean del = store.delByIdList(chunkIds);
            if (!del) {
                logger.error("\u5411\u91cf\u5e93\u5220\u9664\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u662f\u5426\u8fd0\u884c\u6b63\u5e38");
                throw new RuntimeException("\u5411\u91cf\u5e93\u5220\u9664\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u662f\u5426\u8fd0\u884c\u6b63\u5e38");
            }
            ArrayList<Chunk> chunkMilvesList = new ArrayList<Chunk>(chunkIds.size());
            for (int i = 0; i < chunkIds.size(); ++i) {
                Chunk chunk = new Chunk((long)chunkIds.get(i), (long)repoIds.get(i), vectors.get(i));
                chunkMilvesList.add(chunk);
            }
            store.bachInsert(chunkMilvesList);
        } else {
            logger.info("batch vdb data import gai-vdb");
            MilvusBaseDao milvusService = MilvusService.getExecutor(llm, vectorMetricType);
            String collectionName = milvusService.getCollectionName();
            boolean del = milvusService.delByIdList(chunkIds);
            if (!del) {
                logger.error("\u5411\u91cf\u5e93\u5220\u9664\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u662f\u5426\u8fd0\u884c\u6b63\u5e38");
                throw new RuntimeException("\u5411\u91cf\u5e93\u5220\u9664\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u662f\u5426\u8fd0\u884c\u6b63\u5e38");
            }
            ArrayList<InsertParam.Field> fieldList = new ArrayList<InsertParam.Field>();
            fieldList.add(new InsertParam.Field("id", chunkIds));
            fieldList.add(new InsertParam.Field("repoId", repoIds));
            fieldList.add(new InsertParam.Field("vector", vectors));
            InsertParam insertParam = InsertParam.newBuilder().withCollectionName(collectionName).withFields(fieldList).build();
            R insertResult = MilvusClientFactory.getClient().insert(insertParam);
            logger.info("milvus batch data import {}", (Object)insertResult);
            if (insertResult.getStatus() != 0) {
                throw new KDBizException("milvus batch import err:" + insertResult.getMessage());
            }
        }
        return true;
    }
}

