/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.entity.StructRepo;
import kd.ai.gai.core.repo.entity.StructRepoData;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.core.search.dto.RepoSchemaDTO;
import kd.ai.gai.core.search.index.param.structured.StructuredNodeData;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiStructRepoHelper {
    private static final Log logger = LogFactory.getLog(GaiStructRepoHelper.class);

    public static List<StructRepoField> queryStructRepoFields(long repoId) {
        ArrayList<StructRepoField> list = new ArrayList<StructRepoField>(0);
        DynamicObject repo = BusinessDataServiceHelper.loadSingle((Object)repoId, (String)"gai_struct_repo");
        if (repo != null) {
            DynamicObjectCollection fields = repo.getDynamicObjectCollection("entryentity");
            fields.sort(Comparator.comparingInt(o -> o.getInt("seq")));
            if (fields != null && !fields.isEmpty()) {
                for (int i = 0; i < fields.size(); ++i) {
                    DynamicObject field = (DynamicObject)fields.get(i);
                    String name = field.getString("fieldname");
                    String srcFieldKey = field.getString("srcfieldkey");
                    Long index = field.getLong("fieldindex");
                    long entryId = field.getLong("id");
                    Boolean isEmbeddingIndex = field.getBoolean("embedindex");
                    Boolean isFullIndex = field.getBoolean("fullindex");
                    String dataType = field.getString("datatype");
                    StructRepoField item = new StructRepoField();
                    item.setDataType(dataType);
                    item.setId(entryId);
                    item.setName(name);
                    item.setSourceFieldKey(srcFieldKey);
                    item.setEmbeddingIndex(isEmbeddingIndex);
                    item.setFullIndex(isFullIndex);
                    item.setSeq(field.getInt("seq"));
                    if (index < 10L) {
                        item.setFieldName(String.format("datafield0%s", index));
                    } else {
                        item.setFieldName(String.format("datafield%s", index));
                    }
                    list.add(item);
                }
            }
        }
        return list;
    }

    public static StructRepo queryStructRepo(long repoId) {
        StructRepo structRepo = null;
        DynamicObject repo = BusinessDataServiceHelper.loadSingle((Object)repoId, (String)"gai_struct_repo");
        if (repo != null) {
            structRepo = new StructRepo();
            structRepo.setRepoId(repo.getLong("id"));
            structRepo.setRepoType(repo.getString("repotype"));
            structRepo.setRepoNumber(repo.getString("reponumber"));
            structRepo.setName(repo.getString("name"));
            structRepo.setNumber(repo.getString("number"));
            structRepo.setVectorModel(repo.getString("vectormodel"));
            DynamicObject dObjBizObject = repo.getDynamicObject("srcbizobject");
            if (dObjBizObject != null) {
                structRepo.setSourceBizObjectName(dObjBizObject.getLocaleString("name"));
                structRepo.setSourceBizObjectNumber(dObjBizObject.getString("number"));
            }
            ArrayList<StructRepoField> structRepoFields = new ArrayList<StructRepoField>(0);
            DynamicObjectCollection fields = repo.getDynamicObjectCollection("entryentity");
            if (fields != null && !fields.isEmpty()) {
                for (int i = 0; i < fields.size(); ++i) {
                    DynamicObject field = (DynamicObject)fields.get(i);
                    String name = field.getString("fieldname");
                    String srcFieldKey = field.getString("srcfieldkey");
                    Long index = field.getLong("fieldindex");
                    long entryId = field.getLong("id");
                    Boolean isEmbeddingIndex = field.getBoolean("embedindex");
                    Boolean isFullIndex = field.getBoolean("fullindex");
                    String dataType = field.getString("datatype");
                    StructRepoField item = new StructRepoField();
                    item.setDataType(dataType);
                    item.setId(entryId);
                    item.setName(name);
                    item.setSourceFieldKey(srcFieldKey);
                    item.setEmbeddingIndex(isEmbeddingIndex);
                    item.setFullIndex(isFullIndex);
                    if (index < 10L) {
                        item.setFieldName(String.format("datafield0%s", index));
                    } else {
                        item.setFieldName(String.format("datafield%s", index));
                    }
                    structRepoFields.add(item);
                }
            }
            structRepo.setFields(structRepoFields);
        }
        return structRepo;
    }

    public static StructRepo queryStructRepoByRepoNumber(String repoNumber) {
        StructRepo structRepo = null;
        QFilter filter = new QFilter("number", "=", (Object)repoNumber);
        DynamicObject repo = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_struct_repo", (QFilter[])new QFilter[]{filter});
        if (repo != null) {
            structRepo = new StructRepo();
            structRepo.setRepoId(repo.getLong("id"));
            structRepo.setRepoType(repo.getString("repotype"));
            structRepo.setRepoNumber(repo.getString("reponumber"));
            structRepo.setName(repo.getString("name"));
            structRepo.setNumber(repo.getString("number"));
            structRepo.setVectorModel(repo.getString("vectormodel"));
        }
        return structRepo;
    }

    public static void batchUpdateTableDataStatus(List<Long> dataIdList, String dataStatus) {
        ArrayList<DynamicObject> updateEntrys = new ArrayList<DynamicObject>(0);
        for (Long dataId : dataIdList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gai_table_repo");
            dynamicObject.set("id", (Object)dataId);
            dynamicObject.set("datastatus", (Object)dataStatus);
            updateEntrys.add(dynamicObject);
        }
        SaveServiceHelper.update((DynamicObject[])updateEntrys.toArray(new DynamicObject[0]));
    }

    public static void batchUpdateTableDataStatus(List<Long> dataIdList, String dataStatus, String errorMsg) {
        ArrayList<DynamicObject> updateEntrys = new ArrayList<DynamicObject>(0);
        for (Long dataId : dataIdList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gai_table_repo");
            dynamicObject.set("id", (Object)dataId);
            dynamicObject.set("datastatus", (Object)dataStatus);
            dynamicObject.set("errormsgdetail", (Object)GaiStructRepoHelper.handlerMsgLength(errorMsg, 1000));
            updateEntrys.add(dynamicObject);
        }
        SaveServiceHelper.update((DynamicObject[])updateEntrys.toArray(new DynamicObject[0]));
    }

    public static void batchUpdateTableDataStatusWithMessage(List<Long> dataIdList, String dataStatus) {
        ArrayList<DynamicObject> updateEntrys = new ArrayList<DynamicObject>(0);
        for (Long dataId : dataIdList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gai_table_repo");
            dynamicObject.set("id", (Object)dataId);
            dynamicObject.set("datastatus", (Object)dataStatus);
            dynamicObject.set("errormsg", (Object)" ");
            dynamicObject.set("errormsgdetail", (Object)" ");
            updateEntrys.add(dynamicObject);
        }
        SaveServiceHelper.update((DynamicObject[])updateEntrys.toArray(new DynamicObject[0]));
    }

    private static String handlerMsgLength(String message, int maxLength) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        int length = message.length();
        if (length >= maxLength) {
            return message.substring(0, maxLength - 1);
        }
        return message;
    }

    public static List<StructRepoData> batchQueryTableRepoData(Long repoId, List<Long> dataIdList) {
        List<StructRepoField> fields = GaiStructRepoHelper.queryStructRepoFields(repoId);
        List dataFields = fields.stream().map(new Function<StructRepoField, String>(){

            @Override
            public String apply(StructRepoField structRepoField) {
                return structRepoField.getFieldName();
            }
        }).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", dataIdList);
        ArrayList<String> queryList = new ArrayList<String>(0);
        queryList.add("id");
        queryList.add("datastatus");
        ArrayList<Object> propertyList = new ArrayList<Object>(0);
        propertyList.addAll(dataFields);
        propertyList.addAll(queryList);
        String properties = StringUtils.join(propertyList, (String)",");
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"gai_table_repo", (String)properties, (QFilter[])new QFilter[]{filter});
        ArrayList<StructRepoData> structRepoData = new ArrayList<StructRepoData>(0);
        if (datas != null && datas.length > 0) {
            for (DynamicObject data : datas) {
                StructRepoData sd = new StructRepoData();
                sd.setId(data.getLong("id"));
                sd.setDataStatus(data.getString("datastatus"));
                sd.setRepoId(repoId);
                HashMap<String, Object> tableData = new HashMap<String, Object>(0);
                for (String field : dataFields) {
                    tableData.put(field, data.getString(String.format("%s_tag", field)));
                }
                sd.setData(tableData);
                structRepoData.add(sd);
            }
        }
        return structRepoData;
    }

    public static List<Map<String, Object>> queryRepoData(RepoSchemaDTO repoSchema, List<Long> dataIdList) {
        long repoId = repoSchema.getRepoId();
        String repoType = repoSchema.getRepoType();
        if (StringUtils.equalsIgnoreCase((CharSequence)repoType, (CharSequence)RepoConstant.RepoType.TABLE.getType())) {
            return GaiStructRepoHelper.queryRepoDataList(repoId, "gai_table_repo", dataIdList);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)repoType, (CharSequence)RepoConstant.RepoType.LEVEL.getType())) {
            return GaiStructRepoHelper.queryRepoDataList(repoId, "gai_repo_treedata", dataIdList);
        }
        throw new KDBizException("\u67e5\u8be2\u77e5\u8bc6\u5e93\u6570\u636e\u9519\u8bef\uff0ctype\u4e0d\u662f\u6307\u5b9a\u7684\u77e5\u8bc6\u5e93\u7c7b\u578b\u3002");
    }

    public static List<Map<String, Object>> queryRepoData(RepoSchemaDTO repoSchema, Long[] dataIdList) {
        return GaiStructRepoHelper.queryRepoData(repoSchema, Arrays.asList(dataIdList));
    }

    public static List<Map<String, Object>> queryRepoDataList(Long repoId, String entryNumber, List<Long> dataIdList) {
        logger.info("\u67e5\u8be2\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u6570\u636e\uff0crepoId:{},entryNumber:{},dataIdList:{}", new Object[]{repoId, entryNumber, dataIdList});
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(0);
        List<StructRepoField> fields = GaiStructRepoHelper.queryStructRepoFields(repoId);
        List dataFields = fields.stream().map(new Function<StructRepoField, String>(){

            @Override
            public String apply(StructRepoField structRepoField) {
                return String.format("%s_tag", structRepoField.getFieldName());
            }
        }).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", dataIdList);
        ArrayList<String> queryList = new ArrayList<String>(0);
        queryList.add("id");
        ArrayList<Object> propertyList = new ArrayList<Object>(0);
        propertyList.addAll(dataFields);
        propertyList.addAll(queryList);
        String properties = StringUtils.join(propertyList, (String)",");
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)entryNumber, (String)properties, (QFilter[])new QFilter[]{filter});
        if (datas != null && datas.length > 0) {
            for (DynamicObject data : datas) {
                HashMap<String, Object> tableData = new HashMap<String, Object>(0);
                for (String field : dataFields) {
                    tableData.put(field.substring(0, field.indexOf("_tag")), data.getString(field));
                }
                tableData.put("id", data.getLong("id"));
                dataList.add(tableData);
            }
        }
        logger.info("\u67e5\u8be2\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u6570\u636e\u8fd4\u56de:{}", dataList);
        return dataList;
    }

    public static List<StructuredNodeData> queryLevelData(RepoSchemaDTO repoSchema, List<Long> pkIds) {
        long structRepoId = repoSchema.getRepoId();
        Map dataNumLevels = BusinessDataServiceHelper.loadFromCache((String)"gai_repo_treedata", (String)"id,longnumber,level", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        HashSet setParentNumbers = new HashSet();
        dataNumLevels.forEach((dataPkId, data) -> {
            String[] parentNumbers;
            String longNumber = data.getString("longnumber");
            for (String number : parentNumbers = longNumber.split("\\.")) {
                if (!StringUtils.isNotEmpty((CharSequence)number)) continue;
                setParentNumbers.add(number);
            }
        });
        QFilter qFilter = new QFilter("number", "in", setParentNumbers);
        qFilter.or(new QFilter("parent", "in", pkIds));
        List allDataPkIds = QueryServiceHelper.queryPrimaryKeys((String)"gai_repo_treedata", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        List<StructRepoField> fields = GaiStructRepoHelper.queryStructRepoFields(structRepoId);
        StringBuilder sbSelectField = new StringBuilder();
        sbSelectField.append(String.format("%s,", "id"));
        sbSelectField.append(String.format("%s,", "name"));
        sbSelectField.append(String.format("%s,", "number"));
        sbSelectField.append(String.format("%s,", "longnumber"));
        sbSelectField.append(String.format("%s.%s,", "parent", "id"));
        sbSelectField.append(String.format("%s,", "level"));
        fields.forEach(field -> sbSelectField.append(String.format("%s,", field.getFieldName())));
        sbSelectField.deleteCharAt(sbSelectField.length() - 1);
        ArrayList<StructuredNodeData> listResult = new ArrayList<StructuredNodeData>();
        Map mapAllData = BusinessDataServiceHelper.loadFromCache((String)"gai_repo_treedata", (String)sbSelectField.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)allDataPkIds)});
        dataNumLevels.forEach((dataPkId, data) -> {
            StructuredNodeData mapRelationData = GaiStructRepoHelper.buildRelationLevelData(dataPkId, mapAllData, fields);
            listResult.add(mapRelationData);
        });
        return listResult;
    }

    private static StructuredNodeData buildRelationLevelData(Object dataPkId, Map<Object, DynamicObject> mapAllData, List<StructRepoField> repoFields) {
        DynamicObject parentObj;
        StructuredNodeData mapResult = new StructuredNodeData();
        DynamicObject targetObj = mapAllData.getOrDefault(dataPkId, null);
        if (targetObj == null) {
            return null;
        }
        Map<String, Object> mapTarget = GaiStructRepoHelper.buildLevelDataByAlgoRow(targetObj, repoFields);
        mapResult.setTarget(mapTarget);
        ArrayList<Map<String, Object>> parents = new ArrayList<Map<String, Object>>();
        String parentIdField = String.format("%s.%s", "parent", "id");
        long curParentId = targetObj.getLong(parentIdField);
        while (curParentId > 0L && (parentObj = (DynamicObject)mapAllData.getOrDefault(curParentId, null)) != null) {
            Map<String, Object> mapParent = GaiStructRepoHelper.buildLevelDataByAlgoRow(parentObj, repoFields);
            parents.add(0, mapParent);
            curParentId = parentObj.getLong(parentIdField);
        }
        mapResult.setFatherPath(parents);
        ArrayList<Map<String, Object>> nextLevelChilds = new ArrayList<Map<String, Object>>();
        mapAllData.forEach((key, value) -> {
            if (dataPkId.equals(value.getLong(parentIdField))) {
                Map<String, Object> mapChild = GaiStructRepoHelper.buildLevelDataByAlgoRow(value, repoFields);
                nextLevelChilds.add(mapChild);
            }
        });
        mapResult.setSonIndex(nextLevelChilds);
        return mapResult;
    }

    private static Map<String, Object> buildLevelDataByAlgoRow(DynamicObject row, List<StructRepoField> repoFields) {
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        rowData.put("id", row.getLong("id"));
        rowData.put("level", row.getInt("level"));
        repoFields.forEach(field -> rowData.put(field.getName(), row.getString(field.getFieldName())));
        return rowData;
    }
}

