/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.result;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.flow.param.converter.annotation.ParamDefinitionAnnotations;
import kd.ai.gai.core.repo.result.RepoSearchResult;
import kd.ai.gai.core.util.JsonSafeAccessor;

public class MetaRepoResult
extends RepoSearchResult<EntityItem> {
    private List<EntityItem> items;

    public void convertToItems(List<Map<String, Object>> resultList) {
        ArrayList<EntityItem> entities = new ArrayList<EntityItem>();
        if (resultList != null) {
            for (Map<String, Object> entityMap : resultList) {
                EntityItem entity = new EntityItem();
                entity.setEntityId(JsonSafeAccessor.getString(entityMap, "entityId"));
                entity.setChunkId(JsonSafeAccessor.getLong(entityMap, "chunkId"));
                entity.setTitle(JsonSafeAccessor.getString(entityMap, "title"));
                entity.setChunk(JsonSafeAccessor.getString(entityMap, "chunk"));
                entity.setScore(JsonSafeAccessor.getFloat(entityMap, "score", Float.valueOf(0.0f)).floatValue());
                entities.add(entity);
            }
        }
        this.setItems(entities);
    }

    @Override
    public List<EntityItem> getItems() {
        return this.items;
    }

    public void setItems(List<EntityItem> items) {
        this.items = items;
    }

    public static class EntityItem {
        @ParamDefinitionAnnotations.Description(value="\u5b9e\u4f53ID")
        private String entityId;
        @ParamDefinitionAnnotations.Description(value="\u5206\u5757ID")
        private Long chunkId;
        @ParamDefinitionAnnotations.Description(value="\u77e5\u8bc6\u540d\u79f0")
        private String title;
        @ParamDefinitionAnnotations.Description(value="\u5206\u5757\u5185\u5bb9")
        private String chunk;
        @ParamDefinitionAnnotations.Description(value="\u76f8\u5173\u5ea6\u5206\u6570")
        private float score;

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public Long getChunkId() {
            return this.chunkId;
        }

        public void setChunkId(Long chunkId) {
            this.chunkId = chunkId;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getChunk() {
            return this.chunk;
        }

        public void setChunk(String chunk) {
            this.chunk = chunk;
        }

        public float getScore() {
            return this.score;
        }

        public void setScore(float score) {
            this.score = score;
        }
    }
}

