/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.repo.result;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.flow.param.converter.annotation.ParamDefinitionAnnotations;
import kd.ai.gai.core.repo.result.RepoSearchResult;
import kd.ai.gai.core.util.JsonSafeAccessor;

public class UniversalRepoResult
extends RepoSearchResult<KnowledgeItem> {
    private List<KnowledgeItem> items;

    public void convertToItems(JSONArray jsonArray) {
        ArrayList<KnowledgeItem> items = new ArrayList<KnowledgeItem>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject itemJson = jsonArray.getJSONObject(i);
            KnowledgeItem item = new KnowledgeItem();
            item.setBusinessId(JsonSafeAccessor.getLong(itemJson, "businessId"));
            item.setChunk(JsonSafeAccessor.getString(itemJson, "chunk"));
            item.setChunkId(JsonSafeAccessor.getLong(itemJson, "chunkId"));
            item.setFileId(JsonSafeAccessor.getLong(itemJson, "fileId"));
            item.setFileName(JsonSafeAccessor.getString(itemJson, "fileName"));
            item.setFilePath(JsonSafeAccessor.getString(itemJson, "filePath"));
            item.setFileType(JsonSafeAccessor.getString(itemJson, "fileType"));
            item.setFileSize(JsonSafeAccessor.getString(itemJson, "fileSize"));
            item.setOrder(JsonSafeAccessor.getInteger(itemJson, "order", (Integer)0));
            item.setPageNum(JsonSafeAccessor.getInteger(itemJson, "pageNum", (Integer)0));
            item.setRepoId(JsonSafeAccessor.getLong(itemJson, "repoId"));
            item.setSimilarity(JsonSafeAccessor.getDouble(itemJson, "similarity", (Double)0.0));
            item.setTitle(JsonSafeAccessor.getString(itemJson, "title"));
            item.setUrl(JsonSafeAccessor.getString(itemJson, "url"));
            item.setNeedCached(JsonSafeAccessor.getBoolean(itemJson, "needCached"));
            item.setSource(JsonSafeAccessor.getString(itemJson, "source"));
            items.add(item);
        }
        this.setItems(items);
    }

    @Override
    public List<KnowledgeItem> getItems() {
        return this.items;
    }

    public void setItems(List<KnowledgeItem> items) {
        this.items = items;
    }

    public static class KnowledgeItem {
        @ParamDefinitionAnnotations.Description(value="\u4e1a\u52a1ID")
        private Long businessId;
        @ParamDefinitionAnnotations.Description(value="\u5206\u5757\u5185\u5bb9")
        private String chunk;
        @ParamDefinitionAnnotations.Description(value="\u5206\u5757id")
        private Long chunkId;
        @ParamDefinitionAnnotations.Description(value="\u77e5\u8bc6id")
        private Long fileId;
        @ParamDefinitionAnnotations.Description(value="\u77e5\u8bc6\u540d\u79f0")
        private String fileName;
        @ParamDefinitionAnnotations.Description(value="\u77e5\u8bc6\u9644\u4ef6\u76f8\u5bf9\u8def\u5f84")
        private String filePath;
        @ParamDefinitionAnnotations.Description(value="\u77e5\u8bc6\u9644\u4ef6\u7c7b\u578b")
        private String fileType;
        @ParamDefinitionAnnotations.Description(value="\u6587\u4ef6\u5927\u5c0f")
        private String fileSize;
        @ParamDefinitionAnnotations.Description(value="\u987a\u5e8f")
        private int order;
        @ParamDefinitionAnnotations.Description(value="\u9875\u7801")
        private int pageNum;
        @ParamDefinitionAnnotations.Description(value="\u77e5\u8bc6\u5e93ID")
        private Long repoId;
        @ParamDefinitionAnnotations.Description(value="\u76f8\u4f3c\u5ea6/\u5206\u6570")
        private double similarity;
        @ParamDefinitionAnnotations.Description(value="\u5f15\u7528\u6807\u9898")
        private String title;
        @ParamDefinitionAnnotations.Description(value="\u77e5\u8bc6\u9644\u4ef6\u9884\u89c8url")
        private String url;
        @ParamDefinitionAnnotations.Description(value="\u6587\u6863\u68c0\u7d22\u7ed3\u679c\u589e\u52a0\u89d2\u6807\u5c5e\u6027")
        private Boolean needCached;
        @ParamDefinitionAnnotations.Description(value="\u5206\u5757\u89d2\u6807\u7c7b\u578b")
        private String source;

        public Long getBusinessId() {
            return this.businessId;
        }

        public void setBusinessId(Long businessId) {
            this.businessId = businessId;
        }

        public String getChunk() {
            return this.chunk;
        }

        public void setChunk(String chunk) {
            this.chunk = chunk;
        }

        public Long getChunkId() {
            return this.chunkId;
        }

        public void setChunkId(Long chunkId) {
            this.chunkId = chunkId;
        }

        public Long getFileId() {
            return this.fileId;
        }

        public void setFileId(Long fileId) {
            this.fileId = fileId;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public String getFileType() {
            return this.fileType;
        }

        public void setFileType(String fileType) {
            this.fileType = fileType;
        }

        public String getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(String fileSize) {
            this.fileSize = fileSize;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public int getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(int pageNum) {
            this.pageNum = pageNum;
        }

        public Long getRepoId() {
            return this.repoId;
        }

        public void setRepoId(Long repoId) {
            this.repoId = repoId;
        }

        public double getSimilarity() {
            return this.similarity;
        }

        public void setSimilarity(double similarity) {
            this.similarity = similarity;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Boolean getNeedCached() {
            return this.needCached;
        }

        public void setNeedCached(Boolean needCached) {
            this.needCached = needCached;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }
    }
}

