/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.dto;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.search.dto.RepoSchemaDTO;
import kd.ai.gai.core.search.helper.KnowledgeRepoServiceHelper;

public class EmbDataCacheDTO {
    private Long repoId;
    private String repoNumber;
    private String repoName;
    private Set<String> vectorFieldKeys = Sets.newHashSetWithExpectedSize((int)16);
    private Set<String> allDataIdSet = Sets.newHashSetWithExpectedSize((int)16);
    private Map<String, Set<String>> embeddingTaskDataMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Set<String>> embeddingDataFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Set<String>> toVectorDataFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Set<String>> failedDataFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private Set<String> successDataIdSet = Sets.newHashSetWithExpectedSize((int)16);

    public Long getRepoId() {
        return this.repoId;
    }

    public void setRepoId(Long repoId) {
        this.repoId = repoId;
    }

    public String getRepoNumber() {
        return this.repoNumber;
    }

    public void setRepoNumber(String repoNumber) {
        this.repoNumber = repoNumber;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public Set<String> getVectorFieldKeys() {
        return this.vectorFieldKeys;
    }

    public void setVectorFieldKeys(Set<String> vectorFieldKeys) {
        this.vectorFieldKeys = vectorFieldKeys;
    }

    public Set<String> getAllDataIdSet() {
        return this.allDataIdSet;
    }

    public void setAllDataIdSet(Set<String> allDataIdSet) {
        this.allDataIdSet = allDataIdSet;
    }

    public Map<String, Set<String>> getEmbeddingTaskDataMap() {
        return this.embeddingTaskDataMap;
    }

    public void setEmbeddingTaskDataMap(Map<String, Set<String>> embeddingTaskDataMap) {
        this.embeddingTaskDataMap = embeddingTaskDataMap;
    }

    public Map<String, Set<String>> getEmbeddingDataFieldMap() {
        return this.embeddingDataFieldMap;
    }

    public void setEmbeddingDataFieldMap(Map<String, Set<String>> embeddingDataFieldMap) {
        this.embeddingDataFieldMap = embeddingDataFieldMap;
    }

    public Map<String, Set<String>> getToVectorDataFieldMap() {
        return this.toVectorDataFieldMap;
    }

    public void setToVectorDataFieldMap(Map<String, Set<String>> toVectorDataFieldMap) {
        this.toVectorDataFieldMap = toVectorDataFieldMap;
    }

    public Map<String, Set<String>> getFailedDataFieldMap() {
        return this.failedDataFieldMap;
    }

    public void setFailedDataFieldMap(Map<String, Set<String>> failedDataFieldMap) {
        this.failedDataFieldMap = failedDataFieldMap;
    }

    public Set<String> getSuccessDataIdSet() {
        return this.successDataIdSet;
    }

    public void setSuccessDataIdSet(Set<String> successDataIdSet) {
        this.successDataIdSet = successDataIdSet;
    }

    public String toString() {
        return "EmbDataCacheDTO{repoId=" + this.repoId + ", repoNumber='" + this.repoNumber + '\'' + ", repoName='" + this.repoName + '\'' + ", vectorFieldKeys=" + this.vectorFieldKeys + ", allDataIdSet=" + this.allDataIdSet + ", embeddingTaskDataMap=" + this.embeddingTaskDataMap + ", embeddingDataFieldMap=" + this.embeddingDataFieldMap + ", toVectorDataFieldMap=" + this.toVectorDataFieldMap + ", failedDataFieldMap=" + this.failedDataFieldMap + ", successDataIdSet=" + this.successDataIdSet + '}';
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmbDataCacheDTO)) {
            return false;
        }
        EmbDataCacheDTO that = (EmbDataCacheDTO)o;
        return Objects.equals(this.repoId, that.repoId) && Objects.equals(this.repoNumber, that.repoNumber) && Objects.equals(this.repoName, that.repoName) && Objects.equals(this.vectorFieldKeys, that.vectorFieldKeys) && Objects.equals(this.allDataIdSet, that.allDataIdSet) && Objects.equals(this.embeddingTaskDataMap, that.embeddingTaskDataMap) && Objects.equals(this.embeddingDataFieldMap, that.embeddingDataFieldMap) && Objects.equals(this.toVectorDataFieldMap, that.toVectorDataFieldMap) && Objects.equals(this.failedDataFieldMap, that.failedDataFieldMap) && Objects.equals(this.successDataIdSet, that.successDataIdSet);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.repoId);
        result = 31 * result + Objects.hashCode(this.repoNumber);
        result = 31 * result + Objects.hashCode(this.repoName);
        result = 31 * result + Objects.hashCode(this.vectorFieldKeys);
        result = 31 * result + Objects.hashCode(this.allDataIdSet);
        result = 31 * result + Objects.hashCode(this.embeddingTaskDataMap);
        result = 31 * result + Objects.hashCode(this.embeddingDataFieldMap);
        result = 31 * result + Objects.hashCode(this.toVectorDataFieldMap);
        result = 31 * result + Objects.hashCode(this.failedDataFieldMap);
        result = 31 * result + Objects.hashCode(this.successDataIdSet);
        return result;
    }

    public static EmbDataCacheDTO buildByRepoIdWithDataIdSet(String repoId, Set<String> dataIdSet) {
        return EmbDataCacheDTO.buildByRepoIdWithDataIdSet(Long.valueOf(repoId), dataIdSet);
    }

    public static EmbDataCacheDTO buildByRepoIdWithDataIdSet(Long repoId, Set<String> dataIdSet) {
        RepoSchemaDTO schemaDTO = KnowledgeRepoServiceHelper.getRepoService().getSchemaByRepoId(repoId);
        List<RepoSchemaDTO.SchemaField> fields = schemaDTO.getFields();
        Set<String> vectorFieldKeys = fields.stream().filter(RepoSchemaDTO.SchemaField::getVectorIndexEnable).map(RepoSchemaDTO.SchemaField::getFieldKey).collect(Collectors.toSet());
        return new EmbDataCacheDTOBuilder().repoId(schemaDTO.getRepoId()).repoNumber(schemaDTO.getRepoNumber()).repoName(schemaDTO.getRepoName()).vectorFieldKeys(vectorFieldKeys).allDataIdSet(dataIdSet).build();
    }

    public static final class EmbDataCacheDTOBuilder {
        private Long repoId;
        private String repoNumber;
        private String repoName;
        private Set<String> vectorFieldKeys = Sets.newHashSetWithExpectedSize((int)16);
        private Set<String> allDataIdSet = Sets.newHashSetWithExpectedSize((int)16);
        private Map<String, Set<String>> embeddingTaskDataMap = Maps.newHashMapWithExpectedSize((int)16);
        private Map<String, Set<String>> embeddingDataFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        private Map<String, Set<String>> toVectorDataFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        private Map<String, Set<String>> failedDataFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        private Set<String> successDataIdSet = Sets.newHashSetWithExpectedSize((int)16);

        public EmbDataCacheDTOBuilder() {
        }

        public EmbDataCacheDTOBuilder(EmbDataCacheDTO other) {
            this.repoId = other.repoId;
            this.repoNumber = other.repoNumber;
            this.repoName = other.repoName;
            this.vectorFieldKeys = other.vectorFieldKeys;
            this.allDataIdSet = other.allDataIdSet;
            this.embeddingTaskDataMap = other.embeddingTaskDataMap;
            this.embeddingDataFieldMap = other.embeddingDataFieldMap;
            this.toVectorDataFieldMap = other.toVectorDataFieldMap;
            this.failedDataFieldMap = other.failedDataFieldMap;
            this.successDataIdSet = other.successDataIdSet;
        }

        public static EmbDataCacheDTOBuilder anEmbDataCacheDTO() {
            return new EmbDataCacheDTOBuilder();
        }

        public EmbDataCacheDTOBuilder repoId(Long repoId) {
            this.repoId = repoId;
            return this;
        }

        public EmbDataCacheDTOBuilder repoNumber(String repoNumber) {
            this.repoNumber = repoNumber;
            return this;
        }

        public EmbDataCacheDTOBuilder repoName(String repoName) {
            this.repoName = repoName;
            return this;
        }

        public EmbDataCacheDTOBuilder vectorFieldKeys(Set<String> vectorFieldKeys) {
            this.vectorFieldKeys = vectorFieldKeys;
            return this;
        }

        public EmbDataCacheDTOBuilder allDataIdSet(Set<String> allDataIdSet) {
            this.allDataIdSet = allDataIdSet;
            return this;
        }

        public EmbDataCacheDTOBuilder embeddingTaskDataMap(Map<String, Set<String>> embeddingTaskDataMap) {
            this.embeddingTaskDataMap = embeddingTaskDataMap;
            return this;
        }

        public EmbDataCacheDTOBuilder embeddingDataFieldMap(Map<String, Set<String>> embeddingDataFieldMap) {
            this.embeddingDataFieldMap = embeddingDataFieldMap;
            return this;
        }

        public EmbDataCacheDTOBuilder toVectorDataFieldMap(Map<String, Set<String>> toVectorDataFieldMap) {
            this.toVectorDataFieldMap = toVectorDataFieldMap;
            return this;
        }

        public EmbDataCacheDTOBuilder failedDataFieldMap(Map<String, Set<String>> failedDataFieldMap) {
            this.failedDataFieldMap = failedDataFieldMap;
            return this;
        }

        public EmbDataCacheDTOBuilder successDataIdSet(Set<String> successDataIdSet) {
            this.successDataIdSet = successDataIdSet;
            return this;
        }

        public EmbDataCacheDTO build() {
            EmbDataCacheDTO embDataCacheDTO = new EmbDataCacheDTO();
            embDataCacheDTO.setRepoId(this.repoId);
            embDataCacheDTO.setRepoNumber(this.repoNumber);
            embDataCacheDTO.setRepoName(this.repoName);
            embDataCacheDTO.setVectorFieldKeys(this.vectorFieldKeys);
            embDataCacheDTO.setAllDataIdSet(this.allDataIdSet);
            embDataCacheDTO.setEmbeddingTaskDataMap(this.embeddingTaskDataMap);
            embDataCacheDTO.setEmbeddingDataFieldMap(this.embeddingDataFieldMap);
            embDataCacheDTO.setToVectorDataFieldMap(this.toVectorDataFieldMap);
            embDataCacheDTO.setFailedDataFieldMap(this.failedDataFieldMap);
            embDataCacheDTO.setSuccessDataIdSet(this.successDataIdSet);
            return embDataCacheDTO;
        }
    }
}

