/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.dto;

import kd.bos.context.RequestContext;

public class ResponseDTO<T> {
    private static final String SUCCESS_CODE = "0";
    private static final String SUCCESS_MSG = "success";
    private static final String ERROR_CODE = "-1";
    private static final String ERROR_MSG = "error";
    private String requestId;
    private Boolean status;
    private String errCode;
    private String errMsg;
    private T data;

    public static <T> ResponseDTO<T> success() {
        return new ResponseDTO<Object>(true, SUCCESS_CODE, SUCCESS_MSG, null);
    }

    public static <T> ResponseDTO<T> success(T t) {
        return new ResponseDTO<T>(true, SUCCESS_CODE, SUCCESS_MSG, t);
    }

    public static <T> ResponseDTO<T> success(String msg, T t) {
        return new ResponseDTO<T>(true, SUCCESS_CODE, msg, t);
    }

    public static <T> ResponseDTO<T> successMsg(String msg) {
        return new ResponseDTO<Object>(true, SUCCESS_CODE, msg, null);
    }

    public static <T> ResponseDTO<T> error() {
        return new ResponseDTO<Object>(false, ERROR_CODE, ERROR_MSG, null);
    }

    public static <T> ResponseDTO<T> error(String msg) {
        return new ResponseDTO<Object>(false, ERROR_CODE, msg, null);
    }

    public static <T> ResponseDTO<T> error(String code, String msg) {
        return new ResponseDTO<Object>(false, code, msg, null);
    }

    public static <T> ResponseDTO<T> error(String code, String msg, T t) {
        return new ResponseDTO<T>(false, code, msg, t);
    }

    public static <T> ResponseDTO<T> errorData(String msg, T t) {
        return new ResponseDTO<T>(false, ERROR_CODE, msg, t);
    }

    public ResponseDTO() {
    }

    public ResponseDTO(String errCode, String errMsg, T data) {
        this.requestId = RequestContext.get().getTraceId();
        this.status = true;
        this.errCode = errCode;
        this.errMsg = errMsg;
        this.data = data;
    }

    public ResponseDTO(Boolean status, String errCode, String errMsg, T data) {
        this.requestId = RequestContext.get().getTraceId();
        this.status = status;
        this.errCode = errCode;
        this.errMsg = errMsg;
        this.data = data;
    }

    public ResponseDTO(String requestId, Boolean status, String errCode, String errMsg, T data) {
        this.requestId = requestId;
        this.status = status;
        this.errCode = errCode;
        this.errMsg = errMsg;
        this.data = data;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "ResponseDTO{requestId='" + this.requestId + '\'' + ", status=" + this.status + ", errCode='" + this.errCode + '\'' + ", errMsg='" + this.errMsg + '\'' + ", data=" + this.data + '}';
    }
}

