/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.RerankChunk;
import kd.ai.gai.core.domain.dto.repo.RerankerConfig;
import kd.ai.gai.core.domain.llm.base.ResultRerank;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.RerankMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.enuz.repo.SearchType;
import kd.ai.gai.core.rag.service.RerankerConfigService;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.ai.gai.core.search.dto.RepoSchemaDTO;
import kd.ai.gai.core.search.helper.KnowledgeRepoServiceHelper;
import kd.ai.gai.core.search.index.dto.RerankerSearchDTD;
import kd.ai.gai.core.search.index.param.keyword.KeywordDataSearchParam;
import kd.ai.gai.core.search.index.param.structured.QureyStructuredNodeDataParam;
import kd.ai.gai.core.search.index.param.structured.SearchStructuredDataParam;
import kd.ai.gai.core.search.index.param.structured.SearchTargetDataParam;
import kd.ai.gai.core.search.index.param.structured.SearchTargetDataResult;
import kd.ai.gai.core.search.index.param.structured.StructuredNodeData;
import kd.ai.gai.core.search.index.param.structured.StructuredRowData;
import kd.ai.gai.core.search.index.param.structured.StructuredSearchResultData;
import kd.ai.gai.core.search.index.param.vector.VectorDataSearchParam;
import kd.ai.gai.core.search.index.schema.KeywordIndexSchema;
import kd.ai.gai.core.search.index.schema.VectorCollectionSchema;
import kd.ai.gai.core.search.index.service.KeywordService;
import kd.ai.gai.core.search.index.service.KeywordServiceHelper;
import kd.ai.gai.core.search.index.service.VectorService;
import kd.ai.gai.core.search.index.service.VectorServiceHelper;
import kd.ai.gai.core.service.rerank.RerankService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.jetbrains.annotations.NotNull;

public class StructuredRepoServiceHelper {
    private static final Log logger = LogFactory.getLog(StructuredRepoServiceHelper.class);

    public static StructuredRowData search(SearchStructuredDataParam searchParams) {
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u884c\u7ea7\u6570\u636e\u68c0\u7d22-\u5165\u53c2\uff1a{}", (Object)searchParams);
        Long repoSchemaId = searchParams.getRepoSchemaId();
        String query = searchParams.getQuery();
        int topK = searchParams.getTopK();
        float similarity = searchParams.getSimilarity();
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u5f85\u68c0\u7d22\u6587\u672c\u5185\u5bb9\u4e0d\u4e3a\u7a7a"), new Object[0]);
        }
        if (topK < 1 || topK > 100) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "TopK\u503c\u4e3a[1,100]"), new Object[0]);
        }
        if (similarity < 0.0f || similarity > 1.0f) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "similarity\u503c\u4e3a[0,1]"), new Object[0]);
        }
        String rerankerLLmNumber = "";
        if (searchParams.isEnableReranker()) {
            rerankerLLmNumber = StructuredRepoServiceHelper.getReranker();
        }
        RepoSchemaDTO repoSchema = KnowledgeRepoServiceHelper.getRepoService().getSchemaBySchemaId(repoSchemaId);
        Long repoId = repoSchema.getRepoId();
        String vectorModel = repoSchema.getVectorModel();
        LLM embeddingModel = LLM.parse(vectorModel);
        String searchType = repoSchema.getSearchType();
        String repoType = repoSchema.getRepoType();
        String vectorMetricTypeStr = repoSchema.getVectorMetricType();
        VectorMetricType vectorMetricType = StringUtils.isEmpty((CharSequence)vectorMetricTypeStr) ? VectorMetricType.COSINE : VectorMetricType.parse(vectorMetricTypeStr);
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u884c\u7ea7\u6570\u636e\u68c0\u7d22-\u5e93ID:{},\u7c7b\u578b:{},\u68c0\u7d22\u6a21\u578b:{}", new Object[]{repoId, repoType, searchType});
        List<Object> searchDatas = new ArrayList();
        if (SearchType.VECTOR.toString().equalsIgnoreCase(searchType)) {
            searchDatas = StructuredRepoServiceHelper.vectorSearchBuild(repoId, vectorMetricType, query, topK, similarity, embeddingModel);
        } else if (SearchType.KEYWORD.toString().equalsIgnoreCase(searchType)) {
            searchDatas = StructuredRepoServiceHelper.keywordSearchBulid(repoId, query, topK);
        } else if (SearchType.HYBRID.toString().equalsIgnoreCase(searchType)) {
            List<StructuredSearchResultData> vectorSearchDatas = StructuredRepoServiceHelper.vectorSearchBuild(repoId, vectorMetricType, query, topK, 0.0f, embeddingModel);
            List<StructuredSearchResultData> keywordSearchDatas = StructuredRepoServiceHelper.keywordSearchBulid(repoId, query, topK);
            searchDatas.addAll(vectorSearchDatas);
            searchDatas.addAll(keywordSearchDatas);
        }
        if (searchDatas != null && !searchDatas.isEmpty()) {
            List<Object> usrSearchDatas = Collections.emptyList();
            if (searchParams.isEnableReranker()) {
                RerankerSearchDTD rerankerDTD = StructuredRepoServiceHelper.rerankerSearchDatas(repoSchema, rerankerLLmNumber, query, searchDatas, topK, similarity);
                if (rerankerDTD != null) {
                    usrSearchDatas = rerankerDTD.getMetaDatas();
                }
            } else {
                List<Long> dataIds = searchDatas.stream().map(o -> o.getDataId()).distinct().collect(Collectors.toList());
                usrSearchDatas = KnowledgeRepoServiceHelper.getDataService().queryRepoData(repoSchema, dataIds);
            }
            logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u884c\u7ea7\u6570\u636e\u68c0\u7d22-\u53ef\u7528\u884c\u6570\u636e\u7ed3\u679c\uff1a{}", usrSearchDatas);
            if (usrSearchDatas != null && !usrSearchDatas.isEmpty()) {
                List<RepoSchemaDTO.SchemaField> fields = repoSchema.getFields();
                Map<String, String> fieldPropertyMap = fields.stream().collect(Collectors.toMap(RepoSchemaDTO.SchemaField::getFieldKey, RepoSchemaDTO.SchemaField::getFieldName));
                List<Map<String, Object>> covertDataList = StructuredRepoServiceHelper.covertData(fieldPropertyMap, usrSearchDatas);
                StructuredRowData structuredData = new StructuredRowData(repoType, covertDataList);
                logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u884c\u7ea7\u6570\u636e\u68c0\u7d22-\u884c\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)structuredData);
                return structuredData;
            }
        }
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u884c\u7ea7\u6570\u636e\u68c0\u7d22-\u672a\u68c0\u7d22\u5230\u6570\u636e");
        return new StructuredRowData();
    }

    public static List<SearchTargetDataResult> vectorSearch(SearchTargetDataParam param) {
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u76ee\u6807\u6570\u636e\u5411\u91cf\u68c0\u7d22-\u5165\u53c2\uff1a{}", (Object)param);
        String repoSchemaNumber = param.getRepoSchemaNumber();
        String query = param.getQuery();
        int topK = param.getTopK();
        float similarity = param.getSimilarity();
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u5f85\u68c0\u7d22\u6587\u672c\u5185\u5bb9\u4e0d\u4e3a\u7a7a"), new Object[0]);
        }
        if (topK < 1 || topK > 100) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "TopK\u503c\u4e3a[1,100]"), new Object[0]);
        }
        if (similarity < 0.0f || similarity > 1.0f) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "similarity\u503c\u4e3a[0,1]"), new Object[0]);
        }
        RepoSchemaDTO repoSchema = KnowledgeRepoServiceHelper.getRepoService().getSchemaBySchemaNumber(repoSchemaNumber);
        String searchType = repoSchema.getSearchType();
        if (SearchType.KEYWORD.toString().equalsIgnoreCase(searchType)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u77e5\u8bc6\u5e93\u5411\u91cf\u68c0\u7d22\uff0c\u9700\u8981\u77e5\u8bc6\u5e93\u5185\u5b57\u6bb5\u8bbe\u7f6e\u6784\u5efa\u5411\u91cf\u7d22\u5f15"), new Object[0]);
        }
        String embeddingModelNum = repoSchema.getVectorModel();
        Long repoId = repoSchema.getRepoId();
        LLM embeddingModel = LLM.parse(embeddingModelNum);
        String vectorMetricTypeStr = repoSchema.getVectorMetricType();
        VectorMetricType vectorMetricType = StringUtils.isEmpty((CharSequence)vectorMetricTypeStr) ? VectorMetricType.COSINE : VectorMetricType.parse(vectorMetricTypeStr);
        List<StructuredSearchResultData> vectorResults = StructuredRepoServiceHelper.vectorSearchBuild(repoId, vectorMetricType, query, topK, similarity, embeddingModel);
        List<SearchTargetDataResult> searchTargetDataResultList = StructuredRepoServiceHelper.covert2SearchTargetDatas(param.getSearchType(), repoSchema, vectorResults);
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u76ee\u6807\u6570\u636e\u5411\u91cf\u68c0\u7d22-\u7ed3\u679c\uff1a{}", searchTargetDataResultList);
        return searchTargetDataResultList;
    }

    public static List<SearchTargetDataResult> keywordSearch(SearchTargetDataParam param) {
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u76ee\u6807\u6570\u636e\u5168\u6587\u68c0\u7d22-\u5165\u53c2\uff1a{}", (Object)param);
        String query = param.getQuery();
        int topK = param.getTopK();
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u5f85\u68c0\u7d22\u6587\u672c\u5185\u5bb9\u4e0d\u4e3a\u7a7a"), new Object[0]);
        }
        if (topK < 1 || topK > 100) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "TopK\u503c\u4e3a[1,100]"), new Object[0]);
        }
        String repoSchemaNumber = param.getRepoSchemaNumber();
        RepoSchemaDTO repoSchema = KnowledgeRepoServiceHelper.getRepoService().getSchemaBySchemaNumber(repoSchemaNumber);
        if (repoSchema == null) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, String.format("repo schema number \u503c\u4e3a: %s \u6570\u636e\u4e0d\u5b58\u5728", repoSchemaNumber)), new Object[0]);
        }
        String searchType = repoSchema.getSearchType();
        if (SearchType.VECTOR.toString().equalsIgnoreCase(searchType)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u77e5\u8bc6\u5e93\u5168\u6587\u68c0\u7d22\uff0c\u9700\u8981\u77e5\u8bc6\u5e93\u5185\u5b57\u6bb5\u8bbe\u7f6e\u6784\u5efa\u5168\u6587\u7d22\u5f15"), new Object[0]);
        }
        List<StructuredSearchResultData> keywordResults = StructuredRepoServiceHelper.keywordSearchBulid(repoSchema.getRepoId(), query, topK);
        List<SearchTargetDataResult> searchTargetDataResults = StructuredRepoServiceHelper.covert2SearchTargetDatas(param.getSearchType(), repoSchema, keywordResults);
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u68c0\u7d22-\u5168\u6587\u68c0\u7d22\u7ed3\u679c\uff1a{}", searchTargetDataResults);
        return searchTargetDataResults;
    }

    public static List<SearchTargetDataResult> hybridSearch(SearchTargetDataParam param) {
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u76ee\u6807\u6570\u636e\u6df7\u5408\u68c0\u7d22-\u5165\u53c2\uff1a{}", (Object)param);
        String repoSchemaNumber = param.getRepoSchemaNumber();
        String query = param.getQuery();
        int topK = param.getTopK();
        float similarity = param.getSimilarity();
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u5f85\u68c0\u7d22\u6587\u672c\u5185\u5bb9\u4e0d\u4e3a\u7a7a"), new Object[0]);
        }
        if (topK < 1 || topK > 32) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "TopK\u503c\u4e3a[1,32]"), new Object[0]);
        }
        if (similarity < 0.0f || similarity > 1.0f) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "similarity\u503c\u4e3a[0,1]"), new Object[0]);
        }
        RepoSchemaDTO repoSchema = KnowledgeRepoServiceHelper.getRepoService().getSchemaBySchemaNumber(repoSchemaNumber);
        if (repoSchema == null) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, String.format("repo schema number \u503c\u4e3a: %s \u6570\u636e\u4e0d\u5b58\u5728", repoSchemaNumber)), new Object[0]);
        }
        String searchType = repoSchema.getSearchType();
        if (!SearchType.HYBRID.toString().equalsIgnoreCase(searchType)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u77e5\u8bc6\u5e93\u6df7\u5408\u68c0\u7d22\uff0c\u9700\u8981\u540c\u65f6\u5177\u5907\u5411\u91cf\u3001\u5168\u6587\u7d22\u5f15"), new Object[0]);
        }
        String rerankerLLmNumber = StructuredRepoServiceHelper.getReranker();
        String embeddingModelNum = repoSchema.getVectorModel();
        Long repoId = repoSchema.getRepoId();
        LLM embeddingModel = LLM.parse(embeddingModelNum);
        ArrayList<StructuredSearchResultData> searchDatas = new ArrayList<StructuredSearchResultData>();
        String vectorMetricTypeStr = repoSchema.getVectorMetricType();
        VectorMetricType vectorMetricType = StringUtils.isEmpty((CharSequence)vectorMetricTypeStr) ? VectorMetricType.COSINE : VectorMetricType.parse(vectorMetricTypeStr);
        List<StructuredSearchResultData> keywordResults = StructuredRepoServiceHelper.keywordSearchBulid(repoSchema.getRepoId(), query, topK);
        List<StructuredSearchResultData> vectorResults = StructuredRepoServiceHelper.vectorSearchBuild(repoId, vectorMetricType, query, topK, 0.0f, embeddingModel);
        searchDatas.addAll(keywordResults);
        searchDatas.addAll(vectorResults);
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u68c0\u7d22-\u6df7\u5408\u68c0\u7d22-\u7ed3\u679c\uff1a{}", searchDatas);
        RerankerSearchDTD rerankerDTD = StructuredRepoServiceHelper.rerankerSearchDatas(repoSchema, rerankerLLmNumber, query, searchDatas, topK, similarity);
        if (rerankerDTD != null) {
            List<Map<String, Object>> usrSearchDatas = rerankerDTD.getMetaDatas();
            Map<String, Float> dataScore = rerankerDTD.getDataScore();
            List<RepoSchemaDTO.SchemaField> fields = repoSchema.getFields();
            Map<String, String> fieldPropertyMap = fields.stream().collect(Collectors.toMap(RepoSchemaDTO.SchemaField::getFieldKey, RepoSchemaDTO.SchemaField::getFieldName));
            List<Map<String, Object>> covertDataList = StructuredRepoServiceHelper.covertData(fieldPropertyMap, usrSearchDatas);
            List<SearchTargetDataResult> searchTargetDataResults = dataScore.entrySet().stream().map(v -> {
                String innerId = (String)v.getKey();
                String[] innerInfo = innerId.split("_");
                long dataId = Long.parseLong(innerInfo[0]);
                String property = innerInfo[1];
                Float score = (Float)v.getValue();
                Map rowData = covertDataList.stream().filter(r -> Long.parseLong(String.valueOf(r.get("id"))) == dataId).findFirst().get();
                return new SearchTargetDataResult((String)fieldPropertyMap.get(property), score.floatValue(), rowData);
            }).collect(Collectors.toList());
            logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u76ee\u6807\u6570\u636e\u6df7\u5408\u68c0\u7d22-\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(searchTargetDataResults));
            return searchTargetDataResults;
        }
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u76ee\u6807\u6570\u636e\u6df7\u5408\u68c0\u7d22-\u672a\u68c0\u7d22\u5230\u7ed3\u679c");
        return Collections.EMPTY_LIST;
    }

    public static List<StructuredNodeData> queryNodeData(QureyStructuredNodeDataParam queryParams) {
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u8282\u70b9\u56de\u6eaf\u6570\u636e-\u5165\u53c2\uff1a{}", (Object)JsonUtil.toJson(queryParams));
        Long repoSchemaId = queryParams.getRepoSchemaId();
        RepoSchemaDTO repoSchema = KnowledgeRepoServiceHelper.getRepoService().getSchemaBySchemaId(repoSchemaId);
        List<Long> dataIds = queryParams.getDataIds();
        if (repoSchema.getExternal() != null && repoSchema.getExternal().booleanValue()) {
            return StructuredRepoServiceHelper.queryThird(repoSchema, dataIds);
        }
        List<StructuredNodeData> nodeDatas = GaiStructRepoHelper.queryLevelData(repoSchema, dataIds);
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u68c0\u7d22-\u8282\u70b9\u56de\u6eaf\u68c0\u7d22\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(nodeDatas));
        return nodeDatas;
    }

    public static List<StructuredNodeData> queryThird(RepoSchemaDTO repoSchema, List<Long> dataIds) {
        String callBack = repoSchema.getMserviceCallBack();
        long repoId = repoSchema.getRepoId();
        if (StringUtils.isEmpty((CharSequence)callBack)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u56de\u8c03\u5185\u5bb9\u4e3a\u7a7a"), new Object[0]);
        }
        JSONObject jsonObject = JSON.parseObject((String)callBack);
        JSONObject json = jsonObject.getJSONObject("searchCallBack");
        String cloudId = json.getString("cloudId");
        String appId = json.getString("appId");
        String serviceName = json.getString("serviceName");
        String methodName = json.getString("methodName");
        JSONObject params = new JSONObject();
        params.put("type", (Object)"queryLevelData");
        params.put("repoId", (Object)repoId);
        params.put("repoType", (Object)repoSchema.getRepoType());
        params.put("dataIds", dataIds);
        String rs = (String)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.toJSONString()});
        logger.info("searchCallBack\u56de\u8c03\u8fd4\u56de\u7ed3\u679c:{}", (Object)rs);
        return JSON.parseArray((String)rs, StructuredNodeData.class);
    }

    public static VectorService getVectorService() {
        return VectorServiceHelper.getStructuredService();
    }

    public static KeywordService getKeywordService() {
        return KeywordServiceHelper.getStructuredService();
    }

    private static List<StructuredSearchResultData> keywordSearchBulid(Long repoId, String query, int topK) {
        KeywordDataSearchParam keywordDataSearchParam = KeywordDataSearchParam.newBuilder().withIndexName(new KeywordIndexSchema(repoId)).withQuery(query).withTopK(topK).build();
        List<StructuredSearchResultData> keywordResult = StructuredRepoServiceHelper.getKeywordService().search(keywordDataSearchParam);
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u68c0\u7d22-\u5168\u6587\u68c0\u7d22\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(keywordResult));
        return keywordResult;
    }

    private static List<StructuredSearchResultData> vectorSearchBuild(Long repoId, VectorMetricType vectorMetricType, String query, int topK, float similarity, LLM embeddingModel) {
        VectorDataSearchParam searchParam = VectorDataSearchParam.newBuilder().withCollectionName(new VectorCollectionSchema(repoId)).withEmbeddingModel(embeddingModel).withVectorMetricType(vectorMetricType).withQuery(query).withTopK(topK).withSimilarity(similarity).build();
        List<StructuredSearchResultData> vectorResult = StructuredRepoServiceHelper.getVectorService().search(searchParam);
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u68c0\u7d22-\u5411\u91cf\u68c0\u7d22\u7ed3\u679c\uff1a{}", vectorResult);
        List<StructuredSearchResultData> filterStrucrDatas = vectorResult.stream().filter(v -> v.getScore() >= similarity).collect(Collectors.toList());
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u68c0\u7d22-\u5411\u91cf\u68c0\u7d22-\u76f8\u4f3c\u5ea6\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(filterStrucrDatas));
        return filterStrucrDatas;
    }

    private static RerankerSearchDTD rerankerSearchDatas(RepoSchemaDTO repoSchema, String serviceNumber, String query, List<StructuredSearchResultData> searchDatas, int topK, float similarity) {
        logger.info("\u3010RAG-Reranker\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u91cd\u6392\u6a21\u578b\u5904\u7406\u5f85\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)JsonUtil.toJson(searchDatas));
        if (searchDatas != null && searchDatas.size() > 0) {
            List distinctSearchDataList = searchDatas.stream().distinct().collect(Collectors.toList());
            logger.info("\u3010RAG-Reranker\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u91cd\u6392\u6a21\u578b\u5904\u7406\u5f85\u8bf7\u6c42\u6570\u636e-\u53bb\u91cd-\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(distinctSearchDataList));
            List<Long> searchRowDataIds = distinctSearchDataList.stream().map(o -> o.getDataId()).distinct().collect(Collectors.toList());
            List<Map<String, Object>> useRenkerRepoRowDataList = KnowledgeRepoServiceHelper.getDataService().queryRepoData(repoSchema, searchRowDataIds);
            logger.info("\u3010RAG-Reranker\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u67e5\u8be2\u5e93\u6570\u636e-\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(useRenkerRepoRowDataList));
            ArrayList<RerankChunk> rerankCellValList = new ArrayList<RerankChunk>(useRenkerRepoRowDataList.size());
            for (StructuredSearchResultData searchData : distinctSearchDataList) {
                Long repoDataId = searchData.getDataId();
                String searchDataInnerId = searchData.getInnerId();
                String propertyKey = searchData.getPropertyKey();
                for (Map<String, Object> row : useRenkerRepoRowDataList) {
                    Long useRerankerRowDataId = Long.parseLong(String.valueOf(row.get("id")));
                    if (repoDataId.longValue() != useRerankerRowDataId.longValue()) continue;
                    String cellVal = String.valueOf(row.get(propertyKey));
                    RerankChunk rerankChunk = new RerankChunk(searchDataInnerId, cellVal);
                    rerankCellValList.add(rerankChunk);
                }
            }
            if (rerankCellValList.size() < topK) {
                topK = rerankCellValList.size();
                logger.info("\u3010RAG-Reranker\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u91cd\u6392\u6a21\u578b\u5904\u7406\u5f85\u8bf7\u6c42\u6570\u636e\uff0c\u6587\u6863\u6570\u636e\u5c11\u4e8etopK,\u6570\u636e\u53d8\u66f4\u4e3a\uff1a{}", (Object)topK);
            }
            RerankMessage rerankMessage = new RerankMessage(serviceNumber, rerankCellValList, query, topK);
            logger.info("\u3010RAG-Reranker\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u91cd\u6392\u6a21\u578b-\u6570\u636e\u9884\u5904\u7406\u53bb\u91cd\u540e\u8bf7\u6c42\u6d88\u606f\u4f53\uff1a{}", (Object)JsonUtil.toJson(rerankMessage));
            ResultRerank resultRerank = RerankService.getRerankServiceInstance(serviceNumber).syncRerank(rerankMessage);
            String errorCode = resultRerank.getErrorCode();
            if (Errors.OK.getCode().equals(errorCode)) {
                logger.info("\u3010RAG-Reranker\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u91cd\u6392\u6a21\u578b\u5904\u7406\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(resultRerank));
                List<RerankChunk> rerankContenList = resultRerank.getData();
                Map rerankScoreMap = rerankContenList.stream().filter(r -> r.getRelevanceScore().floatValue() >= similarity).collect(Collectors.toList()).stream().collect(Collectors.toMap(RerankChunk::getChunkId, RerankChunk::getRelevanceScore, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
                List<Map<String, Object>> processedDatas = rerankContenList.stream().map(chunk -> {
                    Map useRepoRowData = useRenkerRepoRowDataList.stream().filter(d -> {
                        String innerId = chunk.getChunkId();
                        String[] rowInfo = innerId.split("_");
                        Long innerRowDataId = Long.parseLong(rowInfo[0]);
                        Long sRepoRowId = Long.parseLong(String.valueOf(d.get("id")));
                        Float relevanceScore = chunk.getRelevanceScore();
                        boolean exist = relevanceScore.floatValue() >= similarity;
                        return innerRowDataId.longValue() == sRepoRowId.longValue() && exist;
                    }).findFirst().orElse(null);
                    return useRepoRowData;
                }).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                logger.info("\u3010RAG-Reranker\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u91cd\u6392\u6a21\u578b\u76f8\u4f3c\u5ea6\u9608\u503c:{}\u8fc7\u6ee4,\u540e\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)Float.valueOf(similarity), (Object)JsonUtil.toJson(processedDatas));
                return new RerankerSearchDTD(processedDatas, rerankScoreMap);
            }
            String resultErr = JsonUtil.toJson(resultRerank);
            logger.error("\u3010RAG-Reranker\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u91cd\u6392\u6a21\u578b\u8c03\u7528\u5f02\u5e38\uff1a{}", (Object)resultErr);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_SEARCH_ERR, resultErr), new Object[0]);
        }
        logger.info("\u3010RAG-Reranker\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u68c0\u7d22\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u91cd\u6392");
        return null;
    }

    @NotNull
    private static List<SearchTargetDataResult> covert2SearchTargetDatas(SearchType searchType, RepoSchemaDTO repoSchema, List<StructuredSearchResultData> searchResults) {
        String repoType = repoSchema.getRepoType();
        List<RepoSchemaDTO.SchemaField> fields = repoSchema.getFields();
        Map<String, String> fieldPropertyMap = fields.stream().collect(Collectors.toMap(RepoSchemaDTO.SchemaField::getFieldKey, RepoSchemaDTO.SchemaField::getFieldName));
        List<Long> dataIds = searchResults.stream().map(o -> o.getDataId()).distinct().collect(Collectors.toList());
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u76ee\u6807\u6570\u636e\u3010{}\u3011\u68c0\u7d22-\u67e5\u6570IDS\uff1a{}", (Object)searchType, (Object)(dataIds != null ? dataIds.toString() : "[],\u4e3a\u7a7a"));
        if (dataIds == null || dataIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<Map<String, Object>> usrSearchDatas = KnowledgeRepoServiceHelper.getDataService().queryRepoData(repoSchema, dataIds);
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u76ee\u6807\u6570\u636e\u3010{}\u3011\u68c0\u7d22-\u67e5\u6570\u7ed3\u679c\uff1a{}", (Object)searchType, (Object)JsonUtil.toJson(usrSearchDatas));
        List<Map<String, Object>> rowInfos = StructuredRepoServiceHelper.covertData(fieldPropertyMap, usrSearchDatas);
        return searchResults.stream().map(v -> {
            Long dataId = v.getDataId();
            try {
                Map rowData = rowInfos.stream().filter(r -> Long.parseLong(String.valueOf(r.get("id"))) == dataId).findFirst().get();
                return new SearchTargetDataResult((String)fieldPropertyMap.get(v.getPropertyKey()), v.getScore(), rowData);
            }
            catch (Exception e) {
                logger.error("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u76ee\u6807\u6570\u636e\u3010{}\u3011\u68c0\u7d22-\u5b58\u5728\u4e1a\u52a1\u5e93\u4e0e\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5e93\u4e2d\u5bf9\u5e94IDS\u6570\u636e", (Object)searchType, (Object)e);
                throw new KDBizException(String.format("\u4e1a\u52a1\u5e93\u4e0e\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u65b9\u68c0\u67e5\u5e93\u4e2d\u5bf9\u5e94IDS\u6570\u636e:%s", dataIds.toString()));
            }
        }).collect(Collectors.toList());
    }

    @NotNull
    private static List<Map<String, Object>> covertData(Map<String, String> fieldPropertyMap, List<Map<String, Object>> useSearchDatas) {
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u68c0\u7d22-\u5e93\u884c\u6570\u636e-\u5b57\u6bb5shcema\u4fe1\u606f\uff1a{}\uff0c\u539f\u59cb\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(fieldPropertyMap), (Object)JsonUtil.toJson(useSearchDatas));
        ArrayList<Map<String, Object>> newUseSearchDatas = new ArrayList<Map<String, Object>>(useSearchDatas.size());
        for (Map<String, Object> useSearchData : useSearchDatas) {
            LinkedHashMap<String, Object> newUseSearchData = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> next : useSearchData.entrySet()) {
                String key = next.getKey();
                Object value = next.getValue();
                if (fieldPropertyMap.containsKey(key)) {
                    newUseSearchData.put(fieldPropertyMap.get(key), value);
                    continue;
                }
                newUseSearchData.put(key, value);
            }
            useSearchData.clear();
            newUseSearchDatas.add(newUseSearchData);
        }
        logger.info("\u3010RAG-\u63a5\u53e3\u670d\u52a1\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u68c0\u7d22-\u5e93\u884c\u6570\u636e-shcema\u8f6c\u6362\u540e\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(newUseSearchDatas));
        return newUseSearchDatas;
    }

    private static String getReranker() {
        RerankerConfig rerankerConfig = RerankerConfigService.loadCurrentReranker();
        logger.info("\u3010RAG\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u884c\u7ea7\u6570\u636e\u68c0\u7d22-\u542f\u7528\u91cd\u6392\u5e8f\uff0c\u68c0\u67e5\u77e5\u8bc6\u5e93\u914d\u7f6e\uff0c\u91cd\u6392\u6a21\u578b\u8bbe\u7f6e\u4fe1\u606f\uff1a{}", (Object)JsonUtil.toJson(rerankerConfig));
        boolean used = rerankerConfig.getUsed();
        if (!used) {
            String errMsg = "\u91cd\u6392\u5e8f\u6a21\u578b\u5728\u77e5\u8bc6\u5e93\u914d\u7f6e\u4e2d\u672a\u5f00\u542f";
            logger.error("\u3010RAG\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u884c\u7ea7\u6570\u636e\u68c0\u7d22-\u91cd\u6392\u5e8f\u5f02\u5e38,{}", (Object)errMsg);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_SEARCH_ERR, errMsg), new Object[0]);
        }
        String rerankerLLmNumber = rerankerConfig.getServiceNumber();
        return rerankerLLmNumber;
    }
}

