/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.entity.StructRepo;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.ai.gai.core.search.IKnowledgeRepoService;
import kd.ai.gai.core.search.IKnowledgeStatusService;
import kd.ai.gai.core.search.dto.RepoSchemaDTO;
import kd.ai.gai.core.search.enums.KnoDataStatus;
import kd.ai.gai.core.search.helper.KnowledgeRepoServiceHelper;
import kd.ai.gai.core.search.param.knoData.KnoDataStatusParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class KnowLedgeStatusService
implements IKnowledgeStatusService {
    private static final Log logger = LogFactory.getLog(KnowLedgeStatusService.class);

    @Override
    public void dataStatusCallBack(KnoDataStatusParam param) {
        List<Object> knoDataIds = param.getKnoDataIds();
        String status = param.getStatus();
        String repoNumber = param.getRepoNumber();
        IKnowledgeRepoService repoService = KnowledgeRepoServiceHelper.getRepoService();
        RepoSchemaDTO schema = repoService.getSchemaByRepoNum(repoNumber);
        if (BooleanUtils.isTrue((Boolean)schema.getExternal())) {
            String paramJsonStr = JSON.toJSONString((Object)param);
            logger.info(Constant.RepoSchema.LOG_PREFIX + "\u5916\u90e8\u77e5\u8bc6\u5e93,\u5f00\u59cb\u6279\u91cf\u66f4\u65b0\u77e5\u8bc6\u6570\u636e\u56de\u8c03\u72b6\u6001,repoId:[{}],param:[{}]", (Object)param.getRepoId(), (Object)paramJsonStr);
            String mserviceCallBack = schema.getMserviceCallBack();
            JSONObject callBackJsonObj = JSON.parseObject((String)mserviceCallBack);
            JSONObject serviceJsonObj = callBackJsonObj.getJSONObject("dataStateCallback");
            String cloudId = serviceJsonObj.getString("cloudId");
            String appId = serviceJsonObj.getString("appId");
            String serviceName = serviceJsonObj.getString("serviceName");
            String methodName = serviceJsonObj.getString("methodName");
            try {
                DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{paramJsonStr});
            }
            catch (Exception e) {
                logger.error(Constant.RepoSchema.LOG_PREFIX + "\u5916\u90e8\u77e5\u8bc6\u5e93,\u56de\u8c03\u66f4\u65b0\u6570\u636e\u72b6\u6001\u5931\u8d25,param:[{}],callBack:[{}]", new Object[]{paramJsonStr, mserviceCallBack, e});
                throw new KDBizException(ResManager.loadKDString((String)"\u56de\u8c03\u66f4\u65b0\u6570\u636e\u72b6\u6001\u5931\u8d25\uff0c\u5fae\u670d\u52a1\u8c03\u7528\u5f02\u5e38\u3002", (String)"KnowLedgeStatusService_0", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            return;
        }
        logger.info("\u5f00\u59cb\u6279\u91cf\u66f4\u65b0\u77e5\u8bc6\u6570\u636e\u56de\u8c03\u72b6\u6001\uff0cids\uff1a{}\uff0cstatus\uff1a{}\uff0crepoNumber\uff1a{}", new Object[]{knoDataIds, status, repoNumber});
        StructRepo repo = GaiStructRepoHelper.queryStructRepoByRepoNumber(repoNumber);
        if (repo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u56de\u8c03\u66f4\u65b0\u6570\u636e\u72b6\u6001\u5931\u8d25\uff0c\u672a\u627e\u5230\u77e5\u8bc6\u5e93\u7f16\u7801\u5bf9\u5e94\u7684\u77e5\u8bc6\u5e93\u3002", (String)"KnowLedgeStatusService_1", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        String repoType = repo.getRepoType();
        String formId = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)repoType, (CharSequence)RepoConstant.RepoType.LEVEL.getType())) {
            formId = "gai_repo_treedata";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)repoType, (CharSequence)RepoConstant.RepoType.TABLE.getType())) {
            formId = "gai_table_repo";
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u56de\u8c03\u66f4\u65b0\u6570\u636e\u72b6\u6001\u5931\u8d25\uff0c\u77e5\u8bc6\u5e93\u7c7b\u578b\u9519\u8bef\u3002", (String)"KnowLedgeStatusService_2", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)KnoDataStatus.SUCCESS.getValue())) {
            ArrayList<DynamicObject> updateEntrys = new ArrayList<DynamicObject>(0);
            for (Object dataId : knoDataIds) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)formId);
                dynamicObject.set("id", dataId);
                dynamicObject.set("datastatus", (Object)status);
                updateEntrys.add(dynamicObject);
            }
            SaveServiceHelper.update((DynamicObject[])updateEntrys.toArray(new DynamicObject[0]));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)KnoDataStatus.FAILED.getValue())) {
            String errorMsg = param.getBriefForFailure();
            String errorDetailMsg = param.getDetailedForFailure();
            String string = StringUtils.isEmpty((CharSequence)errorMsg) ? "" : (errorMsg = errorMsg.length() > 500 ? errorMsg.substring(0, 499) : errorMsg);
            errorDetailMsg = StringUtils.isEmpty((CharSequence)errorDetailMsg) ? "" : (errorDetailMsg.length() > 2000 ? errorDetailMsg.substring(0, 1999) : errorDetailMsg);
            String finalErrorMsg = errorMsg;
            String finalErrorDetailMsg = errorDetailMsg;
            ArrayList<DynamicObject> updateEntrys = new ArrayList<DynamicObject>(0);
            for (Object dataId : knoDataIds) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)formId);
                dynamicObject.set("id", dataId);
                dynamicObject.set("datastatus", (Object)status);
                dynamicObject.set("errormsg", (Object)this.handlerMsgLength(finalErrorMsg, 500));
                dynamicObject.set("errormsgdetail", (Object)this.handlerMsgLength(finalErrorDetailMsg, 1000));
                updateEntrys.add(dynamicObject);
            }
            SaveServiceHelper.update((DynamicObject[])updateEntrys.toArray(new DynamicObject[0]));
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u56de\u8c03\u66f4\u65b0\u6570\u636e\u72b6\u6001\u5931\u8d25\uff0c\u72b6\u6001\u7c7b\u578b\u9519\u8bef\u3002", (String)"KnowLedgeStatusService_3", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        logger.info("\u5b8c\u6210\u6279\u91cf\u66f4\u65b0\u77e5\u8bc6\u6570\u636e\u56de\u8c03\u72b6\u6001");
    }

    private String handlerMsgLength(String message, int maxLength) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        int length = message.length();
        if (length >= maxLength) {
            return message.substring(0, maxLength - 1);
        }
        return message;
    }
}

