/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.engine.handler.StructuredEmbeddingHandler;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.ai.gai.core.search.IKnowledgeDataService;
import kd.ai.gai.core.search.IKnowledgeRepoService;
import kd.ai.gai.core.search.IKnowledgeStatusService;
import kd.ai.gai.core.search.dto.EmbContent;
import kd.ai.gai.core.search.dto.EmbTaskDTO;
import kd.ai.gai.core.search.dto.RepoSchemaDTO;
import kd.ai.gai.core.search.enums.KnoDataStatus;
import kd.ai.gai.core.search.helper.KnowledgeRepoServiceHelper;
import kd.ai.gai.core.search.helper.StructuredRepoServiceHelper;
import kd.ai.gai.core.search.index.param.keyword.KeywordData;
import kd.ai.gai.core.search.index.param.keyword.KeywordDataAddParam;
import kd.ai.gai.core.search.index.param.keyword.KeywordDataDelParam;
import kd.ai.gai.core.search.index.param.vector.VectorDataDelParam;
import kd.ai.gai.core.search.index.schema.KeywordIndexSchema;
import kd.ai.gai.core.search.index.schema.VectorCollectionSchema;
import kd.ai.gai.core.search.index.service.KeywordService;
import kd.ai.gai.core.search.index.service.VectorService;
import kd.ai.gai.core.search.param.knoData.DelKnoDataParam;
import kd.ai.gai.core.search.param.knoData.KnoDataStatusParam;
import kd.ai.gai.core.search.param.knoData.SaveKnoDataParam;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeDataService
implements IKnowledgeDataService {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeDataService.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)("gai-repo-schema-" + LocalDateTime.now()), (int)10);

    @Override
    public void batchAddKnowledge(SaveKnoDataParam param) {
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f00\u59cb\u6279\u91cf\u65b0\u589e\u77e5\u8bc6\u5e93\u6570\u636e,param:[{}]", (Object)param);
        List<String> paramFieldKeys = param.getFieldKeys();
        int dataIdIndex = paramFieldKeys.indexOf("id");
        if (dataIdIndex == -1) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5b57\u6bb5\u4e2d\u5fc5\u987b\u8981\u6709id\u5b57\u6bb5,param:[{}]", (Object)param);
            throw new KDBizException("\u5b57\u6bb5\u4e2d\u5fc5\u987b\u8981\u6709id\u5b57\u6bb5");
        }
        Object[][] data = param.getData();
        if (ArrayUtils.isEmpty((Object[])data) || ArrayUtils.isEmpty((Object[])data[0])) {
            return;
        }
        if (data[0].length != paramFieldKeys.size()) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5b57\u6bb5\u6570\u91cf\u548c\u6570\u636e\u5b57\u6bb5\u6570\u91cf\u9700\u4e00\u81f4,param:[{}]", (Object)param);
            throw new KDBizException("\u5b57\u6bb5\u6570\u91cf\u548c\u6570\u636e\u5b57\u6bb5\u6570\u91cf\u9700\u4e00\u81f4");
        }
        String schemaNumber = param.getSchemaNumber();
        RepoSchemaDTO schema = KnowledgeDataService.safeGetSchema(schemaNumber);
        List<RepoSchemaDTO.SchemaField> fields = schema.getFields();
        Map<String, String> fieldKeyNameMap = fields.stream().collect(Collectors.toMap(RepoSchemaDTO.SchemaField::getFieldKey, RepoSchemaDTO.SchemaField::getFieldName));
        Set savedAllFieldKeys = fields.stream().map(RepoSchemaDTO.SchemaField::getFieldKey).collect(Collectors.toSet());
        HashSet paramFieldKeysSet = Sets.newHashSet(paramFieldKeys);
        paramFieldKeysSet.remove("id");
        if (!savedAllFieldKeys.containsAll(paramFieldKeysSet)) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u542b\u6709\u672a\u77e5\u5b57\u6bb5,param:[{}]", (Object)param);
            throw new KDBizException("\u542b\u6709\u672a\u77e5\u5b57\u6bb5");
        }
        Set vectorFieldKeys = fields.stream().filter(RepoSchemaDTO.SchemaField::getVectorIndexEnable).map(RepoSchemaDTO.SchemaField::getFieldKey).collect(Collectors.toSet());
        Set indexFieldKeys = fields.stream().filter(RepoSchemaDTO.SchemaField::getFullIndexEnable).map(RepoSchemaDTO.SchemaField::getFieldKey).collect(Collectors.toSet());
        IKnowledgeRepoService repoService = KnowledgeRepoServiceHelper.getRepoService();
        repoService.increaseDataCount(schemaNumber, data.length, 0, 0);
        THREAD_POOL.execute(() -> {
            try {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f00\u59cb\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e,schema:[{}]", (Object)schema);
                HashSet failedIndexDataId = Sets.newHashSetWithExpectedSize((int)data.length);
                if (CollectionUtils.isNotEmpty((Collection)indexFieldKeys)) {
                    failedIndexDataId.addAll(KnowledgeDataService.processIndexData(data, dataIdIndex, fieldKeyNameMap, schema, paramFieldKeys, indexFieldKeys, vectorFieldKeys));
                }
                if (CollectionUtils.isNotEmpty((Collection)vectorFieldKeys)) {
                    KnowledgeDataService.processVectorData(data, dataIdIndex, schema, paramFieldKeys, vectorFieldKeys, failedIndexDataId);
                }
            }
            catch (Exception e) {
                log.error(Constant.RepoSchema.LOG_PREFIX + "\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e\u5f02\u5e38,param:[{}]", (Object)param, (Object)e);
                HashSet dataIds = Sets.newHashSetWithExpectedSize((int)data.length);
                for (Object[] dataArr : data) {
                    String dataId = dataArr[dataIdIndex].toString();
                    dataIds.add(Long.valueOf(dataId));
                }
                IKnowledgeStatusService statusService = KnowledgeRepoServiceHelper.getStatusService();
                KnoDataStatusParam statusParam = new KnoDataStatusParam();
                statusParam.setRepoId(schema.getRepoId());
                statusParam.setRepoNumber(schema.getRepoNumber());
                statusParam.setKnoDataIds(Lists.newArrayList((Iterable)dataIds));
                statusParam.setStatus(KnoDataStatus.FAILED.getValue());
                statusParam.setBriefForFailure("\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e\u5f02\u5e38");
                statusParam.setDetailedForFailure(e.getMessage());
                statusService.dataStatusCallBack(statusParam);
            }
        });
    }

    private static void processVectorData(Object[][] data, int dataIdIndex, RepoSchemaDTO schema, List<String> fieldKeys, Set<String> vectorFieldKeys, Set<Long> failedIndexDataId) {
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f00\u59cb\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e-\u5411\u91cf,fieldKeys:[{}]", vectorFieldKeys);
        ArrayList contents = Lists.newArrayListWithExpectedSize((int)vectorFieldKeys.size());
        for (Object[] dataArr : data) {
            String dataId = dataArr[dataIdIndex].toString();
            if (failedIndexDataId.contains(Long.valueOf(dataId))) {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u6570\u636e\u5168\u6587\u7d22\u5f15\u5931\u8d25,\u4e0d\u518d\u5411\u91cf\u5316\u5904\u7406,dataId:[{}]", (Object)dataId);
                continue;
            }
            int notBlankFieldCount = 0;
            for (String vectorField : vectorFieldKeys) {
                int dataIndex = fieldKeys.indexOf(vectorField);
                String dataContent = dataArr[dataIndex].toString();
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dataContent)) continue;
                EmbContent embContent = new EmbContent.EmbContentBuilder().dataId(dataId).fieldKey(vectorField).fieldName(vectorField).content(dataContent).build();
                contents.add(embContent);
                ++notBlankFieldCount;
            }
            if (notBlankFieldCount != 0) continue;
            KnoDataStatusParam statusParam = new KnoDataStatusParam();
            statusParam.setRepoId(schema.getRepoId());
            statusParam.setRepoNumber(schema.getRepoNumber());
            statusParam.setKnoDataIds(Lists.newArrayList((Object[])new Object[]{dataId}));
            statusParam.setStatus(KnoDataStatus.SUCCESS.getValue());
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e-\u5411\u91cf,\u6240\u6709\u5b57\u6bb5\u5185\u5bb9\u90fd\u4e3a\u7a7a,\u76f4\u63a5\u56de\u8c03 param:[{}]", (Object)statusParam);
            IKnowledgeStatusService statusService = KnowledgeRepoServiceHelper.getStatusService();
            statusService.dataStatusCallBack(statusParam);
        }
        if (CollectionUtils.isNotEmpty((Collection)contents)) {
            EmbTaskDTO embTaskDTO = new EmbTaskDTO.EmbTaskDTOBuilder().repoId(schema.getRepoId()).llm(LLM.parse(schema.getVectorModel())).contentList(contents).build();
            StructuredEmbeddingHandler.process(embTaskDTO);
        }
    }

    private static Set<Long> processIndexData(Object[][] data, int dataIdIndex, Map<String, String> fieldKeyNameMap, RepoSchemaDTO schema, List<String> fieldKeys, Set<String> indexFieldKeys, Set<String> vectorFieldKeys) {
        int totalCount;
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f00\u59cb\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e-\u5168\u6587\u7d22\u5f15,indexFieldKeys:[{}]", indexFieldKeys);
        HashSet failedDataIds = Sets.newHashSetWithExpectedSize((int)data.length);
        ArrayList<KeywordData> keywordDataList = new ArrayList<KeywordData>();
        int remainCount = totalCount = indexFieldKeys.size() * data.length;
        for (Object[] dataArr : data) {
            IKnowledgeStatusService statusService;
            String dataId = dataArr[dataIdIndex].toString();
            int notBlankFieldCount = 0;
            for (String fieldKey : indexFieldKeys) {
                String fieldName = fieldKeyNameMap.get(fieldKey);
                int dataIndex = fieldKeys.indexOf(fieldKey);
                if (dataIndex == -1) {
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e-\u5168\u6587\u7d22\u5f15,\u53c2\u6570\u4e2d\u6ca1\u6709\u8be5\u5b57\u6bb5\u6570\u636e,fieldKey:[{}],fieldName:[{}]", (Object)fieldKey, (Object)fieldName);
                    --remainCount;
                    continue;
                }
                String dataContent = dataArr[dataIndex].toString();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dataContent)) {
                    ++notBlankFieldCount;
                    KeywordData keywordData = new KeywordData(Long.valueOf(dataId), fieldKey, fieldName, dataContent);
                    keywordDataList.add(keywordData);
                }
                --remainCount;
            }
            if (notBlankFieldCount == 0) {
                KnoDataStatusParam statusParam = new KnoDataStatusParam();
                statusParam.setRepoId(schema.getRepoId());
                statusParam.setRepoNumber(schema.getRepoNumber());
                statusParam.setKnoDataIds(Lists.newArrayList((Object[])new Object[]{dataId}));
                statusParam.setStatus(KnoDataStatus.SUCCESS.getValue());
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e-\u5168\u6587\u7d22\u5f15,\u6240\u6709\u5b57\u6bb5\u5185\u5bb9\u90fd\u4e3a\u7a7a,\u76f4\u63a5\u56de\u8c03 param:[{}]", (Object)statusParam);
                statusService = KnowledgeRepoServiceHelper.getStatusService();
                statusService.dataStatusCallBack(statusParam);
                continue;
            }
            if (keywordDataList.size() < 500 && remainCount > 0) continue;
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e-\u5168\u6587\u7d22\u5f15,\u6279\u6b21\u5904\u7406 [{}/{}]", (Object)(totalCount - remainCount), (Object)totalCount);
            Set dataIds = keywordDataList.stream().map(KeywordData::getDataId).collect(Collectors.toSet());
            statusService = KnowledgeRepoServiceHelper.getStatusService();
            try {
                KnoDataStatusParam statusParam;
                KeywordIndexSchema indexSchema = new KeywordIndexSchema(schema.getRepoId());
                KeywordDataAddParam keywordDataAddParam = KeywordDataAddParam.newBuilder().withIndexName(indexSchema).withIndexDatas(keywordDataList).build();
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e-\u5168\u6587\u7d22\u5f15,\u6279\u91cf\u65b0\u589e\u7d22\u5f15\u6570\u636e param:[{}]", keywordDataList);
                KeywordService keywordService = StructuredRepoServiceHelper.getKeywordService();
                boolean addResult = keywordService.batchAddData(keywordDataAddParam);
                if (!addResult) {
                    log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e-\u5168\u6587\u7d22\u5f15,\u6279\u91cf\u65b0\u589e\u7d22\u5f15\u6570\u636e\u5931\u8d25 param:[{}]", keywordDataList);
                    failedDataIds.addAll(dataIds);
                    statusParam = new KnoDataStatusParam();
                    statusParam.setRepoId(schema.getRepoId());
                    statusParam.setRepoNumber(schema.getRepoNumber());
                    statusParam.setKnoDataIds(Lists.newArrayList(dataIds));
                    statusParam.setStatus(KnoDataStatus.FAILED.getValue());
                    statusParam.setBriefForFailure("\u5168\u6587\u7d22\u5f15\u5931\u8d25");
                    statusParam.setDetailedForFailure("\u5168\u6587\u7d22\u5f15\u5931\u8d25");
                    statusService.dataStatusCallBack(statusParam);
                } else if (CollectionUtils.isEmpty(vectorFieldKeys)) {
                    statusParam = new KnoDataStatusParam();
                    statusParam.setRepoId(schema.getRepoId());
                    statusParam.setRepoNumber(schema.getRepoNumber());
                    statusParam.setKnoDataIds(Lists.newArrayList(dataIds));
                    statusParam.setStatus(KnoDataStatus.SUCCESS.getValue());
                    log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e-\u5168\u6587\u7d22\u5f15,\u6ca1\u6709\u9700\u8981\u5411\u91cf\u5316\u7684\u5b57\u6bb5,\u76f4\u63a5\u56de\u8c03 param:[{}]", keywordDataList);
                    statusService.dataStatusCallBack(statusParam);
                }
            }
            catch (Exception e) {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f02\u6b65\u5904\u7406\u77e5\u8bc6\u5e93\u6570\u636e-\u5168\u6587\u7d22\u5f15\u5f02\u5e38, param:[{}]", keywordDataList, (Object)e);
                failedDataIds.addAll(dataIds);
                KnoDataStatusParam statusParam = new KnoDataStatusParam();
                statusParam.setRepoId(schema.getRepoId());
                statusParam.setRepoNumber(schema.getRepoNumber());
                statusParam.setKnoDataIds(Lists.newArrayList(dataIds));
                statusParam.setStatus(KnoDataStatus.FAILED.getValue());
                statusParam.setBriefForFailure("\u5168\u6587\u7d22\u5f15\u5f02\u5e38");
                statusParam.setDetailedForFailure(e.getMessage());
                statusService.dataStatusCallBack(statusParam);
            }
            keywordDataList.clear();
        }
        return failedDataIds;
    }

    @Override
    public void batchDelKnowledge(DelKnoDataParam param) {
        List indexFieldKeys;
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f00\u59cb\u6279\u91cf\u5220\u9664\u77e5\u8bc6\u5e93\u6570\u636e,param:[{}]", (Object)param);
        this.checkDelParam(param);
        List<Object> knoDataIds = param.getKnoDataIds();
        if (CollectionUtils.isEmpty(knoDataIds)) {
            return;
        }
        RepoSchemaDTO schema = KnowledgeDataService.safeGetSchema(param.getSchemaNumber());
        List<RepoSchemaDTO.SchemaField> fields = schema.getFields();
        List vectorFieldKeys = fields.stream().filter(RepoSchemaDTO.SchemaField::getVectorIndexEnable).map(RepoSchemaDTO.SchemaField::getFieldKey).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(vectorFieldKeys)) {
            VectorCollectionSchema collectionSchema = new VectorCollectionSchema(schema.getRepoId());
            ArrayList<VectorDataDelParam.DelData> delDataList = new ArrayList<VectorDataDelParam.DelData>();
            for (String fieldName : vectorFieldKeys) {
                for (Object object : knoDataIds) {
                    VectorDataDelParam.DelData delData = new VectorDataDelParam.DelData(Long.valueOf(object.toString()), fieldName);
                    delDataList.add(delData);
                }
            }
            VectorDataDelParam dataDelParam = VectorDataDelParam.newBuilder().withCollectionName(collectionSchema).withDelDataList(delDataList).build();
            VectorService vectorService = StructuredRepoServiceHelper.getVectorService();
            try {
                vectorService.batchDelData(dataDelParam);
            }
            catch (Exception e) {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u77e5\u8bc6\u5e93\u6570\u636e\u7684\u5411\u91cf\u5f02\u5e38,param:[{}]", (Object)JSON.toJSONString((Object)dataDelParam));
                throw e;
            }
        }
        if (CollectionUtils.isNotEmpty(indexFieldKeys = fields.stream().filter(RepoSchemaDTO.SchemaField::getFullIndexEnable).map(RepoSchemaDTO.SchemaField::getFieldKey).collect(Collectors.toList()))) {
            KeywordIndexSchema indexSchema = new KeywordIndexSchema(schema.getRepoId());
            ArrayList<KeywordDataDelParam.DelData> dataList = new ArrayList<KeywordDataDelParam.DelData>();
            for (String fieldName : indexFieldKeys) {
                for (Object knoDataId : knoDataIds) {
                    KeywordDataDelParam.DelData delData = new KeywordDataDelParam.DelData(Long.valueOf(knoDataId.toString()), fieldName);
                    dataList.add(delData);
                }
            }
            KeywordDataDelParam dataDelParam = KeywordDataDelParam.newBuilder().withIndexName(indexSchema).withIndexDelDatas(dataList).build();
            KeywordService keywordService = StructuredRepoServiceHelper.getKeywordService();
            try {
                keywordService.batchDelData(dataDelParam);
            }
            catch (Exception exception) {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u77e5\u8bc6\u5e93\u6570\u636e\u7684\u7d22\u5f15\u5f02\u5e38,param:[{}]", (Object)JSON.toJSONString((Object)dataDelParam));
                throw exception;
            }
        }
    }

    @Override
    public void batchModKnowledge(SaveKnoDataParam param) {
        RepoSchemaDTO schema = KnowledgeDataService.safeGetSchema(param.getSchemaNumber());
        List<String> fieldKeys = param.getFieldKeys();
        int dataIdIndex = fieldKeys.indexOf("id");
        Object[][] data = param.getData();
        ArrayList knoDataIds = Lists.newArrayListWithExpectedSize((int)data.length);
        for (Object[] dataArr : data) {
            Object idObj = dataArr[dataIdIndex];
            knoDataIds.add(idObj);
        }
        DelKnoDataParam delKnoDataParam = new DelKnoDataParam(schema.getSchemaNumber(), knoDataIds);
        this.batchDelKnowledge(delKnoDataParam);
        this.batchAddKnowledge(param);
    }

    @Override
    public List<Map<String, Object>> queryRepoData(RepoSchemaDTO repoSchema, List<Long> dataIdList) {
        if (repoSchema.getExternal() != null && repoSchema.getExternal().booleanValue()) {
            return KnowledgeDataService.queryThird(repoSchema, dataIdList);
        }
        return GaiStructRepoHelper.queryRepoData(repoSchema, dataIdList);
    }

    public static List<Map<String, Object>> queryThird(RepoSchemaDTO repoSchema, List<Long> dataIds) {
        String callBack = repoSchema.getMserviceCallBack();
        long repoId = repoSchema.getRepoId();
        if (StringUtils.isEmpty((CharSequence)callBack)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.RAG_REPO_MS_PARAMS_ERR, "\u56de\u8c03\u5185\u5bb9\u4e3a\u7a7a"), new Object[0]);
        }
        JSONObject jsonObject = JSON.parseObject((String)callBack);
        JSONObject json = jsonObject.getJSONObject("searchCallBack");
        String cloudId = json.getString("cloudId");
        String appId = json.getString("appId");
        String serviceName = json.getString("serviceName");
        String methodName = json.getString("methodName");
        JSONObject params = new JSONObject();
        params.put("type", (Object)"queryRepoData");
        params.put("repoId", (Object)repoId);
        params.put("repoType", (Object)repoSchema.getRepoType());
        params.put("dataIds", dataIds);
        String rs = (String)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.toJSONString()});
        log.info("searchCallBack queryRepoData \u56de\u8c03\u8fd4\u56de\u7ed3\u679c:{}", (Object)rs);
        return (List)JSON.parseObject((String)rs, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
    }

    private static RepoSchemaDTO safeGetSchema(String schemaNumber) {
        IKnowledgeRepoService repoService = KnowledgeRepoServiceHelper.getRepoService();
        RepoSchemaDTO schema = repoService.getSchemaBySchemaNum(schemaNumber);
        if (schema == null) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u6839\u636eschemaNumber:[{}],\u672a\u627e\u5230\u5df2\u4fdd\u5b58\u7684\u77e5\u8bc6\u5e93schema", (Object)schemaNumber);
            throw new KDBizException("\u672a\u627e\u5230\u5df2\u4fdd\u5b58\u7684\u77e5\u8bc6\u5e93schema");
        }
        return schema;
    }

    public void checkDelParam(DelKnoDataParam param) {
        if (param == null) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u77e5\u8bc6\u5e93\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            throw new KDBizException("\u5220\u9664\u77e5\u8bc6\u5e93\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String schemaNumber = param.getSchemaNumber();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)schemaNumber)) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93schema\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            throw new KDBizException("\u77e5\u8bc6\u5e93schema\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

