/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.enuz.es.ESTokenizerType;
import kd.ai.gai.core.enuz.repo.SearchType;
import kd.ai.gai.core.search.IKnowledgeRepoService;
import kd.ai.gai.core.search.dto.CreateRepoResDTO;
import kd.ai.gai.core.search.dto.RepoSchemaDTO;
import kd.ai.gai.core.search.enums.FullSearchType;
import kd.ai.gai.core.search.enums.RepoFieldType;
import kd.ai.gai.core.search.enums.VectorDbType;
import kd.ai.gai.core.search.helper.StructuredRepoServiceHelper;
import kd.ai.gai.core.search.index.param.keyword.KeywordDataCountParam;
import kd.ai.gai.core.search.index.param.keyword.KeywordIndexCreateParam;
import kd.ai.gai.core.search.index.param.keyword.KeywordIndexDropParam;
import kd.ai.gai.core.search.index.param.keyword.KeywordIndexNameParam;
import kd.ai.gai.core.search.index.param.vector.VectorCollectionCreateParam;
import kd.ai.gai.core.search.index.param.vector.VectorCollectionDropParam;
import kd.ai.gai.core.search.index.param.vector.VectorCollectionNameParam;
import kd.ai.gai.core.search.index.param.vector.VectorDataCountParam;
import kd.ai.gai.core.search.index.schema.KeywordIndexSchema;
import kd.ai.gai.core.search.index.schema.VectorCollectionSchema;
import kd.ai.gai.core.search.index.service.KeywordService;
import kd.ai.gai.core.search.index.service.VectorService;
import kd.ai.gai.core.search.param.schema.AddFieldParam;
import kd.ai.gai.core.search.param.schema.DelKnoSchemaParam;
import kd.ai.gai.core.search.param.schema.SaveKnoSchemaParam;
import kd.ai.gai.core.service.embedding.EmbeddingService;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeRepoService
implements IKnowledgeRepoService {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeRepoService.class);

    @Override
    public CreateRepoResDTO saveSchema(SaveKnoSchemaParam param) {
        String schemaNumber;
        StopWatch stopWatch;
        block11: {
            stopWatch = new StopWatch();
            stopWatch.start();
            this.checkParam(param);
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u4fdd\u5b58\u77e5\u8bc6\u5e93Schema:[{}]", (Object)param);
            schemaNumber = param.getSchemaNumber();
            DynamicObject dynamicObject = this.transParamToDo(param);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schemaNumber)) {
                RepoSchemaDTO savedSchema = this.getSchemaBySchemaNumber(schemaNumber);
                if (this.hasData(savedSchema) && this.fieldModOrDel(savedSchema.getFields(), param.getFields())) {
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u4e2d\u5df2\u6709\u6570\u636e,\u4e0d\u5141\u8bb8\u5220\u9664\u6216\u4fee\u6539\u5b57\u6bb5,repoId:[{}],savedFields:[{}],paramFields:[{}]", new Object[]{param.getRepoId(), savedSchema.getFields(), param.getFields()});
                    throw new KDBizException("\u77e5\u8bc6\u5e93\u4e2d\u5df2\u6709\u6570\u636e,\u4e0d\u5141\u8bb8\u5220\u9664\u6216\u4fee\u6539\u5b57\u6bb5");
                }
                KnowledgeRepoService.checkCanNotMod(param, savedSchema);
                KnowledgeRepoService.keepOldValue(dynamicObject, savedSchema);
                this.setFieldListAndSearchType(dynamicObject, param.getFields(), param.getTokenizerType(), param.getVectorMetricType());
                DelKnoSchemaParam delParam = new DelKnoSchemaParam.DelKnoSchemaParamBuilder().schemaNumber(schemaNumber).build();
                this.delSchema(delParam, false);
            } else {
                if (this.repoExist(param.getRepoId())) {
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684schema\u5df2\u5b58\u5728,repoId:[{}]", (Object)param.getRepoId());
                    throw new KDBizException("\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684schema\u5df2\u5b58\u5728");
                }
                if (this.repoExist(param.getRepoNumber())) {
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684schema\u5df2\u5b58\u5728,repoNum:[{}]", (Object)param.getRepoNumber());
                    throw new KDBizException("\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684schema\u5df2\u5b58\u5728");
                }
                schemaNumber = this.generateRandomNum();
                this.setFieldListAndSearchType(dynamicObject, param.getFields(), param.getTokenizerType(), param.getVectorMetricType());
            }
            dynamicObject.set("number", (Object)schemaNumber);
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            catch (Exception e) {
                log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93schema\u4fdd\u5b58\u5f02\u5e38,param:[{}]", (Object)param, (Object)e);
                Long repoId = param.getRepoId();
                try {
                    this.delVectorCollection(repoId);
                }
                catch (Exception ex) {
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u4fdd\u5b58\u77e5\u8bc6\u5e93\u5f02\u5e38\u540e,\u5220\u9664\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684\u5411\u91cfCollection\u5f02\u5e38,repoId:[{}]", (Object)repoId, (Object)ex);
                }
                try {
                    this.delFullSearchIndex(repoId);
                }
                catch (Exception ex) {
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u4fdd\u5b58\u77e5\u8bc6\u5e93\u5f02\u5e38\u540e,\u5220\u9664\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684\u5168\u6587\u7d22\u5f15index\u5f02\u5e38,repoId:[{}]", (Object)repoId, (Object)ex);
                }
                String errMsg = e.getMessage();
                if (!org.apache.commons.lang3.StringUtils.contains((CharSequence)errMsg, (CharSequence)"value too long for type")) break block11;
                throw new KDBizException("\u5b57\u6bb5\u957f\u5ea6\u8d85\u51fa\u9650\u5236");
            }
        }
        CreateRepoResDTO resDTO = new CreateRepoResDTO();
        resDTO.setSchemaNumber(schemaNumber);
        stopWatch.stop();
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u4fdd\u5b58\u77e5\u8bc6\u5e93Schema\u5b8c\u6210,\u8017\u65f6:[{}ms]", (Object)stopWatch.getTime());
        return resDTO;
    }

    private static void keepOldValue(DynamicObject dynamicObject, RepoSchemaDTO savedSchema) {
        dynamicObject.set("id", (Object)savedSchema.getSchemaId());
        dynamicObject.set("vector_collection_name", (Object)savedSchema.getVectorCollectionName());
        dynamicObject.set("full_search_index_name", (Object)savedSchema.getFullSearchIndex());
        dynamicObject.set("data_total_count", (Object)savedSchema.getDataTotalCount());
        dynamicObject.set("data_success_count", (Object)savedSchema.getDataSuccessCount());
        dynamicObject.set("data_failed_count", (Object)savedSchema.getDataFailedCount());
    }

    private static void checkCanNotMod(SaveKnoSchemaParam param, RepoSchemaDTO savedSchema) {
        if (!savedSchema.getRepoId().equals(param.getRepoId())) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u542b\u6709\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5,param:[{}],savedSchema:[{}]", (Object)param, (Object)savedSchema);
            throw new KDBizException("\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5[repoId]");
        }
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)param.getRepoNumber(), (CharSequence)savedSchema.getRepoNumber())) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u542b\u6709\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5,param:[{}],savedSchema:[{}]", (Object)param, (Object)savedSchema);
            throw new KDBizException("\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5[repoNumber]");
        }
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)param.getVectorModel(), (CharSequence)savedSchema.getVectorModel())) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u542b\u6709\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5,param:[{}],savedSchema:[{}]", (Object)param, (Object)savedSchema);
            throw new KDBizException("\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5[vectorModel]");
        }
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)param.getRepoType(), (CharSequence)savedSchema.getRepoType())) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u542b\u6709\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5,param:[{}],savedSchema:[{}]", (Object)param, (Object)savedSchema);
            throw new KDBizException("\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5[repoType]");
        }
        if (!savedSchema.getExternal().equals(param.getExternal())) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u542b\u6709\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5,param:[{}],savedSchema:[{}]", (Object)param, (Object)savedSchema);
            throw new KDBizException("\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5[external]");
        }
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)param.getTokenizerType(), (CharSequence)savedSchema.getTokenizerType())) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u542b\u6709\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5,param:[{}],savedSchema:[{}]", (Object)param, (Object)savedSchema);
            throw new KDBizException("\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5[tokenizerType]");
        }
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)param.getVectorMetricType(), (CharSequence)savedSchema.getVectorMetricType())) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u542b\u6709\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5,param:[{}],savedSchema:[{}]", (Object)param, (Object)savedSchema);
            throw new KDBizException("\u4e0d\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5[vectorMetricType]");
        }
    }

    @Override
    public void delSchema(DelKnoSchemaParam param) {
        this.delSchema(param, true);
    }

    public void delSchema(DelKnoSchemaParam param, Boolean delColAndIndex) {
        QFilter filter;
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u77e5\u8bc6\u5e93Schema:[{}],delColAndIndex:[{}]", (Object)param, (Object)delColAndIndex);
        int delete = 0;
        RepoSchemaDTO schema = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)param.getSchemaNumber())) {
            schema = this.getSchemaBySchemaNum(param.getSchemaNumber());
            filter = new QFilter("number", "=", (Object)param.getSchemaNumber());
            delete = DeleteServiceHelper.delete((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
        }
        if (delete <= 0 && ObjectUtils.isNotEmpty((Object)param.getRepoId())) {
            schema = this.getSchemaByRepoId(param.getRepoId());
            filter = new QFilter("repoid", "=", (Object)String.valueOf(param.getRepoId()));
            delete = DeleteServiceHelper.delete((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
        }
        if (delete <= 0 && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)param.getRepoNumber())) {
            schema = this.getSchemaByRepoNum(param.getRepoNumber());
            filter = new QFilter("repo_number", "=", (Object)param.getRepoNumber());
            delete = DeleteServiceHelper.delete((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
        }
        if (delete <= 0) {
            log.warn(Constant.RepoSchema.LOG_PREFIX + "\u6839\u636e\u53c2\u6570\u672a\u80fd\u5220\u9664\u4efb\u4f55\u4e00\u4e2a\u77e5\u8bc6\u5e93Schema,param:[{}]", (Object)param);
        } else if (BooleanUtils.isTrue((Boolean)delColAndIndex)) {
            this.delVectorCollection(schema);
            this.delFullSearchIndex(schema);
        }
    }

    @Override
    public boolean schemaExist(String schemaNumber) {
        QFilter filter = new QFilter("number", "=", (Object)schemaNumber);
        return QueryServiceHelper.exists((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
    }

    @Override
    public boolean repoExist(Long repoId) {
        QFilter filter = new QFilter("repoid", "=", (Object)String.valueOf(repoId));
        return QueryServiceHelper.exists((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
    }

    @Override
    public boolean repoExist(String repoNumber) {
        QFilter filter = new QFilter("repo_number", "=", (Object)repoNumber);
        return QueryServiceHelper.exists((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
    }

    @Override
    public void addFieldToRepo(AddFieldParam param) {
        List<SaveKnoSchemaParam.SchemaFieldInfo> newFields = param.getFields();
        if (CollectionUtils.isEmpty(newFields)) {
            return;
        }
        String schemaNumber = param.getSchemaNumber();
        RepoSchemaDTO schema = this.getSchemaBySchemaNum(schemaNumber);
        List<RepoSchemaDTO.SchemaField> savedFields = schema.getFields();
        for (RepoSchemaDTO.SchemaField savedField : savedFields) {
            SaveKnoSchemaParam.SchemaFieldInfo field = new SaveKnoSchemaParam.SchemaFieldInfo(savedField.getFieldId(), savedField.getFieldKey(), savedField.getFieldName(), savedField.getFieldType(), savedField.getVectorIndexEnable(), savedField.getFullIndexEnable());
            newFields.add(field);
        }
        SaveKnoSchemaParam saveParam = new SaveKnoSchemaParam.SaveKnoSchemaParamBuilder().schemaNumber(schema.getSchemaNumber()).repoId(schema.getRepoId()).repoNumber(schema.getRepoNumber()).repoName(schema.getRepoName()).vectorModel(schema.getVectorModel()).repoType(schema.getRepoType()).vectorMetricType(schema.getVectorMetricType()).dataSrcNumber(schema.getDataSrcNumber()).external(schema.getExternal()).mserviceCallBack(schema.getMserviceCallBack()).fields(newFields).build();
        this.saveSchema(saveParam);
    }

    @Override
    public void delFieldByRepoNum(String repoNumber, List<Long> fieldIds) {
        QFilter numberFilter = new QFilter("repo_number", "=", (Object)repoNumber);
        DynamicObjectCollection doCollection = QueryServiceHelper.query((String)"gai_repo_schema", (String)"id,number,name,repoid,repo_number,repo_name,repo_type,vector_model,vector_db_type,vector_collection_name,search_type,full_search_type,full_search_index_name,data_src_number,external,mservice_call_back,status,enable,gai_repo_sche_field_list.fieldid,gai_repo_sche_field_list.field_key,gai_repo_sche_field_list.field_name,gai_repo_sche_field_list.field_type,gai_repo_sche_field_list.vector_index_enable,gai_repo_sche_field_list.full_index_enable,", (QFilter[])new QFilter[]{numberFilter});
        HashSet fieldIsSet = Sets.newHashSet(fieldIds);
        for (int i = 0; i < doCollection.size(); ++i) {
            DynamicObject fieldDO = (DynamicObject)doCollection.get(i);
            Long fieldId = fieldDO.getLong("gai_repo_sche_field_list.id");
            if (!fieldIsSet.contains(fieldId)) continue;
            doCollection.remove((Object)fieldDO);
        }
    }

    @Override
    public RepoSchemaDTO getSchemaByRepoId(Long repoId) {
        QFilter filter = new QFilter("repoid", "=", (Object)String.valueOf(repoId));
        DynamicObject savedDynamicObject = BusinessDataServiceHelper.loadSingle((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
        if (savedDynamicObject == null) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u672a\u627e\u5230\u5df2\u4fdd\u5b58\u7684\u77e5\u8bc6\u5e93schema,repoId:[{}]", (Object)repoId);
            throw new KDBizException("\u672a\u627e\u5230\u5df2\u4fdd\u5b58\u7684\u77e5\u8bc6\u5e93schema");
        }
        return this.transDoToDTO(savedDynamicObject);
    }

    @Override
    public RepoSchemaDTO getSchemaByRepoNum(String repoNumber) {
        QFilter filter = new QFilter("repo_number", "=", (Object)String.valueOf(repoNumber));
        DynamicObject savedDynamicObject = BusinessDataServiceHelper.loadSingle((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
        if (savedDynamicObject == null) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u672a\u627e\u5230\u5df2\u4fdd\u5b58\u7684\u77e5\u8bc6\u5e93schema,repoNumber:[{}]", (Object)repoNumber);
            throw new KDBizException("\u672a\u627e\u5230\u5df2\u4fdd\u5b58\u7684\u77e5\u8bc6\u5e93schema");
        }
        return this.transDoToDTO(savedDynamicObject);
    }

    @Override
    public RepoSchemaDTO getSchemaBySchemaId(Long schemaId) {
        QFilter filter = new QFilter("id", "=", (Object)schemaId);
        DynamicObject savedDynamicObject = BusinessDataServiceHelper.loadSingle((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
        if (savedDynamicObject == null) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u672a\u627e\u5230\u5df2\u4fdd\u5b58\u7684\u77e5\u8bc6\u5e93schema,schemaId:[{}]", (Object)schemaId);
            throw new KDBizException("\u672a\u627e\u5230\u5df2\u4fdd\u5b58\u7684\u77e5\u8bc6\u5e93schema");
        }
        return this.transDoToDTO(savedDynamicObject);
    }

    @Override
    public RepoSchemaDTO getSchemaBySchemaNum(String schemaNumber) {
        QFilter filter = new QFilter("number", "=", (Object)schemaNumber);
        DynamicObject savedDynamicObject = BusinessDataServiceHelper.loadSingle((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
        if (savedDynamicObject == null) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u672a\u627e\u5230\u5df2\u4fdd\u5b58\u7684\u77e5\u8bc6\u5e93schema,schemaNumber:[{}]", (Object)schemaNumber);
            throw new KDBizException("\u672a\u627e\u5230\u5df2\u4fdd\u5b58\u7684\u77e5\u8bc6\u5e93schema");
        }
        return this.transDoToDTO(savedDynamicObject);
    }

    @Override
    public RepoSchemaDTO getSchemaBySchemaNumber(String schemaNumber) {
        QFilter filter = new QFilter("number", "=", (Object)schemaNumber);
        DynamicObject savedDynamicObject = BusinessDataServiceHelper.loadSingle((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
        return this.transDoToDTO(savedDynamicObject);
    }

    @Override
    public void increaseDataCount(String schemaNumber, int dataCount, int successCount, int failedCount) {
        QFilter filter = new QFilter("number", "=", (Object)schemaNumber);
        DynamicObject savedDynamicObject = BusinessDataServiceHelper.loadSingle((String)"gai_repo_schema", (QFilter[])new QFilter[]{filter});
        long newDataCount = savedDynamicObject.getLong("data_total_count") + (long)dataCount;
        savedDynamicObject.set("data_total_count", (Object)newDataCount);
        long newSuccessCount = savedDynamicObject.getLong("data_success_count") + (long)successCount;
        savedDynamicObject.set("data_success_count", (Object)newSuccessCount);
        long newFailedCount = savedDynamicObject.getLong("data_failed_count") + (long)failedCount;
        savedDynamicObject.set("data_failed_count", (Object)newFailedCount);
        SaveServiceHelper.update((DynamicObject)savedDynamicObject);
    }

    public String generateRandomNum() {
        LocalDateTime curDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyMMddHHmmss");
        String formattedStamp = formatter.format(curDateTime);
        return "repoSchema_" + formattedStamp + RandomStringUtils.randomAlphanumeric((int)4);
    }

    public void checkParam(SaveKnoSchemaParam param) {
        Boolean external;
        if (param == null) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u521b\u5efa\u77e5\u8bc6\u5e93\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            throw new KDBizException("\u521b\u5efa\u77e5\u8bc6\u5e93\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long repoId = param.getRepoId();
        if (repoId == null) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a,param:[{}]", (Object)param);
            throw new KDBizException("\u77e5\u8bc6\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String repoNumber = param.getRepoNumber();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)repoNumber)) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,param:[{}]", (Object)param);
            throw new KDBizException("\u77e5\u8bc6\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.length((CharSequence)repoNumber) > 30) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u7f16\u7801\u957f\u5ea6\u8d85\u51fa\u9650\u5236,param:[{}]", (Object)param);
            throw new KDBizException("\u77e5\u8bc6\u5e93\u7f16\u7801\u957f\u5ea6\u8d85\u51fa\u9650\u5236");
        }
        String repoName = param.getRepoName();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)repoName)) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a,param:[{}]", (Object)param);
            throw new KDBizException("\u77e5\u8bc6\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.length((CharSequence)repoName) > 200) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u540d\u79f0\u957f\u5ea6\u8d85\u51fa\u9650\u5236,param:[{}]", (Object)param);
            throw new KDBizException("\u77e5\u8bc6\u5e93\u540d\u79f0\u957f\u5ea6\u8d85\u51fa\u9650\u5236");
        }
        String vectorModel = param.getVectorModel();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)vectorModel)) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5411\u91cf\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a,param:[{}]", (Object)param);
            throw new KDBizException("\u5411\u91cf\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String repoType = param.getRepoType();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)repoType)) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a,param:[{}]", (Object)param);
            throw new KDBizException("\u77e5\u8bc6\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tokenizerType = param.getTokenizerType();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tokenizerType)) {
            param.setTokenizerType(ESTokenizerType.IKMAXWORD.toString());
        }
        if ((external = param.getExternal()) == null) {
            param.setExternal(false);
        }
        if (BooleanUtils.isTrue((Boolean)external)) {
            String mserviceCallBack = param.getMserviceCallBack();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)mserviceCallBack)) {
                log.error(Constant.RepoSchema.LOG_PREFIX + "\u5916\u90e8\u77e5\u8bc6\u5e93\u9700\u8981\u6307\u5b9a\u5fae\u670d\u52a1\u56de\u8c03,param:[{}]", (Object)param);
                throw new KDBizException("\u5916\u90e8\u77e5\u8bc6\u5e93\u9700\u8981\u6307\u5b9a\u5fae\u670d\u52a1\u56de\u8c03");
            }
            try {
                JSONObject serviceJsonObj = JSON.parseObject((String)mserviceCallBack);
                JSONObject dataServiceJsonObj = serviceJsonObj.getJSONObject("dataStateCallback");
                String dataCloudId = dataServiceJsonObj.getString("cloudId");
                String dataAppId = dataServiceJsonObj.getString("appId");
                String dataServiceName = dataServiceJsonObj.getString("serviceName");
                String dataMethodName = dataServiceJsonObj.getString("methodName");
                if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dataCloudId, dataAppId, dataServiceName, dataMethodName})) {
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u6307\u5b9a\u7684\u6570\u636e\u72b6\u6001\u53d8\u66f4\u901a\u77e5\u5fae\u670d\u52a1\u56de\u8c03\u4fe1\u606f\u9519\u8bef,param:[{}]", (Object)param);
                    throw new KDBizException("\u6307\u5b9a\u7684\u6570\u636e\u72b6\u6001\u53d8\u66f4\u901a\u77e5\u5fae\u670d\u52a1\u56de\u8c03\u4fe1\u606f\u9519\u8bef");
                }
                JSONObject searchServiceJsonObj = serviceJsonObj.getJSONObject("searchCallBack");
                String searchCloudId = searchServiceJsonObj.getString("cloudId");
                String searchAppId = searchServiceJsonObj.getString("appId");
                String searchServiceName = searchServiceJsonObj.getString("serviceName");
                String searchMethodName = searchServiceJsonObj.getString("methodName");
                if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{searchCloudId, searchAppId, searchServiceName, searchMethodName})) {
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u6307\u5b9a\u7684\u68c0\u7d22\u5fae\u670d\u52a1\u56de\u8c03\u4fe1\u606f\u9519\u8bef,param:[{}]", (Object)param);
                    throw new KDBizException("\u6307\u5b9a\u7684\u68c0\u7d22\u5fae\u670d\u52a1\u56de\u8c03\u4fe1\u606f\u9519\u8bef");
                }
            }
            catch (NullPointerException e) {
                log.error(Constant.RepoSchema.LOG_PREFIX + "\u6307\u5b9a\u7684\u670d\u52a1\u56de\u8c03\u4fe1\u606f\u9519\u8bef,param:[{}]", (Object)param);
                throw new KDBizException("\u6307\u5b9a\u7684\u5fae\u670d\u52a1\u56de\u8c03\u4fe1\u606f\u9519\u8bef");
            }
        }
    }

    private void setFieldListAndSearchType(DynamicObject dynamicObject, List<SaveKnoSchemaParam.SchemaFieldInfo> fields, String tokenizerType, String vectorMetricType) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        boolean hasVectorField = false;
        boolean hasFullField = false;
        DynamicObjectCollection doCollection = dynamicObject.getDynamicObjectCollection("gai_repo_sche_field_list");
        HashSet fieldIdSet = Sets.newHashSetWithExpectedSize((int)fields.size());
        HashSet fieldKeySet = Sets.newHashSetWithExpectedSize((int)fields.size());
        HashSet fieldNameSet = Sets.newHashSetWithExpectedSize((int)fields.size());
        for (SaveKnoSchemaParam.SchemaFieldInfo field : fields) {
            DynamicObject fieldDO = new DynamicObject(doCollection.getDynamicObjectType());
            KnowledgeRepoService.checkField(field, fieldIdSet, fieldKeySet, fieldNameSet);
            fieldDO.set("fieldid", (Object)field.getFieldId());
            fieldDO.set("field_key", (Object)field.getFieldKey());
            fieldDO.set("field_name", (Object)field.getFieldName());
            fieldDO.set("field_type", (Object)RepoFieldType.STRING.getValue());
            fieldDO.beginResetDirtyFlag();
            fieldDO.set("vector_index_enable", (Object)field.getVectorIndexEnable());
            fieldDO.set("full_index_enable", (Object)field.getFullIndexEnable());
            fieldDO.endResetDirtyFlag();
            doCollection.add((Object)fieldDO);
            if (BooleanUtils.isTrue((Boolean)field.getVectorIndexEnable())) {
                hasVectorField = true;
            }
            if (!BooleanUtils.isTrue((Boolean)field.getFullIndexEnable())) continue;
            hasFullField = true;
        }
        String collectionName = dynamicObject.getString("vector_collection_name");
        String indexName = dynamicObject.getString("full_search_index_name");
        String vectorModel = dynamicObject.getString("vector_model");
        long repoId = dynamicObject.getLong("repoid");
        if (hasVectorField && hasFullField) {
            dynamicObject.set("search_type", (Object)SearchType.HYBRID);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)collectionName)) {
                collectionName = this.createVectorCollection(vectorModel, vectorMetricType, repoId);
                dynamicObject.set("vector_collection_name", (Object)collectionName);
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)indexName)) {
                try {
                    indexName = this.createFullSearchIndex(repoId, tokenizerType);
                }
                catch (KDBizException e) {
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)collectionName)) {
                        try {
                            this.delVectorCollection(repoId);
                            log.info(Constant.RepoSchema.LOG_PREFIX + "\u6df7\u5408\u68c0\u7d22\u521b\u5efa\u5411\u91cfCollection\u6210\u529f\u4f46\u521b\u5efa\u521b\u5efa\u5168\u6587\u7d22\u5f15\u5931\u8d25\u540e,\u5220\u9664\u521b\u5efa\u6210\u529f\u7684\u5411\u91cf\u7d22\u5f15\u5b8c\u6210,repoId:[{}]", (Object)repoId);
                        }
                        catch (KDBizException ex) {
                            log.error(Constant.RepoSchema.LOG_PREFIX + "\u6df7\u5408\u68c0\u7d22\u521b\u5efa\u5411\u91cfCollection\u6210\u529f\u4f46\u521b\u5efa\u521b\u5efa\u5168\u6587\u7d22\u5f15\u5931\u8d25\u540e,\u5220\u9664\u521b\u5efa\u6210\u529f\u7684\u5411\u91cf\u7d22\u5f15\u5f02\u5e38,repoId:[{}]", (Object)repoId);
                        }
                    }
                    throw e;
                }
                dynamicObject.set("full_search_index_name", (Object)indexName);
            }
        } else if (hasVectorField) {
            dynamicObject.set("search_type", (Object)SearchType.VECTOR);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)collectionName)) {
                collectionName = this.createVectorCollection(vectorModel, vectorMetricType, repoId);
                dynamicObject.set("vector_collection_name", (Object)collectionName);
            }
        } else if (hasFullField) {
            dynamicObject.set("search_type", (Object)SearchType.KEYWORD);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)indexName)) {
                indexName = this.createFullSearchIndex(repoId, tokenizerType);
                dynamicObject.set("full_search_index_name", (Object)indexName);
            }
        } else {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u8981\u6c42\u81f3\u5c11\u6709\u4e00\u4e2a\u5b57\u6bb5\u7528\u5230\u5168\u6587\u68c0\u7d22\u6216\u5411\u91cf\u68c0\u7d22,fields:[{}]", fields);
            throw new KDBizException("\u8981\u6c42\u81f3\u5c11\u6709\u4e00\u4e2a\u5b57\u6bb5\u7528\u5230\u5168\u6587\u68c0\u7d22\u6216\u5411\u91cf\u68c0\u7d22");
        }
    }

    private static void checkField(SaveKnoSchemaParam.SchemaFieldInfo field, Set<Long> fieldIdSet, Set<String> fieldKeySet, Set<String> fieldNameSet) {
        Long fieldId = field.getFieldId();
        String fieldKey = field.getFieldKey();
        String fieldName = field.getFieldName();
        if (fieldId == null || org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fieldKey, fieldName})) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5b57\u6bb5ID,key,\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a,fieldId:[{}],fieldKey:[{}],fieldName:[{}]", new Object[]{fieldId, fieldKey, fieldName});
            throw new KDBizException("\u5b57\u6bb5ID,key,\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!fieldIdSet.add(fieldId)) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5b57\u6bb5ID\u91cd\u590d,fieldId:[{}]", (Object)fieldId);
            throw new KDBizException("\u5b57\u6bb5ID\u91cd\u590d");
        }
        if (!fieldKeySet.add(fieldKey)) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5b57\u6bb5Key\u91cd\u590d,fieldKey:[{}]", (Object)fieldKey);
            throw new KDBizException("\u5b57\u6bb5Key\u91cd\u590d");
        }
        if (!fieldNameSet.add(fieldName)) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5b57\u6bb5\u540d\u79f0\u91cd\u590d,fieldName:[{}]", (Object)fieldName);
            throw new KDBizException("\u5b57\u6bb5\u540d\u79f0\u91cd\u590d");
        }
    }

    public String createVectorCollection(String vectorModel, String vectorMetricType, Long repoId) {
        LLM embeddingLlm = LLM.parse(vectorModel);
        if (embeddingLlm == null || !embeddingLlm.isActive() || LLM.ModelType.EMBEDDING != embeddingLlm.getModelType()) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u672a\u627e\u5230\u53ef\u7528\u7684\u7684embedding\u6a21\u578b,repoId:[{}],vectorModel:[{}]", (Object)repoId, (Object)vectorModel);
            throw new KDBizException("\u672a\u627e\u5230\u53ef\u7528\u7684\u7684embedding\u6a21\u578b");
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            VectorMetricType metricType;
            if (StringUtils.isEmpty((CharSequence)vectorMetricType)) {
                metricType = VectorMetricType.COSINE;
            } else {
                metricType = VectorMetricType.parse(vectorMetricType);
                if (metricType == null) {
                    metricType = VectorMetricType.COSINE;
                }
            }
            EmbeddingService embeddingService = EmbeddingServiceFactory.getExecutor(embeddingLlm, metricType);
            VectorCollectionCreateParam collectionCreateParam = VectorCollectionCreateParam.newBuilder().withEmbeddingNumer(embeddingLlm.getNumber()).withVectorMetricType(metricType).withCollectionName(new VectorCollectionSchema(repoId)).withDim(embeddingService.getDimension()).build();
            VectorService vectorService = StructuredRepoServiceHelper.getVectorService();
            vectorService.createCollection(collectionCreateParam);
            String paramJsonStr = JSON.toJSONString((Object)collectionCreateParam);
            String collectionName = collectionCreateParam.getCollectionName();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)collectionName)) {
                log.error(Constant.RepoSchema.LOG_PREFIX + "\u521b\u5efa\u5411\u91cfCollection\u540d\u79f0\u4e3a\u7a7a,param:[{}]", (Object)paramJsonStr);
                throw new KDBizException("\u521b\u5efa\u7684\u5411\u91cfCollection\u540d\u79f0\u4e3a\u7a7a");
            }
            stopWatch.stop();
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u521b\u5efa\u5411\u91cfCollection\u5b8c\u6210,\u8017\u65f6:[{}ms],param:[{}]", (Object)stopWatch.getTime(), (Object)paramJsonStr);
            return collectionName;
        }
        catch (Exception e) {
            stopWatch.stop();
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u521b\u5efa\u5411\u91cfCollection\u5f02\u5e38,\u8017\u65f6:[{}ms],repoId:[{}],vectorModel:[{}]", new Object[]{stopWatch.getTime(), repoId, vectorModel, e});
            try {
                this.delVectorCollection(repoId);
            }
            catch (KDBizException ex) {
                log.error(Constant.RepoSchema.LOG_PREFIX + "\u521b\u5efa\u5411\u91cfCollection\u5f02\u5e38\u540e\u5c1d\u8bd5\u5220\u9664\u4ecd\u7136\u5f02\u5e38,repoId:[{}],vectorModel:[{}]", (Object)repoId, (Object)vectorModel);
            }
            throw new KDBizException("\u521b\u5efa\u5411\u91cfCollection\u5f02\u5e38");
        }
    }

    public void delVectorCollection(Long repoId) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            VectorService vectorService = StructuredRepoServiceHelper.getVectorService();
            VectorCollectionSchema collectionSchema = new VectorCollectionSchema(repoId);
            VectorCollectionNameParam existParam = VectorCollectionNameParam.newBuilder().withCollectionName(collectionSchema).build();
            boolean exist = vectorService.collectionExist(existParam);
            if (!exist) {
                stopWatch.stop();
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5411\u91cfCollection\u4e0d\u5b58\u5728,\u8017\u65f6:[{}ms],\u4e0d\u9700\u8981\u5220\u9664,repoId:[{}]", (Object)stopWatch.getTime(), (Object)repoId);
                return;
            }
            VectorCollectionDropParam param = VectorCollectionDropParam.newBuilder().withCollectionName(collectionSchema).build();
            vectorService.dropCollection(param);
            stopWatch.stop();
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u5411\u91cfCollection\u5b8c\u6210,\u8017\u65f6:[{}ms],repoId:[{}]", (Object)stopWatch.getTime(), (Object)repoId);
        }
        catch (Exception e) {
            stopWatch.stop();
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u5411\u91cfCollection\u5f02\u5e38,\u8017\u65f6:[{}ms],repoId:[{}]", new Object[]{stopWatch.getTime(), repoId, e});
            throw new KDBizException("\u5220\u9664\u5411\u91cfCollection\u5f02\u5e38");
        }
    }

    public void delVectorCollection(RepoSchemaDTO schema) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)schema.getVectorCollectionName())) {
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u672a\u521b\u5efa\u5411\u91cfCollection,\u4e0d\u9700\u8981\u5220\u9664,schema:[{}]", (Object)schema);
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Long repoId = schema.getRepoId();
        try {
            VectorService vectorService = StructuredRepoServiceHelper.getVectorService();
            VectorCollectionSchema collectionSchema = new VectorCollectionSchema(repoId);
            VectorCollectionNameParam existParam = VectorCollectionNameParam.newBuilder().withCollectionName(collectionSchema).build();
            boolean exist = vectorService.collectionExist(existParam);
            if (!exist) {
                stopWatch.stop();
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5411\u91cfCollection\u4e0d\u5b58\u5728,\u4e0d\u9700\u8981\u5220\u9664,\u8017\u65f6:[{}ms],schema:[{}]", (Object)stopWatch.getTime(), (Object)schema);
                return;
            }
            VectorCollectionDropParam param = VectorCollectionDropParam.newBuilder().withCollectionName(collectionSchema).build();
            vectorService.dropCollection(param);
            stopWatch.stop();
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u5411\u91cfCollection\u5b8c\u6210,\u8017\u65f6:[{}ms],schema:[{}]", (Object)stopWatch.getTime(), (Object)schema);
        }
        catch (Exception e) {
            stopWatch.stop();
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u5411\u91cfCollection\u5f02\u5e38,\u8017\u65f6:[{}ms],schema:[{}]", new Object[]{stopWatch.getTime(), schema, e});
            throw new KDBizException("\u5220\u9664\u5411\u91cfCollection\u5f02\u5e38");
        }
    }

    public String createFullSearchIndex(Long repoId, String tokenizerType) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            ESTokenizerType esTokenizerType = ESTokenizerType.getValueOf(tokenizerType);
            esTokenizerType = esTokenizerType == null ? ESTokenizerType.IKMAXWORD : esTokenizerType;
            KeywordIndexSchema indexSchema = new KeywordIndexSchema(repoId);
            KeywordIndexCreateParam indexCreateParam = KeywordIndexCreateParam.newBuilder().withIndexName(indexSchema).withTokenizerType(esTokenizerType).build();
            KeywordService keywordService = StructuredRepoServiceHelper.getKeywordService();
            keywordService.createIndex(indexCreateParam);
            String paramJsonStr = JSON.toJSONString((Object)indexCreateParam);
            String indexName = indexCreateParam.getIndexName();
            stopWatch.stop();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)indexName)) {
                log.error(Constant.RepoSchema.LOG_PREFIX + "\u521b\u5efa\u7684\u5168\u6587\u7d22\u5f15index\u540d\u79f0\u4e3a\u7a7a,\u8017\u65f6:[{}ms],param:[{}]", (Object)stopWatch.getTime(), (Object)paramJsonStr);
                throw new KDBizException("\u521b\u5efa\u7684\u5168\u6587\u7d22\u5f15index\u540d\u79f0\u4e3a\u7a7a");
            }
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u521b\u5efa\u5168\u6587\u7d22\u5f15index\u5b8c\u6210,\u8017\u65f6:[{}ms],param:[{}]", (Object)stopWatch.getTime(), (Object)paramJsonStr);
            return indexName;
        }
        catch (Exception e) {
            stopWatch.stop();
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u521b\u5efa\u5168\u6587\u7d22\u5f15index\u5f02\u5e38,\u8017\u65f6:[{}ms],repoId:[{}]", new Object[]{stopWatch.getTime(), repoId, e});
            try {
                this.delFullSearchIndex(repoId);
            }
            catch (Exception ex) {
                log.error(Constant.RepoSchema.LOG_PREFIX + "\u521b\u5efa\u5168\u6587\u7d22\u5f15index\u5f02\u5e38\u540e\u5c1d\u8bd5\u5220\u9664\u4ecd\u7136\u5f02\u5e38,repoId:[{}]", (Object)repoId);
            }
            throw new KDBizException("\u521b\u5efa\u5168\u6587\u7d22\u5f15index\u5f02\u5e38");
        }
    }

    public void delFullSearchIndex(Long repoId) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            KeywordIndexSchema keywordIndexSchema = new KeywordIndexSchema(repoId);
            KeywordIndexDropParam param = KeywordIndexDropParam.newBuilder().withIndexName(keywordIndexSchema).build();
            KeywordService keywordService = StructuredRepoServiceHelper.getKeywordService();
            KeywordIndexNameParam indexNameParam = KeywordIndexNameParam.newBuilder().withIndexName(keywordIndexSchema).build();
            boolean exist = keywordService.indexExist(indexNameParam);
            if (!exist) {
                stopWatch.stop();
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5168\u6587\u7d22\u5f15index\u4e0d\u5b58\u5728,\u4e0d\u9700\u8981\u5220\u9664,\u8017\u65f6:[{}ms],repoId:[{}]", (Object)stopWatch.getTime(), (Object)repoId);
                return;
            }
            keywordService.delIndex(param);
            stopWatch.stop();
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u5168\u6587\u7d22\u5f15index\u5b8c\u6210,\u8017\u65f6:[{}ms],repoId:[{}]", (Object)stopWatch.getTime(), (Object)repoId);
        }
        catch (Exception e) {
            stopWatch.stop();
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u5168\u6587\u7d22\u5f15index\u5f02\u5e38,\u8017\u65f6:[{}ms],repoId:[{}]", new Object[]{stopWatch.getTime(), repoId, e});
            throw new KDBizException("\u5220\u9664\u5168\u6587\u7d22\u5f15index\u5f02\u5e38");
        }
    }

    public void delFullSearchIndex(RepoSchemaDTO schema) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)schema.getFullSearchIndex())) {
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u672a\u521b\u5efa\u5168\u6587\u7d22\u5f15index,\u4e0d\u9700\u8981\u5220\u9664,schema:[{}]", (Object)schema);
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Long repoId = schema.getRepoId();
        try {
            KeywordIndexSchema keywordIndexSchema = new KeywordIndexSchema(repoId);
            KeywordIndexDropParam param = KeywordIndexDropParam.newBuilder().withIndexName(keywordIndexSchema).build();
            KeywordService keywordService = StructuredRepoServiceHelper.getKeywordService();
            KeywordIndexNameParam indexNameParam = KeywordIndexNameParam.newBuilder().withIndexName(keywordIndexSchema).build();
            boolean exist = keywordService.indexExist(indexNameParam);
            if (!exist) {
                stopWatch.stop();
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5168\u6587\u7d22\u5f15index\u4e0d\u5b58\u5728,\u4e0d\u9700\u8981\u5220\u9664,\u8017\u65f6:[{}ms],schema:[{}]", (Object)stopWatch.getTime(), (Object)schema);
                return;
            }
            keywordService.delIndex(param);
            stopWatch.stop();
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u5168\u6587\u7d22\u5f15index\u5b8c\u6210,\u8017\u65f6:[{}ms],schema:[{}]", (Object)stopWatch.getTime(), (Object)schema);
        }
        catch (Exception e) {
            stopWatch.stop();
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u5220\u9664\u5168\u6587\u7d22\u5f15index\u5f02\u5e38,\u8017\u65f6:[{}ms],schema:[{}]", new Object[]{stopWatch.getTime(), schema, e});
            throw new KDBizException("\u5220\u9664\u5168\u6587\u7d22\u5f15index\u5f02\u5e38");
        }
    }

    public boolean hasData(RepoSchemaDTO schema) {
        Long dataTotalCount = schema.getDataTotalCount();
        if (dataTotalCount > 0L) {
            return true;
        }
        Long repoId = schema.getRepoId();
        long vectorData = this.countVectorData(repoId);
        if (vectorData > 0L) {
            return true;
        }
        long indexData = this.countIndexData(repoId);
        return indexData > 0L;
    }

    public long countIndexData(Long repoId) {
        try {
            KeywordService keywordService = StructuredRepoServiceHelper.getKeywordService();
            KeywordIndexSchema keywordIndexSchema = new KeywordIndexSchema(repoId);
            KeywordDataCountParam countParam = KeywordDataCountParam.newBuilder().withIndexName(keywordIndexSchema).build();
            long dataCount = keywordService.queryCountByIndexName(countParam);
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u67e5\u8be2\u77e5\u8bc6\u5e93\u7d22\u5f15\u6570\u636e\u91cf\u5b8c\u6210,repoId:[{}],dataCount:[{}]", (Object)repoId, (Object)dataCount);
            return dataCount;
        }
        catch (Exception e) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u67e5\u8be2\u77e5\u8bc6\u5e93\u7d22\u5f15\u6570\u636e\u91cf\u5f02\u5e38,repoId:[{}]", (Object)repoId, (Object)e);
            return 0L;
        }
    }

    public long countVectorData(Long repoId) {
        try {
            VectorService vectorService = StructuredRepoServiceHelper.getVectorService();
            VectorDataCountParam countParam = VectorDataCountParam.newBuilder().withCollectionName(new VectorCollectionSchema(repoId)).build();
            long dataCount = vectorService.queryCountByCollectionName(countParam);
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u67e5\u8be2\u77e5\u8bc6\u5e93\u5411\u91cf\u5e93\u6570\u636e\u91cf\u5b8c\u6210,repoId:[{}],dataCount:[{}]", (Object)repoId, (Object)dataCount);
            return dataCount;
        }
        catch (Exception e) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u67e5\u8be2\u77e5\u8bc6\u5e93\u5411\u91cf\u5e93\u6570\u636e\u91cf\u5f02\u5e38,repoId:[{}]", (Object)repoId, (Object)e);
            return 0L;
        }
    }

    public boolean fieldModOrDel(List<RepoSchemaDTO.SchemaField> savedFields, List<SaveKnoSchemaParam.SchemaFieldInfo> paramFields) {
        List parsedFields = JSON.parseArray((String)JSON.toJSONString(savedFields), SaveKnoSchemaParam.SchemaFieldInfo.class);
        return !Sets.newHashSet(paramFields).containsAll(parsedFields);
    }

    private DynamicObject transParamToDo(SaveKnoSchemaParam param) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"gai_repo_schema");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
        dynamicObject.set("name", (Object)("repoSchema_" + param.getRepoName()));
        dynamicObject.set("repoid", (Object)param.getRepoId());
        dynamicObject.set("repo_number", (Object)param.getRepoNumber());
        dynamicObject.set("repo_name", (Object)param.getRepoName());
        dynamicObject.set("repo_type", (Object)param.getRepoType());
        dynamicObject.set("vector_model", (Object)param.getVectorModel());
        dynamicObject.set("vector_metric_type", (Object)param.getVectorMetricType());
        dynamicObject.set("vector_db_type", (Object)VectorDbType.MILVUS.getValue());
        dynamicObject.set("full_search_type", (Object)FullSearchType.ES.getValue());
        dynamicObject.set("data_src_number", (Object)param.getDataSrcNumber());
        dynamicObject.set("external", (Object)param.getExternal());
        dynamicObject.set("mservice_call_back", (Object)param.getMserviceCallBack());
        dynamicObject.set("tokenizer_type", (Object)param.getTokenizerType());
        dynamicObject.set("enable", (Object)1);
        dynamicObject.set("status", (Object)"C");
        return dynamicObject;
    }

    public RepoSchemaDTO transDoToDTO(DynamicObject dynamicObject) {
        RepoSchemaDTO schemaDTO = new RepoSchemaDTO();
        schemaDTO.setSchemaId(Long.valueOf(dynamicObject.getString("id")));
        schemaDTO.setSchemaNumber(dynamicObject.getString("number"));
        schemaDTO.setSchemaName(dynamicObject.getString("name"));
        schemaDTO.setRepoId(Long.valueOf(dynamicObject.getString("repoid")));
        schemaDTO.setRepoNumber(dynamicObject.getString("repo_number"));
        schemaDTO.setRepoName(dynamicObject.getString("repo_name"));
        schemaDTO.setRepoType(dynamicObject.getString("repo_type"));
        schemaDTO.setSearchType(dynamicObject.getString("search_type"));
        schemaDTO.setVectorModel(dynamicObject.getString("vector_model"));
        schemaDTO.setVectorDbType(dynamicObject.getString("vector_db_type"));
        schemaDTO.setVectorMetricType(dynamicObject.getString("vector_metric_type"));
        schemaDTO.setVectorCollectionName(dynamicObject.getString("vector_collection_name"));
        schemaDTO.setFullSearchType(dynamicObject.getString("full_search_type"));
        schemaDTO.setFullSearchIndex(dynamicObject.getString("full_search_index_name"));
        schemaDTO.setDataSrcNumber(dynamicObject.getString("data_src_number"));
        schemaDTO.setExternal(dynamicObject.getBoolean("external"));
        schemaDTO.setMserviceCallBack(dynamicObject.getString("mservice_call_back"));
        schemaDTO.setTokenizerType(dynamicObject.getString("tokenizer_type"));
        schemaDTO.setDataTotalCount(dynamicObject.getLong("data_total_count"));
        schemaDTO.setDataSuccessCount(dynamicObject.getLong("data_success_count"));
        schemaDTO.setDataFailedCount(dynamicObject.getLong("data_failed_count"));
        DynamicObjectCollection doCollection = dynamicObject.getDynamicObjectCollection("gai_repo_sche_field_list");
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)doCollection.size());
        for (DynamicObject fieldDO : doCollection) {
            RepoSchemaDTO.SchemaField field = new RepoSchemaDTO.SchemaField();
            field.setId(fieldDO.getLong("id"));
            field.setFieldId(fieldDO.getLong("fieldid"));
            field.setFieldKey(fieldDO.getString("field_key"));
            field.setFieldType(fieldDO.getString("field_type"));
            field.setFieldName(fieldDO.getString("field_name"));
            field.setFullIndexEnable(fieldDO.getBoolean("full_index_enable"));
            field.setVectorIndexEnable(fieldDO.getBoolean("vector_index_enable"));
            fields.add(field);
        }
        schemaDTO.setFields(fields);
        return schemaDTO;
    }
}

