/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.param.keyword;

import java.util.List;
import javax.validation.constraints.NotNull;
import kd.ai.gai.core.search.index.param.keyword.KeywordData;
import kd.ai.gai.core.search.index.schema.KeywordIndexSchema;
import kd.ai.gai.core.search.index.service.KeywordServiceHelper;

public class KeywordDataAddParam {
    private final String indexName;
    private final String oldIndexName;
    private final List<KeywordData> keywordDatas;

    public String getIndexName() {
        return this.indexName;
    }

    public String getOldIndexName() {
        return this.oldIndexName;
    }

    public List<KeywordData> getKeywordDatas() {
        return this.keywordDatas;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public KeywordDataAddParam(@NotNull Builder builder) {
        this.indexName = builder.indexName;
        this.oldIndexName = builder.oldIndexName;
        this.keywordDatas = builder.keywordDatas;
    }

    public static class Builder {
        private String indexName;
        private String oldIndexName;
        private List<KeywordData> keywordDatas;

        private Builder() {
        }

        public Builder withIndexName(KeywordIndexSchema keywordIndexSchema) {
            this.indexName = KeywordServiceHelper.biuldIndexName(keywordIndexSchema);
            this.oldIndexName = KeywordServiceHelper.biuldOldIndexName(keywordIndexSchema);
            return this;
        }

        public Builder withIndexDatas(List<KeywordData> keywordDatas) {
            this.keywordDatas = keywordDatas;
            return this;
        }

        public KeywordDataAddParam build() {
            return new KeywordDataAddParam(this);
        }
    }
}

