/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.param.keyword;

import javax.validation.constraints.NotNull;
import kd.ai.gai.core.search.index.schema.KeywordIndexSchema;
import kd.ai.gai.core.search.index.service.KeywordServiceHelper;

public class KeywordDataCountParam {
    private final String indexName;
    private final String oldIndexName;

    public static Builder newBuilder() {
        return new Builder();
    }

    public KeywordDataCountParam(@NotNull Builder builder) {
        this.indexName = builder.indexName;
        this.oldIndexName = builder.oldIndexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getOldIndexName() {
        return this.oldIndexName;
    }

    public static class Builder {
        private String indexName;
        private String oldIndexName;

        private Builder() {
        }

        public Builder withIndexName(KeywordIndexSchema keywordIndexSchema) {
            this.indexName = KeywordServiceHelper.biuldIndexName(keywordIndexSchema);
            this.oldIndexName = KeywordServiceHelper.biuldOldIndexName(keywordIndexSchema);
            return this;
        }

        public KeywordDataCountParam build() {
            return new KeywordDataCountParam(this);
        }
    }
}

