/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.param.keyword;

import java.util.List;
import javax.validation.constraints.NotNull;
import kd.ai.gai.core.search.index.schema.KeywordIndexSchema;
import kd.ai.gai.core.search.index.service.KeywordServiceHelper;

public class KeywordDataDelParam {
    private final String indexName;
    private final String oldIndexName;
    private final List<DelData> datas;

    public static Builder newBuilder() {
        return new Builder();
    }

    public KeywordDataDelParam(@NotNull Builder builder) {
        this.indexName = builder.indexName;
        this.oldIndexName = builder.oldIndexName;
        this.datas = builder.datas;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getOldIndexName() {
        return this.oldIndexName;
    }

    public List<DelData> getDatas() {
        return this.datas;
    }

    public static class DelData {
        private String id;
        private Long dataId;
        private String propertyKey;

        public DelData(Long dataId, String propertyKey) {
            if (dataId == null) {
                throw new RuntimeException("dataId is not null");
            }
            if (propertyKey == null) {
                throw new RuntimeException("propertyKey is not null");
            }
            this.id = String.format("%s_%s", dataId, propertyKey);
            this.dataId = dataId;
            this.propertyKey = propertyKey;
        }

        public String getId() {
            return this.id;
        }

        public Long getDataId() {
            return this.dataId;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }
    }

    public static class Builder {
        private String indexName;
        private String oldIndexName;
        private List<DelData> datas;

        private Builder() {
        }

        public Builder withIndexName(KeywordIndexSchema indexSchema) {
            this.indexName = KeywordServiceHelper.biuldIndexName(indexSchema);
            this.oldIndexName = KeywordServiceHelper.biuldOldIndexName(indexSchema);
            return this;
        }

        public Builder withIndexDelDatas(List<DelData> datas) {
            this.datas = datas;
            return this;
        }

        public KeywordDataDelParam build() {
            return new KeywordDataDelParam(this);
        }
    }
}

