/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.param.keyword;

import javax.validation.constraints.NotNull;
import kd.ai.gai.core.search.index.schema.KeywordIndexSchema;
import kd.ai.gai.core.search.index.service.KeywordServiceHelper;

public class KeywordDataSearchParam {
    private final String indexName;
    private final String oldIndexName;
    private final String query;
    private final int topK;

    public static Builder newBuilder() {
        return new Builder();
    }

    public KeywordDataSearchParam(@NotNull Builder builder) {
        this.indexName = builder.indexName;
        this.oldIndexName = builder.oldIndexName;
        this.query = builder.query;
        this.topK = builder.topK;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getQuery() {
        return this.query;
    }

    public int getTopK() {
        return this.topK;
    }

    public String getOldIndexName() {
        return this.oldIndexName;
    }

    public static class Builder {
        private String indexName;
        private String oldIndexName;
        private String query;
        private int topK;

        private Builder() {
        }

        public Builder withIndexName(KeywordIndexSchema indexSchema) {
            this.indexName = KeywordServiceHelper.biuldIndexName(indexSchema);
            this.oldIndexName = KeywordServiceHelper.biuldOldIndexName(indexSchema);
            return this;
        }

        public Builder withQuery(String query) {
            this.query = query;
            return this;
        }

        public Builder withTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public KeywordDataSearchParam build() {
            return new KeywordDataSearchParam(this);
        }
    }
}

