/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.param.keyword;

import javax.validation.constraints.NotNull;
import kd.ai.gai.core.enuz.es.ESTokenizerType;
import kd.ai.gai.core.search.index.schema.KeywordIndexSchema;
import kd.ai.gai.core.search.index.service.KeywordServiceHelper;

public class KeywordIndexCreateParam {
    private final String indexName;
    private final String desc;
    private final ESTokenizerType tokenizerType;

    public static Builder newBuilder() {
        return new Builder();
    }

    public KeywordIndexCreateParam(@NotNull Builder builder) {
        this.indexName = builder.indexName;
        this.desc = builder.desc;
        this.tokenizerType = builder.tokenizerType;
    }

    public ESTokenizerType getTokenizerType() {
        return this.tokenizerType;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public static class Builder {
        private String indexName;
        private String desc;
        private ESTokenizerType tokenizerType;

        private Builder() {
        }

        public Builder withIndexName(KeywordIndexSchema keywordIndexSchema) {
            this.indexName = KeywordServiceHelper.biuldIndexName(keywordIndexSchema);
            return this;
        }

        public Builder withDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder withTokenizerType(ESTokenizerType tokenizerType) {
            this.tokenizerType = tokenizerType;
            return this;
        }

        public KeywordIndexCreateParam build() {
            return new KeywordIndexCreateParam(this);
        }
    }
}

