/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.param.vector;

import javax.validation.constraints.NotNull;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.search.index.schema.VectorCollectionSchema;
import kd.ai.gai.core.search.index.service.VectorServiceHelper;

public class VectorCollectionCreateParam {
    private final String collectionName;
    private final String embeddingNumer;
    private final int dim;
    private final String desc;
    private final VectorMetricType vectorMetricType;

    public VectorCollectionCreateParam(@NotNull Builder builder) {
        this.collectionName = builder.collectionName;
        this.dim = builder.dim;
        this.desc = builder.desc;
        this.embeddingNumer = builder.embeddingNumer;
        this.vectorMetricType = builder.vectorMetricType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getEmbeddingNumer() {
        return this.embeddingNumer;
    }

    public int getDim() {
        return this.dim;
    }

    public VectorMetricType getVectorMetricType() {
        return this.vectorMetricType;
    }

    public String getDesc() {
        return this.desc;
    }

    public static class Builder {
        private String collectionName;
        private String embeddingNumer;
        private int dim;
        private VectorMetricType vectorMetricType;
        private String desc;

        private Builder() {
        }

        public Builder withCollectionName(VectorCollectionSchema collectionSchema) {
            this.collectionName = VectorServiceHelper.biuldCollectionName(collectionSchema);
            return this;
        }

        public Builder withEmbeddingNumer(String embeddingNumer) {
            this.embeddingNumer = embeddingNumer;
            return this;
        }

        public Builder withDim(int dim) {
            this.dim = dim;
            return this;
        }

        public Builder withVectorMetricType(VectorMetricType vectorMetricType) {
            this.vectorMetricType = vectorMetricType;
            return this;
        }

        public Builder withDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public VectorCollectionCreateParam build() {
            return new VectorCollectionCreateParam(this);
        }
    }
}

