/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.param.vector;

import java.util.List;
import javax.validation.constraints.NotNull;
import kd.ai.gai.core.search.index.param.vector.VectorData;
import kd.ai.gai.core.search.index.schema.VectorCollectionSchema;
import kd.ai.gai.core.search.index.service.VectorServiceHelper;

public class VectorDataAddParam {
    private final String collectionName;
    private final List<VectorData> vectorDataList;

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<VectorData> getVectorDataList() {
        return this.vectorDataList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public VectorDataAddParam(@NotNull Builder builder) {
        this.collectionName = builder.collectionName;
        this.vectorDataList = builder.vectorDataList;
    }

    public static class Builder {
        private String collectionName;
        private List<VectorData> vectorDataList;

        private Builder() {
        }

        public Builder withCollectonName(VectorCollectionSchema collectionSchema) {
            this.collectionName = VectorServiceHelper.biuldCollectionName(collectionSchema);
            return this;
        }

        public Builder withVectorDataList(List<VectorData> vectorDataList) {
            this.vectorDataList = vectorDataList;
            return this;
        }

        public VectorDataAddParam build() {
            return new VectorDataAddParam(this);
        }
    }
}

