/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.param.vector;

import java.util.List;
import javax.validation.constraints.NotNull;
import kd.ai.gai.core.search.index.schema.VectorCollectionSchema;
import kd.ai.gai.core.search.index.service.VectorServiceHelper;

public class VectorDataDelParam {
    private final String collectionName;
    private final List<DelData> delDataList;

    public static Builder newBuilder() {
        return new Builder();
    }

    public VectorDataDelParam(@NotNull Builder builder) {
        this.collectionName = builder.collectionName;
        this.delDataList = builder.delDataList;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<DelData> getDelDataList() {
        return this.delDataList;
    }

    public static class DelData {
        private String id;
        private Long dataId;
        private String propertyKey;

        public DelData(Long dataId, String propertyKey) {
            if (dataId == null) {
                throw new RuntimeException("dataId is not null");
            }
            if (propertyKey == null) {
                throw new RuntimeException("propertyKey is not null");
            }
            this.id = String.format("%s_%s", dataId, propertyKey);
            this.dataId = dataId;
            this.propertyKey = propertyKey;
        }

        public String getId() {
            return this.id;
        }

        public Long getDataId() {
            return this.dataId;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }
    }

    public static class Builder {
        private String collectionName;
        private List<DelData> delDataList;

        private Builder() {
        }

        public Builder withCollectionName(VectorCollectionSchema collectionSchema) {
            this.collectionName = VectorServiceHelper.biuldCollectionName(collectionSchema);
            return this;
        }

        public Builder withDelDataList(List<DelData> delDataList) {
            this.delDataList = delDataList;
            return this;
        }

        public VectorDataDelParam build() {
            return new VectorDataDelParam(this);
        }
    }
}

