/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.param.vector;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.search.index.schema.VectorCollectionSchema;
import kd.ai.gai.core.search.index.service.VectorServiceHelper;

public class VectorDataSearchParam
implements Serializable {
    private static final long serialVersionUID = 2844424756210943205L;
    private final String collectionName;
    private final String query;
    private final int topK;
    private final float similarity;
    private final LLM embeddingModel;
    private final VectorMetricType vectorMetricType;

    public static Builder newBuilder() {
        return new Builder();
    }

    public VectorDataSearchParam(@NotNull Builder builder) {
        this.collectionName = builder.collectionName;
        this.embeddingModel = builder.embeddingModel;
        this.query = builder.query;
        this.topK = builder.topK;
        this.similarity = builder.similarity;
        this.vectorMetricType = builder.vectorMetricType;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public LLM getEmbeddingModel() {
        return this.embeddingModel;
    }

    public String getQuery() {
        return this.query;
    }

    public int getTopK() {
        return this.topK;
    }

    public VectorMetricType getVectorMetricType() {
        return this.vectorMetricType;
    }

    public float getSimilarity() {
        return this.similarity;
    }

    public static class Builder {
        private String collectionName;
        private String query;
        private int topK;
        private float similarity;
        private LLM embeddingModel;
        private VectorMetricType vectorMetricType;

        private Builder() {
        }

        public Builder withCollectionName(VectorCollectionSchema collectionNameSchema) {
            this.collectionName = VectorServiceHelper.biuldCollectionName(collectionNameSchema);
            return this;
        }

        public Builder withQuery(String query) {
            this.query = query;
            return this;
        }

        public Builder withTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder withVectorMetricType(VectorMetricType vectorMetricType) {
            this.vectorMetricType = vectorMetricType;
            return this;
        }

        public Builder withSimilarity(float similarity) {
            this.similarity = similarity;
            return this;
        }

        public Builder withEmbeddingModel(LLM embeddingModel) {
            this.embeddingModel = embeddingModel;
            return this;
        }

        public VectorDataSearchParam build() {
            return new VectorDataSearchParam(this);
        }
    }
}

