/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.service;

import kd.ai.gai.core.search.index.schema.KeywordIndexSchema;
import kd.ai.gai.core.search.index.service.KeywordService;
import kd.ai.gai.core.search.index.service.impl.ESKeywordServiceImpl;
import kd.bos.dataentity.utils.StringUtils;

public class KeywordServiceHelper {
    private KeywordServiceHelper() {
    }

    public static KeywordService getStructuredService() {
        return Holder.service;
    }

    public static String biuldIndexName(KeywordIndexSchema indexSchema) {
        String tenantId = indexSchema.getTenantId();
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new RuntimeException("tenantId is not null.");
        }
        String tenantCode = tenantId.replaceAll("[^a-zA-Z0-9_]", "_").replaceAll("_+", "_");
        return String.format("gpt_sk_%s_%s_%s_data", tenantCode, indexSchema.getAccountId(), indexSchema.getRepoId()).toLowerCase();
    }

    public static String biuldOldIndexName(KeywordIndexSchema indexSchema) {
        return String.format("gpt_sk_%s_%s_%s_data", indexSchema.getTenantId(), indexSchema.getAccountId(), indexSchema.getRepoId()).toLowerCase();
    }

    private static class Holder {
        private static KeywordService service = new ESKeywordServiceImpl();

        private Holder() {
        }
    }
}

