/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.search.index.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.repo.RepoFulltextIndex;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.es.ESDataType;
import kd.ai.gai.core.enuz.es.ESFilterType;
import kd.ai.gai.core.enuz.es.ESIndexType;
import kd.ai.gai.core.enuz.es.ESTokenizerType;
import kd.ai.gai.core.enuz.repo.SearchDataSource;
import kd.ai.gai.core.search.index.param.keyword.KeywordData;
import kd.ai.gai.core.search.index.param.keyword.KeywordDataAddParam;
import kd.ai.gai.core.search.index.param.keyword.KeywordDataCountParam;
import kd.ai.gai.core.search.index.param.keyword.KeywordDataDelParam;
import kd.ai.gai.core.search.index.param.keyword.KeywordDataSearchParam;
import kd.ai.gai.core.search.index.param.keyword.KeywordIndexCreateParam;
import kd.ai.gai.core.search.index.param.keyword.KeywordIndexDropParam;
import kd.ai.gai.core.search.index.param.keyword.KeywordIndexNameParam;
import kd.ai.gai.core.search.index.param.structured.StructuredSearchResultData;
import kd.ai.gai.core.search.index.service.KeywordService;
import kd.ai.gai.core.service.es.ESClientFactory;
import kd.ai.gai.core.service.es.ESFilterEntity;
import kd.ai.gai.core.service.es.ESQueryParam;
import kd.ai.gai.core.service.es.ESService;
import kd.ai.gai.core.util.GaiBeanUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class ESKeywordServiceImpl
implements KeywordService {
    private static Log logger = LogFactory.getLog(ESKeywordServiceImpl.class);
    private static final String indexType = ESIndexType.DOC.toString();
    private final String PROPERTY_DATA_ID = "id";
    private final String PROPERTY_NAME = "propertyName";
    private final String PROPERTY_VAL = "propertyVal";
    private final String[] FULLTEXT_RETURN_FIELDS = new String[]{"id", "propertyName", "propertyVal"};

    @Override
    public boolean createIndex(KeywordIndexCreateParam createParam) throws IOException {
        String indexName = createParam.getIndexName();
        logger.info("\u3010RAG\u3011structured repo init fullText build index :{}", (Object)indexName);
        ESService es = ESService.getInstance();
        boolean indexExist = es.isIndexExist(ESClientFactory.getEsClient(), indexName);
        logger.info("\u3010RAG\u3011structured repo init fullText index exist:{}", (Object)indexExist);
        if (!indexExist) {
            ESTokenizerType tokenizerType = createParam.getTokenizerType();
            if (tokenizerType == null) {
                logger.warn("\u3010RAG\u3011structured repo init fullText index ESTokenizerType is null,default:ik_max_word");
                tokenizerType = ESTokenizerType.IKMAXWORD;
            }
            String indexMappingJson = this.buildMappingJson(tokenizerType);
            logger.info("\u3010RAG\u3011structured repo init fullText build mapping :{}", (Object)indexMappingJson);
            es.createIndex(ESClientFactory.getEsClient(), indexName, indexType, indexMappingJson);
            logger.info("\u3010RAG\u3011structured repo init fullText create index:{},indexType:{} end ", (Object)indexName, (Object)indexType);
        } else {
            logger.info("\u3010RAG\u3011structured repo init fullText index is exist,no init");
        }
        return true;
    }

    private String buildMappingJson(ESTokenizerType tokenizerType) {
        logger.info("\u3010RAG\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u6784\u5efa\u5168\u6587\u7d22\u5f15Mapping \u5f00\u59cb");
        RepoFulltextIndex[] repoFulltextIndices = new RepoFulltextIndex[]{new RepoFulltextIndex("id", ESDataType.STRING, ESTokenizerType.KEYWORD), new RepoFulltextIndex("propertyName", ESDataType.STRING, tokenizerType), new RepoFulltextIndex("propertyVal", ESDataType.STRING, tokenizerType)};
        String mappingIndex = ESService.getInstance().buildMappingIndex(indexType, repoFulltextIndices);
        logger.info("\u3010RAG\u3011\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u6784\u5efa\u5168\u6587\u7d22\u5f15Mapping \u5b8c\u6210\uff0c\u4fe1\u606f\uff1a{}", (Object)mappingIndex);
        return mappingIndex;
    }

    @Override
    public boolean indexExist(KeywordIndexNameParam indexNameParam) throws IOException {
        logger.info("\u3010RAG\u3011structured repo check fullText build indexName :{}", (Object)JsonUtil.toJson(indexNameParam));
        String indexName = indexNameParam.getIndexName();
        boolean indexExist = this.isIndexExist(indexName);
        if (indexExist) {
            return true;
        }
        indexName = indexNameParam.getOldIndexName();
        indexExist = this.isIndexExist(indexName);
        logger.info("\u3010RAG\u3011structured repo check fullText index exist:{}", (Object)indexExist);
        return indexExist;
    }

    private boolean isIndexExist(String indexName) throws IOException {
        return ESService.getInstance().isIndexExist(ESClientFactory.getEsClient(), indexName);
    }

    @Override
    public List<StructuredSearchResultData> search(KeywordDataSearchParam searchParam) {
        try {
            logger.info("\u3010RAG-\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u5168\u6587\u68c0\u7d22\u3011\u53c2\u6570\uff1a{}", (Object)JsonUtil.toJson(searchParam));
            ESService es = ESService.getInstance();
            String indexName = searchParam.getIndexName();
            String query = searchParam.getQuery();
            int topK = searchParam.getTopK();
            boolean indexExist = this.isIndexExist(indexName);
            if (!indexExist) {
                indexName = searchParam.getOldIndexName();
            }
            ArrayList<ESFilterEntity> filters = new ArrayList<ESFilterEntity>(1);
            filters.add(new ESFilterEntity("propertyVal", query, ESFilterType.MATCH));
            ESQueryParam queryParam = new ESQueryParam(indexName, filters, this.FULLTEXT_RETURN_FIELDS, topK);
            SearchRequest request = es.buildSearchRequest(queryParam);
            request.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
            SearchHits searchHits = es.search(ESClientFactory.getEsClient(), request);
            ArrayList<StructuredSearchResultData> rsdatas = new ArrayList<StructuredSearchResultData>(topK);
            for (SearchHit hit : searchHits) {
                float score = hit.getScore();
                Map source = hit.getSourceAsMap();
                rsdatas.add(new StructuredSearchResultData(String.valueOf(source.get("id")), SearchDataSource.ES, score));
            }
            return rsdatas;
        }
        catch (IOException e) {
            logger.error("\u3010RAG-\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93-\u5168\u6587\u68c0\u7d22\u3011ES \u8fde\u63a5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, e.getMessage()), new Object[0]);
        }
    }

    @Override
    public boolean delIndex(KeywordIndexDropParam dropParam) throws IOException {
        String indexName = dropParam.getIndexName();
        boolean indexExist = this.isIndexExist(indexName);
        if (!indexExist) {
            indexName = dropParam.getOldIndexName();
        }
        logger.info("repo del fullText dropParam :{}", (Object)JsonUtil.toJson(dropParam));
        boolean del = ESService.getInstance().deleteIndex(ESClientFactory.getEsClient(), indexName);
        logger.info("repo del fullText index end");
        return del;
    }

    @Override
    public boolean batchAddData(KeywordDataAddParam addParam) {
        try {
            List<KeywordData> keywordDatas;
            logger.info("\u3010RAG\u3011structured repo batch delete data addParam :{}", (Object)addParam);
            String indexName = addParam.getIndexName();
            boolean indexExist = this.isIndexExist(indexName);
            if (!indexExist) {
                indexName = addParam.getOldIndexName();
            }
            if ((keywordDatas = addParam.getKeywordDatas()) == null || keywordDatas.isEmpty()) {
                logger.error("\u3010RAG\u3011structured repo batch delete data addParam is null");
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, "\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u65b0\u589e\u6570\u636e\uff0c\u53c2\u6570\u4e3anull"), new Object[0]);
            }
            ArrayList<XContentBuilder> xContentBuilders = new ArrayList<XContentBuilder>(keywordDatas.size());
            for (KeywordData ftd : keywordDatas) {
                xContentBuilders.add(this.bildIndexDataToXContent(ftd));
            }
            return ESService.getInstance().batchInsertDoc(ESClientFactory.getEsClient(), indexName, xContentBuilders);
        }
        catch (Throwable throwable) {
            logger.error("\u3010RAG\u3011structured repo batch add data error msg:{}", (Object)throwable.getMessage(), (Object)throwable);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, throwable.getMessage()), new Object[0]);
        }
    }

    @Override
    public long batchDelData(KeywordDataDelParam delParam) {
        try {
            logger.info("\u3010RAG\u3011structured repo batch delete data delParam:\u3010{}\u3011", (Object)delParam);
            if (delParam == null) {
                logger.error("\u3010RAG\u3011structured repo batchDelData delParam is not null");
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, "\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u5220\u9664\u5168\u6587\u672c\u6570\u636e\uff0c\u53c2\u6570\u4e3anull"), new Object[0]);
            }
            String indexName = delParam.getIndexName();
            boolean indexExist = this.isIndexExist(indexName);
            if (!indexExist) {
                indexName = delParam.getOldIndexName();
            }
            List<KeywordDataDelParam.DelData> datas = delParam.getDatas();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            if (datas != null) {
                ArrayList<String> dataIds = new ArrayList<String>(datas.size());
                for (KeywordDataDelParam.DelData data : datas) {
                    dataIds.add(data.getId());
                }
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"id", dataIds));
            }
            long delCount = ESService.getInstance().deleteByQuery(ESClientFactory.getEsClient(), indexName, indexType, (QueryBuilder)boolQueryBuilder);
            logger.info("\u3010RAG\u3011structured repo batch delete data deleted count=" + delCount);
            return delCount;
        }
        catch (Exception e) {
            logger.error("\u3010RAG\u3011structured repo batch delete data deleted error msg\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, e.getMessage()), new Object[0]);
        }
    }

    @Override
    public long queryCountByIndexName(KeywordDataCountParam countParam) {
        logger.info("\u3010RAG\u3011structured repo query count params:{}", (Object)JsonUtil.toJson(countParam));
        try {
            String indexName = countParam.getIndexName();
            boolean indexExist = this.isIndexExist(indexName);
            if (!indexExist) {
                indexName = countParam.getOldIndexName();
            }
            long count = ESService.getInstance().queryCountByIndexName(ESClientFactory.getEsClient(), indexName);
            logger.info("\u3010RAG\u3011structured repo query count by indexName :{}", (Object)count);
            return count;
        }
        catch (IOException e) {
            logger.error("\u3010RAG\u3011structured repo query count by indexName error :{}", (Object)e.getMessage(), (Object)e);
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, e.getMessage()), new Object[0]);
        }
    }

    private XContentBuilder bildIndexDataToXContent(KeywordData data) throws Throwable {
        if (data == null) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, "\u6570\u636e\u4e3a\u7a7a"), new Object[0]);
        }
        Map<String, Object> element = GaiBeanUtils.processElement(data);
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject();
        Set<Map.Entry<String, Object>> entries = element.entrySet();
        for (Map.Entry<String, Object> next : entries) {
            xContentBuilder.field(next.getKey(), next.getValue());
        }
        return xContentBuilder.endObject();
    }
}

