/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AssistantService {
    private static final Log log = LogFactory.getLog(AssistantService.class);
    public static final String ASS_BIZ_APP_ID = "3ACHGCGWU9MJ";
    public static final String TABLE = "gai_gpt_assistant_config";
    public static final String ID = "id";
    public static final long DEFAULT_ID = 10000L;
    public static final String ASS_PICTURE = "picture";
    public static final String ASS_NAME = "name";
    public static final String ASS_NUMBER = "number";
    public static final String ASS_OPENING_SPEECH = "openingspeech";
    public static final String ASS_INTRODUCE = "introduce";
    public static final String ASS_PERSONA = "persona";
    public static final String ASS_TYPE = "type";
    public static final String ASS_ENABLE = "enable";
    public static final String ASS_PROMPT = "prompt";
    public static final String ASS_ALL_STAFF_ASSISTANT = "allstaffassistant";
    public static final String queryKey = "id,number,picture,name,introduce,prompt,persona,type,enable,openingspeech,allstaffassistant";
    public static final String PIC_STATIC_PRE = "/kingdee/gai/images/pc/icon/";
    public static final String DEFAULT_PIC = "/kingdee/gai/images/pc/icon/Cosmic_48_48.png";

    public static synchronized Assistant getDefault() {
        return AssistantService.getOne(10000L);
    }

    public static synchronized Assistant getOne(long assId) {
        if (assId == 0L) {
            return null;
        }
        try {
            DynamicObject obj;
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)TABLE, (String)queryKey, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)assId)});
            if (objs == null || objs.length == 0) {
                if (10000L == assId) {
                    return null;
                }
                String pictureUrl = UrlService.getDomainContextUrl() + DEFAULT_PIC;
                obj = BusinessDataServiceHelper.newDynamicObject((String)TABLE);
                obj.set(ID, (Object)10000L);
                obj.set(ASS_NAME, (Object)"\u82cd\u7a79");
                obj.set(ASS_TYPE, (Object)"A");
                obj.set(ASS_ENABLE, (Object)"1");
                obj.set(ASS_PICTURE, (Object)pictureUrl);
                obj.set(ASS_INTRODUCE, (Object)"\u4f60\u7684AI\u7ba1\u7406\u52a9\u624b");
                obj.set("openingSpeech", (Object)"\u6b22\u8fce\u4f7f\u7528");
                obj.set(ASS_PERSONA, (Object)"\u6211\u662f\u91d1\u8776\u667a\u80fdAI\u7ba1\u7406\u52a9\u624b\u82cd\u7a79\uff0c\u5e2e\u7528\u6237\u89e3\u7b54\u7591\u95ee\u9ad8\u6548\u5de5\u4f5c\u3002");
                Assistant assistant = new Assistant();
                assistant.setName(obj.getString(ASS_NAME));
                assistant.setPicture(obj.getString(ASS_PICTURE));
                assistant.setIntroduce(obj.getString(ASS_INTRODUCE));
                assistant.setOpeningSpeech(obj.getString(ASS_OPENING_SPEECH));
                assistant.setPersona(obj.getString(ASS_PERSONA));
                assistant.setType(obj.getString(ASS_TYPE));
                assistant.setEnable(obj.getString(ASS_ENABLE));
                assistant.setId((Long)obj.getPkValue());
                objs = new DynamicObject[]{obj};
                SaveServiceHelper.save((DynamicObject[])objs);
            } else {
                obj = objs[0];
            }
            Assistant assistant = new Assistant();
            assistant.setName(obj.getString(ASS_NAME));
            assistant.setPicture(obj.getString(ASS_PICTURE));
            assistant.setIntroduce(obj.getString(ASS_INTRODUCE));
            assistant.setOpeningSpeech(obj.getString(ASS_OPENING_SPEECH));
            assistant.setPersona(obj.getString(ASS_PERSONA));
            assistant.setType(obj.getString(ASS_TYPE));
            assistant.setEnable(obj.getString(ASS_ENABLE));
            assistant.setId((Long)obj.getPkValue());
            DynamicObject dynamicObject = obj.getDynamicObject(ASS_PROMPT);
            if (dynamicObject != null) {
                assistant.setPromptId(dynamicObject.getLong(0));
            }
            if (StringUtils.isEmpty((CharSequence)assistant.getPicture())) {
                String pictureUrl = UrlService.getDomainContextUrl() + DEFAULT_PIC;
                assistant.setPicture(pictureUrl);
            }
            return assistant;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Assistant> getList() {
        ArrayList<Assistant> assistantList = new ArrayList<Assistant>(10);
        RequestContext context = RequestContext.get();
        long userId = context.getCurrUserId();
        ArrayList filters = Lists.newArrayList();
        QFilter enableFilter = new QFilter(ASS_ENABLE, "=", (Object)"1");
        filters.add(enableFilter);
        QFilter allStaffFilter = new QFilter(ASS_ALL_STAFF_ASSISTANT, "=", (Object)"1");
        try {
            QFilter permissionFilter = PermissionServiceHelper.getDataPermWithOrg((long)userId, (String)ASS_BIZ_APP_ID, (String)TABLE);
            if (permissionFilter == null) {
                boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)ASS_BIZ_APP_ID, (String)TABLE, (String)"47150e89000000ac");
                if (hasPermission) {
                    log.info("\u7528\u6237\u672a\u8bbe\u7f6e\u6570\u636e\u89c4\u5219,\u4f46\u6709\u529f\u80fd\u6743\u9650,\u53ef\u67e5\u8be2\u6240\u6709\u52a9\u624b,userId:[{}]", (Object)userId);
                    allStaffFilter.or(enableFilter);
                } else {
                    log.info("\u7528\u6237\u672a\u8bbe\u7f6e\u6570\u636e\u89c4\u5219,\u4e14\u65e0\u529f\u80fd\u6743\u9650,\u53ea\u80fd\u67e5\u8be2\u5168\u5458\u52a9\u624b,userId:[{}]", (Object)userId);
                }
            } else {
                allStaffFilter.or(permissionFilter);
                log.info("\u7528\u6237\u8bbe\u7f6e\u4e86\u6570\u636e\u89c4\u5219,\u83b7\u53d6\u6743\u9650Filter\u6210\u529f,userId:[{}],permissionFilter:{}", (Object)userId, (Object)JSON.toJSONString((Object)permissionFilter));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6743\u9650Filter\u5f02\u5e38,userId:[{}]", (Object)userId, (Object)e);
            return assistantList;
        }
        filters.add(allStaffFilter);
        Map doMap = BusinessDataServiceHelper.loadFromCache((String)TABLE, (String)queryKey, (QFilter[])filters.toArray(new QFilter[0]));
        if (ObjectUtils.isEmpty((Object)doMap)) {
            return assistantList;
        }
        Collection collection = doMap.values();
        for (DynamicObject obj : collection) {
            Assistant assistant = new Assistant();
            assistant.setId(obj.getLong(ID));
            assistant.setName(obj.getString(ASS_NAME));
            assistant.setNumber(obj.getString(ASS_NUMBER));
            assistant.setPicture(obj.getString(ASS_PICTURE));
            assistant.setIntroduce(obj.getString(ASS_INTRODUCE));
            assistant.setOpeningSpeech(obj.getString(ASS_OPENING_SPEECH));
            assistant.setPersona(obj.getString(ASS_PERSONA));
            assistant.setAllStaff(obj.getBoolean(ASS_ALL_STAFF_ASSISTANT));
            DynamicObject dynPrompt = obj.getDynamicObject(ASS_PROMPT);
            if (dynPrompt != null) {
                assistant.setPromptId(dynPrompt.getLong(ID));
            }
            if (StringUtils.isEmpty((CharSequence)assistant.getPicture())) {
                String pictureUrl = UrlService.getDomainContextUrl() + DEFAULT_PIC;
                assistant.setPicture(pictureUrl);
            }
            assistantList.add(assistant);
        }
        return assistantList;
    }

    public static Assistant getAssistantWithDefault() {
        Assistant assistant = AssistantService.getDefault();
        if (assistant == null) {
            assistant = new Assistant();
            assistant.setPicture("/kingdee/gai/images/pc/agent/avatar/common_agent.png");
            assistant.setId(10000L);
            assistant.setName(ResManager.loadKDString((String)"\u82cd\u7a79GPT", (String)"gai.core.assistant.default.name", (String)"ai-gai-core", (Object[])new Object[0]));
            assistant.setIntroduce(ResManager.loadKDString((String)"\u901a\u7528\u57fa\u7840\u52a9\u624b", (String)"gai.core.assistant.default.introduce", (String)"ai-gai-plugin", (Object[])new Object[0]));
            assistant.setOpeningSpeech(ResManager.loadKDString((String)"\u4f60\u597d\uff0c\u6211\u662f\u82cd\u7a79GPT\u52a9\u624b", (String)"gai.core.assistant.default.prologue", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)assistant.getPicture())) {
            assistant.setPicture("/kingdee/gai/images/pc/agent/avatar/common_agent.png");
        }
        return assistant;
    }
}

