/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.CallBackInfo;
import kd.ai.gai.core.domain.dto.ChatParams;
import kd.ai.gai.core.domain.dto.FeedParams;
import kd.ai.gai.core.domain.dto.NewSessionParams;
import kd.ai.gai.core.domain.dto.StopParams;
import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.message.ChatMessage;
import kd.ai.gai.core.engine.message.StopStreamMessage;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.service.AssistantService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.SkillService;
import kd.ai.gai.core.service.op.IUserFeedbackService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.GaiLicenseUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class GaiCosmicAppService
implements Serializable {
    private static Log log = LogFactory.getLog(GaiCosmicAppService.class);
    private static volatile LocalMemoryCache CACHE;
    public static final String ASS_BIZ_APP_ID = "3ACHGCGWU9MJ";
    public static final String TABLE = "gai_gpt_assistant_config";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalMemoryCache getCache() {
        if (CACHE != null) return CACHE;
        Class<GaiCosmicAppService> clazz = GaiCosmicAppService.class;
        synchronized (GaiCosmicAppService.class) {
            if (CACHE != null) return CACHE;
            CACHE = GaiCosmicAppService.createCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return CACHE;
        }
    }

    public static LocalMemoryCache createCache() {
        CacheConfigInfo cacheConfigInfo = new CacheConfigInfo();
        cacheConfigInfo.setMaxItemSize(100);
        cacheConfigInfo.setTimeout(18000);
        CacheFactory cacheFactory = CacheFactory.getCommonCacheFactory();
        return cacheFactory.$getOrCreateLocalMemoryCache("kd_gai_ass", "pic_base64_data", cacheConfigInfo);
    }

    public static String getCachedBase64Pic(String pic) {
        Object cachedBase64Pic;
        if (StringUtils.isEmpty((String)pic)) {
            return null;
        }
        LocalMemoryCache cache = GaiCosmicAppService.getCache();
        if (!cache.contains(pic)) {
            try {
                String base64Pic = GaiUtils.getImageBase64ByIO(pic);
                cache.put(pic, (Object)base64Pic);
            }
            catch (Exception e) {
                log.error("\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                return null;
            }
        }
        if ((cachedBase64Pic = cache.get(pic)) != null) {
            return cachedBase64Pic.toString();
        }
        return null;
    }

    public static List<Assistant> getAssistants() {
        List<Assistant> assistantList = AssistantService.getList();
        for (Assistant assistant : assistantList) {
            String pic = assistant.getPicture();
            assistant.setPicture(GaiCosmicAppService.getCachedBase64Pic(pic));
        }
        return assistantList;
    }

    public static Map<String, Object> newSession(NewSessionParams newSessionParams) {
        List<Skill> skillListNotCheckBlg;
        log.info("new Session:{}", (Object)JSONObject.toJSONString((Object)newSessionParams));
        long assistantId = newSessionParams.getAssistantId();
        String callbackUrl = newSessionParams.getCallbackUrl();
        if (StringUtils.isEmpty((String)callbackUrl)) {
            callbackUrl = JSON.toJSONString((Object)newSessionParams.getCallBackInfo());
        }
        String clientType = newSessionParams.getClientType();
        String chatSessionId = GaiUtils.newContext4CosmicApp(assistantId, clientType, callbackUrl);
        long userId = RequestContext.get().getCurrUserId();
        List<String> blgs = GaiLicenseUtils.getUserBLG(userId);
        log.info("blgs: {}", (Object)blgs.toString());
        GaiCosmicAppService.checkAssistantPermission(assistantId, userId);
        List<Skill> skillList = SkillService.getPermissionList(assistantId, "", blgs);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(skillList) && org.apache.commons.collections4.CollectionUtils.isNotEmpty(skillListNotCheckBlg = SkillService.getList(assistantId, false))) {
            throw new KDBizException(Errors.skillIsNullError(), new Object[0]);
        }
        Context context = FlowCacheData.getContext(chatSessionId);
        context.setSkillList(skillList);
        Map<String, Long> userInfoByPhone = GaiCosmicAppService.getUserInfoByPhone(newSessionParams.getOpPhone());
        context.setOpUserId(userInfoByPhone.get("userId"));
        context.setOpUserName(newSessionParams.getOpUserName());
        FlowCacheData.putContext(chatSessionId, context);
        ArrayList skillMapList = new ArrayList(10);
        if (skillList == null) {
            skillList = new ArrayList<Skill>();
        }
        for (Skill skill : skillList) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("id", skill.getId());
            item.put("name", skill.getName());
            item.put("number", skill.getNumber());
            item.put("type", skill.getType().toString());
            String pic = skill.getPicture();
            item.put("picture", GaiCosmicAppService.getCachedBase64Pic(pic));
            skillMapList.add(item);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sessionId", chatSessionId);
        result.put("skills", skillMapList);
        return result;
    }

    private static List<Skill> getAgentListByCheckLic(List<Skill> skillList) {
        Set<Long> processIdList = skillList.stream().filter(skill -> skill.getType() == Skill.Type.PROCESS).map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet());
        Set<Long> agentIdList = skillList.stream().filter(skill -> skill.getType() == Skill.Type.AGENT).map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet());
        Set<Long> usedSkillIdList = GPTLicenseHelper.getUseBizIds(GaiFormIdEnum.GAI_AGENT.getId(), agentIdList);
        usedSkillIdList.addAll(GPTLicenseHelper.getUseBizIds(GaiFormIdEnum.GAI_PROCESS.getId(), processIdList));
        log.info("usedSkillIdList: {}", (Object)usedSkillIdList.toString());
        skillList = skillList.stream().filter(skill -> usedSkillIdList.contains(Long.valueOf(skill.getId()))).collect(Collectors.toList());
        return skillList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkAssistantPermission(long assistantId, long userId) {
        log.info("assistantId is {}", (Object)assistantId);
        if (!GPTLicenseHelper.checkLic("gai_assistant", assistantId)) {
            throw new KDBizException(Errors.USER_BLG_ISNULL, new Object[0]);
        }
        QFilter idFilter = new QFilter("id", "=", (Object)assistantId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TABLE, (String)"allstaffassistant,enable", (QFilter[])new QFilter[]{idFilter});
        if (dynamicObject == null) {
            throw new KDBizException(Errors.ASSISTANT_ISNULL, new Object[0]);
        }
        boolean isAllStaff = dynamicObject.getBoolean("allstaffassistant");
        boolean enable = dynamicObject.getBoolean("enable");
        if (!isAllStaff) {
            try {
                QFilter permissionFilter = PermissionServiceHelper.getDataPermWithOrg((long)userId, (String)ASS_BIZ_APP_ID, (String)TABLE);
                if (permissionFilter == null) {
                    boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)ASS_BIZ_APP_ID, (String)TABLE, (String)"47150e89000000ac");
                    if (!hasPermission) {
                        log.info("\u7528\u6237\u672a\u8bbe\u7f6e\u6570\u636e\u89c4\u5219,\u4e14\u65e0\u529f\u80fd\u6743\u9650,\u53ea\u80fd\u67e5\u8be2\u5168\u5458\u52a9\u624b,userId:[{}]", (Object)userId);
                        throw new KDBizException(Errors.USER_NO_ASSISTANT, new Object[0]);
                    }
                    log.info("\u7528\u6237\u672a\u8bbe\u7f6e\u6570\u636e\u89c4\u5219,\u4f46\u6709\u529f\u80fd\u6743\u9650,\u53ef\u67e5\u8be2\u6240\u6709\u52a9\u624b,userId:[{}]", (Object)userId);
                } else {
                    ArrayList filters = Lists.newArrayList();
                    filters.add(idFilter);
                    filters.add(permissionFilter);
                    log.info("\u7528\u6237\u8bbe\u7f6e\u4e86\u6570\u636e\u89c4\u5219,\u83b7\u53d6\u6743\u9650Filter\u6210\u529f,userId:[{}],permissionFilter:{}", (Object)userId, (Object)JSON.toJSONString((Object)permissionFilter));
                    DynamicObject dynamicObjects = QueryServiceHelper.queryOne((String)TABLE, (String)"enable", (QFilter[])filters.toArray(new QFilter[0]));
                    if (dynamicObjects == null) {
                        throw new KDBizException(Errors.USER_NO_ASSISTANT, new Object[0]);
                    }
                }
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u6743\u9650Filter\u5f02\u5e38,userId:[{}]", (Object)userId, (Object)e);
                throw new KDBizException(Errors.GET_PERMISSION_ERROR, new Object[0]);
            }
        }
        if (!enable) {
            throw new KDBizException(Errors.ASSISTANT_IS_DISABLE, new Object[0]);
        }
    }

    public static void checkAssistantForChat(long assistantId, long userId) {
        log.info("assistantId is {}", (Object)assistantId);
        if (!GPTLicenseHelper.checkLic("gai_assistant", assistantId)) {
            throw new KDBizException(Errors.USER_BLG_ISNULL, new Object[0]);
        }
        QFilter idFilter = new QFilter("id", "=", (Object)assistantId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TABLE, (String)"allstaffassistant,enable", (QFilter[])new QFilter[]{idFilter});
        if (dynamicObject == null) {
            throw new KDBizException(Errors.ASSISTANT_ISNULL, new Object[0]);
        }
        boolean enable = dynamicObject.getBoolean("enable");
        if (!enable) {
            throw new KDBizException(Errors.ASSISTANT_IS_DISABLE, new Object[0]);
        }
    }

    public static Map<String, Object> chat(ChatParams chatParams) {
        long skillId;
        log.info("chatParams:{}", (Object)JSONObject.toJSONString((Object)chatParams));
        if (StringUtils.isEmpty((String)chatParams.getMessage().getQuery())) {
            throw new KDBizException(Errors.noUserInputError(), new Object[0]);
        }
        String chatSessionId = chatParams.getSessionId();
        String chatTraceId = chatParams.getChatTraceId();
        if (StringUtils.isEmpty((String)chatSessionId)) {
            NewSessionParams newSessionParams = new NewSessionParams();
            newSessionParams.setAssistantId(10000L);
            newSessionParams.setCallbackUrl(chatParams.getCallbackUrl());
            newSessionParams.setCallBackInfo(chatParams.getCallbackInfo());
            Map<String, Object> newSessionResultMap = GaiCosmicAppService.newSession(newSessionParams);
            chatSessionId = (String)newSessionResultMap.get("sessionId");
        }
        if (StringUtils.isEmpty((String)chatTraceId)) {
            chatTraceId = RequestContext.get().getTraceId();
        }
        ChatParams.Message message = chatParams.getMessage();
        String callbackUrl = chatParams.getCallbackUrl();
        CallBackInfo callBackInfo = chatParams.getCallbackInfo();
        Context context = FlowCacheData.getContext(chatSessionId);
        if (StringUtils.isBlank((String)context.getChatSessionId())) {
            throw new KDBizException(new ErrorCode("-201", "session\u8fc7\u671f"), new Object[0]);
        }
        if (context.getUserId() != RequestContext.get().getCurrUserId()) {
            throw new KDBizException(Errors.ASSISTANT_USER_ERROR, new Object[0]);
        }
        Assistant assistantInContext = context.getAssistant();
        if (assistantInContext != null) {
            long userId = RequestContext.get().getCurrUserId();
            GaiCosmicAppService.checkAssistantForChat(assistantInContext.getId(), userId);
        }
        if (callBackInfo != null && StringUtils.isNotEmpty((String)JSON.toJSONString((Object)callBackInfo))) {
            context.setCallbackUrl(JSON.toJSONString((Object)callBackInfo));
        }
        if (StringUtils.isNotEmpty((String)callbackUrl)) {
            context.setCallbackUrl(callbackUrl);
        }
        context.setChatTraceId(chatTraceId);
        FlowCacheData.putContext(chatSessionId, context);
        log.info("chatTraceId:{} monitorTraceId:{}", (Object)context.getChatTraceId(), (Object)RequestContext.get().getTraceId());
        String input = message.getQuery();
        Skill.Type skillType = StringUtils.isEmpty((String)message.getSkillType()) ? null : Skill.Type.valueOf(message.getSkillType().toUpperCase());
        long l = skillId = StringUtils.isEmpty((String)message.getSkillId()) ? 0L : Long.parseLong(message.getSkillId());
        if (skillId == 0L) {
            skillId = SkillService.getIdByNumber(skillType, message.getSkillNumber());
        }
        if (skillId == 0L && context.getAssistant() != null && context.getAssistant().getPromptId() == 0L) {
            Assistant assistant = AssistantService.getOne(context.getAssistant().getId());
            assistant = assistant == null ? new Assistant() : assistant;
            context.setAssistant(assistant);
        }
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.setSkillId(skillId);
        chatMessage.setSkillType(skillType);
        chatMessage.setUserInput(input);
        chatMessage.setChatSessionId(chatSessionId);
        chatMessage.setInParaMap(chatParams.getMessage().getInputParams());
        Result result = HandlerFactory.runHandler(context, chatMessage);
        Map<Object, Object> resultMap = new HashMap<String, String>();
        if (result.getErrorCode().equals((Object)Errors.FAKE_OK)) {
            resultMap = ResultVoHelper.buildFakeErrMsg(Errors.LLM_ERROR.getCode(), result.getErrorCode().getMessage(), chatSessionId);
            PushMsgService.pushWaitingDone(context);
        }
        resultMap.put("traceId", chatTraceId);
        resultMap.put("traceProcessId", GaiCosmicAppService.getFlowTraceId(context, result));
        Map<String, String> data = result.getData();
        resultMap.put("runId", data != null ? data.getOrDefault("runId", "") : "");
        resultMap.put("chatSessionId", chatSessionId);
        return resultMap;
    }

    private static String getFlowTraceId(Context context, Result result) {
        String traceId = result.getTraceId();
        if (StringUtils.isEmpty((String)traceId)) {
            IAppCache appCache = EngineCache.getAppCache(context.getChatSessionId());
            traceId = (String)appCache.get(TraceUtil.flowTraceKey(context.getFlowId()), String.class);
        }
        return traceId;
    }

    public static String feedBack(FeedParams feedParams) {
        log.info("feedParams:{}", (Object)JSONObject.toJSONString((Object)feedParams));
        Context context = FlowCacheData.getContext(feedParams.getChatSessionId());
        if (context.getUserId() != RequestContext.get().getCurrUserId()) {
            throw new KDBizException(Errors.ASSISTANT_USER_ERROR, new Object[0]);
        }
        GaiCosmicAppService.checkAssistantPermission(feedParams.getAssistantId(), context.getUserId());
        IUserFeedbackService.create().reportUserFeedback(new UserFeedbackEventParams(context.getSlideenv(), feedParams));
        return "ok";
    }

    public static Map<String, Long> getUserInfoByPhone(String phone) {
        HashMap<String, Long> userOrg = new HashMap<String, Long>();
        if (!StringUtils.isEmpty((String)phone)) {
            String realPhone = new String(Base64.getDecoder().decode(phone));
            log.info("realPhone:{}", (Object)realPhone);
            QFilter filterUser = new QFilter("phone", "=", (Object)realPhone);
            QFilter[] filterUsers = new QFilter[]{filterUser};
            String selectFileds = "id,fuid,number,name,phone";
            Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFileds, (QFilter[])filterUsers);
            if (!CollectionUtils.isEmpty((Map)userMap)) {
                long userId = (Long)userMap.keySet().iterator().next();
                long orgId = UserServiceHelper.getUserMainOrgId((long)userId);
                userOrg.put("userId", userId);
                userOrg.put("orgId", orgId);
                log.info("userId{}orgId{}", (Object)userId, (Object)orgId);
            } else {
                DynamicObject useap = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)selectFileds, (QFilter[])filterUsers);
                if (useap != null) {
                    long userId = useap.getLong("id");
                    long orgId = UserServiceHelper.getUserMainOrgId((long)userId);
                    userOrg.put("userId", userId);
                    userOrg.put("orgId", orgId);
                    log.info("2userId{}orgId{}", (Object)userId, (Object)orgId);
                }
            }
        }
        return userOrg;
    }

    public static String stopChat(StopParams stopParams) {
        String chatSessionId = stopParams.getSessionId();
        String taskId = stopParams.getTaskId();
        Context context = FlowCacheData.getContext(chatSessionId);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)context.getChatSessionId())) {
            log.error("Context not found by chatSessionId:[{}]", (Object)chatSessionId);
            throw new KDBizException(Errors.NO_CONTEXT, new Object[0]);
        }
        if (context.getUserId() != RequestContext.get().getCurrUserId()) {
            throw new KDBizException(Errors.ASSISTANT_USER_ERROR, new Object[0]);
        }
        StopStreamMessage stopStreamMessage = new StopStreamMessage();
        stopStreamMessage.setTaskId(taskId);
        stopStreamMessage.setSseRequestTraceId(stopParams.getSseRequestTraceId());
        log.info("stopStreamMessage:{}", (Object)JSONObject.toJSONString((Object)stopStreamMessage));
        HandlerFactory.runHandler(context, stopStreamMessage);
        return "ok";
    }
}

