/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Operation;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.enuz.OperationType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OperationService {
    private static final String ENTITY_OPERATION = "gai_operation";
    private static final String KEY_ID = "id";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_SERVICENAME = "servicename";
    private static final String KEY_APP = "app";
    private static final String KEY_APPID = "appid";
    private static final String KEY_ACTION = "action";
    private static final String KEY_OPERATION = "operationtype";
    private static final String KEY_ISPRESET = "ispreset";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_IS_INPUT = "isinput";
    private static final String KEY_INPUT_VALUE = "input_value";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_DESC = "output_desc";

    public static List<Operation> getOperationList() {
        ArrayList<Operation> operationList = new ArrayList<Operation>(10);
        return operationList;
    }

    public static Operation getOperationById(long id) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)ENTITY_OPERATION);
        if (obj == null) {
            return null;
        }
        return OperationService.convertFromDynamicObject(obj);
    }

    public static Operation getOperationByAction(String action) {
        if (StringUtils.isBlank((CharSequence)action)) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_ACTION, "=", (Object)action), new QFilter(KEY_ISPRESET, "=", (Object)"1")};
        Map opMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_OPERATION), (QFilter[])qFilters);
        ArrayList<Operation> list = new ArrayList<Operation>(10);
        if (opMap != null && !opMap.isEmpty()) {
            for (Map.Entry entry : opMap.entrySet()) {
                list.add(OperationService.convertFromDynamicObject((DynamicObject)entry.getValue()));
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return (Operation)list.get(0);
    }

    private static Operation convertFromDynamicObject(DynamicObject obj) {
        DynamicObjectCollection outputs;
        if (obj == null) {
            return null;
        }
        DynamicObject app = (DynamicObject)obj.get(KEY_APP);
        String bizAppId = app == null ? "" : app.getString(KEY_ID);
        String type = obj.getString(KEY_OPERATION);
        String action = obj.getString(KEY_ACTION);
        String number = obj.getString(KEY_NUMBER);
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new KDException(String.format("\u64cd\u4f5c\uff1a%s\u7684\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u64cd\u4f5c", number));
        }
        OperationType operationType = OperationType.valueOf(Integer.parseInt(type));
        Operation operation = new Operation(obj.getLong(KEY_ID), obj.getString(KEY_NUMBER), bizAppId, obj.getString(KEY_APPID), obj.getString(KEY_SERVICENAME), operationType, obj.getBoolean(KEY_ISPRESET));
        operation.setAction(action);
        DynamicObjectCollection inputs = obj.getDynamicObjectCollection(KEY_ENTRYENTITY_INPUT);
        if (inputs != null) {
            ArrayList<Var> inputVarList = new ArrayList<Var>(10);
            for (DynamicObject input : inputs) {
                Var var = new Var(input.getString(KEY_INPUT_NAME), input.getString(KEY_INPUT_TYPE), input.getString(KEY_INPUT_DESC), input.getBoolean(KEY_IS_INPUT), input.getString(KEY_INPUT_VALUE));
                inputVarList.add(var);
            }
            operation.setInputVarList(inputVarList);
        }
        if ((outputs = obj.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTPUT)) != null) {
            ArrayList<Var> outputVarList = new ArrayList<Var>(10);
            for (DynamicObject output : outputs) {
                Var var = new Var(output.getString(KEY_OUTPUT_NAME), output.getString(KEY_OUTPUT_TYPE), output.getString(KEY_OUTPUT_DESC));
                outputVarList.add(var);
            }
            operation.setOutputVarList(outputVarList);
        }
        return operation;
    }
}

