/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.domain.vo.SuggestedAskData;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.process.ImportTypeEnum;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.util.DynamicObjectUtils;
import kd.ai.gai.core.util.GaiLicenseUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.core.util.OperationResultUtil;
import kd.ai.gai.core.util.PinyinUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.list.query.QueryFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ProcessService {
    private static final Log log = LogFactory.getLog(ProcessService.class);
    private static final String ENTITY_PROCESS = "gai_process";
    private static final String ENTITY_OPERATION = "gai_operation";
    private static final String ID = "id";
    private static final String APP_ID = "app";
    private static final String PROCESS_NUMBER = "number";
    private static final String PROCESS_USE_ORG = "useorg";
    private static final String PROCESS_NAME = "name";
    private static final String PROCESS_DES = "desc";
    private static final String PROCESS_FLOW = "flow";
    private static final String PROCESS_BLGS = "blgids";
    private static final String PROCESS_GROUP = "group";
    private static final String PROCESS_SERVICE_DES = "serviceDesc";
    private static final String PROCESS_SERVICE_DES2 = "servicedesc";
    private static final String PROCESS_CONFIG = "process_configs";
    private static final String CONFIG_NODEID = "process_nodeid";
    private static final String CONFIG_NAME = "process_name";
    private static final String CONFIG_TYPE = "process_type";
    private static final String CONFIG_DESC = "process_desc";
    private static final String KEY_APP = "app";
    private static final String KEY_OPERATION = "operationtype";
    private static final String APP_GAI = "gai";

    public static List<Process> getProcessList() {
        ArrayList<Process> processList = new ArrayList<Process>(10);
        Map processMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_PROCESS, null);
        if (processMap != null) {
            for (Map.Entry entry : processMap.entrySet()) {
                processList.add(ProcessService.convertFromDynamicObject((DynamicObject)entry.getValue()));
            }
        }
        return processList;
    }

    public static List<Skill> getProcessListData() {
        return ProcessService.getProcessListData(false, null);
    }

    public static List<Skill> getProcessListData(boolean isPublish, List<String> blgs) {
        DynamicObject[] objs;
        ArrayList<Skill> processListData = new ArrayList<Skill>(10);
        QFilter[] qFilters = null;
        if (isPublish) {
            qFilters = new QFilter[]{new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr())};
        }
        if ((objs = BusinessDataServiceHelper.load((String)ENTITY_PROCESS, (String)"id,name,number,desc,servicedesc,modifytime,blgids ", qFilters, (String)"modifytime desc")) != null) {
            for (DynamicObject obj : objs) {
                String[] blgidArr;
                String blgids = obj.getString(PROCESS_BLGS);
                if (StringUtils.isEmpty((CharSequence)blgids)) {
                    blgids = "606";
                }
                for (String item : blgidArr = blgids.split(",")) {
                    if (blgs != null && !blgs.contains(item)) continue;
                    processListData.add(new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null));
                }
            }
        }
        return processListData;
    }

    public static List<Skill> getProcessListDataByAppid(String appId, List<String> blgs) {
        DynamicObject app;
        log.info("\u83b7\u53d6\u6d41\u7a0b\u5217\u8868:AppNumber:{},\u7528\u6237\u6743\u9650{}", (Object)appId, blgs);
        ArrayList<Skill> processListData = new ArrayList<Skill>(10);
        if (blgs == null) {
            return processListData;
        }
        if (StringUtils.isNotBlank((CharSequence)appId) && (app = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)ID, (QFilter[])new QFilter[]{new QFilter(PROCESS_NUMBER, "=", (Object)appId)})) != null) {
            String id = app.getString(ID);
            QFilter filter = new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr());
            QFilter[] qFilters = new QFilter[]{filter.and("app.fbasedataid", "=", (Object)id)};
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)ENTITY_PROCESS, (String)"id,name,number,desc,servicedesc,entryentity_suggestedask.seq,entryentity_suggestedask.question,entryentity_suggestedask.fileids,modifytime,blgids ", (QFilter[])qFilters, (String)"modifytime desc");
            if (objs != null) {
                for (DynamicObject obj : objs) {
                    String[] blgidArr;
                    String blgids = obj.getString(PROCESS_BLGS);
                    if (StringUtils.isEmpty((CharSequence)blgids)) {
                        blgids = "606";
                    }
                    for (String item : blgidArr = blgids.split(",")) {
                        if (!blgs.contains(item)) continue;
                        Skill skill = new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null);
                        DynamicObjectCollection suggestedAskDataObjs = obj.getDynamicObjectCollection("entryentity_suggestedask");
                        ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>(suggestedAskDataObjs.size());
                        for (DynamicObject dObjSuggestedAskData : suggestedAskDataObjs) {
                            SuggestedAskData askData = new SuggestedAskData(dObjSuggestedAskData.getPkValue().toString(), dObjSuggestedAskData.getString("question"), dObjSuggestedAskData.getString("fileids"));
                            suggestedAskDataList.add(askData);
                        }
                        skill.setSuggestedAsks(suggestedAskDataList);
                        processListData.add(skill);
                    }
                }
            }
        }
        StringBuilder sqlBuild = new StringBuilder();
        sqlBuild.append("SELECT A.fid, A.fname,  A.fnumber, A.fdesc,A.fservicedesc,A.fmodifytime,A.fblgids ");
        sqlBuild.append("FROM t_gai_process A ");
        sqlBuild.append("LEFT JOIN t_gai_process_app B ON A.fid = B.fid ");
        sqlBuild.append("WHERE A.fpublish='1' and B.fid IS NULL ");
        sqlBuild.append("order by A.fmodifytime desc ");
        DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)sqlBuild.toString(), (Object[])new Object[0], resultSet -> {
            block0: while (resultSet.next()) {
                String[] blgidArr;
                String blgids = resultSet.getString("fblgids");
                if (StringUtils.isEmpty((CharSequence)blgids)) {
                    blgids = "606";
                }
                for (String item : blgidArr = blgids.split(",")) {
                    if (!blgs.contains(item)) continue;
                    processListData.add(new Skill(resultSet.getLong("fid") + "", resultSet.getString("fnumber"), resultSet.getString("fname"), resultSet.getString("fdesc"), resultSet.getString("fservicedesc"), null));
                    continue block0;
                }
            }
            return null;
        });
        processListData.sort(Comparator.comparing(o -> PinyinUtils.getPinYin(o.getName()).toLowerCase()));
        log.info(String.format("\u83b7\u53d6\u6d41\u7a0b\u5217\u8868:AppNumber:%s,\u7528\u6237\u6743\u9650 %s,\u6280\u80fd\u6e05\u5355\uff1a%s", appId, blgs, JSON.toJSONString(processListData)));
        return processListData;
    }

    public static Process getProcessById(long id) {
        try {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_PROCESS);
            if (obj == null) {
                return null;
            }
            return ProcessService.convertFromDynamicObject(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Skill> getProcessByIds(List<Long> ids) {
        DynamicObject[] objs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])ids.toArray(), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)ENTITY_PROCESS).getDataEntityType());
        if (objs == null) {
            return null;
        }
        ArrayList<Skill> processListData = new ArrayList<Skill>();
        for (DynamicObject obj : objs) {
            String blgids = obj.getString(PROCESS_BLGS);
            if (StringUtils.isEmpty((CharSequence)blgids)) {
                blgids = "606";
            }
            Skill skill = new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null);
            skill.setType(Skill.Type.PROCESS);
            DynamicObjectCollection suggestedAskDataObjs = obj.getDynamicObjectCollection("entryentity_suggestedask");
            ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>(suggestedAskDataObjs.size());
            for (DynamicObject dObjSuggestedAskData : suggestedAskDataObjs) {
                SuggestedAskData askData = new SuggestedAskData(dObjSuggestedAskData.getPkValue().toString(), dObjSuggestedAskData.getString("question"), dObjSuggestedAskData.getString("fileids"));
                suggestedAskDataList.add(askData);
            }
            skill.setSuggestedAsks(suggestedAskDataList);
            processListData.add(skill);
        }
        return processListData;
    }

    public static Skill getProcessByIdAndOther(long id, String appNumber, List<String> blgs) {
        DynamicObject obj;
        Skill skill = null;
        long userId = RequestContext.get().getCurrUserId();
        if (blgs == null) {
            blgs = GaiLicenseUtils.getUserBLG(userId);
        }
        try {
            obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_PROCESS);
        }
        catch (Exception e) {
            return null;
        }
        if (obj == null) {
            return null;
        }
        if (!obj.getString("enable").equals(EnableEnum.YES.getKeyStr())) {
            return null;
        }
        ArrayList<String> appNumberListInDb = new ArrayList<String>();
        MulBasedataDynamicObjectCollection appObject = (MulBasedataDynamicObjectCollection)obj.get("app");
        if (!appObject.isEmpty()) {
            for (DynamicObject dynamicObject : appObject) {
                if (dynamicObject == null || dynamicObject.get(1) == null) continue;
                String appNumberInDb = ((DynamicObject)dynamicObject.get(1)).getString(PROCESS_NUMBER);
                appNumberListInDb.add(appNumberInDb);
            }
        }
        if (appNumber != null && !appNumberListInDb.isEmpty() && !appNumberListInDb.contains(appNumber)) {
            return null;
        }
        String blgids = obj.getString(PROCESS_BLGS);
        if (StringUtils.isEmpty((CharSequence)blgids)) {
            blgids = "606";
        }
        String[] blgidArr = blgids.split(",");
        String version = LicenseServiceHelper.getProductVersion();
        for (String item : blgidArr) {
            if (!GaiUtils.canShowSkill(version, userId, blgs, item)) continue;
            skill = new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null);
            DynamicObjectCollection suggestedAskDataObjs = obj.getDynamicObjectCollection("entryentity_suggestedask");
            ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>(suggestedAskDataObjs.size());
            for (DynamicObject dObjSuggestedAskData : suggestedAskDataObjs) {
                SuggestedAskData askData = new SuggestedAskData(dObjSuggestedAskData.getPkValue().toString(), dObjSuggestedAskData.getString("question"), dObjSuggestedAskData.getString("fileids"));
                suggestedAskDataList.add(askData);
            }
            skill.setSuggestedAsks(suggestedAskDataList);
        }
        return skill;
    }

    public static List<Skill> getProcessByIdsAndOther(Collection<Long> ids, boolean checkBlg) {
        return ProcessService.getProcessByIdsAndOther(ids, null, null, checkBlg);
    }

    public static List<Skill> getProcessByIdsAndOther(Collection<Long> ids, String appNumber, List<String> blgs, boolean checkBlg) {
        DynamicObject[] doArr;
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<Object> skillList = Lists.newArrayListWithExpectedSize((int)ids.size());
        try {
            String selectFields = "id,app,number,name,desc,servicedesc,blgids,entryentity_suggestedask,question,fileids";
            QFilter filter = new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr()).and(ID, "in", ids);
            Map dyos = BusinessDataServiceHelper.loadFromCache((String)GaiFormIdEnum.GAI_PROCESS.getId(), (String)selectFields, (QFilter[])filter.toArray());
            doArr = dyos.values().toArray(new DynamicObject[0]);
        }
        catch (Exception e) {
            return skillList;
        }
        if (doArr == null || doArr.length == 0) {
            return skillList;
        }
        ArrayList skillDos = Lists.newArrayListWithExpectedSize((int)doArr.length);
        if (StringUtils.isNotBlank((CharSequence)appNumber)) {
            for (DynamicObject skillDo : doArr) {
                ArrayList<String> appNumberListInDb = new ArrayList<String>();
                MulBasedataDynamicObjectCollection appObject = (MulBasedataDynamicObjectCollection)skillDo.get("app");
                if (!appObject.isEmpty()) {
                    for (DynamicObject dynamicObject : appObject) {
                        if (dynamicObject == null || dynamicObject.get(1) == null) continue;
                        String appNumberInDb = ((DynamicObject)dynamicObject.get(1)).getString(PROCESS_NUMBER);
                        appNumberListInDb.add(appNumberInDb);
                    }
                }
                if (!appNumberListInDb.isEmpty() && !appNumberListInDb.contains(appNumber)) continue;
                skillDos.add(skillDo);
            }
        } else {
            skillDos.addAll(Arrays.asList(doArr));
        }
        for (DynamicObject skillDo : skillDos) {
            skillList.add(ProcessService.doToSkill(skillDo));
        }
        if (checkBlg) {
            skillList = ProcessService.getSkillListByCheckLic(skillList);
        }
        return skillList;
    }

    private static List<Skill> getSkillListByCheckLic(List<Skill> processDataList) {
        Set<Long> processIdList = processDataList.stream().filter(skill -> skill.getType() == Skill.Type.PROCESS).map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet());
        Set<Long> agentIdList = processDataList.stream().filter(skill -> skill.getType() == Skill.Type.AGENT).map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet());
        Set<Long> usedSkillIdList = GPTLicenseHelper.getUseBizIds(GaiFormIdEnum.GAI_AGENT.getId(), agentIdList);
        usedSkillIdList.addAll(GPTLicenseHelper.getUseBizIds(GaiFormIdEnum.GAI_PROCESS.getId(), processIdList));
        log.info("usedSkillIdList: {}", (Object)usedSkillIdList.toString());
        processDataList = processDataList.stream().filter(skill -> usedSkillIdList.contains(Long.valueOf(skill.getId()))).collect(Collectors.toList());
        return processDataList;
    }

    public static Skill doToSkill(DynamicObject obj) {
        Skill skill = new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null);
        DynamicObjectCollection suggestedAskDataObjs = obj.getDynamicObjectCollection("entryentity_suggestedask");
        ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>(suggestedAskDataObjs.size());
        for (DynamicObject dObjSuggestedAskData : suggestedAskDataObjs) {
            SuggestedAskData askData = new SuggestedAskData(dObjSuggestedAskData.getPkValue().toString(), dObjSuggestedAskData.getString("question"), dObjSuggestedAskData.getString("fileids"));
            suggestedAskDataList.add(askData);
        }
        skill.setSuggestedAsks(suggestedAskDataList);
        return skill;
    }

    public static Process getProcessByNumber(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter(PROCESS_NUMBER, "=", (Object)number)};
        Map objs = BusinessDataServiceHelper.loadFromCache((String)ENTITY_PROCESS, (String)"id,number,name,desc,servicedesc,flow,useorg,blgids", (QFilter[])filters);
        if (objs == null || objs.isEmpty()) {
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)objs.entrySet().iterator().next().getValue();
        return ProcessService.convertFromDynamicObject(dynamicObject);
    }

    public static String getAppIdByProcess(long processId) {
        DynamicObject app;
        Long opId;
        DynamicObject op;
        String type;
        String flowStr;
        String appId = "";
        Process process = ProcessService.getProcessById(processId);
        String string = flowStr = process == null ? "" : process.getFlow();
        if (StringUtils.isBlank((CharSequence)flowStr)) {
            return appId;
        }
        Flow flow = JsonUtil.fromBase64String(flowStr);
        List<Action> actionList = flow.actionList();
        if (actionList == null || actionList.isEmpty()) {
            return appId;
        }
        ArrayList<Long> operationIds = new ArrayList<Long>(10);
        for (Action action : actionList) {
            if (!(action instanceof JavaPluginAction) || ((JavaPluginAction)action).getActionId() == 0L) continue;
            operationIds.add(((JavaPluginAction)action).getActionId());
        }
        if (operationIds.isEmpty()) {
            return appId;
        }
        Map opMap = BusinessDataServiceHelper.loadFromCache((Object[])operationIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_OPERATION));
        Iterator iterator = operationIds.iterator();
        while (iterator.hasNext() && (!"0".equals(type = (op = (DynamicObject)opMap.get(opId = (Long)iterator.next())).getString(KEY_OPERATION)) || APP_GAI.equals(appId = (app = op.getDynamicObject("app")).getString(PROCESS_NUMBER)))) {
        }
        return appId;
    }

    private static Process convertFromDynamicObject(DynamicObject obj) {
        if (obj == null) {
            return null;
        }
        DynamicObject org = (DynamicObject)obj.get(PROCESS_USE_ORG);
        long useorg = org == null ? 0L : org.getLong(ID);
        return new Process(obj.getLong(ID), obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), useorg, obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES), obj.getString(PROCESS_FLOW), obj.getString(PROCESS_BLGS));
    }

    private static List<Long> getProcessGroupIdArr(Long[] groupIds, boolean includeChild) {
        DynamicObject[] dObjParentGroups = BusinessDataServiceHelper.load((Object[])groupIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ENTITY_PROCESS));
        ArrayList<Long> idArrays = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : dObjParentGroups) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ENTITY_PROCESS);
            String longNumber = dynamicObject.getString("longnumber");
            idArrays.add((Long)dynamicObject.getPkValue());
            if (!includeChild) continue;
            IQuery query = QueryFactory.createQuery();
            GroupProp groupProp = (GroupProp)entityType.getProperty(PROCESS_GROUP);
            List childIdsArrays = query.getChildsId(groupProp, longNumber);
            for (String childGroupId : childIdsArrays) {
                long id = Long.parseLong(childGroupId);
                idArrays.add(id);
            }
        }
        return idArrays;
    }

    public static List<Skill> getProcessListDataByGroupIds(Long[] groupIds) {
        ArrayList<Skill> processListData = new ArrayList<Skill>(10);
        QFilter[] qFilters = null;
        qFilters = new QFilter[]{new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr()), new QFilter(PROCESS_GROUP, "in", (Object)groupIds)};
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)ENTITY_PROCESS, (String)"id,group,name,number,desc,servicedesc,modifytime,blgids,entryentity_suggestedask.seq,entryentity_suggestedask.question,entryentity_suggestedask.fileids", (QFilter[])qFilters, (String)"modifytime desc, entryentity_suggestedask.seq asc");
        if (objs != null) {
            for (DynamicObject obj : objs) {
                Skill processData = new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null);
                DynamicObjectCollection suggestedAskDataObjs = obj.getDynamicObjectCollection("entryentity_suggestedask");
                ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>(suggestedAskDataObjs.size());
                for (DynamicObject dObjSuggestedAskData : suggestedAskDataObjs) {
                    SuggestedAskData askData = new SuggestedAskData(dObjSuggestedAskData.getPkValue().toString(), dObjSuggestedAskData.getString("question"), dObjSuggestedAskData.getString("fileids"));
                    suggestedAskDataList.add(askData);
                }
                processData.setSuggestedAsks(suggestedAskDataList);
                processListData.add(processData);
            }
        }
        return processListData;
    }

    public static void deleteProcessRefOperation(Object[] processIdArr) {
        IDataEntityType dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_PROCESS.getId()).getDataEntityType();
        DynamicObject[] processDoArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])processIdArr, (IDataEntityType)dataEntityType);
        if (processDoArr != null) {
            for (DynamicObject processDo : processDoArr) {
                String fflow;
                Flow flow;
                List<Action> actionList;
                if (processDo.getBoolean("enable") || (actionList = (flow = JsonUtil.fromBase64String(fflow = processDo.getString(PROCESS_FLOW))).getActions()) == null || actionList.isEmpty()) continue;
                List operationActionList = actionList.stream().filter(Node::isCusOptionNode).collect(Collectors.toList());
                ArrayList<Long> operationIdList = new ArrayList<Long>(5);
                for (int i = 0; i < operationActionList.size(); ++i) {
                    JavaPluginAction javaPluginAction = (JavaPluginAction)operationActionList.get(i);
                    operationIdList.add(javaPluginAction.getActionId());
                }
                if (!kd.bos.util.CollectionUtils.isNotEmpty(operationIdList)) continue;
                DeleteServiceHelper.delete((String)GaiFormIdEnum.GAI_OPERATION.getId(), (QFilter[])new QFilter(ID, "in", operationIdList).toArray());
            }
        }
    }

    public static JSONArray assemblyExportProcess(Object[] processIdArr) {
        RequestContext rc = RequestContext.get();
        DynamicObjectType processDynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_PROCESS.getId()).getDynamicObjectType();
        DynamicObject[] processDoArr = BusinessDataServiceHelper.load((Object[])processIdArr, (DynamicObjectType)processDynamicObjectType);
        JSONArray processJa = new JSONArray();
        for (DynamicObject processDo : processDoArr) {
            DynamicObject[] promptDoArr;
            JSONObject processJo = new JSONObject();
            String flowBase64 = processDo.getString(PROCESS_FLOW);
            Flow flow = JsonUtil.fromBase64String(flowBase64);
            List<Action> actionList = flow.getActions();
            ArrayList javaPluginActionIdLsit = new ArrayList();
            ArrayList llmPromptIdLsit = new ArrayList();
            actionList.forEach(action -> {
                String type = action.getType();
                ProcessNodeType processNodeType = ProcessNodeType.valueOf(Integer.parseInt(type));
                if (processNodeType == ProcessNodeType.CusOption) {
                    JavaPluginAction javaPluginAction = (JavaPluginAction)action;
                    long actionId = javaPluginAction.getActionId();
                    javaPluginActionIdLsit.add(actionId);
                } else if (processNodeType == ProcessNodeType.Llm) {
                    LLMAction llmAction = (LLMAction)action;
                    long llmPromptId = llmAction.getLlmPromptId();
                    llmPromptIdLsit.add(llmPromptId);
                }
            });
            processJo.put("process", (Object)DynamicObjectUtils.dynamicObject2Json(processDo, processDynamicObjectType));
            DynamicObject[] operationDoArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])javaPluginActionIdLsit.toArray(), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_OPERATION.getId()).getDataEntityType());
            if (operationDoArr != null) {
                JSONArray operationJa = new JSONArray();
                DynamicObjectType operationDynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_OPERATION.getId()).getDynamicObjectType();
                for (DynamicObject operationDo : operationDoArr) {
                    operationJa.add((Object)DynamicObjectUtils.dynamicObject2Json(operationDo, operationDynamicObjectType));
                }
                processJo.put("operationJa", (Object)operationJa);
            }
            if ((promptDoArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])llmPromptIdLsit.toArray(), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_PROMPT.getId()).getDataEntityType())) != null) {
                JSONArray promptJa = new JSONArray();
                DynamicObjectType promptDynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_PROMPT.getId()).getDynamicObjectType();
                for (DynamicObject promptDo : promptDoArr) {
                    promptJa.add((Object)DynamicObjectUtils.dynamicObject2Json(promptDo, promptDynamicObjectType));
                }
                processJo.put("promptJa", (Object)promptJa);
            }
            processJo.put("user", (Object)String.format("%s(%s)", rc.getUserName(), rc.getCurrUserId()));
            processJo.put("clientUrl", (Object)rc.getClientFullContextPath());
            processJo.put("processId", processDo.getPkValue());
            processJo.put("processName", (Object)processDo.getString(PROCESS_NAME));
            processJa.add((Object)processJo);
        }
        return processJa;
    }

    public static void importOperation(String importType, JSONArray operationJa) {
        String ids = "";
        for (Object obj : operationJa) {
            DynamicObject newOperationDo = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_OPERATION.getId());
            DynamicObject operationDo = DynamicObjectUtils.json2DynamicObject((String)obj, newOperationDo.getDynamicObjectType());
            DynamicObjectUtils.copyDynamicObject(operationDo, newOperationDo, 2, false, false, false);
            boolean increment = StringUtils.equalsIgnoreCase((CharSequence)importType, (CharSequence)ImportTypeEnum.INCREMENT.getId());
            if (!increment) {
                DeleteServiceHelper.delete((IDataEntityType)newOperationDo.getDataEntityType(), (Object[])new Object[]{newOperationDo.getPkValue()});
            }
            if (!QueryServiceHelper.exists((String)GaiFormIdEnum.GAI_OPERATION.getId(), (Object)newOperationDo.getPkValue())) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newOperationDo});
                ProcessService.resetCreateInfo(newOperationDo, true, false);
                ids = StringUtils.isNotEmpty((CharSequence)ids) ? String.format("%s,%s", ids, newOperationDo.getPkValue()) : newOperationDo.getPkValue() + "";
                continue;
            }
            log.warn("\u5bfc\u5165\u65b9\u5f0f:{}, \u81ea\u5b9a\u4e49\u64cd\u4f5c\uff1a{}({})\u5df2\u5b58\u5728\uff0c\u5ffd\u7565\u672c\u6b21\u5bfc\u5165", new Object[]{importType, newOperationDo.getString(PROCESS_NAME), newOperationDo.getString(PROCESS_NUMBER)});
        }
        log.info("\u6210\u529f\u5bfc\u5165\u81ea\u5b9a\u4e49\u64cd\u4f5c\uff1a{}", (Object)ids);
    }

    public static Map<String, Integer> importProcessWithResult(String content, String importType, boolean increment) {
        return ProcessService.importProcessWithResult(content, importType, increment, 0L);
    }

    public static Map<String, Integer> importProcessWithResult(String content, String importType, boolean increment, long createOrgId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        int successCount = 0;
        int ingoreCount = 0;
        JSONArray resultJa = JSON.parseArray((String)content);
        for (Object processObj : resultJa) {
            JSONObject processJo = (JSONObject)processObj;
            String process = processJo.getString("process");
            JSONArray promptJa = JSON.parseArray((String)processJo.getString("promptJa"));
            JSONArray operationJa = JSON.parseArray((String)processJo.getString("operationJa"));
            DynamicObject newProcessDo = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_PROCESS.getId());
            DynamicObject processDo = DynamicObjectUtils.json2DynamicObject(process, newProcessDo.getDynamicObjectType());
            newProcessDo = DynamicObjectUtils.deepCopy(processDo, true, false);
            if (increment) {
                ProcessService.resetBasicInfo(newProcessDo);
                ProcessService.resetCreateOrg(newProcessDo, createOrgId);
                if (!QueryServiceHelper.exists((String)GaiFormIdEnum.GAI_PROCESS.getId(), (Object)newProcessDo.getPkValue())) {
                    ProcessService.importProcess(importType, newProcessDo, operationJa);
                    ++successCount;
                } else {
                    ++ingoreCount;
                    log.warn("\u5bfc\u5165\u65b9\u5f0f:{}, \u4efb\u52a1\u6d41\uff1a{}({})\u5df2\u5b58\u5728\uff0c\u5ffd\u7565\u672c\u6b21\u5bfc\u5165", new Object[]{importType, newProcessDo.getString(PROCESS_NAME), newProcessDo.getString(PROCESS_NUMBER)});
                }
            } else {
                log.warn("\u5bfc\u5165\u65b9\u5f0f:{}, \u4efb\u52a1\u6d41\uff1a{}({})", new Object[]{importType, newProcessDo.getString(PROCESS_NAME), newProcessDo.getString(PROCESS_NUMBER)});
                DeleteServiceHelper.delete((IDataEntityType)newProcessDo.getDataEntityType(), (Object[])new Object[]{newProcessDo.getPkValue()});
                ProcessService.resetBasicInfo(newProcessDo);
                ProcessService.resetCreateOrg(newProcessDo, createOrgId);
                ProcessService.importProcess(importType, newProcessDo, operationJa);
                ++successCount;
            }
            String ids = "";
            for (Object obj : promptJa) {
                DynamicObject newPromptDo = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_PROMPT.getId());
                DynamicObject promptDo = DynamicObjectUtils.json2DynamicObject((String)obj, newPromptDo.getDynamicObjectType());
                newPromptDo = DynamicObjectUtils.deepCopy(promptDo, true, false);
                if (!increment) {
                    DeleteServiceHelper.delete((IDataEntityType)newPromptDo.getDataEntityType(), (Object[])new Object[]{newPromptDo.getPkValue()});
                }
                if (!QueryServiceHelper.exists((String)GaiFormIdEnum.GAI_PROMPT.getId(), (Object)newPromptDo.getPkValue())) {
                    newPromptDo.set("prompt_repo_config", (Object)new DynamicObjectCollection());
                    ProcessService.resetBasicInfo(newPromptDo);
                    ProcessService.resetCreateOrg(newPromptDo, createOrgId);
                    ProcessService.importPrompt(newPromptDo);
                    ids = StringUtils.isNotEmpty((CharSequence)ids) ? String.format("%s,%s", ids, newPromptDo.getPkValue()) : newPromptDo.getPkValue() + "";
                    continue;
                }
                log.warn("\u63d0\u793a\u8bcd\uff1a{}({})\u5df2\u5b58\u5728\uff0c\u5ffd\u7565\u672c\u6b21\u5bfc\u5165", (Object)newPromptDo.getString(PROCESS_NAME), (Object)newPromptDo.getString(PROCESS_NUMBER));
            }
            log.info("\u6210\u529f\u5bfc\u5165Prompt\uff1a{}", (Object)ids);
        }
        map.put("successCount", successCount);
        map.put("ingoreCount", ingoreCount);
        return map;
    }

    private static void resetCreateOrg(DynamicObject newProcessDo, long createOrgId) {
        if (createOrgId <= 0L) {
            createOrgId = RequestContext.get().getOrgId();
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)createOrgId, (String)"bos_org", (String)String.format("%s,%s,%s", ID, PROCESS_NAME, PROCESS_NUMBER));
        newProcessDo.set("org", (Object)org);
        newProcessDo.set("createorg", (Object)org);
        newProcessDo.set(PROCESS_USE_ORG, (Object)org);
    }

    private static void resetBasicInfo(DynamicObject newProcessDo) {
        RequestContext rc = RequestContext.get();
        newProcessDo.set("creator", (Object)rc.getCurrUserId());
        newProcessDo.set("modifier", (Object)rc.getCurrUserId());
        newProcessDo.set("createtime", (Object)KDDateUtils.now());
        newProcessDo.set("modifytime", (Object)KDDateUtils.now());
    }

    private static void importProcess(String importType, DynamicObject newProcessDo, JSONArray operationJa) {
        OperationResult opResult = SaveServiceHelper.saveOperate((String)ENTITY_PROCESS, (DynamicObject[])new DynamicObject[]{newProcessDo}, (OperateOption)OperateOption.create());
        if (!opResult.isSuccess()) {
            throw new KDBizException(OperationResultUtil.getOperationResultMessage(opResult));
        }
        ProcessService.importOperation(importType, operationJa);
    }

    private static void fixBdU(String tableName, long bdId, long orgId) {
        DB.execute((DBRoute)DBRoute.of((String)"aidb"), (String)("delete from " + tableName + " where fdataid = ?"), (Object[])new Object[]{bdId});
        boolean flag = DB.execute((DBRoute)DBRoute.of((String)"aidb"), (String)("insert into " + tableName + "(fdataid, fcreateorgid, fuseorgid) values(?,?,?)"), (Object[])new Object[]{bdId, orgId, orgId});
        log.info("fixBdU {} : {}", (Object)tableName, (Object)flag);
    }

    public static void importPrompt(DynamicObject newPromptDo) {
        OperationResult opResult = SaveServiceHelper.saveOperate((String)"gai_prompt", (DynamicObject[])new DynamicObject[]{newPromptDo}, (OperateOption)OperateOption.create());
        if (!opResult.isSuccess()) {
            throw new KDBizException(OperationResultUtil.getOperationResultMessage(opResult));
        }
    }

    private static void fillMultiLangName(DynamicObject dynamicObject) {
        String multiLangTableName = String.format("%s_l", dynamicObject.getDataEntityType().getAlias());
        DB.execute((DBRoute)DBRoute.of((String)"aidb"), (String)String.format("delete from %s where fid = ?", multiLangTableName), (Object[])new Object[]{dynamicObject.getPkValue()});
        DB.execute((DBRoute)DBRoute.of((String)"aidb"), (String)String.format("insert into %s(fpkid, fid, flocaleid, fname) values(?,?,?,?)", multiLangTableName), (Object[])new Object[]{kd.bos.id.ID.genStringId(), dynamicObject.getPkValue(), "zh_CN", dynamicObject.getString(PROCESS_NAME)});
    }

    public static void resetCreateInfo(DynamicObject dynamicObject, boolean resetUser, boolean resetOrg) {
        RequestContext rc = RequestContext.get();
        DynamicObject updateDo = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (DynamicObjectType)dynamicObject.getDynamicObjectType());
        updateDo.set(PROCESS_NAME, (Object)dynamicObject.getLocaleString(PROCESS_NAME));
        if (resetUser) {
            updateDo.set("creator", (Object)rc.getCurrUserId());
            updateDo.set("modifier", (Object)rc.getCurrUserId());
        }
        if (resetOrg) {
            updateDo.set("org", (Object)rc.getOrgId());
            updateDo.set("createorg", (Object)rc.getOrgId());
            updateDo.set(PROCESS_USE_ORG, (Object)rc.getOrgId());
        }
        updateDo.set("createtime", (Object)KDDateUtils.now());
        updateDo.set("modifytime", (Object)KDDateUtils.now());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{updateDo});
    }
}

