/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.PromptInVar;
import kd.ai.gai.core.domain.dto.PromptOutVar;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.PROMPT_SCOPE;
import kd.ai.gai.core.service.AiccService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PromptService {
    public static final String ID = "id";
    public static final String PROMPT_NUMBER = "number";
    public static final String PROMPT_USE_ORG = "useorg";
    public static final String PROMPT_NAME = "name";
    public static final String PROMPT_DES = "desc";
    public static final String PROMPT_LLM_STYLE = "model_style";
    public static final String PROMPT_PROMPT_TEM = "prompt_tag";
    public static final String PROMPT_VARIABLE = "var_configs";
    public static final String PROMPT_LLM = "language_model";
    public static final String OUT_VAR = "out_var_configs";
    public static final String REMEMBER_COUNT = "remembercount";
    private static final String QUERY_4_LIST_FIELDS = "name,number,desc," + PROMPT_SCOPE.ALL.getValue() + "," + PROMPT_SCOPE.BIZ.getValue() + "," + PROMPT_SCOPE.DEV.getValue() + "," + "model_style";
    private static final String QUERY_4_ITEM = "number,useorg,language_model," + PROMPT_SCOPE.ALL.getValue() + "," + PROMPT_SCOPE.BIZ.getValue() + "," + PROMPT_SCOPE.DEV.getValue() + "," + "prompt_tag" + "," + "var_configs" + "," + "model_style" + "," + "out_var_configs";

    public static Prompt getById(long id) {
        LLM llm;
        DynamicObject promptInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"gai_prompt");
        if (Objects.isNull(promptInfo)) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.PRAMPT_NO_EXIET_ERROR), new Object[0]);
        }
        BigDecimal rememberCount = promptInfo.getBigDecimal(REMEMBER_COUNT);
        DynamicObjectCollection repos = promptInfo.getDynamicObjectCollection("prompt_repo_config");
        ArrayList<Long> repoIds = new ArrayList<Long>(repos.size());
        for (DynamicObject repoRow : repos) {
            DynamicObject repo = repoRow.getDynamicObject("repoid");
            repoIds.add((Long)repo.getPkValue());
        }
        Prompt prompt = new Prompt();
        prompt.setReference(null);
        prompt.setId(id);
        prompt.setNumber(promptInfo.getString(PROMPT_NUMBER));
        prompt.setPrompt(promptInfo.getString(PROMPT_PROMPT_TEM));
        String serviceNumber = promptInfo.getString(PROMPT_LLM);
        prompt.setServiceNumber(serviceNumber);
        Map<String, Object> service = AiccService.queryLlmAiccService(serviceNumber);
        if (service == null || service.isEmpty()) {
            throw new KDBizException("\u63d0\u793a\u5bf9\u5e94\u7684\u6a21\u578b\u670d\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u3010Agent\u5e73\u53f0\u3011-\u3010\u914d\u7f6e\u4e2d\u5fc3\u3011-\u3010\u6a21\u578b\u670d\u52a1\u3011\u786e\u8ba4\u3002serviceNumber: " + serviceNumber);
        }
        String llmNumber = (String)service.get("llm");
        if (StringUtils.isEmpty((CharSequence)llmNumber)) {
            llmNumber = serviceNumber;
        }
        if ((llm = LLM.parse(llmNumber)) == null) {
            throw new KDBizException("\u6a21\u578b\u670d\u52a1\u6ca1\u6709\u5173\u8054\u6a21\u578b\u6216\u662f\u6682\u65f6\u4e0d\u652f\u6301\u7684\u5927\u6a21\u578b\u7c7b\u578b,\u6a21\u578b\u670d\u52a1\uff1a" + serviceNumber);
        }
        prompt.setLlm(llm);
        prompt.setRemembercount(rememberCount.intValue());
        prompt.setRepoIds(repoIds);
        DynamicObjectCollection inputFieldList = promptInfo.getDynamicObjectCollection(PROMPT_VARIABLE);
        ArrayList<PromptInVar> promptInVarList = new ArrayList<PromptInVar>(10);
        for (DynamicObject inputField : inputFieldList) {
            String var = inputField.getString("var");
            String name = inputField.getString("var_name");
            String type = inputField.getString("var_type");
            PromptInVar promptInVar = new PromptInVar(var, name, type);
            promptInVarList.add(promptInVar);
        }
        prompt.setPromptInVarList(promptInVarList);
        DynamicObjectCollection outFieldList = promptInfo.getDynamicObjectCollection(OUT_VAR);
        ArrayList<PromptOutVar> promptOutVarList = new ArrayList<PromptOutVar>();
        for (DynamicObject outField : outFieldList) {
            String var = outField.getString("out_var");
            String name = outField.getString("out_var_name");
            String type = outField.getString("out_var_type");
            PromptOutVar promptOutVar = new PromptOutVar(var, name, type, outField.getBoolean("out_json_analysis"));
            promptOutVarList.add(promptOutVar);
        }
        prompt.setPromptOutVarList(promptOutVarList);
        String modelStyle = promptInfo.getString(PROMPT_LLM_STYLE);
        LlmStyle llmStyle = LlmStyle.parse(modelStyle);
        prompt.setLlmStyle(llmStyle);
        prompt.setCreateTime(promptInfo.getDate("createtime"));
        return prompt;
    }
}

