/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.CallBackInfo;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.agent.MessageConfig;
import kd.ai.gai.core.domain.llm.LLMSearchInfo;
import kd.ai.gai.core.domain.vo.ActionVO;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.enuz.ForwardType;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.sse.cache.SSEIteratorCache;
import kd.ai.gai.core.sse.iterator.AbstractSSEIterator;
import kd.ai.gai.core.sse.iterator.ChatIterator;
import kd.ai.gai.core.trace.util.ThreadUtils;
import kd.ai.gai.core.util.HttpUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class PushMsgService {
    private static final Log log = LogFactory.getLog(PushMsgService.class);

    private PushMsgService() {
    }

    public static void doPush(Context context, Map<String, Object> resultVoMap) {
        SLIDEENV slideenv = context.getSlideenv();
        log.info("chatSessionId:{},chatTraceId {}, slideEnv:{}, callbackUrl:{}", new Object[]{context.getChatSessionId(), context.getChatTraceId(), slideenv.name(), context.getCallbackUrl()});
        resultVoMap.put("chatSessionId", context.getChatSessionId());
        resultVoMap.put("chatTraceId", context.getChatTraceId());
        PushMsgService.doPushWs(context, resultVoMap);
        PushMsgService.doPushToAPI(context, resultVoMap);
    }

    private static boolean isEndMessage(Context context, Map<String, Object> resultVoMap) {
        JSONObject configJo;
        boolean askUser;
        JSONObject dataJo;
        Object configObj;
        List actionVOList = (List)resultVoMap.get("actionList");
        ActionVO actionVO = (ActionVO)actionVOList.get(0);
        if (actionVO.getType() == ResultActionType.waitingDone) {
            return true;
        }
        if (actionVO.getType() == ResultActionType.stopStream) {
            return true;
        }
        if (actionVO.getType() == ResultActionType.error) {
            return true;
        }
        Object data = actionVO.getData();
        if (actionVO.getType() == ResultActionType.multiMsg && data != null && (configObj = (dataJo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)data))).get((Object)"config")) != null && (askUser = (configJo = (JSONObject)configObj).getBooleanValue("askUser"))) {
            boolean sseAutoClose = dataJo.getBooleanValue("sseAutoClose");
            log.info("askUser node, sseAutoClose : {}", (Object)sseAutoClose);
            return sseAutoClose;
        }
        return false;
    }

    private static void doPushToAPI(Context context, Map<String, Object> resultVoMap) {
        AbstractSSEIterator sseIterator = SSEIteratorCache.get(context.getChatSessionId(), RequestContext.get().getTraceId());
        if (sseIterator instanceof ChatIterator) {
            log.info("SSE push:" + JSON.toJSONString(resultVoMap));
            sseIterator.put(JSON.toJSONString(resultVoMap));
            if (PushMsgService.isEndMessage(context, resultVoMap)) {
                SSEIteratorCache.finish(context.getChatSessionId(), RequestContext.get().getTraceId());
            }
        } else {
            String callbackUrl = context.getCallbackUrl();
            if (StringUtils.isNotEmpty((CharSequence)callbackUrl)) {
                if (callbackUrl.startsWith("http")) {
                    PushMsgService.doPushUrl(context, resultVoMap);
                } else {
                    PushMsgService.doPushService(callbackUrl, resultVoMap);
                }
            }
        }
    }

    private static void doPushService(String callbackInfoString, Map<String, Object> resultVoMap) {
        CallBackInfo callBackInfo = (CallBackInfo)JSON.parseObject((String)callbackInfoString, CallBackInfo.class);
        if (callBackInfo == null) {
            return;
        }
        try {
            log.info("\u5fae\u670d\u52a1\u56de\u8c03\u5f00\u59cb{}.{}.{}.{}, body:{}", new Object[]{callBackInfo.getCloudId(), callBackInfo.getAppId(), callBackInfo.getServiceName(), callBackInfo.getMethodName(), JSON.toJSONString(resultVoMap)});
            Object rs = DispatchServiceHelper.invokeBizService((String)callBackInfo.getCloudId(), (String)callBackInfo.getAppId(), (String)callBackInfo.getServiceName(), (String)callBackInfo.getMethodName(), (Object[])new Object[]{JSON.toJSONString(resultVoMap)});
            log.info("\u5fae\u670d\u52a1\u56de\u8c03\u6210\u529f{}.{}.{}.{}, body:{}, result:{}", new Object[]{callBackInfo.getCloudId(), callBackInfo.getAppId(), callBackInfo.getServiceName(), callBackInfo.getMethodName(), JSON.toJSONString(resultVoMap), JSON.toJSON((Object)rs)});
        }
        catch (Exception e) {
            log.error("\u5fae\u670d\u52a1\u56de\u8c03\u9519\u8bef", (Throwable)e);
        }
    }

    private static void doPushUrl(Context context, Map<String, Object> resultVoMap) {
        resultVoMap.put("chatTraceId", context.getChatTraceId());
        String urlString = context.getCallbackUrl();
        String token = UrlUtil.getParam((String)urlString, (String)"token");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("access_token", token);
        headers.put("X-Request-Id", RequestContext.get().getTraceId());
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("sessionId", context.getChatSessionId());
        request.put("message", resultVoMap);
        HttpPost httpRequest = HttpUtils.buildRequest(urlString, headers, request);
        try (CloseableHttpResponse httpResponse = HttpUtils.httpClient.execute((HttpUriRequest)httpRequest);){
            int errCode = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (Exception e) {
            log.error("\u56de\u8c03url\u62a5\u9519" + e.getMessage() + "," + httpRequest.getURI().toString(), (Throwable)e);
        }
    }

    private static void doPushWs(Context context, Map<String, Object> resultVoMap) {
        if (context.getAssistantPageId() == null && context.getRootPageId() == null) {
            return;
        }
        ArrayList commands = new ArrayList();
        ArrayList subList = new ArrayList();
        HashMap<String, Object> subCom = new HashMap<String, Object>();
        SLIDEENV slideenv = context.getSlideenv();
        String k = "gpt_gai";
        if (slideenv == SLIDEENV.PLAYGROUND) {
            k = "gai_gpt_playground";
        } else if (slideenv == SLIDEENV.SIMPLE_CHAT) {
            k = "gai_optimization_stream";
        }
        subCom.put("k", k);
        subCom.put("v", resultVoMap);
        subList.add(subCom);
        HashMap<String, Serializable> command1 = new HashMap<String, Serializable>();
        command1.put("a", Character.valueOf('u'));
        command1.put("p", subList);
        commands.add(command1);
        HashMap<String, Object> arg = new HashMap<String, Object>();
        arg.put("pageId", context.getAssistantPageId());
        arg.put("actions", commands);
        HashMap<String, Object> commandMain = new HashMap<String, Object>();
        commandMain.put("a", "sendDynamicFormAction");
        commandMain.put("p", Collections.singletonList(arg));
        RequestContext.get().setGlobalSessionId(context.getGlobalSessionId());
        PushMessage message = new PushMessage(PushMessageRange.RootPage, context.getRootPageId(), (Object)JSON.toJSONString(Collections.singleton(commandMain), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        PushServiceHelper.push((PushMessage)message);
    }

    public static void pushStreamThinkChat(Context context, String taskId, String flowId, int index, String think, boolean mergeLastMessageCard, List<LLMSearchInfo> searchInfos) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildThinkChat(true, context.getChatSessionId(), taskId, flowId, index, think, mergeLastMessageCard, searchInfos, context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushThinkChat(Context context, String taskId, String think, List<LLMSearchInfo> searchInfo) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildThinkChat(false, context.getChatSessionId(), taskId, 0, think, false, searchInfo, context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushStreamChat(Context context, String taskId, String flowId, int index, String chat, boolean mergeLastMessageCard, List<LLMSearchInfo> searchInfos) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildChat(true, context.getChatSessionId(), taskId, flowId, index, chat, mergeLastMessageCard, searchInfos, context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushChat(Context context, String taskId, String chat, List<LLMSearchInfo> searchInfo) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildChat(false, context.getChatSessionId(), taskId, 0, chat, false, searchInfo, context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushStreamDown(Context context, String taskId, String flowId, String chatMsgJustRecord, String messageId, String runId) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildStreamDone(context.getChatSessionId(), taskId, flowId, chatMsgJustRecord, messageId, runId, context);
        PushMsgService.doPush(context, resultVoMap);
        ThreadUtils.sleep(100L);
    }

    public static void pushMultiMsg(Context context, boolean replaceLast, List<MsgNodeMessage.MessageElement> messageElementList, String messageId) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildMultiMsg(context.getChatSessionId(), replaceLast, messageElementList, messageId, context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushMultiMsg(Context context, boolean replaceLast, List<MsgNodeMessage.MessageElement> messageElementList, String messageId, Action action) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildMultiMsg(context.getChatSessionId(), replaceLast, messageElementList, messageId, context, action);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushAskUser(Context context, List<MsgNodeMessage.MessageElement> messageElementList, String messageId, MessageConfig messageConfig, boolean allowUserInput, boolean sseAutoClose) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildAskUserMsg(context.getChatSessionId(), messageElementList, messageId, messageConfig, allowUserInput, sseAutoClose, context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushForward(Context context, ForwardType type, String actionKey, String forwardMsgKey) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildForward(context.getChatSessionId(), type, actionKey, forwardMsgKey);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushErrMsg(Context context, String code, String msg) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildErrMsg(code, msg, context.getChatSessionId(), context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushFakeOk(Context context, String code, String msg) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildFakeErrMsg(code, msg, context.getChatSessionId());
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushWaiting(Context context, long flowId, String taskId) {
        FlowCacheData.putContext(context.getChatSessionId(), context.putTask(flowId, taskId));
        Map<String, Object> resultVoMap = ResultVoHelper.buildWaiting(flowId, taskId, context.getChatSessionId(), context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushEndOutput(Context context, long flowId, Map<String, String> dataMap) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildEndOutput(context.getChatSessionId(), flowId, dataMap, context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushStopStream(Context context) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildStopStream(context.getChatSessionId(), context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushWaitingDone(Context context) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildWaitingDone(context.getChatSessionId(), context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushWaitingDone(Context context, long flowId, String taskId) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildWaitingDone(context.getChatSessionId(), flowId, taskId, context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushRecommendQuestion(Context context, List<Map<String, Object>> questionList) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildRecommendQuestion(questionList, context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushChangeConfig(Context context, GaiInitConfig gaiInitConfig) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildChangeConfig(gaiInitConfig);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushResult(Context context, String resultActionType, Object data) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildResult(resultActionType, data, context);
        PushMsgService.doPush(context, resultVoMap);
    }

    public static void pushChatBottom(Context context, ContextData contextData) {
        Map<String, Object> contextMsg = ResultVoHelper.buildChatBottom(contextData, context);
        PushMsgService.doPush(context, contextMsg);
    }

    public static void pushIdentifySkill(Context context, String skillId) {
        Map<String, Object> contextMsg = ResultVoHelper.buildIdentifySkill(skillId);
        PushMsgService.doPush(context, contextMsg);
    }
}

