/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.domain.dto.refrence.QueryRefrenceParam;
import kd.ai.gai.core.domain.dto.refrence.RefrenceRelation;
import kd.ai.gai.core.domain.dto.refrence.SaveRefrenceParam;
import kd.ai.gai.core.util.OperationResultUtil;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class RefrenceRelationService {
    public static void saveRelation(SaveRefrenceParam param) {
        Set<Long> dataIds = param.getDataIds();
        QFilter qFilter = new QFilter("refrenceformid", "=", (Object)param.getRefrenceFormId());
        qFilter.and(new QFilter("refrenceid", "=", (Object)param.getRefrenceId()));
        qFilter.and(new QFilter("formid", "=", (Object)param.getFormId()));
        DeleteServiceHelper.delete((String)"gai_refrence_relation", (QFilter[])new QFilter[]{qFilter, new QFilter("dataid", "not in", dataIds)});
        DynamicObjectCollection dObjRelations = QueryServiceHelper.query((String)"gai_refrence_relation", (String)"dataid", (QFilter[])new QFilter[]{qFilter, new QFilter("dataid", "in", dataIds)});
        dObjRelations.forEach(dObjRelation -> dataIds.remove(dObjRelation.getLong("dataid")));
        if (dataIds.isEmpty()) {
            return;
        }
        ArrayList newRelationList = new ArrayList(dataIds.size());
        dataIds.forEach(dataId -> {
            DynamicObject dObjNewRelation = BusinessDataServiceHelper.newDynamicObject((String)"gai_refrence_relation");
            dObjNewRelation.set("refrenceformid", (Object)param.getRefrenceFormId());
            dObjNewRelation.set("refrenceid", (Object)param.getRefrenceId());
            dObjNewRelation.set("formid", (Object)param.getFormId());
            dObjNewRelation.set("dataid", dataId);
            newRelationList.add(dObjNewRelation);
        });
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"gai_refrence_relation", (DynamicObject[])newRelationList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            throw new KDBizException(OperationResultUtil.getOperationResultMessage(operationResult));
        }
    }

    public static void deleteAllRelation(String refrenceFormId, Set<Long> refrenceIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("refrenceformid", "=", (Object)refrenceFormId), new QFilter("refrenceid", "in", refrenceIds)};
        DeleteServiceHelper.delete((String)"gai_refrence_relation", (QFilter[])qFilters);
    }

    /*
     * Loose catch block
     */
    private static List<RefrenceRelation> queryRefrenceRelation(String formId, List<Long> dataIds, String specifiedRefrenceFormId) {
        boolean bExists;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("formid", "=", (Object)formId));
        qFilterList.add(new QFilter("dataid", "in", dataIds));
        if (StringUtils.isNotEmpty((CharSequence)specifiedRefrenceFormId)) {
            qFilterList.add(new QFilter("refrenceformid", "=", (Object)specifiedRefrenceFormId));
        }
        if (!(bExists = QueryServiceHelper.exists((String)"gai_refrence_relation", (QFilter[])qFilterList.toArray(new QFilter[0])))) {
            return Collections.emptyList();
        }
        String selectFields = String.format("%s,%s,%s,%s,%s", "id", "formid", "dataid", "refrenceformid", "refrenceid");
        String orderBy = String.format("%s,%s desc", "refrenceformid", "refrenceid");
        try {
            try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"AlgoKey_RefrenceRelationService_queryRefrenceRelation", (String)"gai_refrence_relation", (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[0]), (String)orderBy);){
                ArrayList<RefrenceRelation> refrenceRelations = new ArrayList<RefrenceRelation>(1);
                while (dataset.hasNext()) {
                    Row row = dataset.next();
                    RefrenceRelation relation = new RefrenceRelation(row.getString("formid"), row.getLong("dataid"), row.getString("refrenceformid"), row.getLong("refrenceid"));
                    refrenceRelations.add(relation);
                }
                ArrayList<RefrenceRelation> arrayList = refrenceRelations;
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    public static Map<String, List<Map<String, Object>>> queryRefrenceDetailDatas(QueryRefrenceParam param) {
        RefrenceRelationService.verifyParams(param);
        HashMap<String, List<Map<String, Object>>> mapResult = new HashMap<String, List<Map<String, Object>>>(param.getDataIds().size());
        List<RefrenceRelation> refrenceRelations = RefrenceRelationService.queryRefrenceRelation(param.getFormId(), param.getDataIds(), param.getRefrenceFormId());
        HashMap<String, Set<Long>> mapRefrenceIdSet = new HashMap<String, Set<Long>>();
        refrenceRelations.forEach(relation -> {
            Set setRefrenceIds = mapRefrenceIdSet.computeIfAbsent(relation.getRefrenceFormId(), k -> new HashSet(1));
            setRefrenceIds.add(relation.getRefrenceId());
        });
        String detailFields = "";
        if (StringUtils.isNotEmpty((CharSequence)param.getRefrenceFormId()) && StringUtils.isNotEmpty((CharSequence)param.getSelectFields())) {
            detailFields = param.getSelectFields();
        }
        if (StringUtils.isEmpty((CharSequence)detailFields)) {
            detailFields = String.format("%s,%s,%s,%s", "id", "number", "name", "enable");
        }
        Map<String, Map<Long, DynamicObject>> mapRefrenceDynamicObjets = RefrenceRelationService.queryDynamicObjects(mapRefrenceIdSet, detailFields);
        String[] fields = detailFields.split(",");
        refrenceRelations.forEach(relation -> {
            List list = mapResult.computeIfAbsent(String.valueOf(relation.getDataId()), k -> new ArrayList(1));
            HashMap<String, Object> mapRow = new HashMap<String, Object>(fields.length);
            Map mapFormDynamicObjets = (Map)mapRefrenceDynamicObjets.get(relation.getRefrenceFormId());
            if (mapFormDynamicObjets == null) {
                return;
            }
            DynamicObject dObjRefrenceDataRow = (DynamicObject)mapFormDynamicObjets.get(relation.getRefrenceId());
            if (dObjRefrenceDataRow == null) {
                return;
            }
            mapRow.put("formId", relation.getRefrenceFormId());
            for (String field : fields) {
                mapRow.put(field, dObjRefrenceDataRow.get(field));
            }
            list.add(mapRow);
        });
        return mapResult;
    }

    private static Map<String, Map<Long, DynamicObject>> queryDynamicObjects(Map<String, Set<Long>> mapRefrenceIdSet, String selectFields) {
        HashSet<String> fields = new HashSet<String>(1);
        fields.addAll(Arrays.asList(selectFields.split(",")));
        fields.add("id");
        selectFields = String.join((CharSequence)",", fields);
        HashMap<String, Map<Long, DynamicObject>> mapRefrenceDynamicObjets = new HashMap<String, Map<Long, DynamicObject>>(mapRefrenceIdSet.size());
        for (Map.Entry<String, Set<Long>> entry : mapRefrenceIdSet.entrySet()) {
            String formId = entry.getKey();
            DynamicObjectCollection rows = QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", mapRefrenceIdSet.get(formId))});
            HashMap mapdObjs = new HashMap(rows.size());
            rows.forEach(row -> mapdObjs.put(row.getLong("id"), row));
            mapRefrenceDynamicObjets.put(formId, mapdObjs);
        }
        return mapRefrenceDynamicObjets;
    }

    private static void verifyParams(QueryRefrenceParam queryRefrenceParam) {
        if (StringUtils.isEmpty((CharSequence)queryRefrenceParam.getFormId())) {
            throw new KDBizException("");
        }
        if (queryRefrenceParam.getDataIds() == null || queryRefrenceParam.getDataIds().isEmpty()) {
            throw new KDBizException("");
        }
    }
}

