/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.AgentSample;
import kd.ai.gai.core.domain.dto.agent.Question;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.domain.vo.SuggestedAskData;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class SkillService {
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String ASSISTANT = "assistant";
    public static final String ORDER = "order";
    public static final String SKILL_ID = "skillid";
    public static final String SKILL_TYPE = "skilltype";
    public static final String SKILL_SERVICE_DES = "skillservicedesc";
    private static final String QUERY_4_LIST_FIELDS = "id,skillid,skilltype,skillservicedesc,order";
    public static final String SKILL_FORM_ID = "gai_skill";
    public static final String AGENT_FORM_ID = "gai_agent";
    public static final String PROCESS_FORM_ID = "gai_process";
    private static final Log log = LogFactory.getLog(SkillService.class);

    public static Skill Agent2Skill4Save(Agent agent, int order) {
        Skill skill = new Skill();
        skill.setId(agent.getAgentId() + "");
        skill.setType(Skill.Type.AGENT);
        skill.setOrder(order);
        skill.setServiceDes(agent.getDescription());
        return skill;
    }

    public static long getIdByNumber(Skill.Type skillType, String skillNumber) {
        if (skillType == Skill.Type.PROCESS) {
            Process process = ProcessService.getProcessByNumber(skillNumber);
            if (process != null) {
                return process.getId();
            }
        } else {
            return AgentService.getAgentIdByNumber(skillNumber);
        }
        return 0L;
    }

    public static void clearAndSaveList(long assistantId, List<Skill> skillList) {
        QFilter[] qFilters = new QFilter[]{new QFilter(ASSISTANT, "=", (Object)assistantId)};
        DeleteServiceHelper.delete((String)SKILL_FORM_ID, (QFilter[])qFilters);
        DynamicObject[] dynamicObjects = new DynamicObject[skillList.size()];
        for (int i = 0; i < skillList.size(); ++i) {
            Skill skill = skillList.get(i);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)SKILL_FORM_ID);
            dynamicObject.set(ORDER, (Object)skill.getOrder());
            dynamicObject.set(SKILL_SERVICE_DES, (Object)skill.getServiceDes());
            dynamicObject.set(SKILL_ID, (Object)skill.getId());
            dynamicObject.set(SKILL_TYPE, (Object)skill.getType());
            dynamicObject.set(ASSISTANT, (Object)assistantId);
            dynamicObjects[i] = dynamicObject;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public static List<Skill> getList(long assistantId, String appId, List<String> blgs, boolean forceShowAllAgent, boolean checkBlg) {
        return SkillService.getSkills(assistantId, appId, blgs, forceShowAllAgent, checkBlg);
    }

    public static List<Skill> getList(long assistantId, String appId, List<String> blgs, boolean forceShowAllAgent) {
        return SkillService.getSkills(assistantId, appId, blgs, forceShowAllAgent, true);
    }

    public static List<Skill> getList(long assistantId) {
        return SkillService.getList(assistantId, true);
    }

    public static List<Skill> getList(long assistantId, String appId, List<String> blgs) {
        return SkillService.getSkills(assistantId, appId, blgs, false, true);
    }

    public static List<Skill> getPermissionList(long assistantId, String appId, List<String> blgs) {
        List<Skill> skills = SkillService.getSkills(assistantId, appId, blgs, false, true);
        if (!SkillService.isAllStaffAssistant(assistantId)) {
            return SkillService.getSkillList(skills, false);
        }
        return skills;
    }

    public static boolean isAllStaffAssistant(long assistantId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)assistantId, (String)GaiFormIdEnum.GAI_ASS.getId());
        return dynamicObject.getBoolean("allstaffassistant");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Skill> getList(long assistantId, boolean checkBlg) {
        if (assistantId == 0L) {
            return new ArrayList<Skill>();
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(ASSISTANT, "=", (Object)assistantId)};
        Map doMap = BusinessDataServiceHelper.loadFromCache((String)SKILL_FORM_ID, (String)QUERY_4_LIST_FIELDS, (QFilter[])qFilters, (String)ORDER);
        Collection dynamicObjects = doMap.values();
        Set<Long> skillIdSet = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong(SKILL_ID)).collect(Collectors.toSet());
        List<AgentSample> agents = AgentService.getAgentListByIdList(Lists.newArrayList(skillIdSet), checkBlg);
        HashMap agentMap = Maps.newHashMapWithExpectedSize((int)agents.size());
        for (AgentSample agent : agents) {
            Long id = Long.valueOf(agent.getAgentId());
            agentMap.put(id, agent);
        }
        List<Skill> processList = ProcessService.getProcessByIdsAndOther(skillIdSet, checkBlg);
        HashMap processMap = Maps.newHashMapWithExpectedSize((int)agents.size());
        for (Skill skill : processList) {
            Long id = Long.valueOf(skill.getId());
            processMap.put(id, skill);
        }
        ArrayList skills = Lists.newArrayListWithExpectedSize((int)dynamicObjects.size());
        Iterator iterator = dynamicObjects.iterator();
        while (true) {
            String skillServiceDesc;
            Skill skill;
            DynamicObject dynamicObject2;
            block12: {
                if (!iterator.hasNext()) {
                    return skills;
                }
                dynamicObject2 = (DynamicObject)iterator.next();
                skill = new Skill();
                long skillId = dynamicObject2.getLong(SKILL_ID);
                skillServiceDesc = dynamicObject2.getString(SKILL_SERVICE_DES);
                skill.setId(skillId + "");
                String skillType = dynamicObject2.getString(SKILL_TYPE);
                if (Skill.Type.AGENT.name().equals(skillType)) {
                    AgentSample agent = (AgentSample)agentMap.get(skillId);
                    if (agent != null) {
                        skill.setType(Skill.Type.AGENT);
                        skill.setName(agent.getName());
                        skill.setNumber(agent.getNumber());
                        skill.setPicture(agent.getPicture());
                        skill.setBgColor(agent.getBgColor());
                        skill.setPrologue(agent.getPrologue());
                        List<Question> questions = agent.getQuestionList();
                        ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>();
                        if (questions != null) {
                            for (Question question : questions) {
                                suggestedAskDataList.add(new SuggestedAskData("1", question.getValue(), null));
                            }
                            skill.setSuggestedAsks(suggestedAskDataList);
                        }
                        break block12;
                    } else {
                        log.info("\u8fd9\u4e2aid\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u7684agent\uff0c\u5df2\u7ecf\u5ffd\u7565", (Object)skillId);
                        continue;
                    }
                }
                skill.setType(Skill.Type.PROCESS);
                Skill process = (Skill)processMap.get(skillId);
                if (process != null) {
                    skill.setName(process.getName());
                    skill.setNumber(process.getNumber());
                    skill.setSuggestedAsks(process.getSuggestedAsks());
                    skill.setPrologue(process.getPrologue());
                } else {
                    log.info("\u8fd9\u4e2aid\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u7684process\uff0c\u5df2\u7ecf\u5ffd\u7565", (Object)skillId);
                    continue;
                }
            }
            skill.setServiceDes(skillServiceDesc);
            skill.setOrder(dynamicObject2.getInt(ORDER));
            skills.add(skill);
        }
    }

    public static List<Skill> getSkillList(List<Skill> skillList, boolean isFull) {
        if (!isFull) {
            ArrayList<Long> ids = new ArrayList<Long>(10);
            ids.addAll(SkillService.permissionCheck(AGENT_FORM_ID));
            ids.addAll(SkillService.permissionCheck(PROCESS_FORM_ID));
            if (!skillList.isEmpty()) {
                Iterator<Skill> iterator = skillList.iterator();
                while (iterator.hasNext()) {
                    Skill skill = iterator.next();
                    if (ids.contains(Long.parseLong(skill.getId()))) continue;
                    iterator.remove();
                }
            }
        }
        return skillList;
    }

    public static List<Long> permissionCheck(String formId) {
        QFilter qFilter = new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr());
        long userId = RequestContext.get().getCurrUserId();
        MainEntityType met = MetadataServiceHelper.getDataEntityType((String)formId);
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)met.getAppId());
        QFilter permissionFilter = PermissionServiceHelper.getDataPermission((long)userId, (String)appId, (String)formId);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (permissionFilter == null) {
            return ids;
        }
        qFilter.and(permissionFilter);
        DynamicObject[] toolDoArr = BusinessDataServiceHelper.load((String)formId, (String)ID, (QFilter[])new QFilter[]{qFilter});
        if (toolDoArr != null && toolDoArr.length > 0) {
            for (DynamicObject toolDo : toolDoArr) {
                ids.add(toolDo.getLong(ID));
            }
        }
        return ids;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Skill> getSkills(long assistantId, String appId, List<String> blgs, boolean forceShowAllAgent, boolean checkBlg) {
        if (assistantId == 0L) {
            return new ArrayList<Skill>();
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(ASSISTANT, "=", (Object)assistantId)};
        Map doMap = BusinessDataServiceHelper.loadFromCache((String)SKILL_FORM_ID, (String)QUERY_4_LIST_FIELDS, (QFilter[])qFilters, (String)ORDER);
        Collection dynamicObjects = doMap.values();
        Set<Long> skillIdSet = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong(SKILL_ID)).collect(Collectors.toSet());
        List<AgentSample> agents = AgentService.getAgentListByIdList(Lists.newArrayList(skillIdSet), appId, forceShowAllAgent, checkBlg);
        HashMap agentMap = Maps.newHashMapWithExpectedSize((int)agents.size());
        for (AgentSample agent : agents) {
            Long id = Long.valueOf(agent.getAgentId());
            agentMap.put(id, agent);
        }
        List<Skill> processList = ProcessService.getProcessByIdsAndOther(skillIdSet, appId, blgs, checkBlg);
        HashMap processMap = Maps.newHashMapWithExpectedSize((int)agents.size());
        for (Skill skill : processList) {
            Long id = Long.valueOf(skill.getId());
            processMap.put(id, skill);
        }
        ArrayList skills = Lists.newArrayListWithExpectedSize((int)dynamicObjects.size());
        Iterator iterator = dynamicObjects.iterator();
        while (true) {
            String skillServiceDesc;
            Skill skill;
            DynamicObject dynamicObject2;
            block12: {
                if (!iterator.hasNext()) {
                    return skills;
                }
                dynamicObject2 = (DynamicObject)iterator.next();
                skill = new Skill();
                long skillId = dynamicObject2.getLong(SKILL_ID);
                skillServiceDesc = dynamicObject2.getString(SKILL_SERVICE_DES);
                skill.setId(skillId + "");
                String skillType = dynamicObject2.getString(SKILL_TYPE);
                if (Skill.Type.AGENT.name().equals(skillType)) {
                    AgentSample agent = (AgentSample)agentMap.get(skillId);
                    if (agent != null) {
                        skill.setType(Skill.Type.AGENT);
                        skill.setName(agent.getName());
                        skill.setNumber(agent.getNumber());
                        skill.setPicture(agent.getPicture());
                        skill.setBgColor(agent.getBgColor());
                        skill.setPrologue(agent.getPrologue());
                        List<Question> questions = agent.getQuestionList();
                        ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>();
                        if (questions != null) {
                            for (Question question : questions) {
                                suggestedAskDataList.add(new SuggestedAskData("1", question.getValue(), null));
                            }
                            skill.setSuggestedAsks(suggestedAskDataList);
                        }
                        break block12;
                    } else {
                        log.info("\u8fd9\u4e2aid\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u7684agent\uff0c\u5df2\u7ecf\u5ffd\u7565", (Object)skillId);
                        continue;
                    }
                }
                skill.setType(Skill.Type.PROCESS);
                Skill process = (Skill)processMap.get(skillId);
                if (process != null) {
                    skill.setName(process.getName());
                    skill.setNumber(process.getNumber());
                    skill.setSuggestedAsks(process.getSuggestedAsks());
                    skill.setPrologue(process.getPrologue());
                } else {
                    log.info("\u8fd9\u4e2aid\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u7684process\uff0c\u5df2\u7ecf\u5ffd\u7565", (Object)skillId);
                    continue;
                }
            }
            skill.setServiceDes(skillServiceDesc);
            skill.setOrder(dynamicObject2.getInt(ORDER));
            skills.add(skill);
        }
    }
}

