/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Map;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.hander.OpenAPIAuthHandlerFactory;
import kd.ai.gai.core.agent.tool.model.APIKeyAuthConfig;
import kd.ai.gai.core.agent.tool.model.APIParam;
import kd.ai.gai.core.agent.tool.model.AuthConfig;
import kd.ai.gai.core.agent.tool.model.AuthType;
import kd.ai.gai.core.agent.tool.model.CosmicAccessTokenAuthConfig;
import kd.ai.gai.core.agent.tool.model.NoAuthConfig;
import kd.ai.gai.core.agent.tool.model.OAuthCredentialsConfig;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.domain.dto.agent.AgentTool;
import kd.ai.gai.core.domain.dto.agent.BaseAPI;
import kd.ai.gai.core.domain.dto.agent.MCPTool;
import kd.ai.gai.core.domain.dto.agent.RestfulAPI;
import kd.ai.gai.core.domain.dto.agent.ThirdOpenAPI;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.service.agent.AgentToolService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class APIService {
    private static final Log logger = LogFactory.getLog(APIService.class);
    private static final Integer DEFAULT_TIMEOUT_SECONDS = 120;

    public abstract Map<String, OperationParam> parserOperationParam(String var1, String var2);

    public abstract BaseResult callApi(String var1, BaseAPI var2);

    public abstract BaseResult reHandlerResult(BaseResult var1, OperationParam var2);

    public BaseResult handlerCall(String toolConfig, BaseAPI api, OperationParam operationParam) {
        String chatSessionId = api.getChatSessionId();
        Long runId = api.getRunId();
        JSONObject toolParams = api.getToolParams();
        JSONObject swagger = JSONObject.parseObject((String)toolConfig);
        String at = swagger.getString("authtype");
        Integer timeout = swagger.getInteger("timeout");
        timeout = timeout == null || timeout == 0 ? DEFAULT_TIMEOUT_SECONDS : timeout;
        AuthType authType = AuthType.parseAuthType(at);
        AuthConfig config = APIService.parseAuthConfig(toolConfig);
        APIParam param = this.handlerAPIParam(operationParam, toolParams, config, swagger, chatSessionId, runId);
        param.setToolType(this.getToolType(api));
        param.setTimeout(timeout);
        Object handler = OpenAPIAuthHandlerFactory.getHandler(authType);
        return this.reHandlerResult(handler.call(param), operationParam);
    }

    private String getToolType(BaseAPI api) {
        if (api instanceof MCPTool) {
            return ToolConstant.ToolType.MCP_TOOL.getType();
        }
        if (api instanceof RestfulAPI) {
            return ToolConstant.ToolType.RESTFUL_API.getType();
        }
        if (api instanceof ThirdOpenAPI) {
            return ToolConstant.ToolType.THIRD_OPENAPI.getType();
        }
        return ToolConstant.ToolType.RESTFUL_API.getType();
    }

    protected BaseResult callApi(BaseAPI api) {
        Long toolId = api.getToolId();
        if (toolId == null) {
            return BaseResult.fail("toolId\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject toolParams = api.getToolParams();
        if (toolParams == null) {
            return BaseResult.fail("toolParams\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String operationId = toolParams.getString("operationId");
        if (ObjectUtils.isEmpty((Object)operationId)) {
            return BaseResult.fail("toolParams\u53c2\u6570\u4e2doperationId\u53c2\u6570\u4e3a\u7a7a");
        }
        AgentTool agentTool = AgentToolService.getAgentTool(toolId);
        if (agentTool == null) {
            return BaseResult.fail(String.format("id\u4e3a%s\u7684\u5de5\u5177\u4e0d\u5b58\u5728", toolId));
        }
        String toolType = agentTool.getType();
        if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.AGENT_PRESET.getType())) {
            return new BaseResult();
        }
        String toolConfig = agentTool.getConfig();
        String chatSessionId = api.getChatSessionId();
        Long runId = api.getRunId();
        logger.info("chatSessionId:{},runId:{}", (Object)chatSessionId, (Object)runId);
        if (!StringUtils.isEmpty((CharSequence)chatSessionId)) {
            FlowCacheData.restoreRequestContext(chatSessionId);
        }
        return this.callApi(toolConfig, api);
    }

    public APIParam handlerAPIParam(OperationParam operationParam, JSONObject toolParams, AuthConfig config, JSONObject toolConfigJo, String chatSessionId, Long runId) {
        JSONArray commonHeaders = toolConfigJo.getJSONArray("headerList");
        if (commonHeaders == null) {
            commonHeaders = new JSONArray();
        }
        if (!StringUtils.isEmpty((CharSequence)chatSessionId)) {
            this.buildChatSessionIdHeader(commonHeaders, chatSessionId, runId);
            logger.info("build commonHeaders : {}", (Object)JSONObject.toJSONString((Object)commonHeaders));
        } else {
            logger.error("build commonHeaders,chatSessionId is empty");
        }
        toolParams.put("headers", (Object)commonHeaders);
        JSONArray bodyCommonParams = toolConfigJo.getJSONArray("bodyParamList");
        toolParams.put("bodyParamList", (Object)bodyCommonParams);
        APIParam param = new APIParam(toolParams, config, operationParam);
        return param;
    }

    protected void buildChatSessionIdHeader(JSONArray commonHeaders, String chatSessionId, Long runId) {
        JSONObject sidHeader = new JSONObject();
        JSONObject gaiParams = new JSONObject();
        gaiParams.put("chatSessionId", (Object)chatSessionId);
        gaiParams.put("runId", (Object)runId);
        Context context = FlowCacheData.getContext(chatSessionId);
        if (context != null) {
            gaiParams.put("PAGE_ID", (Object)context.getBizPageId());
            gaiParams.put("ROOT_PAGE_ID", (Object)context.getRootPageId());
        }
        sidHeader.put("key", (Object)"gaiParams");
        sidHeader.put("value", (Object)JSONObject.toJSONString((Object)gaiParams, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        commonHeaders.add((Object)sidHeader);
    }

    public static AuthConfig parseAuthConfig(String toolConfig) {
        JSONObject toolConfigJo = JSONObject.parseObject((String)toolConfig);
        String at = toolConfigJo.getString("authtype");
        AuthConfig config = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.SERVICE.getType())) {
            APIKeyAuthConfig apiKeyAuthConfig;
            JSONObject serviceConfig = toolConfigJo.getJSONObject("serviceConfig");
            config = apiKeyAuthConfig = (APIKeyAuthConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)serviceConfig), APIKeyAuthConfig.class);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.OAUTH.getType())) {
            JSONObject oauthConfig = toolConfigJo.getJSONObject("oauthConfig");
            OAuthCredentialsConfig oAuthConfig = (OAuthCredentialsConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oauthConfig), OAuthCredentialsConfig.class);
            config = oAuthConfig;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.NO_AUTH.getType())) {
            config = new NoAuthConfig();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
            JSONObject cosmicConfig = toolConfigJo.getJSONObject("cosmicAccessTokenConfig");
            CosmicAccessTokenAuthConfig caaa = (CosmicAccessTokenAuthConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)cosmicConfig), CosmicAccessTokenAuthConfig.class);
            config = caaa;
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u9274\u6743\u7c7b\u578b\u3002", (String)"APIService_1", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        return config;
    }
}

