/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.AgentSample;
import kd.ai.gai.core.domain.dto.agent.AiccAgentConfig;
import kd.ai.gai.core.domain.dto.agent.PageQuery;
import kd.ai.gai.core.domain.dto.agent.PageResult;
import kd.ai.gai.core.domain.dto.agent.Process;
import kd.ai.gai.core.domain.dto.agent.Prompt;
import kd.ai.gai.core.domain.dto.agent.Question;
import kd.ai.gai.core.domain.dto.agent.Repo;
import kd.ai.gai.core.domain.dto.agent.Tool;
import kd.ai.gai.core.domain.dto.agent.VarParam;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.agent.AgentServiceService;
import kd.ai.gai.core.service.agent.PictureAvatarService;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class AgentService {
    private static final Log log = LogFactory.getLog(AgentService.class);

    public static Agent getAgent(long id, boolean needDetail) {
        DynamicObject agentDo = null;
        try {
            agentDo = BusinessDataServiceHelper.loadSingle((Object)id, (String)GaiFormIdEnum.GAI_AGENT.getId());
        }
        catch (Exception e) {
            log.error("getAgent error.", (Object)e.getMessage());
            return null;
        }
        if (agentDo == null) {
            return null;
        }
        AiccAgentConfig aiccAgentConfig = AgentServiceService.getAgentService("gai_agent");
        Agent agent = AgentService.trans2Agent(agentDo, needDetail, aiccAgentConfig);
        return agent;
    }

    public static long getAgentIdByNumber(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return 0L;
        }
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        Map objs = BusinessDataServiceHelper.loadFromCache((String)"gai_agent", (String)"id,number,name", (QFilter[])filters);
        if (objs == null || objs.isEmpty()) {
            return 0L;
        }
        return (Long)objs.keySet().iterator().next();
    }

    public static Agent trans2Agent(DynamicObject agentDo, boolean needDetail, AiccAgentConfig aiccAgentConfig) {
        Agent agent = null;
        if (agentDo != null) {
            agent = new Agent();
            agent.setAgentId((Long)agentDo.getPkValue());
            agent.setAssistantId((Long)agentDo.getPkValue());
            String picture = agentDo.getString("picture");
            picture = AgentService.assemblyPictureWebUrl(picture);
            agent.setPicture(picture);
            String bgColor = agentDo.getString("bgcolor");
            agent.setBgColor(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)bgColor) ? bgColor : "#EAF6FF");
            agent.setNumber(agentDo.getString("number"));
            agent.setName(agentDo.getString("name"));
            agent.setDescription(agentDo.getString("description"));
            agent.setAgentName(agentDo.getString("agentname"));
            agent.setVersion(agentDo.getString("version"));
            agent.setPrologue(agentDo.getString("prologue"));
            agent.setLlm(agentDo.getString("llm"));
            agent.setLlmStyle(agentDo.getString("llmstyle"));
            agent.setRepoAutoCall(agentDo.getInt("repoautocall"));
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)agent.getLlm())) {
                agent.setLlm(aiccAgentConfig.getLlm());
                agent.setLlmStyle(aiccAgentConfig.getLlmStyle());
                agent.setLlmNumber(aiccAgentConfig.getLlm());
            } else {
                Map<String, Object> service = AiccService.queryLlmAiccService(agentDo.getString("llm"));
                String llm = (String)service.get("llm");
                agent.setLlmNumber(llm);
            }
            agent.setRoleMode(agentDo.getString("rolemode"));
            agent.setType(agentDo.getString("type"));
            agent.setRememberCount(agentDo.getInt("remembercount"));
            String roledesc = agentDo.getString("roledesc_tag");
            roledesc = roledesc.replaceAll("#####[\\s\\S]*?#####", "");
            agent.setRoleDescTag(roledesc);
            agent.setEnable(agentDo.getBoolean("enable") ? EnableEnum.YES.getKeyStr() : EnableEnum.NO.getKeyStr());
            DynamicObject modifierDo = agentDo.getDynamicObject("modifier");
            agent.setModifierName(modifierDo == null ? "" : modifierDo.getString("name"));
            if (agentDo.getDate("modifytime") != null) {
                agent.setModifyTime(KDDateFormatUtils.getDateTimeFormat().format(agentDo.getDate("modifytime")));
            }
            DynamicObjectCollection questionDoc = agentDo.getDynamicObjectCollection("gai_agent_start");
            DynamicObjectCollection repoDoc = agentDo.getDynamicObjectCollection("gai_agent_repo");
            DynamicObjectCollection toolDoc = agentDo.getDynamicObjectCollection("gai_agent_tool");
            DynamicObjectCollection promptDoc = agentDo.getDynamicObjectCollection("gai_agent_prompt");
            DynamicObjectCollection processDoc = agentDo.getDynamicObjectCollection("gai_agent_process");
            ArrayList<Question> questionList = null;
            ArrayList<Repo> repoList = null;
            ArrayList<Tool> toolList = null;
            ArrayList toolLists = null;
            ArrayList<Prompt> promptList = null;
            ArrayList<Process> processList = null;
            List openApiList = null;
            if (questionDoc != null && !questionDoc.isEmpty()) {
                questionList = new ArrayList<Question>(questionDoc.size());
                for (DynamicObject questionDo : questionDoc) {
                    if (questionDo.get("question") == null) continue;
                    ILocaleString questionLocaleString = questionDo.getLocaleString("question");
                    Question question = new Question();
                    question.setId(StrUtils.longAsString((Long)questionDo.getPkValue()));
                    question.setValue(questionLocaleString.getLocaleValue());
                    questionList.add(question);
                }
            }
            if (needDetail) {
                if (repoDoc != null && !repoDoc.isEmpty()) {
                    repoList = new ArrayList<Repo>(repoDoc.size());
                    for (Object repoDo : repoDoc) {
                        DynamicObject referRepoDo = repoDo.getDynamicObject("repo");
                        if (referRepoDo == null) continue;
                        Repo repo = new Repo();
                        repo.setId((Long)referRepoDo.getPkValue());
                        repo.setNumber(referRepoDo.getString("number"));
                        repo.setName(referRepoDo.getString("name"));
                        repo.setDescription(referRepoDo.getString("desc"));
                        repoList.add(repo);
                    }
                }
                if (toolDoc != null && !toolDoc.isEmpty()) {
                    toolList = new ArrayList<Tool>(toolDoc.size());
                    toolLists = new ArrayList(toolDoc.size());
                    ArrayList<Long> toolIdList = new ArrayList<Long>(toolDoc.size());
                    toolDoc.sort((Comparator)new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject o1, DynamicObject o2) {
                            return o1.getInt("seq") - o2.getInt("seq");
                        }
                    });
                    for (DynamicObject toolDo : toolDoc) {
                        DynamicObject referToolDo = toolDo.getDynamicObject("tool");
                        if (referToolDo == null) continue;
                        toolIdList.add((Long)referToolDo.getPkValue());
                    }
                    Object[] toolIdArr = (Long[])toolIdList.stream().toArray(Long[]::new);
                    DynamicObject[] toolDoArr = BusinessDataServiceHelper.load((Object[])toolIdArr, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_TOOL.getId()).getDynamicObjectType());
                    if (toolDoArr != null && toolDoArr.length > 0) {
                        for (DynamicObject toolDs : toolDoc) {
                            for (DynamicObject toolDo : toolDoArr) {
                                JSONObject configTagJo;
                                if (!toolDs.getDynamicObject("tool").getPkValue().equals(toolDo.getPkValue())) continue;
                                Tool tool = new Tool();
                                tool.setId((Long)toolDo.getPkValue());
                                tool.setName(toolDo.getString("name"));
                                tool.setDescription(toolDo.getString("description"));
                                tool.setNumber(toolDo.getString("number"));
                                String toolType = toolDo.getString("tool_type");
                                tool.setType(toolType);
                                tool.setSelected(toolDs.getString("selected_tag"));
                                String configTag = toolDo.getString("config_tag");
                                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)configTag)) {
                                        configTagJo = JSONObject.parseObject((String)configTag);
                                        String swaggerSchema = configTagJo.getString("llmSchema");
                                        JSONObject swaggerSchemaJo = new JSONObject();
                                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)swaggerSchema)) {
                                            swaggerSchemaJo = JSONObject.parseObject((String)swaggerSchema);
                                        }
                                        JSONObject configJo = new JSONObject();
                                        configJo.put("swaggerSchema", (Object)swaggerSchemaJo);
                                        tool.setConfigTag(configJo);
                                    }
                                } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType())) {
                                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)configTag)) {
                                        configTagJo = JSONObject.parseObject((String)configTag);
                                        tool.setConfigTag(configTagJo);
                                    }
                                } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) {
                                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)configTag)) {
                                        configTagJo = JSONObject.parseObject((String)configTag);
                                        tool.setConfigTag(configTagJo);
                                    }
                                } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType())) {
                                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)configTag)) {
                                        configTagJo = JSONObject.parseObject((String)configTag);
                                        tool.setConfigTag(configTagJo);
                                    }
                                } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)configTag)) {
                                    JSONObject actionConfig = JSONObject.parseObject((String)configTag);
                                    JSONObject configJo = new JSONObject();
                                    JSONArray inputs = actionConfig.getJSONArray("inputParams");
                                    JSONArray outputs = actionConfig.getJSONArray("outputParams");
                                    configJo.put("inputParams", (Object)inputs);
                                    configJo.put("outputParams", (Object)outputs);
                                    configJo.put("action", (Object)actionConfig.getString("action"));
                                    configJo.put("appId", (Object)actionConfig.getString("appId"));
                                    configJo.put("serviceName", (Object)actionConfig.getString("serviceName"));
                                    tool.setConfigTag(configJo);
                                }
                                toolList.add(tool);
                            }
                        }
                    }
                    for (int i = 0; i < toolIdArr.length; ++i) {
                        for (int j = 0; j < toolLists.size(); ++j) {
                            Tool tool = (Tool)toolLists.get(j);
                            if (((Long)toolIdArr[i]).longValue() != tool.getId()) continue;
                            toolList.add(tool);
                        }
                    }
                }
                if (promptDoc != null && !promptDoc.isEmpty()) {
                    promptList = new ArrayList<Prompt>(promptDoc.size());
                    ArrayList<Long> promptIdList = new ArrayList<Long>(promptDoc.size());
                    for (DynamicObject promptDo : promptDoc) {
                        DynamicObject referPromptlDo = promptDo.getDynamicObject("prompt");
                        if (referPromptlDo == null) continue;
                        promptIdList.add((Long)referPromptlDo.getPkValue());
                    }
                    Object[] promptIdArr = (Long[])promptIdList.stream().toArray(Long[]::new);
                    DynamicObject[] promptDoArr = BusinessDataServiceHelper.load((Object[])promptIdArr, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_PROMPT.getId()).getDynamicObjectType());
                    if (promptDoArr != null && promptDoArr.length > 0) {
                        for (DynamicObject promptDo : promptDoArr) {
                            Prompt prompt = new Prompt();
                            prompt.setId((Long)promptDo.getPkValue());
                            prompt.setName(promptDo.getString("name"));
                            prompt.setDescription(promptDo.getString("desc"));
                            prompt.setNumber(promptDo.getString("number"));
                            DynamicObjectCollection varConfigDoc = promptDo.getDynamicObjectCollection("var_configs");
                            if (varConfigDoc != null) {
                                ArrayList<VarParam> varParams = new ArrayList<VarParam>(varConfigDoc.size());
                                for (DynamicObject varParamDo : varConfigDoc) {
                                    VarParam varParam = new VarParam();
                                    varParam.setKey(varParamDo.getString("var"));
                                    varParam.setName(varParamDo.getString("var_name"));
                                    varParam.setType(varParamDo.getString("var_type"));
                                    varParams.add(varParam);
                                }
                                prompt.setVarParams(varParams);
                            }
                            promptList.add(prompt);
                        }
                    }
                }
                if (processDoc != null && !processDoc.isEmpty()) {
                    processList = new ArrayList<Process>(processDoc.size());
                    for (DynamicObject processDo : processDoc) {
                        DynamicObject referProcesslDo = processDo.getDynamicObject("process");
                        if (referProcesslDo == null) continue;
                        Process process = new Process();
                        process.setId((Long)referProcesslDo.getPkValue());
                        process.setName(referProcesslDo.getString("name"));
                        process.setNumber(referProcesslDo.getString("number"));
                        process.setDescription(referProcesslDo.getString("servicedesc"));
                        process.setFflow(referProcesslDo.getString("flow"));
                        processList.add(process);
                    }
                }
            }
            agent.setQuestionList(questionList);
            agent.setRepoList(repoList);
            agent.setToolList(toolList);
            agent.setPromptList(promptList);
            agent.setProcessList(processList);
            agent.setOpenApiList(openApiList);
        }
        return agent;
    }

    public static Map<String, AgentSample> getAgentMap(List<Long> agentIdList) {
        if (CollectionUtils.isNotEmpty(agentIdList)) {
            agentIdList = agentIdList.stream().distinct().collect(Collectors.toList());
        }
        Map<String, AgentSample> map = new HashMap<String, AgentSample>(10);
        DynamicObject[] doArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_AGENT.getId(), (String)"id,name,number,description,picture,bgcolor,prologue,type,modifytime", (QFilter[])new QFilter("id", "in", agentIdList).toArray());
        if (doArr != null && doArr.length > 0) {
            ArrayList<AgentSample> agentSampleList = new ArrayList<AgentSample>(doArr.length);
            for (DynamicObject agentDo : doArr) {
                AgentSample agentSample = new AgentSample();
                agentSample.setAssistantId(StrUtils.longAsString((Long)agentDo.getPkValue()));
                agentSample.setNumber(agentDo.getString("number"));
                agentSample.setName(agentDo.getString("name"));
                agentSample.setDescription(agentDo.getString("description"));
                agentSample.setPrologue(agentDo.getString("prologue"));
                agentSample.setType(agentDo.getString("type"));
                agentSample.setModifyTime(agentDo.getString("modifytime"));
                String picture = agentDo.getString("picture");
                picture = AgentService.assemblyPictureWebUrl(picture);
                agentSample.setPicture(picture);
                agentSampleList.add(agentSample);
            }
            map = agentSampleList.stream().collect(Collectors.toMap(AgentSample::getAssistantId, obj -> obj));
        }
        return map;
    }

    @Nullable
    public static String assemblyPictureWebUrl(String picture) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)picture)) {
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)picture, (CharSequence)"/kingdee/gai/images/pc/agent/avatar/common_agent.png")) {
                picture = PictureAvatarService.getDomainContextUrl() + "/kingdee/gai/images/pc/agent/avatar/common_agent.png";
            } else if (!picture.startsWith("http")) {
                picture = UrlService.getImageFullUrl((String)picture);
            }
        }
        if (!picture.contains("kdcdc")) {
            RequestContext rc = RequestContext.get();
            picture = String.format("%s%s%s", picture, "?kdcdc=", rc.getAccountId());
        }
        return picture;
    }

    public static List<AgentSample> getAgentListByIdList(List<Long> agentIdList, String appNumber, boolean forceShowAllAgent, boolean checkBlg) {
        if (checkBlg) {
            Set<Long> hasLicenceAgentIdList = GPTLicenseHelper.getUseBizIds(GaiFormIdEnum.GAI_AGENT.getId(), new HashSet<Long>(agentIdList));
            agentIdList = new ArrayList<Long>(hasLicenceAgentIdList);
        }
        ArrayList agentSampleList = Lists.newArrayListWithExpectedSize((int)agentIdList.size());
        if (CollectionUtils.isNotEmpty(agentIdList)) {
            Map agentDoArr;
            String selectFields = "id,name,number,description,picture,bgcolor,prologue,type,modifytime,gai_agent_start.id,gai_agent_start.question";
            QFilter filter = new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr()).and("id", "in", agentIdList);
            if (!forceShowAllAgent) {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)appNumber) && !org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)appNumber, (CharSequence)"main")) {
                    AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appNumber);
                    if (appInfo != null) {
                        String id = appInfo.getId();
                        QFilter appFilter = new QFilter("app.fbasedataid", "=", (Object)id).or("app.fbasedataid", "is null", null);
                        filter.and(appFilter);
                    } else {
                        QFilter appFilter = new QFilter("app.fbasedataid", "is null", null);
                        filter.and(appFilter);
                    }
                } else {
                    QFilter appFilter = new QFilter("app.fbasedataid", "is null", null);
                    filter.and(appFilter);
                }
            }
            if ((agentDoArr = BusinessDataServiceHelper.loadFromCache((String)GaiFormIdEnum.GAI_AGENT.getId(), (String)selectFields, (QFilter[])filter.toArray())) != null && agentDoArr.size() > 0) {
                for (DynamicObject agentDo : agentDoArr.values()) {
                    AgentSample agentSample = AgentService.trans2AgentSample(agentDo);
                    agentSampleList.add(agentSample);
                }
            }
        }
        return agentSampleList;
    }

    public static List<AgentSample> getAgentListByIdList(List<Long> agentIdList, boolean checkBlg) {
        List<Object> agentSampleList = Lists.newArrayListWithExpectedSize((int)agentIdList.size());
        if (CollectionUtils.isNotEmpty(agentIdList)) {
            String selectFields = "id,name,number,description,picture,bgcolor,prologue,type,modifytime,gai_agent_start.id,gai_agent_start.question";
            QFilter filter = new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr()).and("id", "in", agentIdList);
            Map agentDoArr = BusinessDataServiceHelper.loadFromCache((String)GaiFormIdEnum.GAI_AGENT.getId(), (String)selectFields, (QFilter[])filter.toArray());
            if (agentDoArr != null && agentDoArr.size() > 0) {
                for (DynamicObject agentDo : agentDoArr.values()) {
                    AgentSample agentSample = AgentService.trans2AgentSample(agentDo);
                    agentSampleList.add(agentSample);
                }
            }
            if (checkBlg) {
                agentSampleList = AgentService.getAgentListByCheckLic((List<AgentSample>)agentSampleList);
            }
        }
        return agentSampleList;
    }

    private static List<AgentSample> getAgentListByCheckLic(List<AgentSample> agentList) {
        Set<Long> agentIdList = agentList.stream().map(agent -> Long.valueOf(agent.getAgentId())).collect(Collectors.toSet());
        Set<Long> hasBlgAgentIdList = GPTLicenseHelper.getUseBizIds(GaiFormIdEnum.GAI_AGENT.getId(), agentIdList);
        log.info("usedAgentIdList: {}", (Object)hasBlgAgentIdList.toString());
        return agentList.stream().filter(agent -> hasBlgAgentIdList.contains(Long.valueOf(agent.getAgentId()))).collect(Collectors.toList());
    }

    public static PageResult<AgentSample> getAgentSamplePage(PageQuery pageQuery) {
        String searchKey = pageQuery.getSearchKey();
        int pageSize = pageQuery.getPageSize() != null ? pageQuery.getPageSize() : -1;
        Long lastAssistantId = pageQuery.getLasId();
        List<Long> idList = pageQuery.getIdList();
        PageResult<AgentSample> pageResult = new PageResult<AgentSample>();
        QFilter qFilter = new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr());
        if (CollectionUtils.isNotEmpty(idList)) {
            qFilter.and("id", "in", idList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)searchKey)) {
            qFilter.and("name", "like", (Object)("%" + searchKey + "%"));
        }
        if (lastAssistantId != null && lastAssistantId > 0L) {
            DynamicObject lastDo = BusinessDataServiceHelper.loadSingle((Object)lastAssistantId, (String)GaiFormIdEnum.GAI_AGENT.getId());
            qFilter.and("modifytime", "<", (Object)lastDo.getDate("modifytime"));
        }
        int loadPageSize = pageSize == -1 ? pageSize : pageSize + 1;
        List<AgentSample> agentSampleList = new ArrayList<AgentSample>();
        DynamicObject[] agentDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_AGENT.getId(), (String)"id,name,number,description,picture,bgcolor,prologue,type,modifytime,gai_agent_start.id,gai_agent_start.question", (QFilter[])qFilter.toArray(), (String)String.format("%s desc, id desc", "modifytime"), (int)loadPageSize);
        if (agentDoArr != null && agentDoArr.length > 0) {
            for (DynamicObject agentDo : agentDoArr) {
                AgentService.checkPictureIfPreset(agentDo);
                AgentSample agentSample = AgentService.trans2AgentSample(agentDo);
                agentSampleList.add(agentSample);
            }
            if (pageSize != -1 && agentSampleList.size() > pageSize) {
                pageResult.setHasMore(true);
                agentSampleList = agentSampleList.subList(0, agentSampleList.size() - 1);
            }
            pageResult.setList(agentSampleList);
        }
        return pageResult;
    }

    public static PageResult<Agent> getAgentPage(PageQuery pageQuery) {
        List idList;
        DynamicObject[] agentDoArr;
        PageResult<Agent> pageResult = new PageResult<Agent>();
        PageResult<AgentSample> agentPageResult = AgentService.getAgentSamplePage(pageQuery);
        pageResult.setHasMore(agentPageResult.getHasMore());
        List<AgentSample> agentSampleList = agentPageResult.getList();
        ArrayList<Agent> agentList = new ArrayList<Agent>();
        if (CollectionUtils.isNotEmpty(agentSampleList) && (agentDoArr = BusinessDataServiceHelper.load((Object[])(idList = agentSampleList.stream().map(o -> Long.parseLong(o.getAgentId())).collect(Collectors.toList())).toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_AGENT.getId()).getDynamicObjectType())) != null && agentDoArr.length > 0) {
            AiccAgentConfig aiccAgentConfig = AgentServiceService.getAgentService("gai_agent");
            for (DynamicObject agentDo : agentDoArr) {
                Agent agent = AgentService.trans2Agent(agentDo, true, aiccAgentConfig);
                agentList.add(agent);
            }
        }
        pageResult.setList(agentList);
        return pageResult;
    }

    public static void checkPictureIfPreset(DynamicObject agentDo) {
        agentDo = BusinessDataServiceHelper.loadSingle((Object)agentDo.getPkValue(), (String)GaiFormIdEnum.GAI_AGENT.getId());
        String picture = agentDo.getString("picture");
        String picturePrefix = "/kingdee/";
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)picture) && org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)picture, (CharSequence)picturePrefix)) {
            picture = PictureAvatarService.uploadPresetPicture2ImageServer(picture);
            agentDo.set("picture", (Object)picture);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agentDo});
        }
    }

    public static AgentSample trans2AgentSample(DynamicObject agentDo) {
        AgentSample agentSample = null;
        if (agentDo != null) {
            agentSample = new AgentSample();
            String id = StrUtils.longAsString((Long)agentDo.getPkValue());
            agentSample.setAgentId(id);
            agentSample.setAssistantId(id);
            agentSample.setNumber(agentDo.getString("number"));
            agentSample.setName(agentDo.getString("name"));
            agentSample.setDescription(agentDo.getString("description"));
            agentSample.setPrologue(agentDo.getString("prologue"));
            agentSample.setType(agentDo.getString("type"));
            String picture = agentDo.getString("picture");
            if (picture != null) {
                picture = AgentService.assemblyPictureWebUrl(picture);
                agentSample.setPicture(picture);
            } else {
                agentSample.setPicture(PictureAvatarService.getPictureByAgentName(null));
            }
            agentSample.setBgColor(agentDo.getString("bgcolor"));
            Date modifyTimeDate = agentDo.getDate("modifytime");
            if (modifyTimeDate != null) {
                agentSample.setModifyTime(KDDateFormatUtils.getDateTimeFormat().format(modifyTimeDate));
            }
            DynamicObjectCollection questionDoc = agentDo.getDynamicObjectCollection("gai_agent_start");
            ArrayList<Question> questionList = null;
            if (questionDoc != null && !questionDoc.isEmpty()) {
                questionList = new ArrayList<Question>();
                for (DynamicObject questionDo : questionDoc) {
                    if (questionDo.get("question") == null) continue;
                    ILocaleString questionLocaleString = questionDo.getLocaleString("question");
                    Question question = new Question();
                    question.setId(StrUtils.longAsString((Long)questionDo.getPkValue()));
                    question.setValue(questionLocaleString.getLocaleValue());
                    questionList.add(question);
                }
            }
            agentSample.setQuestionList(questionList);
        }
        return agentSample;
    }

    public static String getAgentName(String skillType, long skillId) {
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)Skill.Type.PROCESS.name())) {
            DynamicObject processDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.GAI_PROCESS.getId(), (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)skillId).toArray());
            ILocaleString name = processDo.getLocaleString("name");
            return name.getLocaleValue();
        }
        DynamicObject agentDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.GAI_AGENT.getId(), (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)skillId).toArray());
        ILocaleString name = agentDo.getLocaleString("name");
        return name.getLocaleValue();
    }
}

