/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.util.ToolUtils;
import kd.ai.gai.core.domain.dto.agent.AgentTool;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class AgentToolService {
    private static final Log log = LogFactory.getLog(AgentToolService.class);

    public static AgentTool getAgentTool(long id) {
        String toolType;
        AgentTool tool = null;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"gai_tool");
        if (dynamicObject != null) {
            tool = new AgentTool();
            toolType = dynamicObject.getString("tool_type");
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                String allConfig = dynamicObject.getString("config_tag");
                JSONObject obj = JSONObject.parseObject((String)allConfig);
                ToolUtils.handlerOpenAPIAuthInfo(id, obj);
                JSONObject swaggerConfig = obj.getJSONObject("llmSchema");
                tool.setConfigTag(swaggerConfig);
                tool.setConfig(allConfig);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
                String allConfig = dynamicObject.getString("config_tag");
                JSONObject actionConfig = AgentToolService.getCustomActionToolConfig(allConfig);
                ToolUtils.handlerCosmicToolAuthInfo(id, actionConfig);
                log.info("\u81ea\u5b9a\u4e49\u64cd\u4f5c\u63cf\u8ff0\u4fe1\u606f : {}", (Object)JSONObject.toJSONString((Object)actionConfig));
                tool.setConfigTag(actionConfig);
                tool.setConfig(allConfig);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType())) {
                String allConfig = dynamicObject.getString("config_tag");
                JSONObject obj = ToolUtils.handlerToolParam(id, JSONObject.parseObject((String)allConfig));
                tool.setConfigTag(obj);
                tool.setConfig(JSONObject.toJSONString((Object)obj));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u5177\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"AgentToolService_1", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        tool.setType(toolType);
        tool.setToolId(dynamicObject.getLong("id"));
        tool.setNumber(dynamicObject.getString("number"));
        tool.setName(dynamicObject.getString("name"));
        tool.setDescription(dynamicObject.getString("description"));
        tool.setSource(dynamicObject.getString("source"));
        log.info("\u83b7\u53d6\u5de5\u5177\u8be6\u60c5 : {}", (Object)JSONObject.toJSONString((Object)tool));
        return tool;
    }

    public static JSONObject getCustomActionToolConfig(String config) {
        if (StringUtils.isEmpty((CharSequence)config)) {
            return new JSONObject();
        }
        JSONObject actionConfig = JSONObject.parseObject((String)config);
        JSONObject data = new JSONObject();
        JSONArray inputs = actionConfig.getJSONArray("inputParams");
        JSONArray outputs = actionConfig.getJSONArray("outputParams");
        JSONArray configParams = actionConfig.getJSONArray("configParams");
        data.put("inputParams", (Object)inputs);
        data.put("outputParams", (Object)outputs);
        data.put("configParams", (Object)configParams);
        data.put("action", (Object)actionConfig.getString("action"));
        data.put("appId", (Object)actionConfig.getString("appId"));
        data.put("serviceName", (Object)actionConfig.getString("serviceName"));
        return data;
    }
}

