/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.ai.gai.core.api.mservice.query.MsRequiredParams;
import kd.ai.gai.core.domain.dto.CallBackInfo;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.ApiChatMessageDTO;
import kd.ai.gai.core.domain.dto.agent.ChatMessageDTO;
import kd.ai.gai.core.domain.dto.agent.ChatSessionDTO;
import kd.ai.gai.core.domain.dto.agent.ChatUser;
import kd.ai.gai.core.domain.dto.agent.Feedback;
import kd.ai.gai.core.domain.dto.agent.GaiMsgConfig;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.PageQuery;
import kd.ai.gai.core.domain.dto.agent.PageResult;
import kd.ai.gai.core.domain.dto.agent.Run;
import kd.ai.gai.core.domain.dto.agent.RunStep;
import kd.ai.gai.core.domain.dto.agent.RunStepMessage;
import kd.ai.gai.core.domain.dto.agent.annotations.BaseAnnotation;
import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.AgentMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.agent.CtrlStrategyEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.RoleModeEnum;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.enuz.agent.RunStepTypeEnum;
import kd.ai.gai.core.enuz.op.UserFeedbackTypeEnum;
import kd.ai.gai.core.rag.split.TextSplitter;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.agent.RunService;
import kd.ai.gai.core.service.agent.TraceLogService;
import kd.ai.gai.core.service.op.IClientTypeService;
import kd.ai.gai.core.service.op.IUserFeedbackService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.trace.entity.StepLog;
import kd.ai.gai.core.trace.util.ThreadUtils;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ChatService {
    private static final Log log = LogFactory.getLog(ChatService.class);
    private static final IClientTypeService clientTypeService = IClientTypeService.create();

    public static ChatSessionDTO saveChatSession(String chatSessionId, String title, long assistantId, EnableEnum enableEnum) {
        Context context = FlowCacheData.getContext(chatSessionId);
        String lastMessage = title = AnnotationService.clearTags(title);
        if (StringUtils.length((CharSequence)title) > 25) {
            title = StringUtils.substring((String)title, (int)0, (int)25);
        }
        if (StringUtils.length((CharSequence)lastMessage) > 45) {
            lastMessage = StringUtils.substring((String)lastMessage, (int)0, (int)45) + "...";
        }
        RequestContext rc = RequestContext.get();
        long userOrgId = rc.getOrgId();
        long id = ID.genLongId();
        DynamicObject chatSessionDo = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_CHAT_SESSION.getId());
        chatSessionDo.set("id", (Object)id);
        chatSessionDo.set("lastmessagetime", (Object)KDDateUtils.now());
        chatSessionDo.set("name", (Object)title);
        chatSessionDo.set("lastusermessage", (Object)lastMessage);
        chatSessionDo.set("assistantid", (Object)assistantId);
        chatSessionDo.set("chatsessionid", (Object)chatSessionId);
        chatSessionDo.set("masterid", (Object)id);
        chatSessionDo.set("enable", (Object)enableEnum.getKeyStr());
        chatSessionDo.set("ctrlstrategy", (Object)CtrlStrategyEnum.ALL.getId());
        chatSessionDo.set("org", (Object)userOrgId);
        chatSessionDo.set("createorg", (Object)userOrgId);
        chatSessionDo.set("useorg", (Object)userOrgId);
        if (context != null) {
            chatSessionDo.set("clienttype", (Object)clientTypeService.slideEnv2ClientType(context.getSlideenv()).getId());
            chatSessionDo.set("opusername", (Object)context.getOpUserName());
            chatSessionDo.set("creator", (Object)(context.getOpUserId() != null && context.getOpUserId() > 0L ? BusinessDataServiceHelper.loadSingleFromCache((Object)context.getOpUserId(), (String)"bos_user") : UserServiceHelper.getCurrentUser((String)"id")));
            String jsonString = JSON.toJSONString((Object)context);
            chatSessionDo.set("context_tag", (Object)jsonString);
        }
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chatSessionDo});
        BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject)chatSessionDo, (Long)userOrgId);
        if (saveObjs != null && saveObjs.length > 0) {
            log.info("save success size: {}", (Object)saveObjs.length);
            return ChatService.transChatSessionDTO(chatSessionDo);
        }
        log.info("save fail.");
        return null;
    }

    public static Map<Long, String> getSessionIdList(List<String> chatSessionIdList) {
        DynamicObject[] doArr;
        HashMap<Long, String> map = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(chatSessionIdList) && (doArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_CHAT_SESSION.getId(), (String)"id,chatsessionid", (QFilter[])new QFilter("chatsessionid", "in", chatSessionIdList).toArray())) != null) {
            for (DynamicObject dynamicObject : doArr) {
                map.put((Long)dynamicObject.getPkValue(), dynamicObject.getString("chatsessionid"));
            }
        }
        return map;
    }

    public static ChatSessionDTO getChatSession(String chatSessionId) {
        ChatSessionDTO chatSessionDTO = null;
        DynamicObject chatSessionDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.GAI_CHAT_SESSION.getId(), (QFilter[])new QFilter("chatsessionid", "=", (Object)chatSessionId).toArray());
        if (chatSessionDo != null) {
            chatSessionDTO = ChatService.transChatSessionDTO(chatSessionDo);
        }
        return chatSessionDTO;
    }

    public static ChatSessionDTO getChatSession(Long sessionId) {
        ChatSessionDTO chatSessionDTO = null;
        DynamicObject chatSessionDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.GAI_CHAT_SESSION.getId(), (QFilter[])new QFilter("id", "=", (Object)sessionId).toArray());
        if (chatSessionDo != null) {
            chatSessionDTO = ChatService.transChatSessionDTO(chatSessionDo);
        }
        return chatSessionDTO;
    }

    public static void pushAssistantStreamThinkMessage(Context context, Message message, String streamThinkMessage, int seqNo) {
        Run run = RunService.getRunById(message.getRunId());
        String runId = StrUtils.longAsString(message.getRunId());
        String messageId = StrUtils.longAsString(message.getMessageId());
        String runStepId = StrUtils.longAsString(message.getRunStepId());
        if (StringUtils.isNotEmpty((CharSequence)streamThinkMessage)) {
            ChatMessageDTO chatMessageDTO = new ChatMessageDTO();
            chatMessageDTO.setId(context.getChatSessionId());
            chatMessageDTO.setTaskId(runId);
            chatMessageDTO.setMessageId(messageId);
            chatMessageDTO.setType(message.getType());
            chatMessageDTO.setRunId(runId);
            chatMessageDTO.setRunStepId(runStepId);
            chatMessageDTO.setStream(true);
            chatMessageDTO.setMessage(streamThinkMessage);
            chatMessageDTO.setSeqNo(seqNo);
            if (run != null) {
                chatMessageDTO.setRunStatus(run.getRunStatus());
            }
            PushMsgService.pushResult(context, ResultActionType.think_chat.name(), chatMessageDTO);
        }
    }

    public static void pushAssistantStreamMessage(Context context, Message message, String streamMessageContent, boolean isEnd, String configTag, int seqNo) {
        String contentTag = message.getContentTag();
        String skillMessageCache = "skillMessageCache_" + message.getMessageId();
        Skill skill = (Skill)EngineCache.getAppCache(context.getChatSessionId()).get(skillMessageCache, Skill.class);
        if (skill == null) {
            skill = ChatService.getSkill(message);
            EngineCache.getAppCache(context.getChatSessionId()).put(skillMessageCache, (Object)skill);
        }
        Run run = RunService.getRunById(message.getRunId());
        if (StringUtils.isNotEmpty((CharSequence)contentTag)) {
            String runId;
            String taskId = runId = StrUtils.longAsString(message.getRunId());
            String messageId = StrUtils.longAsString(message.getMessageId());
            String runStepId = StrUtils.longAsString(message.getRunStepId());
            if (StringUtils.isNotEmpty((CharSequence)streamMessageContent)) {
                List<BaseAnnotation> annotationList = AnnotationService.parseMessageAnnotations(contentTag);
                ChatMessageDTO chatMessageDTO = new ChatMessageDTO();
                chatMessageDTO.setId(context.getChatSessionId());
                chatMessageDTO.setTaskId(taskId);
                chatMessageDTO.setMessageId(messageId);
                chatMessageDTO.setType(message.getType());
                chatMessageDTO.setRunId(runId);
                chatMessageDTO.setRunStepId(runStepId);
                chatMessageDTO.setStream(true);
                chatMessageDTO.setSkill(skill);
                chatMessageDTO.setAnnotations(annotationList);
                chatMessageDTO.setMessage(streamMessageContent);
                chatMessageDTO.setIndex(contentTag.length());
                chatMessageDTO.setSeqNo(seqNo);
                if (run != null) {
                    chatMessageDTO.setRunStatus(run.getRunStatus());
                }
                PushMsgService.pushResult(context, ResultActionType.chat.name(), chatMessageDTO);
            }
            if (isEnd) {
                PushMsgService.pushStreamDown(context, runId, "0", "", messageId, runId);
                PushMsgService.pushWaitingDone(context, 0L, runId);
                EngineCache.getAppCache(context.getChatSessionId()).remove(skillMessageCache);
                ChatService.callbackV1(message, configTag);
            }
        }
    }

    public static void pushAssistantStreamMessage(Context context, Message message, String streamMessageContent, boolean isEnd, String configTag, int seqNo, String taskId) {
        String contentTag = message.getContentTag();
        String skillMessageCache = "skillMessageCache_" + message.getMessageId();
        Skill skill = (Skill)EngineCache.getAppCache(context.getChatSessionId()).get(skillMessageCache, Skill.class);
        if (skill == null) {
            skill = ChatService.getSkill(message);
            EngineCache.getAppCache(context.getChatSessionId()).put(skillMessageCache, (Object)skill);
        }
        Run run = RunService.getRunById(message.getRunId());
        if (StringUtils.isNotEmpty((CharSequence)contentTag)) {
            String runId = StrUtils.longAsString(message.getRunId());
            String messageId = StrUtils.longAsString(message.getMessageId());
            String runStepId = StrUtils.longAsString(message.getRunStepId());
            if (StringUtils.isNotEmpty((CharSequence)streamMessageContent)) {
                List<BaseAnnotation> annotationList = AnnotationService.parseMessageAnnotations(contentTag);
                ChatMessageDTO chatMessageDTO = new ChatMessageDTO();
                chatMessageDTO.setId(context.getChatSessionId());
                chatMessageDTO.setTaskId(taskId);
                chatMessageDTO.setMessageId(messageId);
                chatMessageDTO.setType(message.getType());
                chatMessageDTO.setRunId(runId);
                chatMessageDTO.setRunStepId(runStepId);
                chatMessageDTO.setStream(true);
                chatMessageDTO.setSkill(skill);
                chatMessageDTO.setAnnotations(annotationList);
                chatMessageDTO.setMessage(streamMessageContent);
                chatMessageDTO.setIndex(contentTag.length());
                chatMessageDTO.setSeqNo(seqNo);
                if (run != null) {
                    chatMessageDTO.setRunStatus(run.getRunStatus());
                }
                PushMsgService.pushResult(context, ResultActionType.chat.name(), chatMessageDTO);
            }
            if (isEnd) {
                PushMsgService.pushStreamDown(context, runId, "0", "", messageId, runId);
                PushMsgService.pushWaitingDone(context, 0L, runId);
                EngineCache.getAppCache(context.getChatSessionId()).remove(skillMessageCache);
                ChatService.callbackV1(message, configTag);
            }
        }
    }

    private static void callbackV1(Message message, String configTag) {
        log.info("lastUserMessage:{}, configTag:{}", (Object)message.getMessageId(), (Object)configTag);
        if (StringUtils.isNotEmpty((CharSequence)configTag)) {
            JSONObject configJo = JSONObject.parseObject((String)configTag);
            CallBackInfo callBackInfo = null;
            JSONObject callBackInfoJo = configJo.getJSONObject("callBackInfo");
            if (callBackInfoJo != null) {
                callBackInfo = (CallBackInfo)JSONObject.toJavaObject((JSON)callBackInfoJo, CallBackInfo.class);
                log.info("start trigger callback ...");
                MsRequiredParams msRequiredParams = null;
                JSONObject msRequiredParamsJo = configJo.getJSONObject("requiredParams");
                if (msRequiredParamsJo != null) {
                    msRequiredParams = (MsRequiredParams)JSONObject.toJavaObject((JSON)msRequiredParamsJo, MsRequiredParams.class);
                }
                ApiChatMessageDTO apiChatMessageDTO = MessageService.getAssistantMessage(message.getRunId());
                log.info("execute mservice requiredParams:{}, bizParams:{}", (Object)JSONObject.toJSONString((Object)msRequiredParams), (Object)JSONObject.toJSONString((Object)apiChatMessageDTO));
                Object obj = DispatchServiceHelper.invokeBizService((String)callBackInfo.getCloudId(), (String)callBackInfo.getAppId(), (String)callBackInfo.getServiceName(), (String)callBackInfo.getMethodName(), (Object[])new Object[]{JSONObject.toJSONString((Object)msRequiredParams), JSONObject.toJSONString((Object)apiChatMessageDTO)});
                log.info("callback result : {}", (Object)JSONObject.toJSONString((Object)obj));
            }
        }
    }

    public static void pushUserOrAssistantMessage(Context context, Message message) {
        String contentTag = message.getContentTag();
        GaiMsgConfig gaiMsgConfig = AnnotationService.parseGaiMsgConfig(contentTag);
        if (gaiMsgConfig != null && !gaiMsgConfig.getNeedPushMsg().booleanValue()) {
            return;
        }
        Skill skill = ChatService.getSkill(message);
        boolean stream = ChatMessageTypeEnum.ASSISTANT.getId().intValue() == message.getType().intValue();
        Run run = RunService.getRunById(message.getRunId());
        if (StringUtils.isNotEmpty((CharSequence)contentTag)) {
            List<String> textList;
            List<String> tagAndContentList = AnnotationService.parseTagAndContentList(contentTag);
            if (CollectionUtils.isNotEmpty(tagAndContentList)) {
                for (int i = 0; i < tagAndContentList.size(); ++i) {
                    contentTag = StringUtils.replace((String)contentTag, (String)tagAndContentList.get(i), (String)String.format("[gaitag]%s[/gaitag]", i));
                }
            }
            List<String> list = textList = stream ? TextSplitter.splitText(contentTag) : Collections.singletonList(contentTag);
            if (CollectionUtils.isNotEmpty(textList)) {
                String runId;
                List<BaseAnnotation> annotationList = AnnotationService.parseMessageAnnotations(message.getContentTag());
                String taskId = runId = StrUtils.longAsString(message.getRunId());
                String messageId = StrUtils.longAsString(message.getMessageId());
                String runStepId = StrUtils.longAsString(message.getRunStepId());
                ChatMessageDTO chatMessageDTO = new ChatMessageDTO();
                chatMessageDTO.setId(context.getChatSessionId());
                chatMessageDTO.setTaskId(taskId);
                chatMessageDTO.setMessageId(messageId);
                chatMessageDTO.setType(message.getType());
                chatMessageDTO.setRunId(runId);
                chatMessageDTO.setRunStepId(runStepId);
                chatMessageDTO.setStream(true);
                chatMessageDTO.setSkill(skill);
                chatMessageDTO.setAnnotations(annotationList);
                if (run != null) {
                    chatMessageDTO.setRunStatus(run.getRunStatus());
                }
                StringBuilder pushedMsgSb = new StringBuilder();
                ChatMessageDTO streamDoneMessageDTO = chatMessageDTO;
                int index = 0;
                for (int i = 0; i < textList.size(); ++i) {
                    ThreadUtils.sleep(RandomUtils.nextInt((int)0, (int)500));
                    if (run != null && MessageService.userMessageCancelled(run.getMessageId())) {
                        log.info("user message cancelled : {}", (Object)run.getMessageId());
                        DynamicObject messageDo = BusinessDataServiceHelper.loadSingle((Object)message.getMessageId(), (String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId());
                        if (messageDo != null) {
                            messageDo.set("content_tag", (Object)pushedMsgSb.toString());
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{messageDo});
                        }
                        return;
                    }
                    String text = textList.get(i);
                    List<String> gaitagAndContentList = AnnotationService.parseTagAndContentList(text);
                    if (CollectionUtils.isNotEmpty(gaitagAndContentList)) {
                        for (int j = 0; j < gaitagAndContentList.size(); ++j) {
                            String gaitagAndContent = gaitagAndContentList.get(j);
                            int gaitagIndex = Integer.parseInt(gaitagAndContent.replace("[gaitag]", "").replace("[/gaitag]", ""));
                            text = StringUtils.replace((String)text, (String)gaitagAndContent, (String)tagAndContentList.get(gaitagIndex));
                        }
                    }
                    chatMessageDTO.setMessage(text);
                    chatMessageDTO.setIndex(index);
                    index += text.length();
                    PushMsgService.pushResult(context, ResultActionType.chat.name(), chatMessageDTO);
                    pushedMsgSb.append(text);
                }
                streamDoneMessageDTO.setMessage(null);
                streamDoneMessageDTO.setRunStepId(null);
                streamDoneMessageDTO.setAnnotations(null);
                PushMsgService.pushResult(context, ResultActionType.streamDone.name(), streamDoneMessageDTO);
            }
            PushMsgService.pushWaitingDone(context, 0L, String.valueOf(message.getRunId()));
        }
    }

    private static Skill getSkill(Message message) {
        Skill skill = null;
        Long skillId = message.getSkillId();
        if (skillId != null && skillId > 0L) {
            String skillType = message.getSkillType();
            DynamicObject skillDo = null;
            skillDo = StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)Skill.Type.PROCESS.name()) ? BusinessDataServiceHelper.loadSingle((Object)skillId, (String)GaiFormIdEnum.GAI_PROCESS.getId()) : BusinessDataServiceHelper.loadSingle((Object)skillId, (String)GaiFormIdEnum.GAI_AGENT.getId());
            if (skillDo != null) {
                skill = new Skill();
                skill.setId(String.valueOf(skillDo.getPkValue()));
                skill.setName(skillDo.getString("name"));
                skill.setType(Skill.getTypeByName(skillType));
                if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)Skill.Type.AGENT.name())) {
                    skill.setPicture(AgentService.assemblyPictureWebUrl(skillDo.getString("picture")));
                }
            }
        }
        return skill;
    }

    public static ChatUser getChatUser() {
        return ChatService.getChatUser(RequestContext.get().getCurrUserId());
    }

    public static ChatUser getChatUser(long userId) {
        DynamicObject userDo = UserServiceHelper.getCurrentUser((String)"name");
        ChatUser chatUser = new ChatUser();
        chatUser.setUserId(StrUtils.longAsString(userId));
        chatUser.setUserName(userDo.getString("name"));
        Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)true);
        chatUser.setPicture((String)userAvatarPathMap.get(userId));
        return chatUser;
    }

    public static PageResult<ChatMessageDTO> getChatMessagePage(String chatSessionId, PageQuery pageQuery) {
        PageResult<ChatMessageDTO> pageResult = new PageResult<ChatMessageDTO>();
        ChatSessionDTO chatSessionDTO = ChatService.getChatSession(chatSessionId);
        if (chatSessionDTO != null) {
            long sessionId = Long.parseLong(chatSessionDTO.getSessionId());
            String searchKey = pageQuery.getSearchKey();
            int pageSize = pageQuery.getPageSize();
            Long lastMessageId = pageQuery.getLasId();
            QFilter qFilter = new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr()).and("sessionid", "=", (Object)sessionId).and("type", "in", Arrays.asList(ChatMessageTypeEnum.USER.getId(), ChatMessageTypeEnum.ASSISTANT.getId(), ChatMessageTypeEnum.PROCESS.getId(), ChatMessageTypeEnum.VISION.getId()));
            if (StringUtils.isNotEmpty((CharSequence)searchKey)) {
                qFilter.and("name", "like", (Object)("%" + searchKey + "%"));
            }
            if (lastMessageId != null && lastMessageId > 0L) {
                qFilter.and("id", "<", (Object)lastMessageId);
            }
            int loadPageSize = pageSize == -1 ? pageSize : pageSize + 1;
            DynamicObject[] chatMessageDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId(), (String)"id,sessionid,type,content_tag,runid,runstepid,createtime,config_tag,thought_tag,assistantid,skillid,skilltype,skillsrc,msgstatus,chattraceid", (QFilter[])qFilter.toArray(), (String)"id desc", (int)loadPageSize);
            List<ChatMessageDTO> chatMessageDTOList = ChatService.transChatMessageDTOList(chatSessionId, chatMessageDoArr);
            if (CollectionUtils.isNotEmpty(chatMessageDTOList)) {
                if (pageSize != -1 && chatMessageDTOList.size() > pageSize) {
                    pageResult.setHasMore(true);
                    chatMessageDTOList = chatMessageDTOList.subList(0, chatMessageDTOList.size() - 1);
                }
                ChatService.fillUserFeedback(chatMessageDTOList);
                ChatService.fillRunInfo(chatMessageDTOList);
                ChatService.fillRunStepChatList(chatMessageDTOList);
                ChatService.fillSkillInfo(chatMessageDTOList);
            }
            chatMessageDTOList = chatMessageDTOList.stream().sorted(Comparator.comparingLong(chatMessageDTO -> Long.parseLong(chatMessageDTO.getMessageId()))).collect(Collectors.toList());
            pageResult.setList(chatMessageDTOList);
        }
        return pageResult;
    }

    public static List<ChatMessageDTO> getChatMessageList(Set<Long> sessionIdList, Date startTime) {
        DynamicObject[] chatMessageDoArr;
        List<ChatMessageDTO> chatMessageDTOList;
        QFilter userTypeQFilter = new QFilter("type", "=", (Object)ChatMessageTypeEnum.USER.getId()).and("msgstatus", "=", (Object)RunStepStatusEnum.COMPLETED.getId());
        QFilter typeQFilter = new QFilter("type", "in", Arrays.asList(ChatMessageTypeEnum.ASSISTANT.getId(), ChatMessageTypeEnum.PROCESS.getId())).or(userTypeQFilter);
        QFilter qFilter = new QFilter("sessionid", "in", sessionIdList).and("enable", "=", (Object)EnableEnum.YES.getKeyStr()).and(typeQFilter);
        if (startTime != null) {
            qFilter.and("createtime", ">", (Object)startTime);
        }
        if (CollectionUtils.isNotEmpty(chatMessageDTOList = ChatService.transChatMessageDTOList(null, chatMessageDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId(), (String)"id,sessionid,type,content_tag,runid,runstepid,createtime,config_tag,thought_tag,assistantid,skillid,skilltype,skillsrc,msgstatus,chattraceid", (QFilter[])qFilter.toArray(), (String)"id asc")))) {
            ChatService.fillUserFeedback(chatMessageDTOList);
            ChatService.fillRunInfo(chatMessageDTOList);
        }
        return chatMessageDTOList;
    }

    private static List<ChatMessageDTO> fillSkillInfo(List<ChatMessageDTO> chatMessageDTOList) {
        if (CollectionUtils.isNotEmpty(chatMessageDTOList)) {
            DynamicObject[] agentDoArr;
            Skill skill;
            DynamicObject[] processDoArr;
            ArrayList<Long> processIdList = new ArrayList<Long>(10);
            ArrayList<Long> agentIdList = new ArrayList<Long>(10);
            for (ChatMessageDTO chatMessageDTO : chatMessageDTOList) {
                DynamicObject[] skill2 = chatMessageDTO.getSkill();
                if (skill2 == null || skill2.getType() == null) continue;
                Skill.Type type = skill2.getType();
                if (StringUtils.equalsIgnoreCase((CharSequence)type.name(), (CharSequence)Skill.Type.PROCESS.name())) {
                    processIdList.add(Long.parseLong(skill2.getId()));
                    continue;
                }
                agentIdList.add(Long.parseLong(skill2.getId()));
            }
            HashMap<String, Skill> skillMap = new HashMap<String, Skill>(10);
            if (CollectionUtils.isNotEmpty(processIdList) && (processDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_PROCESS.getId(), (String)"id,number,name", (QFilter[])new QFilter("id", "in", processIdList).toArray())) != null) {
                for (DynamicObject processDo : processDoArr) {
                    skill = new Skill();
                    skill.setId(String.valueOf(processDo.getPkValue()));
                    skill.setName(processDo.getString("name"));
                    skill.setType(Skill.Type.PROCESS);
                    skillMap.put(String.format("%s_%s", skill.getId(), skill.getType().name()), skill);
                }
            }
            if (CollectionUtils.isNotEmpty(agentIdList) && (agentDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_AGENT.getId(), (String)"id,number,name,picture", (QFilter[])new QFilter("id", "in", agentIdList).toArray())) != null) {
                for (DynamicObject agentDo : agentDoArr) {
                    skill = new Skill();
                    skill.setId(String.valueOf(agentDo.getPkValue()));
                    skill.setName(agentDo.getString("name"));
                    skill.setType(Skill.Type.AGENT);
                    skill.setPicture(AgentService.assemblyPictureWebUrl(agentDo.getString("picture")));
                    skillMap.put(String.format("%s_%s", skill.getId(), skill.getType().name()), skill);
                }
            }
            if (skillMap != null) {
                for (ChatMessageDTO chatMessageDTO : chatMessageDTOList) {
                    String key;
                    Skill skill3 = chatMessageDTO.getSkill();
                    if (skill3 == null) continue;
                    String skillId = skill3.getId();
                    String skillType = "";
                    Skill.Type type = skill3.getType();
                    if (type != null) {
                        skillType = type.name();
                    }
                    if ((skill3 = (Skill)skillMap.get(key = String.format("%s_%s", skillId, skillType))) == null) continue;
                    chatMessageDTO.setSkill(skill3);
                }
            }
        }
        return chatMessageDTOList;
    }

    private static List<ChatMessageDTO> fillUserFeedback(List<ChatMessageDTO> chatMessageDTOList) {
        if (CollectionUtils.isNotEmpty(chatMessageDTOList)) {
            List chatTraceIdList = chatMessageDTOList.stream().map(ChatMessageDTO::getChatTraceId).collect(Collectors.toList());
            DynamicObject[] userFeedbackDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_USER_FEEDBACK.getId(), (String)"id,chattraceid,feedbacktype,contenttype,content", (QFilter[])new QFilter("chattraceid", "in", chatTraceIdList).toArray());
            HashMap<String, Feedback> chatTraceIdFeedbackMap = new HashMap<String, Feedback>();
            if (userFeedbackDoArr != null) {
                for (DynamicObject userFeedbackDo : userFeedbackDoArr) {
                    String feedbackType = userFeedbackDo.getString("feedbacktype");
                    if (!StringUtils.equalsIgnoreCase((CharSequence)feedbackType, (CharSequence)UserFeedbackTypeEnum.TAP.getId()) && !StringUtils.equalsIgnoreCase((CharSequence)feedbackType, (CharSequence)UserFeedbackTypeEnum.LIKE.getId())) continue;
                    String chatTraceId = userFeedbackDo.getString("chattraceid");
                    Feedback feedback = new Feedback();
                    feedback.setFeedbackId(StrUtils.longAsString((Long)userFeedbackDo.getPkValue()));
                    feedback.setType(Integer.parseInt(feedbackType));
                    feedback.setContentType(userFeedbackDo.getString("contenttype"));
                    feedback.setContent(userFeedbackDo.getString("content"));
                    feedback.setChatTraceId(chatTraceId);
                    chatTraceIdFeedbackMap.put(chatTraceId, feedback);
                }
            }
            for (ChatMessageDTO chatMessageDTO : chatMessageDTOList) {
                Feedback feedback = (Feedback)chatTraceIdFeedbackMap.get(chatMessageDTO.getChatTraceId());
                chatMessageDTO.setFeedback(feedback);
            }
        }
        return chatMessageDTOList;
    }

    public static ChatMessageDTO getRunStepMessageByRunStepId(String chatSessionId, Long runStepId) {
        QFilter qFilter = new QFilter("runstepid", "=", (Object)runStepId).and("type", "=", (Object)ChatMessageTypeEnum.RUNSTEP.getId());
        DynamicObject[] chatMessageDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId(), (String)"id,sessionid,type,content_tag,runid,runstepid,createtime,thought_tag,config_tag,assistantid,skillid,skilltype,skillsrc,msgstatus,chattraceid", (QFilter[])qFilter.toArray());
        List<ChatMessageDTO> chatMessageDTOList = ChatService.transChatMessageDTOList(chatSessionId, chatMessageDoArr);
        return CollectionUtils.isNotEmpty(chatMessageDTOList) ? chatMessageDTOList.get(0) : null;
    }

    private static List<ChatMessageDTO> fillRunInfo(List<ChatMessageDTO> chatMessageDTOList) {
        if (CollectionUtils.isNotEmpty(chatMessageDTOList)) {
            Set<Long> runIdList = chatMessageDTOList.stream().map(chatMessageDTO -> Long.parseLong(chatMessageDTO.getRunId())).collect(Collectors.toSet());
            Map<Long, Run> idRunMap = RunService.getIdRunMap(runIdList);
            for (ChatMessageDTO chatMessageDTO2 : chatMessageDTOList) {
                Run run;
                String runId;
                if (StringUtils.isEmpty((CharSequence)chatMessageDTO2.getRunId()) || StringUtils.equalsIgnoreCase((CharSequence)chatMessageDTO2.getRunId(), (CharSequence)"0")) {
                    chatMessageDTO2.setRunStatus(RunStepStatusEnum.COMPLETED.getId());
                }
                if (!StringUtils.isNotEmpty((CharSequence)(runId = chatMessageDTO2.getRunId())) || (run = idRunMap.get(Long.parseLong(runId))) == null) continue;
                chatMessageDTO2.setRunStatus(run.getRunStatus());
                String metadataTag = run.getMetadataTag();
                if (!ChatMessageTypeEnum.ASSISTANT.getId().equals(chatMessageDTO2.getType()) || !StringUtils.isNotEmpty((CharSequence)metadataTag)) continue;
                JSONObject metadataTagJo = JSONObject.parseObject((String)metadataTag);
                JSONArray traceJa = metadataTagJo.getJSONArray("trace");
                chatMessageDTO2.setTrace(traceJa);
            }
        }
        return chatMessageDTOList;
    }

    private static List<ChatMessageDTO> fillRunStepChatList(List<ChatMessageDTO> chatMessageDTOList) {
        if (CollectionUtils.isNotEmpty(chatMessageDTOList)) {
            List runIdList = chatMessageDTOList.stream().map(chatMessageDTO -> Long.parseLong(chatMessageDTO.getRunId())).collect(Collectors.toList());
            QFilter qFilter = new QFilter("type", "=", (Object)ChatMessageTypeEnum.RUNSTEP.getId()).and("runid", "in", runIdList);
            DynamicObject[] chatMessageDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId(), (String)"id,sessionid,type,content_tag,runid,runstepid,createtime,config_tag,assistantid,skillid,skilltype,skillsrc,msgstatus", (QFilter[])qFilter.toArray(), (String)"id asc");
            ArrayList<RunStepMessage> runStepMessageList = new ArrayList<RunStepMessage>();
            if (chatMessageDoArr != null && chatMessageDoArr.length > 0) {
                HashSet<Long> runStepIdList = new HashSet<Long>(chatMessageDoArr.length);
                for (DynamicObject chatMessageDo : chatMessageDoArr) {
                    runStepIdList.add(chatMessageDo.getLong("runstepid"));
                }
                Map<Long, RunStep> idRunStepMap = RunService.getIdRunStepMap(runStepIdList);
                for (DynamicObject chatMessageDo : chatMessageDoArr) {
                    Long runStepId = chatMessageDo.getLong("runstepid");
                    RunStep runStep = idRunStepMap.get(runStepId);
                    if (runStep == null) continue;
                    String stepDetailsTag = runStep.getStepDetailsTag();
                    String thought = null;
                    if (stepDetailsTag != null && stepDetailsTag.length() > 0) {
                        String regex;
                        Pattern pattern;
                        Matcher matcher;
                        String text = null;
                        String toolRegex = "<tool_call>(.*?)</tool_call>";
                        Pattern toolPattern = Pattern.compile(toolRegex, 32);
                        Matcher toolMatcher = toolPattern.matcher(stepDetailsTag);
                        text = toolMatcher.find() ? toolMatcher.group(1) : stepDetailsTag;
                        String thoughtRegex = "<think>(.*?)</think>";
                        Pattern thoughtPattern = Pattern.compile(thoughtRegex, 32);
                        Matcher thoughtMatcher = thoughtPattern.matcher(text);
                        if (thoughtMatcher.find()) {
                            thought = thoughtMatcher.group(1);
                        }
                        if (ChatService.isValidJson(text = (matcher = (pattern = Pattern.compile(regex = "```json.*?\\s+(.*?)```", 32)).matcher(text)).find() ? matcher.group(1) : stepDetailsTag)) {
                            JSONObject json = JSONObject.parseObject((String)text);
                            if (thought == null && (thought = json.getString("thought")) == null) {
                                thought = json.getString("Thought");
                            }
                        }
                    }
                    RunStepMessage runStepMessage = new RunStepMessage();
                    String message = chatMessageDo.getString("content_tag");
                    runStepMessage.setMessage(message);
                    List<BaseAnnotation> annotationList = AnnotationService.parseMessageAnnotations(message);
                    runStepMessage.setAnnotations(annotationList);
                    runStepMessage.setStepStatus(runStep.getStepStatus());
                    runStepMessage.setMessageId(StrUtils.longAsString((Long)chatMessageDo.getPkValue()));
                    runStepMessage.setStream(Boolean.FALSE);
                    runStepMessage.setRunStepId(StrUtils.longAsString(runStepId));
                    runStepMessage.setStepType(runStep.getType());
                    runStepMessage.setStepTypeName(runStep.getType());
                    runStepMessage.setStepDetailName(runStep.getType());
                    String[] typeNames = runStep.getType().split("\\|");
                    if (typeNames.length > 1) {
                        runStepMessage.setStepTypeName(typeNames[1]);
                    } else {
                        runStepMessage.setStepTypeName(runStep.getType());
                    }
                    runStepMessage.setCreateTime(KDDateFormatUtils.getDateTimeFormat().format(chatMessageDo.getDate("createtime")));
                    runStepMessage.setRunId(StrUtils.longAsString(chatMessageDo.getLong("runid")));
                    runStepMessage.setTaskId(runStepMessage.getRunId());
                    runStepMessage.setType(chatMessageDo.getLong("type"));
                    if (thought != null) {
                        RunStepMessage stepMessage = new RunStepMessage();
                        stepMessage.setRunStepId(String.valueOf(ID.genLongId()));
                        stepMessage.setAnnotations(annotationList);
                        stepMessage.setStepStatus(runStep.getStepStatus());
                        stepMessage.setMessageId(StrUtils.longAsString((Long)chatMessageDo.getPkValue()));
                        stepMessage.setStream(Boolean.FALSE);
                        stepMessage.setStepType(runStep.getType());
                        stepMessage.setMessage(thought);
                        stepMessage.setStepTypeName(RunStepTypeEnum.THOUGHT.getName());
                        stepMessage.setCreateTime(KDDateFormatUtils.getDateTimeFormat().format(chatMessageDo.getDate("createtime")));
                        stepMessage.setRunId(StrUtils.longAsString(chatMessageDo.getLong("runid")));
                        stepMessage.setTaskId(stepMessage.getRunId());
                        runStepMessageList.add(stepMessage);
                    }
                    runStepMessageList.add(runStepMessage);
                }
            }
            Map<String, List<RunStepMessage>> runIdRunStepMessageListMap = runStepMessageList.stream().collect(Collectors.groupingBy(RunStepMessage::getRunId));
            for (ChatMessageDTO chatMessageDTO2 : chatMessageDTOList) {
                List<RunStepMessage> list = runIdRunStepMessageListMap.get(chatMessageDTO2.getRunId());
                chatMessageDTO2.setRunStepMessageList(list);
            }
        }
        return chatMessageDTOList;
    }

    public static boolean isValidJson(String jsonStr) {
        try {
            JSON.parse((String)jsonStr);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private static List<ChatMessageDTO> transChatMessageDTOList(String chatSessionId, DynamicObject[] chatMessageDoArr) {
        int length = chatMessageDoArr != null ? chatMessageDoArr.length : 0;
        ArrayList<ChatMessageDTO> chatMessageDTOList = new ArrayList<ChatMessageDTO>(length);
        if (chatMessageDoArr != null && chatMessageDoArr.length > 0) {
            for (DynamicObject chatMessageDo : chatMessageDoArr) {
                Date createTime;
                long messageId = (Long)chatMessageDo.getPkValue();
                long sessionId = chatMessageDo.getLong("sessionid");
                String contentTag = chatMessageDo.getString("content_tag");
                String configTag = chatMessageDo.getString("config_tag");
                ChatMessageDTO chatMessageDTO = new ChatMessageDTO();
                chatMessageDTO.setSessionId(StrUtils.longAsString(sessionId));
                chatMessageDTO.setMessageId(StrUtils.longAsString(messageId));
                chatMessageDTO.setMessage(contentTag);
                String runId = StrUtils.longAsString(chatMessageDo.getLong("runid"));
                chatMessageDTO.setTaskId(runId);
                chatMessageDTO.setRunId(runId);
                chatMessageDTO.setRunStepId(StrUtils.longAsString(chatMessageDo.getLong("runstepid")));
                chatMessageDTO.setId(chatSessionId);
                chatMessageDTO.setAssistantId(StrUtils.longAsString(chatMessageDo.getLong("assistantid")));
                chatMessageDTO.setStream(false);
                chatMessageDTO.setThought(chatMessageDo.getString("thought_tag"));
                String runStatus = chatMessageDo.getString("msgstatus");
                chatMessageDTO.setCancelled(StringUtils.equalsIgnoreCase((CharSequence)runStatus, (CharSequence)RunStepStatusEnum.CANCELLED.getId()));
                chatMessageDTO.setChatTraceId(chatMessageDo.getString("chattraceid"));
                Long skillId = chatMessageDo.getLong("skillid");
                if (skillId != null && skillId > 0L) {
                    String skillType = chatMessageDo.getString("skilltype");
                    Skill skill = new Skill();
                    skill.setId(String.valueOf(skillId));
                    Skill.Type type = Skill.getTypeByName(skillType);
                    skill.setType(type);
                    chatMessageDTO.setSkill(skill);
                }
                chatMessageDTO.setType(chatMessageDo.getLong("type"));
                List<BaseAnnotation> annotations = AnnotationService.parseMessageAnnotations(contentTag);
                chatMessageDTO.setAnnotations(annotations);
                if (StringUtils.isNotEmpty((CharSequence)configTag)) {
                    JSONObject configJo = JSON.parseObject((String)configTag);
                    chatMessageDTO.setConfig(configJo);
                    String taskId = configJo.getString("taskId");
                    if (StringUtils.isNotEmpty((CharSequence)taskId)) {
                        chatMessageDTO.setTaskId(taskId);
                    }
                }
                if ((createTime = chatMessageDo.getDate("createtime")) != null) {
                    chatMessageDTO.setCreateTime(KDDateFormatUtils.getDateTimeFormat().format(createTime));
                }
                chatMessageDTOList.add(chatMessageDTO);
            }
        }
        return chatMessageDTOList;
    }

    public static List<ChatSessionDTO> getChatSessionList(List<String> chatSessionIdList) {
        ArrayList<ChatSessionDTO> chatSessionDTOList = new ArrayList<ChatSessionDTO>(20);
        if (chatSessionIdList != null && !chatSessionIdList.isEmpty()) {
            QFilter qFilter = new QFilter("chatsessionid", "in", chatSessionIdList);
            DynamicObject[] chatSessionDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_CHAT_SESSION.getId(), (String)"id,creator,assistantid,chatsessionid,name,createtime,modifytime,lastmessagetime,lastusermessage,clienttype,opusername", (QFilter[])qFilter.toArray(), null, (int)-1);
            if (chatSessionDoArr != null) {
                for (DynamicObject chatSessionDo : chatSessionDoArr) {
                    ChatSessionDTO chatSessionDTO = ChatService.transChatSessionDTO(chatSessionDo);
                    chatSessionDTOList.add(chatSessionDTO);
                }
            }
        }
        return chatSessionDTOList;
    }

    public static PageResult<ChatSessionDTO> getChatSessionPage(PageQuery pageQuery) {
        RequestContext rc = RequestContext.get();
        String searchKey = pageQuery.getSearchKey();
        int pageSize = pageQuery.getPageSize();
        Long lastSessionId = pageQuery.getLasId();
        PageResult<ChatSessionDTO> pageResult = new PageResult<ChatSessionDTO>();
        QFilter qFilter = new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr());
        qFilter.and("creator", "=", (Object)rc.getCurrUserId());
        qFilter.and("lastmessagetime", "is not null", null);
        qFilter.and("name", "is not null", null);
        if (StringUtils.isNotEmpty((CharSequence)searchKey)) {
            qFilter.and("name", "like", (Object)("%" + searchKey + "%"));
        }
        if (lastSessionId != null && lastSessionId > 0L) {
            DynamicObject lastSessionDo = BusinessDataServiceHelper.loadSingle((Object)lastSessionId, (String)GaiFormIdEnum.GAI_CHAT_SESSION.getId());
            qFilter.and("lastmessagetime", "<", (Object)lastSessionDo.getDate("lastmessagetime"));
        }
        int loadPageSize = pageSize == -1 ? pageSize : pageSize + 1;
        DynamicObject[] chatSessionDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_CHAT_SESSION.getId(), (String)"id,creator,assistantid,chatsessionid,name,createtime,modifytime,lastmessagetime,lastusermessage,clienttype,opusername", (QFilter[])qFilter.toArray(), (String)String.format("%s desc", "lastmessagetime"), (int)loadPageSize);
        if (chatSessionDoArr != null && chatSessionDoArr.length > 0) {
            List<ChatSessionDTO> chatSessionDTOList = new ArrayList<ChatSessionDTO>(chatSessionDoArr.length);
            for (DynamicObject chatSessionDo : chatSessionDoArr) {
                ChatSessionDTO chatSessionDTO = ChatService.transChatSessionDTO(chatSessionDo);
                chatSessionDTOList.add(chatSessionDTO);
            }
            if (pageSize != -1 && chatSessionDTOList.size() > pageSize) {
                pageResult.setHasMore(true);
                chatSessionDTOList = chatSessionDTOList.subList(0, chatSessionDTOList.size() - 1);
            }
            pageResult.setList(chatSessionDTOList);
        }
        return pageResult;
    }

    @NotNull
    public static ChatSessionDTO transChatSessionDTO(DynamicObject chatSessionDo) {
        ChatSessionDTO chatSessionDTO = new ChatSessionDTO();
        chatSessionDTO.setId(chatSessionDo.getString("chatsessionid"));
        chatSessionDTO.setAssistantId(StrUtils.longAsString(chatSessionDo.getLong("assistantid")));
        chatSessionDTO.setSessionId(StrUtils.longAsString((Long)chatSessionDo.getPkValue()));
        chatSessionDTO.setTitle(chatSessionDo.getString("name"));
        DynamicObject creatorDo = chatSessionDo.getDynamicObject("creator");
        chatSessionDTO.setUserId(StrUtils.longAsString(creatorDo != null ? (Long)creatorDo.getPkValue() : 0L));
        chatSessionDTO.setClientType(chatSessionDo.getLong("clienttype"));
        chatSessionDTO.setOpUserName(chatSessionDo.getString("opusername"));
        Date createTime = chatSessionDo.getDate("createtime");
        Date modifyTime = chatSessionDo.getDate("modifytime");
        String lastUserMessage = chatSessionDo.getString("lastusermessage");
        chatSessionDTO.setLastUserMessage(lastUserMessage);
        Date lastMessageTime = chatSessionDo.getDate("lastmessagetime");
        if (lastMessageTime != null) {
            chatSessionDTO.setLastMessageTime(KDDateFormatUtils.getDateTimeFormat().format(lastMessageTime));
        }
        if (createTime != null) {
            chatSessionDTO.setCreateTime(KDDateFormatUtils.getDateTimeFormat().format(createTime));
        }
        if (modifyTime != null) {
            chatSessionDTO.setModifyTime(KDDateFormatUtils.getDateTimeFormat().format(modifyTime));
        }
        return chatSessionDTO;
    }

    public static Feedback reportUserFeedback(Context context, Feedback feedback) {
        feedback.setId(context.getChatSessionId());
        Message message = MessageService.getAgentMessage(feedback.getChatTraceId(), ChatMessageTypeEnum.USER);
        IUserFeedbackService.create().reportUserFeedback(new UserFeedbackEventParams(context.getSlideenv(), feedback.getChatTraceId(), message.getTraceId(), StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(feedback.getType()), (CharSequence)UserFeedbackTypeEnum.TAP.getId()) ? UserFeedbackTypeEnum.TAP.getId() : UserFeedbackTypeEnum.LIKE.getId(), KDDateUtils.now().getTime(), feedback.getContentType(), feedback.getContent(), feedback.getOpType()));
        return feedback;
    }

    public static void saveStepLog(String chatSessionId, Long runId, String stepInput, String thought, String stepOutput, Long userId, String stepType) {
        StepLog stepLog = new StepLog();
        stepLog.setChatSessionId(chatSessionId);
        stepLog.setTraceId(runId);
        stepLog.setThought(thought);
        stepLog.setStepInput(stepInput);
        stepLog.setStepOutput(stepOutput);
        stepLog.setUserId(userId);
        stepLog.setStepType(stepType);
        long sessionId = TraceUtil.handleAgentLogSessionId(chatSessionId);
        stepLog.setSessionId(sessionId);
        BaseResult stepLogResult = TraceLogService.saveStepLog(stepLog);
    }

    private static boolean shouldStartProcess(Agent agent) {
        return agent.getProcessList() != null && agent.getProcessList().size() == 1 && agent.getToolList() == null && agent.getRepoList() == null;
    }

    public static Result startJavaAgentChat(Context context, Message userMessage, Map<String, String> inParaMap) {
        FlowCacheData.clearCache(context.getChatSessionId(), "flowCancelled");
        IUserFeedbackService.create().reportUserFeedback(new UserFeedbackEventParams(context.getSlideenv(), context.getChatTraceId(), context.getTraceId(), UserFeedbackTypeEnum.OK.getId(), KDDateUtils.now().getTime()));
        Skill currentSkill = context.getCurrentSkill();
        Long skillId = userMessage.getSkillId();
        if (currentSkill != null && StringUtils.isNotEmpty((CharSequence)currentSkill.getId()) && Long.parseLong(currentSkill.getId()) > 0L) {
            skillId = Long.parseLong(currentSkill.getId());
        }
        Agent agent = AgentService.getAgent(skillId, true);
        AgentMessage agentMessage = new AgentMessage();
        String chatSessionId = context.getChatSessionId();
        agentMessage.setAgent(agent);
        String userInput = userMessage.getContentTag();
        agentMessage.setMessageId(userMessage.getMessageId());
        agentMessage.setAssistantMessageId(ID.genLongId());
        agentMessage.setRetries(0);
        if (agent.getRoleMode().equals(RoleModeEnum.REACT.getId())) {
            agentMessage.setUserInput("Question: " + userInput);
            agentMessage.setStream(false);
        } else if (agent.getRoleMode().equals(RoleModeEnum.FUNCTIONCALL.getId())) {
            agentMessage.setUserInput(userInput);
            agentMessage.setStream(true);
        }
        agentMessage.setRawUserInput(userInput);
        agentMessage.setRunId(String.valueOf(userMessage.getRunId()));
        agentMessage.setChatSessionId(context.getChatSessionId());
        agentMessage.setRememberCount(agent.getRememberCount());
        agentMessage.setStartTime(System.currentTimeMillis());
        JSONObject agentInfo = new JSONObject();
        agentInfo.put("agentName", (Object)agent.getName());
        agentInfo.put("agentNumber", (Object)agent.getNumber());
        EngineCache.getAppCache(chatSessionId).put("agent", (Object)agentInfo);
        EngineCache.getAppCache(chatSessionId).put("_chat_session_agent_cache_", (Object)String.valueOf(agent.getAgentId()));
        agentMessage.setAsTool(MapUtils.getBooleanValue(inParaMap, (Object)"asTool", (boolean)false));
        PushMsgService.pushWaiting(context, 0L, agentMessage.getRunId());
        return HandlerFactory.runHandler(context, agentMessage);
    }

    public static void agentCancel(String chatSessionId, long runId) {
        MessageService.updateUserMessage2Cancelled(chatSessionId);
    }

    public static ChatSessionDTO updateChatSession(ChatSessionDTO chatSessionDTO, String chatSessionId) {
        Context context = FlowCacheData.getContext(chatSessionId);
        MainEntityType chatSessionType = EntityMetadataCache.getDataEntityType((String)GaiFormIdEnum.GAI_CHAT_SESSION.getId());
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)chatSessionType);
        dynamicObject.set("id", (Object)Long.parseLong(chatSessionDTO.getSessionId()));
        dynamicObject.set("context_tag", (Object)JSON.toJSONString((Object)context));
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        return chatSessionDTO;
    }
}

