/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.domain.dto.agent.AgentTool;
import kd.ai.gai.core.domain.dto.agent.CosmicAction;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.service.agent.AgentToolService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class CosmicActionService {
    private static final Log logger = LogFactory.getLog(CosmicActionService.class);

    public static BaseResult call(CosmicAction cosmicAction) {
        logger.info("\u6267\u884c\u8c03\u7528\u82cd\u7a79Action\u5de5\u5177\u63a5\u53e3\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)cosmicAction));
        Long toolId = cosmicAction.getToolId();
        if (toolId == null) {
            return BaseResult.fail("toolId\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AgentTool tool = AgentToolService.getAgentTool(toolId);
        if (tool == null) {
            return BaseResult.fail("\u5de5\u5177\u4e0d\u5b58\u5728");
        }
        JSONObject toolParams = cosmicAction.getToolParams();
        if (toolParams == null) {
            return BaseResult.fail("toolParams\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String enable = tool.getEnable();
        if (StringUtils.equalsIgnoreCase((CharSequence)enable, (CharSequence)String.valueOf(0))) {
            return BaseResult.fail("\u5de5\u5177\u72b6\u6001\u4e3a\u7981\u7528\uff0c\u65e0\u6cd5\u4f7f\u7528\u3002");
        }
        String chatSessionId = cosmicAction.getChatSessionId();
        Long runId = cosmicAction.getRunId();
        Long runStepId = cosmicAction.getRunStepId();
        if (!StringUtils.isEmpty((CharSequence)chatSessionId)) {
            FlowCacheData.restoreRequestContext(chatSessionId);
        }
        JSONObject actionConfig = tool.getConfigTag();
        JSONArray inputParams = toolParams.getJSONArray("inputParams");
        JSONArray outputParams = actionConfig.getJSONArray("outputParams");
        JSONArray configParams = actionConfig.getJSONArray("configParams");
        return CosmicActionService.call(actionConfig, inputParams, outputParams, configParams, chatSessionId, runId, runStepId);
    }

    public static BaseResult call(JSONObject actionConfig, JSONArray inputParams, JSONArray outputParams, JSONArray configParams, String chatSessionId, Long runId, Long runStepId) {
        Object ret;
        String appId;
        String className;
        block6: {
            String action = actionConfig.getString("action");
            HashMap<String, String> varMaps = new HashMap<String, String>(0);
            CosmicActionService.buildConfigVar(varMaps, configParams);
            Object[] bizParams = new Object[2];
            bizParams[0] = action;
            if (inputParams != null && !inputParams.isEmpty()) {
                for (int i = 0; i < inputParams.size(); ++i) {
                    JSONObject param = inputParams.getJSONObject(i);
                    String paramName = param.getString("paramName");
                    String paramValue = param.getString("paramValue");
                    varMaps.put(paramName, paramValue);
                }
                CosmicActionService.buildChatSessionIdVar(varMaps, chatSessionId, runId);
                logger.info("build varMaps : {}", (Object)JSONObject.toJSONString(varMaps));
                bizParams[1] = varMaps;
            } else {
                CosmicActionService.buildChatSessionIdVar(varMaps, chatSessionId, runId);
                logger.info("build varMaps : {}", (Object)JSONObject.toJSONString(varMaps));
                bizParams[1] = varMaps;
            }
            className = actionConfig.getString("serviceName");
            appId = actionConfig.getString("appId");
            ret = null;
            try {
                ret = DispatchServiceHelper.invokeBOSService((String)appId, (String)"IGPTService", (String)"invokeGptAction", (Object[])new Object[]{className, "invokeAction", bizParams});
            }
            catch (RuntimeException e) {
                if (!e.getCause().toString().contains("ClassNotFoundException")) break block6;
                String message = ResManager.loadKDString((String)"\u7c7b\u540d\u4e0d\u5b58\u5728/\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CosmicActionService_0", (String)"ai-gai-core", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
        }
        if (ret instanceof Map) {
            Map data = (Map)ret;
            logger.info("call cosmic action result : {}", ret);
            JSONObject output = new JSONObject();
            JSONObject resultData = CosmicActionService.handlerOutput(data, outputParams);
            output.put("output", (Object)resultData);
            return new BaseResult(output);
        }
        logger.error("{} : {} \u8c03\u7528\u8fd4\u56de\u7c7b\u578b\u4e0d\u662fMap<String,String>, \u8fd4\u56de\u503c: {} ", new Object[]{appId, className, ret});
        JSONObject output = new JSONObject();
        output.put("output", (Object)new JSONObject());
        return new BaseResult(output);
    }

    private static void buildChatSessionIdVar(Map<String, String> varMaps, String chatSessionId, Long runId) {
        JSONObject gaiParams = new JSONObject();
        gaiParams.put("chatSessionId", (Object)chatSessionId);
        gaiParams.put("runId", (Object)runId);
        if (StringUtils.isEmpty((CharSequence)chatSessionId)) {
            logger.error("chatSessionId is null,can't get PAGE_ID and ROOT_PAGE_ID from context");
        } else {
            Context context = FlowCacheData.getContext(chatSessionId);
            if (context != null) {
                gaiParams.put("PAGE_ID", (Object)context.getBizPageId());
                gaiParams.put("ROOT_PAGE_ID", (Object)context.getRootPageId());
            }
        }
        varMaps.put("gaiParams", JSONObject.toJSONString((Object)gaiParams, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    private static void buildConfigVar(Map<String, String> varMaps, JSONArray configParams) {
        JSONObject config = new JSONObject();
        if (configParams != null && !configParams.isEmpty()) {
            for (int i = 0; i < configParams.size(); ++i) {
                JSONObject param = configParams.getJSONObject(i);
                String name = param.getString("configName");
                String value = param.getString("configValue");
                config.put(name, (Object)value);
            }
        }
        varMaps.put("configParams", JSONObject.toJSONString((Object)config, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    private static JSONObject handlerOutput(Map<String, String> data, JSONArray outputParams) {
        JSONObject resultData = new JSONObject();
        if (outputParams != null && !outputParams.isEmpty()) {
            for (int i = 0; i < outputParams.size(); ++i) {
                Object[] arrays;
                JSONObject param = outputParams.getJSONObject(i);
                String paramName = param.getString("paramName");
                String paramType = param.getString("paramType");
                if (ToolConstant.ParamType.isBasicType(paramType.toLowerCase(Locale.ROOT))) {
                    resultData.put(paramName, (Object)data.get(paramName));
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.ARRAY.getName())) continue;
                JSONObject items = param.getJSONObject("items");
                String arrayType = items.getString("paramType");
                String paramValue = data.get(paramName);
                if (StringUtils.equalsIgnoreCase((CharSequence)arrayType.toLowerCase(Locale.ROOT), (CharSequence)ToolConstant.ParamType.STRING.getName())) {
                    arrays = JsonUtil.fromJson(paramValue, String[].class);
                    resultData.put(paramName, (Object)arrays);
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)arrayType.toLowerCase(Locale.ROOT), (CharSequence)ToolConstant.ParamType.INTEGER.getName())) {
                    arrays = JsonUtil.fromJson(paramValue, Integer[].class);
                    resultData.put(paramName, (Object)arrays);
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)arrayType.toLowerCase(Locale.ROOT), (CharSequence)ToolConstant.ParamType.BOOLEAN.getName())) {
                    arrays = JsonUtil.fromJson(paramValue, Boolean[].class);
                    resultData.put(paramName, (Object)arrays);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)arrayType.toLowerCase(Locale.ROOT), (CharSequence)ToolConstant.ParamType.FLOAT.getName())) continue;
                arrays = JsonUtil.fromJson(paramValue, float[].class);
                resultData.put(paramName, (Object)arrays);
            }
        }
        return resultData;
    }
}

