/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.ai.gai.core.agent.tool.util.CosmicOpenAPIUtils;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPI;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.OpenApiSdkUtil;

public class CosmicOpenAPIService {
    private static final Log logger = LogFactory.getLog(CosmicOpenAPIService.class);
    private static volatile CosmicOpenAPIService service;

    private CosmicOpenAPIService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CosmicOpenAPIService getService() {
        if (service != null) return service;
        Class<CosmicOpenAPIService> clazz = CosmicOpenAPIService.class;
        synchronized (CosmicOpenAPIService.class) {
            if (service != null) return service;
            service = new CosmicOpenAPIService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public OpenApiResult call(CosmicOpenAPI api) {
        logger.info("\u6267\u884c\u8c03\u7528\u82cd\u7a79OpenAPI\u63a5\u53e3\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)api));
        Long apiId = api.getApiId();
        if (apiId == null || apiId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0capiId\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CosmicOpenAPIService_1", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        DynamicObject apiJo = CosmicOpenAPIUtils.checkIsSupportCosmicOperationOpenAPI(apiId);
        Boolean withoutStatus = apiJo.getBoolean("isoutparawithoutstatus");
        Map<String, Object> requestData = api.getRequestData();
        Map<String, String> header = api.getHeader();
        String apiUrl = apiJo.getString("urlformat");
        OpenApiResult openApiResult = null;
        try {
            Object result = OpenApiSdkUtil.invokeOpenApi((String)apiUrl, requestData, header);
            if (withoutStatus.booleanValue()) {
                openApiResult = OpenApiResult.builder().success(result);
                openApiResult.setErrorCode(ApiErrorCode.OK.getStatusCode());
                return openApiResult;
            }
            openApiResult = result != null ? (OpenApiResult)result : OpenApiResult.builder().fail(ApiErrorCode.Data_Invalid.toString(), ApiErrorCode.Data_Invalid.getStatusCode());
            return openApiResult;
        }
        catch (OpenApiException e) {
            openApiResult = OpenApiResult.builder().fail(e.getMessage(), e.getCode());
            return openApiResult;
        }
    }
}

