/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.constant.agent.FieldTypeEnum;
import kd.ai.gai.core.domain.dto.agent.Entity;
import kd.ai.gai.core.domain.dto.agent.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import org.apache.commons.lang3.StringUtils;

public class EntityMetaService {
    private static final Log logger = LogFactory.getLog(EntityMetaService.class);

    private static boolean canShow(IDataEntityProperty dp) {
        return !(dp instanceof DynamicLocaleProperty) && StringUtils.isNotEmpty((CharSequence)dp.getAlias());
    }

    private static String getDisplayName(IDataEntityProperty dp) {
        LocaleString displayName = dp.getDisplayName();
        if (displayName != null) {
            return displayName.getLocaleValue();
        }
        return dp.getName();
    }

    private static String getParentEntityId(IDataEntityType dataEntityType) {
        String parentId = "";
        while (dataEntityType != null) {
            String pid = dataEntityType.getName();
            parentId = StringUtils.isEmpty((CharSequence)parentId) ? pid : String.format("%s.%s", pid, parentId);
            dataEntityType = dataEntityType.getParent();
        }
        parentId = !StringUtils.contains((CharSequence)parentId, (CharSequence)".") ? "" : parentId.substring(parentId.indexOf(46) + 1);
        return parentId;
    }

    private static void getEntityFieldListMapMark(Map<String, EntityType> allEntities, String entityName, String entityDisplayName, DataEntityPropertyCollection properties, Map<String, List<Field>> entityFieldListMap, Map<String, List<Field>> baseEntityFieldListMap, Map<String, List<Field>> subEntityFieldListMap, Map<String, List<Field>> entityListMap, Map<String, List<String>> ref, Map<String, JSONObject> refs) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ArrayList<Field> subFiledList = new ArrayList<Field>();
        ArrayList<Field> entityFieldList = new ArrayList<Field>();
        ArrayList<String> refEntity = new ArrayList<String>();
        EntityType entityType = allEntities.get(entityName);
        String primaryFieldName = entityType.getPrimaryKey().getName();
        if (entityType instanceof SubEntryType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5b50\u5355\u636e\u4f53");
            String string = entityType.getParent().getName();
        } else if (entityType instanceof EntryType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u4f53");
        } else if (entityType instanceof BillEntityType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u5934");
        }
        for (IDataEntityProperty dp : properties) {
            String parentEntityId = EntityMetaService.getParentEntityId(dp.getParent());
            if (parentEntityId.isEmpty()) {
                parentEntityId = entityName;
            }
            if (dp instanceof EntryProp) {
                EntryProp entry = (EntryProp)dp;
                DynamicObjectType dot = entry.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProperties = dot.getProperties();
                String displayName = "";
                if (entry.getDisplayName() != null) {
                    displayName = entry.getDisplayName().getLocaleValue();
                }
                EntityMetaService.getEntityFieldListMapMark(allEntities, entry.getName(), displayName, entryProperties, entityFieldListMap, baseEntityFieldListMap, subEntityFieldListMap, entityListMap, ref, refs);
            } else {
                if (!EntityMetaService.canShow(dp)) continue;
                String mainKey = dp.getName();
                String pkName = "";
                if (dp.getParent() != null && dp.getParent().getPrimaryKey() != null) {
                    pkName = dp.getParent().getPrimaryKey().getName();
                }
                String mainDisplayName = EntityMetaService.getDisplayName(dp);
                if (StringUtils.equalsIgnoreCase((CharSequence)pkName, (CharSequence)mainKey)) {
                    if (StringUtils.isNotEmpty((CharSequence)entityDisplayName)) {
                        mainDisplayName = String.format("%s%s", entityDisplayName, mainDisplayName);
                    }
                    mainDisplayName = String.format("%s_%s", mainDisplayName, "PK");
                }
                if (StringUtils.isNotEmpty((CharSequence)parentEntityId)) {
                    // empty if block
                }
                if (dp instanceof BasedataProp) {
                    MainEntityType dataEntityType;
                    refEntity.add(dp.getName());
                    ArrayList<Field> baseList = new ArrayList<Field>();
                    BasedataProp bd = (BasedataProp)dp;
                    DynamicObjectType ref1 = bd.getDynamicComplexPropertyType();
                    DataEntityPropertyCollection subPS = ref1.getProperties();
                    String baseEntityName = bd.getBaseEntityId();
                    String name = bd.getName();
                    String baseEntityDisplayName = baseEntityName;
                    JSONObject json = new JSONObject();
                    json.put("name", (Object)mainDisplayName);
                    json.put("ref", (Object)baseEntityName);
                    refs.put(name, json);
                    if (StringUtils.isNotEmpty((CharSequence)baseEntityName) && (dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityName)) != null && dataEntityType.getDisplayName() != null) {
                        baseEntityDisplayName = dataEntityType.getDisplayName().getLocaleValue();
                    }
                    for (IDataEntityProperty subDP : subPS) {
                        if (!EntityMetaService.canShow(subDP)) continue;
                        String fieldType = EntityMetaService.getFieldTypeNameByDpMark(subDP);
                        String subKey = subDP.getName();
                        String subDisplayName = EntityMetaService.getDisplayName(subDP);
                        String subName = subDP.getAlias();
                        if (StringUtils.isEmpty((CharSequence)subName)) {
                            subName = subKey.replaceAll("\\.", "_");
                        }
                        Field field = new Field();
                        field.setDesc(subDisplayName);
                        field.setName(String.format("%s", subKey));
                        field.setType(fieldType);
                        if (field.getName() == null || field.getName().equals(field.getDesc()) || field.getName().matches("^.*(\\(|\uff08)(\u5c01\u5b58|\u5e9f\u5f03|\u5df2\u5e9f\u5f03|\u5df2\u5931\u6548)(\\)|\uff09)")) continue;
                        baseList.add(field);
                    }
                    if (baseEntityName != null) {
                        baseEntityFieldListMap.put(String.format("%s", baseEntityName), baseList);
                    }
                } else {
                    String fieldType = EntityMetaService.getFieldTypeNameByDpMark(dp);
                    Field field = new Field();
                    if (mainDisplayName.contains("_PK")) {
                        mainDisplayName = mainDisplayName.replaceAll("_PK", "");
                        fieldType = String.format("%s %s", fieldType, "PK");
                    }
                    field.setDesc(mainDisplayName);
                    field.setType(fieldType);
                    field.setName(mainKey);
                    if (field.getName() != null && !field.getName().equals(field.getDesc()) && !field.getName().matches("^.*(\\(|\uff08)(\u5c01\u5b58|\u5e9f\u5f03|\u5df2\u5e9f\u5f03|\u5df2\u5931\u6548)(\\)|\uff09)")) {
                        if (entityType instanceof SubEntryType) {
                            subFiledList.add(field);
                        } else if (entityType instanceof EntryType) {
                            entityFieldList.add(field);
                        } else {
                            fieldList.add(field);
                        }
                    }
                    if (entityType instanceof SubEntryType) {
                        subEntityFieldListMap.put(String.format("%s|%s", entityName, entityType.getDisplayName()), subFiledList);
                        if (!refEntity.contains(entityType.getName())) {
                            refEntity.add(entityType.getName());
                        }
                    } else if (entityType instanceof EntryType) {
                        if (!entityName.contains("_lk")) {
                            entityListMap.put(String.format("%s|%s", entityName, entityType.getDisplayName()), entityFieldList);
                            if (!refEntity.contains(entityType.getName())) {
                                refEntity.add(entityType.getName());
                            }
                        }
                    } else {
                        entityFieldListMap.put(String.format("%s|%s", entityName, entityType.getDisplayName()), fieldList);
                    }
                }
            }
            if (refEntity.isEmpty()) continue;
            ref.put(parentEntityId, refEntity);
        }
    }

    private static boolean isexist(List<String> filter, String str) {
        for (String s : filter) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }

    private static void getEntityFieldListMapMarkFilter(Map<String, EntityType> allEntities, String entityName, String entityDisplayName, DataEntityPropertyCollection properties, Map<String, List<Field>> entityFieldListMap, Map<String, List<Field>> baseEntityFieldListMap, Map<String, List<Field>> subEntityFieldListMap, Map<String, List<Field>> entityListMap, Map<String, List<String>> ref, Map<String, JSONObject> refs, List<String> filter, String sourceEntityName) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ArrayList<Field> subFiledList = new ArrayList<Field>();
        ArrayList<Field> entityFieldList = new ArrayList<Field>();
        ArrayList<String> refEntity = new ArrayList<String>();
        EntityType entityType = allEntities.get(entityName);
        String primaryFieldName = entityType.getPrimaryKey().getName();
        if (entityType instanceof SubEntryType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5b50\u5355\u636e\u4f53");
            String string = entityType.getParent().getName();
        } else if (entityType instanceof EntryType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u4f53");
        } else if (entityType instanceof BillEntityType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u5934");
        }
        for (IDataEntityProperty dp : properties) {
            String parentEntityId = EntityMetaService.getParentEntityId(dp.getParent());
            if (parentEntityId.isEmpty()) {
                parentEntityId = entityName;
            }
            if (dp instanceof EntryProp) {
                EntryProp entry = (EntryProp)dp;
                DynamicObjectType dot = entry.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProperties = dot.getProperties();
                String displayName = "";
                if (entry.getDisplayName() != null) {
                    displayName = entry.getDisplayName().getLocaleValue();
                }
                EntityMetaService.getEntityFieldListMapMarkFilter(allEntities, entry.getName(), displayName, entryProperties, entityFieldListMap, baseEntityFieldListMap, subEntityFieldListMap, entityListMap, ref, refs, filter, sourceEntityName);
            } else {
                String mainKey;
                if (!EntityMetaService.canShow(dp)) continue;
                String refMainKey = mainKey = dp.getName();
                String pkName = "";
                if (dp.getParent() != null && dp.getParent().getPrimaryKey() != null) {
                    pkName = dp.getParent().getPrimaryKey().getName();
                }
                String mainDisplayName = EntityMetaService.getDisplayName(dp);
                if (StringUtils.equalsIgnoreCase((CharSequence)pkName, (CharSequence)mainKey)) {
                    if (StringUtils.isNotEmpty((CharSequence)entityDisplayName)) {
                        mainDisplayName = String.format("%s%s", entityDisplayName, mainDisplayName);
                    }
                    mainDisplayName = String.format("%s_%s", mainDisplayName, "PK");
                }
                if (StringUtils.isNotEmpty((CharSequence)parentEntityId) && !parentEntityId.equalsIgnoreCase(sourceEntityName)) {
                    refMainKey = String.format("%s.%s", parentEntityId, refMainKey);
                }
                if (dp instanceof BasedataProp) {
                    Object dataEntityType;
                    ArrayList<Field> baseList = new ArrayList<Field>();
                    BasedataProp bd = (BasedataProp)dp;
                    DynamicObjectType ref1 = bd.getDynamicComplexPropertyType();
                    DataEntityPropertyCollection subPS = ref1.getProperties();
                    String baseEntityName = bd.getBaseEntityId();
                    String name = bd.getName();
                    String baseEntityDisplayName = baseEntityName;
                    JSONObject json = new JSONObject();
                    json.put("name", (Object)mainDisplayName);
                    json.put("ref", (Object)baseEntityName);
                    refs.put(name, json);
                    if (StringUtils.isNotEmpty((CharSequence)baseEntityName) && (dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityName)) != null && dataEntityType.getDisplayName() != null) {
                        baseEntityDisplayName = dataEntityType.getDisplayName().getLocaleValue();
                    }
                    dataEntityType = subPS.iterator();
                    while (dataEntityType.hasNext()) {
                        IDataEntityProperty subDP = (IDataEntityProperty)dataEntityType.next();
                        if (!EntityMetaService.canShow(subDP)) continue;
                        String fieldType = EntityMetaService.getFieldTypeNameByDpMark(subDP);
                        String subKey = subDP.getName();
                        String subDisplayName = EntityMetaService.getDisplayName(subDP);
                        String subName = subDP.getAlias();
                        if (StringUtils.isEmpty((CharSequence)subName)) {
                            subName = subKey.replaceAll("\\.", "_");
                        }
                        if (!EntityMetaService.isexist(filter, String.format("%s.%s", refMainKey, subKey))) continue;
                        Field field = new Field();
                        field.setDesc(subDisplayName);
                        field.setName(String.format("%s", subKey));
                        field.setType(fieldType);
                        if (field.getName() != null && !field.getName().equals(field.getDesc()) && !field.getName().matches("^.*(\\(|\uff08)(\u5c01\u5b58|\u5e9f\u5f03|\u5df2\u5e9f\u5f03|\u5df2\u5931\u6548)(\\)|\uff09)")) {
                            baseList.add(field);
                        }
                        if (refEntity.contains(dp.getName())) continue;
                        refEntity.add(dp.getName());
                    }
                    if (baseEntityName != null && baseList.size() > 0) {
                        List tempList = baseEntityFieldListMap.get(baseEntityName);
                        if (baseList != null && baseList.size() > 0) {
                            if (tempList != null && tempList.size() > 0) {
                                tempList.addAll(baseList);
                                tempList = tempList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(Field::getName, f -> f, (existing, replacement) -> existing), map -> new ArrayList(map.values())));
                            } else {
                                tempList = baseList;
                            }
                        }
                        baseEntityFieldListMap.put(String.format("%s", baseEntityName), tempList);
                    }
                } else {
                    String fieldType = EntityMetaService.getFieldTypeNameByDpMark(dp);
                    Field field = new Field();
                    if (mainDisplayName.contains("_PK")) {
                        mainDisplayName = mainDisplayName.replaceAll("_PK", "");
                        fieldType = String.format("%s %s", fieldType, "PK");
                    }
                    field.setDesc(mainDisplayName);
                    field.setType(fieldType);
                    field.setName(mainKey);
                    if (EntityMetaService.isexist(filter, refMainKey) && field.getName() != null && !field.getName().equals(field.getDesc()) && !field.getName().matches("^.*(\\(|\uff08)(\u5c01\u5b58|\u5e9f\u5f03|\u5df2\u5e9f\u5f03|\u5df2\u5931\u6548)(\\)|\uff09)")) {
                        if (entityType instanceof SubEntryType) {
                            subFiledList.add(field);
                        } else if (entityType instanceof EntryType) {
                            entityFieldList.add(field);
                        } else {
                            fieldList.add(field);
                        }
                    }
                    if (entityType instanceof SubEntryType) {
                        if (subFiledList.size() > 0) {
                            subEntityFieldListMap.put(String.format("%s|%s", entityName, entityType.getDisplayName()), subFiledList);
                        }
                        if (!refEntity.contains(entityType.getName())) {
                            refEntity.add(entityType.getName());
                        }
                    } else if (entityType instanceof EntryType) {
                        if (!entityName.contains("_lk")) {
                            if (entityFieldList.size() > 0) {
                                entityListMap.put(String.format("%s|%s", entityName, entityType.getDisplayName()), entityFieldList);
                            }
                            if (!refEntity.contains(entityType.getName())) {
                                refEntity.add(entityType.getName());
                            }
                        }
                    } else {
                        entityFieldListMap.put(String.format("%s|%s", entityName, entityType.getDisplayName()), fieldList);
                    }
                }
            }
            if (refEntity.isEmpty()) continue;
            ref.put(parentEntityId, refEntity);
        }
    }

    private static void getEntityFieldListMap(Map<String, EntityType> allEntities, String entityName, String entityDisplayName, DataEntityPropertyCollection properties, Map<String, List<Field>> entityFieldListMap) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        EntityType entityType = allEntities.get(entityName);
        String primaryFieldName = entityType.getPrimaryKey().getName();
        if (entityType instanceof SubEntryType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5b50\u5355\u636e\u4f53");
            String parentName = entityType.getParent().getName();
            primaryFieldName = String.format("%s.%s.%s", parentName, entityName, primaryFieldName);
        } else if (entityType instanceof EntryType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u4f53");
            primaryFieldName = String.format("%s.%s", entityName, primaryFieldName);
        } else if (entityType instanceof BillEntityType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u5934");
        }
        for (IDataEntityProperty dp : properties) {
            String parentEntityId = EntityMetaService.getParentEntityId(dp.getParent());
            if (dp instanceof EntryProp) {
                EntryProp entry = (EntryProp)dp;
                DynamicObjectType dot = entry.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProperties = dot.getProperties();
                String displayName = "";
                if (entry.getDisplayName() != null) {
                    displayName = entry.getDisplayName().getLocaleValue();
                }
                EntityMetaService.getEntityFieldListMap(allEntities, entry.getName(), displayName, entryProperties, entityFieldListMap);
                continue;
            }
            if (!EntityMetaService.canShow(dp)) continue;
            String mainKey = dp.getName();
            String pkName = "";
            if (dp.getParent() != null && dp.getParent().getPrimaryKey() != null) {
                pkName = dp.getParent().getPrimaryKey().getName();
            }
            String mainDisplayName = EntityMetaService.getDisplayName(dp);
            if (StringUtils.equalsIgnoreCase((CharSequence)pkName, (CharSequence)mainKey)) {
                if (StringUtils.isNotEmpty((CharSequence)entityDisplayName)) {
                    mainDisplayName = String.format("%s%s", entityDisplayName, mainDisplayName);
                }
                mainDisplayName = String.format("%s %s", mainDisplayName, "PK");
            }
            if (StringUtils.isNotEmpty((CharSequence)parentEntityId)) {
                mainKey = String.format("%s.%s", parentEntityId, mainKey);
            }
            if (dp instanceof BasedataProp) {
                MainEntityType dataEntityType;
                String baseEntityName;
                BasedataProp bd = (BasedataProp)dp;
                DynamicObjectType ref = bd.getDynamicComplexPropertyType();
                DataEntityPropertyCollection subPS = ref.getProperties();
                String baseEntityDisplayName = baseEntityName = bd.getBaseEntityId();
                if (StringUtils.isNotEmpty((CharSequence)baseEntityName) && (dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityName)) != null && dataEntityType.getDisplayName() != null) {
                    baseEntityDisplayName = dataEntityType.getDisplayName().getLocaleValue();
                }
                for (IDataEntityProperty subDP : subPS) {
                    if (!EntityMetaService.canShow(subDP)) continue;
                    String fieldType = EntityMetaService.getFieldTypeNameByDp(subDP);
                    String subKey = subDP.getName();
                    String subDisplayName = EntityMetaService.getDisplayName(subDP);
                    String subName = subDP.getAlias();
                    if (StringUtils.isEmpty((CharSequence)subName)) {
                        subName = subKey.replaceAll("\\.", "_");
                    }
                    Field field = new Field();
                    field.setDesc(String.format("%s.%s", mainDisplayName, subDisplayName));
                    field.setName(String.format("%s.%s", mainKey, subKey));
                    field.setType(fieldType);
                    if (field.getName() == null || field.getName().equals(field.getDesc()) || field.getName().matches("^.*(\\(|\uff08)(\u5c01\u5b58|\u5e9f\u5f03|\u5df2\u5e9f\u5f03|\u5df2\u5931\u6548)(\\)|\uff09)") || field.getName().matches("^.*(id|seq)$")) continue;
                    String[] primaryFieldNames = primaryFieldName.split("\\.");
                    String[] names = field.getName().split("\\.");
                    if (names.length > primaryFieldNames.length + 1 || names.length == primaryFieldNames.length + 1 && !subKey.equals("name")) continue;
                    fieldList.add(field);
                }
                continue;
            }
            String fieldType = EntityMetaService.getFieldTypeNameByDp(dp);
            Field field = new Field();
            field.setDesc(mainDisplayName);
            field.setType(fieldType);
            field.setName(mainKey);
            if (field.getName() == null || field.getName().equals(field.getDesc()) || field.getName().matches("^.*(\\(|\uff08)(\u5c01\u5b58|\u5e9f\u5f03|\u5df2\u5e9f\u5f03|\u5df2\u5931\u6548)(\\)|\uff09)") || field.getName().matches("^.*(id|seq)$")) continue;
            String[] primaryFieldNames = primaryFieldName.split("\\.");
            String[] names = field.getName().split("\\.");
            String subKey = "";
            if (names.length > 0) {
                subKey = names[names.length - 1];
            }
            if (names.length > primaryFieldNames.length + 1 || names.length == primaryFieldNames.length + 1 && !subKey.equals("name")) continue;
            fieldList.add(field);
        }
        entityFieldListMap.put(entityName, fieldList);
    }

    public static String getFieldTypeNameByDp(IDataEntityProperty dp) {
        String typeName = FieldTypeEnum.STRING.getId();
        if (dp instanceof BigIntProp || dp instanceof LongProp) {
            typeName = FieldTypeEnum.LONG.getId();
        } else if (dp instanceof IntegerProp) {
            typeName = FieldTypeEnum.INT.getId();
        } else if (dp instanceof DecimalProp) {
            typeName = FieldTypeEnum.DECIMAL.getId();
        } else if (dp instanceof DateProp) {
            typeName = FieldTypeEnum.DATE.getId();
        } else if (dp instanceof DateTimeProp) {
            typeName = FieldTypeEnum.DATETIME.getId();
        } else if (dp instanceof BooleanProp) {
            typeName = FieldTypeEnum.BOOLEAN.getId();
        }
        return typeName;
    }

    public static String getFieldTypeNameByDpMark(IDataEntityProperty dp) {
        String typeName = FieldTypeEnum.STRING.getId();
        String type = "";
        if (dp instanceof ComboProp) {
            List list = ((ComboProp)dp).getComboItems();
            ArrayList<String> listString = new ArrayList<String>(10);
            type = "Enumeration (";
            for (ValueMapItem item : list) {
                String valueType = "(" + item.getName() + ":" + item.getValue() + ")";
                listString.add(valueType);
            }
            type = type + StringUtils.join(listString, (String)",") + ")";
        } else if (dp instanceof BigIntProp || dp instanceof LongProp) {
            typeName = FieldTypeEnum.LONG.getId();
        } else if (dp instanceof IntegerProp) {
            typeName = FieldTypeEnum.INT.getId();
        } else if (dp instanceof DecimalProp) {
            typeName = FieldTypeEnum.DECIMAL.getId();
        } else if (dp instanceof DateProp) {
            typeName = FieldTypeEnum.DATE.getId();
        } else if (dp instanceof DateTimeProp) {
            typeName = FieldTypeEnum.DATETIME.getId();
        } else if (dp instanceof BooleanProp) {
            typeName = FieldTypeEnum.BOOLEAN.getId();
        }
        if (type.length() > 0) {
            return type;
        }
        return typeName;
    }

    public static JSONArray entityMetaQuery(List<String> entityIdList) {
        JSONArray jsonArray = new JSONArray();
        if (entityIdList == null) {
            return null;
        }
        ArrayList<Entity> entityList = new ArrayList<Entity>(entityIdList.size());
        for (String entityId : entityIdList) {
            DynamicObjectCollection allBizAppList;
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
            Entity entity = new Entity();
            entityList.add(entity);
            entity.setId(entityId);
            String displayName = "";
            HashMap<String, List<Field>> entityFieldListMap = new HashMap<String, List<Field>>();
            if (mainEntityType.getDisplayName() != null) {
                displayName = mainEntityType.getDisplayName().getLocaleValue();
                entity.setName(displayName);
            }
            if ((allBizAppList = BizAppServiceHelp.getAllBizApps()) != null && !allBizAppList.isEmpty()) {
                for (DynamicObject bizAppDo : allBizAppList) {
                    String cloudId = bizAppDo.getString("bizcloud");
                    String name = bizAppDo.getString("name");
                    String description = bizAppDo.getString("description");
                    String number = bizAppDo.getString("number");
                    if (!number.equalsIgnoreCase(mainEntityType.getAppId())) continue;
                    DynamicObject cloud = BizCloudServiceHelp.getBizCloudByID((String)cloudId);
                    entity.setFullName(cloud.getString("name") + "." + name + "." + displayName);
                    break;
                }
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            Map allEntities = mainEntityType.getAllEntities();
            EntityMetaService.getEntityFieldListMap(allEntities, mainEntityType.getName(), displayName, mainEntityType.getProperties(), entityFieldListMap);
            for (Map.Entry entry : entityFieldListMap.entrySet()) {
                String mapKey = (String)entry.getKey();
                List mapValue = (List)entry.getValue();
                fields.addAll(mapValue);
            }
            entity.setFields(fields);
            logger.info(String.format("appId:%s", mainEntityType.getAppId()));
        }
        for (Entity entity : entityList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("entity", (Object)entity);
            jsonArray.add((Object)jsonObject);
        }
        logger.info("###entitlyList###" + jsonArray.toJSONString());
        return jsonArray;
    }

    public static String entityMetaQueryFilter(List<String> entityIdList, List<String> filter) {
        Field field;
        String ref;
        String refNames;
        JSONObject json;
        List refMaps;
        String disPlayName;
        String name;
        List fieldList;
        String[] maps;
        String mapKey;
        DynamicObjectCollection allBizAppList;
        if (entityIdList == null) {
            return null;
        }
        String result = null;
        String entityId = entityIdList.get(0);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        Entity entity = new Entity();
        entity.setId(entityId);
        String displayName = "";
        HashMap<String, List<Field>> entityFieldListMap = new HashMap<String, List<Field>>();
        HashMap<String, List<Field>> baseEntityFieldListMap = new HashMap<String, List<Field>>();
        HashMap<String, List<Field>> subEntityFieldListMap = new HashMap<String, List<Field>>();
        HashMap<String, List<Field>> entityListMap = new HashMap<String, List<Field>>();
        HashMap<String, List<String>> refListMap = new HashMap<String, List<String>>();
        HashMap<String, JSONObject> refs = new HashMap<String, JSONObject>();
        if (mainEntityType.getDisplayName() != null) {
            displayName = mainEntityType.getDisplayName().getLocaleValue();
            entity.setName(displayName);
        }
        if ((allBizAppList = BizAppServiceHelp.getAllBizApps()) != null && !allBizAppList.isEmpty()) {
            for (DynamicObject bizAppDo : allBizAppList) {
                String cloudId = bizAppDo.getString("bizcloud");
                String name2 = bizAppDo.getString("name");
                String description = bizAppDo.getString("description");
                String number = bizAppDo.getString("number");
                if (!number.equalsIgnoreCase(mainEntityType.getAppId())) continue;
                DynamicObject cloud = BizCloudServiceHelp.getBizCloudByID((String)cloudId);
                entity.setFullName(cloud.getString("name") + "." + name2 + "." + displayName);
                break;
            }
        }
        Map allEntities = mainEntityType.getAllEntities();
        EntityMetaService.getEntityFieldListMapMarkFilter(allEntities, mainEntityType.getName(), displayName, mainEntityType.getProperties(), entityFieldListMap, baseEntityFieldListMap, subEntityFieldListMap, entityListMap, refListMap, refs, filter, mainEntityType.getName());
        for (Map.Entry entry : entityListMap.entrySet()) {
            mapKey = (String)entry.getKey();
            maps = mapKey.split("\\|");
            fieldList = (List)entry.getValue();
            name = maps[0];
            disPlayName = maps[1];
            refMaps = (List)refListMap.get(name);
            for (String string : refMaps) {
                json = (JSONObject)refs.get(string);
                if (json == null) continue;
                refNames = json.getString("name");
                ref = json.getString("ref");
                field = new Field();
                field.setName(string);
                field.setDesc(refNames);
                field.setType("Reference to " + ref);
                fieldList.add(field);
            }
        }
        for (Map.Entry entry : entityFieldListMap.entrySet()) {
            mapKey = (String)entry.getKey();
            maps = mapKey.split("\\|");
            fieldList = (List)entry.getValue();
            name = maps[0];
            disPlayName = maps[1];
            refMaps = (List)refListMap.get(name);
            if (refMaps != null) {
                for (String string : refMaps) {
                    json = (JSONObject)refs.get(string);
                    refNames = json.getString("name");
                    ref = json.getString("ref");
                    field = new Field();
                    field.setName(string);
                    field.setDesc(refNames);
                    field.setType("Reference to " + ref);
                    fieldList.add(field);
                }
            }
            for (Map.Entry entry2 : entityListMap.entrySet()) {
                String[] mapss = ((String)entry2.getKey()).split("\\|");
                Field field2 = new Field();
                field2.setName(mapss[0]);
                field2.setType(mapss[0]);
                field2.setDesc(mapss[1]);
                fieldList.add(field2);
            }
        }
        logger.info(String.format("appId:%s", mainEntityType.getAppId()));
        result = EntityMetaService.convertJsonToMarkdown(JSONObject.toJSONString(baseEntityFieldListMap)) + "\r\n" + EntityMetaService.convertJsonToMarkdown(JSONObject.toJSONString(entityFieldListMap)) + "\r\n" + EntityMetaService.convertJsonToMarkdown(JSONObject.toJSONString(subEntityFieldListMap)) + "\r\n" + EntityMetaService.convertJsonToMarkdown(JSONObject.toJSONString(subEntityFieldListMap)) + "\r\n" + EntityMetaService.convertJsonToMarkdown(JSONObject.toJSONString(entityListMap));
        return result;
    }

    public static String convertJsonToMarkdown(String json) {
        JSONObject rootObject = JSON.parseObject((String)json);
        StringBuilder markdownBuilder = new StringBuilder();
        Set entries = rootObject.entrySet();
        for (Map.Entry entry : entries) {
            String tableName = (String)entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof JSONArray)) continue;
            markdownBuilder.append(EntityMetaService.generateMarkdownTable(tableName, (JSONArray)value));
        }
        return markdownBuilder.toString();
    }

    public static String convertSelectedToFiled(String json) {
        JSONObject rootObject = JSON.parseObject((String)json);
        StringBuilder markdownBuilder = new StringBuilder();
        Set entries = rootObject.entrySet();
        for (Map.Entry entry : entries) {
            String tableName = (String)entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof JSONArray)) continue;
            markdownBuilder.append(EntityMetaService.generateMarkdownTable(tableName, (JSONArray)value));
        }
        return markdownBuilder.toString();
    }

    private static String generateMarkdownTable(String tableName, JSONArray items) {
        StringBuilder tableBuilder = new StringBuilder();
        tableBuilder.append("### ").append(tableName).append("\n\n");
        tableBuilder.append("| Property Name | code | Type |\n");
        tableBuilder.append("|--------|------|------|\n");
        for (int i = 0; i < items.size(); ++i) {
            JSONObject item = items.getJSONObject(i);
            String name = item.getString("name");
            String type = item.getString("type");
            String desc = item.getString("desc");
            tableBuilder.append("| ").append(desc != null ? desc : "").append(" | ").append(name != null ? name : "").append(" | ").append(type != null ? type : "").append(" |\n");
        }
        tableBuilder.append("\n");
        return tableBuilder.toString();
    }

    public static JSONObject getEntityInfosByAppId(String bizAppId) {
        String bosEntityobject = "bos_entityobject";
        QFilter qFilter = new QFilter("bizappid.number", "=", (Object)bizAppId);
        JSONObject application = new JSONObject();
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,number,bizappid.name,bizappid.id,bizappid.number";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)bosEntityobject, (String)selectFields, (QFilter[])qFilters);
        JSONArray entities = new JSONArray();
        for (DynamicObject dynamicObject : dynamicObjects) {
            JSONObject entity = new JSONObject();
            String entityId = dynamicObject.getString("id");
            String entityName = dynamicObject.getString("name");
            entity.put("id", (Object)entityId);
            entity.put("name", (Object)entityName);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
            entity.put("desc", (Object)mainEntityType.getDisplayName());
            entities.add((Object)entity);
        }
        DynamicObjectCollection allBizAppList = BizAppServiceHelp.getAllBizApps();
        if (allBizAppList != null && !allBizAppList.isEmpty()) {
            for (DynamicObject bizAppDo : allBizAppList) {
                String name = bizAppDo.getString("name");
                String description = bizAppDo.getString("description");
                String cloudId = bizAppDo.getString("bizcloud");
                String number = bizAppDo.getString("number");
                if (!number.equalsIgnoreCase(bizAppId)) continue;
                DynamicObject cloud = BizCloudServiceHelp.getBizCloudByID((String)cloudId);
                application.put("id", (Object)number);
                application.put("name", (Object)name);
                application.put("fullname", (Object)(cloud.getString("name") + "." + name));
                break;
            }
        }
        application.put("entities", (Object)entities);
        return application;
    }

    public static JSONArray entityInfos(List<String> bizApps) {
        JSONArray jsonArray = new JSONArray();
        if (bizApps != null) {
            for (int i = 0; i < bizApps.size(); ++i) {
                JSONObject json = new JSONObject();
                JSONObject application = EntityMetaService.getEntityInfosByAppId(bizApps.get(i));
                json.put("application", (Object)application);
                jsonArray.add((Object)json);
            }
        }
        logger.info("###entityInfos###" + jsonArray.toJSONString());
        return jsonArray;
    }

    public static JSONArray getEntiyMetaInfos(JSONObject json) {
        JSONArray result = null;
        List params = null;
        String levelId = json.getString("levelId");
        int index = EntityInfos.parseIndex(levelId);
        JSONArray objects = json.getJSONArray("objectIds");
        if (index != 0) {
            params = JSONArray.parseArray((String)objects.toString(), String.class);
        }
        switch (index) {
            case 0: {
                result = EntityMetaService.cloudInfos();
                break;
            }
            case 1: {
                result = EntityMetaService.cloudApps(params);
                break;
            }
            case 2: {
                result = EntityMetaService.entityInfos(params);
                break;
            }
            case 3: {
                result = EntityMetaService.entityMetaQuery(params);
                break;
            }
            default: {
                logger.info("");
            }
        }
        return result;
    }

    public static JSONArray cloudApps(List<String> clouds) {
        JSONArray jsonArray = new JSONArray();
        if (clouds == null) {
            return null;
        }
        for (int i = 0; i < clouds.size(); ++i) {
            DynamicObject bizCloud = BizCloudServiceHelp.getBizCloudByID((String)clouds.get(i));
            String cloudName = bizCloud.getString("name");
            JSONObject cloudInfo = new JSONObject();
            cloudInfo.put("id", (Object)clouds.get(i));
            cloudInfo.put("name", (Object)cloudName);
            JSONObject cloud = new JSONObject();
            cloud.put("cloud", (Object)cloudInfo);
            jsonArray.add((Object)cloud);
            DynamicObjectCollection allBizAppList = BizAppServiceHelp.getAllBizAppsByCloudID((String)clouds.get(i));
            if (allBizAppList == null || allBizAppList.isEmpty()) continue;
            JSONArray applications = new JSONArray();
            cloudInfo.put("applications", (Object)applications);
            for (DynamicObject bizAppDo : allBizAppList) {
                JSONObject json = new JSONObject();
                String name = bizAppDo.getString("name");
                String description = bizAppDo.getString("description");
                String number = bizAppDo.getString("number");
                json.put("id", (Object)number);
                json.put("name", (Object)name);
                json.put("desc", (Object)description);
                applications.add((Object)json);
            }
        }
        logger.info("###cloudApps###" + jsonArray.toJSONString());
        return jsonArray;
    }

    public static JSONArray cloudInfos() {
        JSONArray jsonArray = new JSONArray();
        JSONObject cloud = new JSONObject();
        JSONArray clouds = new JSONArray();
        cloud.put("clouds", (Object)clouds);
        jsonArray.add((Object)cloud);
        DynamicObjectCollection allBizCloudList = BizCloudServiceHelp.getAllBizClouds();
        if (allBizCloudList != null && !allBizCloudList.isEmpty()) {
            for (DynamicObject bizCloud : allBizCloudList) {
                JSONObject json = new JSONObject();
                String cloudId = bizCloud.getString("id");
                String name = bizCloud.getString("name");
                json.put("id", (Object)cloudId);
                json.put("name", (Object)name);
                clouds.add((Object)json);
            }
        }
        logger.info("###cloudInfos###" + jsonArray.toJSONString());
        return jsonArray;
    }

    public static enum EntityInfos {
        clouds("0", "\u4e91\u4fe1\u606f", 0),
        apps("1", "\u5e94\u7528\u4fe1\u606f", 1),
        entities("2", "\u5b9e\u4f53\u4fe1\u606f", 2),
        fileds("3", "\u5b57\u6bb5\u4fe1\u606f", 3);

        private String level;
        private String name;
        private int index;

        private EntityInfos(String level, String name) {
            this.name = name;
            this.level = level;
        }

        private EntityInfos(String level, String name, int index) {
            this.level = level;
            this.name = name;
            this.index = index;
        }

        public static String parseName(String level) {
            String name = null;
            for (EntityInfos item : EntityInfos.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.getLevel(), (CharSequence)level)) continue;
                name = item.getName();
                break;
            }
            return name;
        }

        public static int parseIndex(String level) {
            int index = 0;
            for (EntityInfos item : EntityInfos.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.getLevel(), (CharSequence)level)) continue;
                index = item.getIndex();
                break;
            }
            return index;
        }

        public static boolean contains(String level) {
            boolean flag = false;
            for (EntityInfos item : EntityInfos.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.getLevel(), (CharSequence)level)) continue;
                flag = true;
                break;
            }
            return flag;
        }

        public String getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

