/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.ai.gai.core.agent.tool.hander.CosmicAccessTokenAuthHandler;
import kd.ai.gai.core.agent.tool.mcp.client.HttpSseMcpSyncClient;
import kd.ai.gai.core.agent.tool.model.APIKeyAuthConfig;
import kd.ai.gai.core.agent.tool.model.AuthConfig;
import kd.ai.gai.core.agent.tool.model.AuthType;
import kd.ai.gai.core.agent.tool.model.CosmicAccessTokenAuthConfig;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.domain.dto.agent.BaseAPI;
import kd.ai.gai.core.domain.dto.agent.MCPTool;
import kd.ai.gai.core.domain.dto.mcp.SseUrlInfo;
import kd.ai.gai.core.service.agent.APIService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.mcp.spec.McpClientTransport;
import kd.ai.mcp.spec.McpSchema;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MCPService
extends APIService {
    private static final Log logger = LogFactory.getLog(MCPService.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static volatile MCPService service;

    private MCPService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MCPService getService() {
        if (service != null) return service;
        Class<MCPService> clazz = MCPService.class;
        synchronized (MCPService.class) {
            if (service != null) return service;
            service = new MCPService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    @Override
    public BaseResult callApi(String toolConfig, BaseAPI api) {
        try {
            logger.info("\u6267\u884c\u8c03\u7528MCP\u5de5\u5177\u63a5\u53e3\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)api));
            MCPTool mcpTool = (MCPTool)api;
            JSONObject toolParams = mcpTool.getToolParams();
            String operationId = toolParams.getString("operationId");
            JSONObject parameters = toolParams.getJSONObject("parameters");
            McpSchema.CallToolResult callToolResult = this.toolsCall(operationId, (Map<String, Object>)parameters, toolConfig);
            return new BaseResult(this.objectMapper.writeValueAsString((Object)callToolResult));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildUrl(String url, String toolConfig) {
        APIKeyAuthConfig apiKeyAuthConfig;
        String location;
        AuthConfig config = MCPService.parseAuthConfig(toolConfig);
        JSONObject toolConfigJo = JSONObject.parseObject((String)toolConfig);
        String at = toolConfigJo.getString("authtype");
        if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.SERVICE.getType()) && StringUtils.equalsIgnoreCase((CharSequence)(location = (apiKeyAuthConfig = (APIKeyAuthConfig)config).getLocation()), (CharSequence)"query")) {
            url = StringUtils.contains((CharSequence)url, (CharSequence)"?") ? String.format("%s&%s=%s", url, apiKeyAuthConfig.getParamName(), apiKeyAuthConfig.getParamValue()) : String.format("%s?%s=%s", url, apiKeyAuthConfig.getParamName(), apiKeyAuthConfig.getParamValue());
        }
        logger.info("buildUrl: {}", (Object)url);
        return url;
    }

    @NotNull
    private static Map<String, String> buildAuthHeaders(String toolConfig) {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        AuthConfig config = MCPService.parseAuthConfig(toolConfig);
        JSONObject toolConfigJo = JSONObject.parseObject((String)toolConfig);
        String at = toolConfigJo.getString("authtype");
        if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.SERVICE.getType())) {
            APIKeyAuthConfig apiKeyAuthConfig = (APIKeyAuthConfig)config;
            String location = apiKeyAuthConfig.getLocation();
            if (StringUtils.equalsIgnoreCase((CharSequence)location, (CharSequence)"header")) {
                headers.put(apiKeyAuthConfig.getParamName(), apiKeyAuthConfig.getParamValue());
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
            CosmicAccessTokenAuthConfig caaa = (CosmicAccessTokenAuthConfig)config;
            String clientId = caaa.getClient_id();
            String clientSecret = caaa.getClient_secret();
            String accountId = caaa.getAccountId();
            String username = caaa.getUsername();
            String tokenUrl = caaa.getTokenUrl();
            logger.info("tokenUrl:{}", (Object)tokenUrl);
            String accessToken = null;
            StringBuilder sb = new StringBuilder();
            if (tokenUrl.endsWith("api/login.do") || tokenUrl.indexOf("api/login.do") != -1) {
                logger.info("\u4f7f\u7528\u82cd\u7a796.0\u4ee5\u4e0b\u7248\u672c\u7684OpenAPI.");
                accessToken = CosmicAccessTokenAuthHandler.getAccessTokenByAppToken(sb, tokenUrl, clientId, clientSecret, accountId, username);
            } else if (tokenUrl.endsWith("oauth2/getToken") || tokenUrl.indexOf("oauth2/getToken") != -1) {
                logger.info("\u4f7f\u7528\u82cd\u7a796.0\u4ee5\u4e0a\u7248\u672c\u7684OpenAPI.");
                accessToken = CosmicAccessTokenAuthHandler.getAccessToken(tokenUrl, clientId, clientSecret, accountId, username);
            } else {
                accessToken = CosmicAccessTokenAuthHandler.getAccessToken(tokenUrl, clientId, clientSecret, accountId, username);
            }
            if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                headers.put("access_token", accessToken);
                headers.put("accesstoken", accessToken);
            }
        }
        logger.info("buildAuthHeaders: {}", (Object)JSONObject.toJSONString(headers));
        return headers;
    }

    @Override
    public BaseResult reHandlerResult(BaseResult originResult, OperationParam operationParam) {
        return null;
    }

    public McpSchema.CallToolResult toolsCall(String toolName, Map<String, Object> parameters, String toolConfig) {
        logger.info("\u6267\u884c\u8c03\u7528MCP\u5de5\u5177:{}\u63a5\u53e3\u53c2\u6570:{}", (Object)toolName, (Object)JSONObject.toJSONString(parameters));
        JSONObject configJo = JSONObject.parseObject((String)toolConfig);
        String url = configJo.getString("url");
        url = MCPService.buildUrl(url, toolConfig);
        Map<String, String> headers = MCPService.buildAuthHeaders(toolConfig);
        AtomicReference callToolResult = new AtomicReference();
        SseUrlInfo sseUrlInfo = this.parseUrl(url);
        if (sseUrlInfo != null) {
            HttpSseMcpSyncClient httpSseMcpSyncClient = new HttpSseMcpSyncClient();
            String finalToolName = toolName;
            Map<String, Object> finalParameters = parameters;
            httpSseMcpSyncClient.withClient(httpSseMcpSyncClient.createMcpTransport(sseUrlInfo.getBaseUri(), sseUrlInfo.getEndpoint(), headers), mcpSyncClient -> {
                try {
                    mcpSyncClient.initialize();
                    McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest(finalToolName, finalParameters);
                    callToolResult.set(mcpSyncClient.callTool(callToolRequest));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return (McpSchema.CallToolResult)callToolResult.get();
    }

    public McpSchema.ListToolsResult toolsList(String toolConfig) {
        JSONObject configJo = JSONObject.parseObject((String)toolConfig);
        String url = configJo.getString("url");
        url = MCPService.buildUrl(url, toolConfig);
        Map<String, String> headers = MCPService.buildAuthHeaders(toolConfig);
        AtomicReference listToolsResult = new AtomicReference();
        SseUrlInfo sseUrlInfo = this.parseUrl(url);
        if (sseUrlInfo != null) {
            HttpSseMcpSyncClient httpSseMcpSyncClient = new HttpSseMcpSyncClient();
            McpClientTransport mcpClientTransport = httpSseMcpSyncClient.createMcpTransport(sseUrlInfo.getBaseUri(), sseUrlInfo.getEndpoint(), headers);
            httpSseMcpSyncClient.withClient(mcpClientTransport, mcpSyncClient -> {
                try {
                    mcpSyncClient.initialize();
                    listToolsResult.set(mcpSyncClient.listTools(null));
                    logger.info("listToolsResult:{}", (Object)new ObjectMapper().writeValueAsString((Object)listToolsResult));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return (McpSchema.ListToolsResult)listToolsResult.get();
    }

    private SseUrlInfo parseUrl(String url) {
        try {
            URI uri = new URI(url);
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            String query = uri.getQuery();
            if (path == null || path.isEmpty()) {
                path = "/sse";
            }
            if (StringUtils.isNotEmpty((CharSequence)query)) {
                path = String.format("%s?%s", path, query);
            }
            String hostWithPort = host;
            if (port != -1) {
                hostWithPort = hostWithPort + ":" + port;
            }
            return new SseUrlInfo(String.format("%s://%s", uri.getScheme(), hostWithPort), path);
        }
        catch (URISyntaxException e) {
            logger.error("Invalid URL", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, OperationParam> parserOperationParam(String toolConfig, String operationId) {
        return null;
    }
}

