/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.ai.gai.core.domain.dto.agent.BaseAPI;
import kd.ai.gai.core.domain.dto.agent.ThirdOpenAPI;
import kd.ai.gai.core.service.agent.APIService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OpenAPIService
extends APIService {
    private static final Log logger = LogFactory.getLog(OpenAPIService.class);
    private static volatile OpenAPIService service;

    private OpenAPIService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenAPIService getService() {
        if (service != null) return service;
        Class<OpenAPIService> clazz = OpenAPIService.class;
        synchronized (OpenAPIService.class) {
            if (service != null) return service;
            service = new OpenAPIService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public BaseResult call(ThirdOpenAPI api) {
        logger.info("\u6267\u884c\u8c03\u7528\u7b2c\u4e09\u65b9OpenAPI\u5de5\u5177\u63a5\u53e3\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)api));
        return this.callApi(api);
    }

    public BaseResult callOpenAPITool(String toolConfig, JSONObject toolParams) {
        return this.callApi(toolConfig, new ThirdOpenAPI(null, null, toolParams));
    }

    @Override
    public Map<String, OperationParam> parserOperationParam(String toolConfig, String operationId) {
        JSONObject swagger = JSONObject.parseObject((String)toolConfig);
        String swaggerConfig = swagger.getString("swaggerSchema");
        Map<String, OperationParam> operationParamMap = OpenAPIUtils.parseOperationParam(swaggerConfig);
        return operationParamMap;
    }

    @Override
    public BaseResult callApi(String toolConfig, BaseAPI api) {
        ThirdOpenAPI thirdOpenAPI = (ThirdOpenAPI)api;
        JSONObject toolParams = thirdOpenAPI.getToolParams();
        String operationId = toolParams.getString("operationId");
        Map<String, OperationParam> operationParamMap = this.parserOperationParam(toolConfig, operationId);
        if (!operationParamMap.containsKey(operationId)) {
            BaseResult br = BaseResult.fail(String.format("\u5de5\u5177\u4e2d\u4e0d\u5b58\u5728\u540d\u4e3a%s\u7684\u63a5\u53e3", operationId));
            return br;
        }
        OperationParam operationParam = operationParamMap.get(operationId);
        return this.handlerCall(toolConfig, api, operationParam);
    }

    @Override
    public BaseResult reHandlerResult(BaseResult originResult, OperationParam operationParam) {
        return originResult;
    }
}

