/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.openapi.v3.models.MediaType;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Response;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Schema;
import kd.ai.gai.core.agent.tool.util.JsonExtractor;
import kd.ai.gai.core.agent.tool.util.JsonStructureValidator;
import kd.ai.gai.core.agent.tool.util.OpenAPIProtocolUtils;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.ai.gai.core.domain.dto.agent.AgentTool;
import kd.ai.gai.core.domain.dto.agent.BaseAPI;
import kd.ai.gai.core.domain.dto.agent.RestfulAPI;
import kd.ai.gai.core.service.agent.APIService;
import kd.ai.gai.core.service.agent.AgentToolService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RestfulAPIService
extends APIService {
    private static final Log logger = LogFactory.getLog(RestfulAPIService.class);
    private static volatile RestfulAPIService service;

    private RestfulAPIService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestfulAPIService getService() {
        if (service != null) return service;
        Class<RestfulAPIService> clazz = RestfulAPIService.class;
        synchronized (RestfulAPIService.class) {
            if (service != null) return service;
            service = new RestfulAPIService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public BaseResult call(RestfulAPI api) {
        logger.info("\u6267\u884c\u8c03\u7528\u7b2c\u4e09\u65b9RestfulAPI\u5de5\u5177\u63a5\u53e3\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)api));
        return this.callApi(api);
    }

    public BaseResult callOpenAPITool(String toolConfig, JSONObject toolParams) {
        return this.callApi(toolConfig, new RestfulAPI(null, null, toolParams));
    }

    @Override
    public Map<String, OperationParam> parserOperationParam(String toolConfig, String operationId) {
        return OpenAPIUtils.parserRestfulOperationParam(toolConfig, operationId);
    }

    @Override
    public BaseResult callApi(String toolConfig, BaseAPI api) {
        JSONObject requestBody;
        RestfulAPI restfulAPI = (RestfulAPI)api;
        JSONObject toolParams = restfulAPI.getToolParams();
        String operationId = toolParams.getString("operationId");
        Map<String, OperationParam> operationParamMap = this.parserOperationParam(toolConfig, operationId);
        if (!operationParamMap.containsKey(operationId)) {
            BaseResult br = BaseResult.fail(String.format("\u5de5\u5177\u4e2d\u4e0d\u5b58\u5728\u540d\u4e3a%s\u7684\u63a5\u53e3", operationId));
            return br;
        }
        OperationParam operationParam = operationParamMap.get(operationId);
        String contentType = operationParam.getContentType();
        if (toolParams.containsKey((Object)"requestBody") && (requestBody = toolParams.getJSONObject("requestBody")) != null) {
            requestBody.put("contentType", (Object)contentType);
        }
        return this.handlerCall(toolConfig, api, operationParam);
    }

    @Override
    public BaseResult reHandlerResult(BaseResult originResult, OperationParam operationParam) {
        String output;
        JSONObject data;
        if (StringUtils.equalsIgnoreCase((CharSequence)originResult.getErrCode(), (CharSequence)BaseResult.SUCCESS) && (data = (JSONObject)originResult.getData()) != null && JsonExtractor.isValidJson(output = data.getString("output"))) {
            String template = this.getRestfulAPIOutputParamJsonTemplate(operationParam);
            logger.info("restful api output param json template : {}", (Object)template);
            try {
                JsonStructureValidator validator = new JsonStructureValidator("\u8f93\u51fa\u53c2\u6570", "\u8fd4\u56de\u6570\u636e");
                List<JsonStructureValidator.ValidationError> errors = validator.validate(output, template);
                if (!errors.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    errors.forEach(e -> sb.append(String.format("[Path %s] %s ", e.getPath(), e.getMessage())).append(System.lineSeparator()));
                    originResult.setErrCode("-1");
                    originResult.setErrMsg(sb.toString());
                    originResult.setStatus(Boolean.FALSE);
                    Object resultObj = JSON.parse((String)output);
                    originResult.setData(resultObj);
                } else {
                    JsonNode dataNode = JsonExtractor.extractByStructure(output, template);
                    String jsonData = JsonExtractor.toJsonString(dataNode);
                    Object resultObj = JSON.parse((String)jsonData);
                    originResult.setData(resultObj);
                }
            }
            catch (Exception e2) {
                logger.error("\u89e3\u6790restful api \u8fd4\u56dejson\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f={}", (Object)e2.getMessage());
                originResult.setErrCode(BaseResult.FAILED);
            }
        }
        return originResult;
    }

    public String getRestfulAPIOutputParamJsonTemplate(OperationParam operationParam) {
        Map<String, Response> responseMap = operationParam.getResponses();
        Response response = responseMap.get("200");
        String contentType = operationParam.getContentType();
        Map<String, MediaType> mediaTypeMap = response.getContent();
        MediaType mediaType = mediaTypeMap.get(contentType);
        Schema schema = mediaType.getSchema();
        JSONObject schemaObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)schema));
        JSON outputSchema = OpenAPIProtocolUtils.getSchemaJSON(schemaObj);
        String template = JSON.toJSONString((Object)outputSchema);
        return template;
    }

    public String getRestfulAPIOutputParamJsonTemplate(String toolConfig, String operationId) {
        OperationParam operationParam = OpenAPIUtils.parserSingleRestfulOperationParam(toolConfig, operationId);
        return this.getRestfulAPIOutputParamJsonTemplate(operationParam);
    }

    public String getRestfulAPIOutputParamJsonTemplate(Long toolId, String operationId) {
        AgentTool tool = AgentToolService.getAgentTool(toolId);
        String toolConfig = tool.getConfig();
        return this.getRestfulAPIOutputParamJsonTemplate(toolConfig, operationId);
    }
}

