/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.config;

import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class GaiParamConfigService {
    public static final String KEY_NAME = "name";
    public static final String KEY_TYPE = "type";
    public static final String KEY_DESC = "desc";
    public static final String KEY_VALUE = "value";
    public static final String KEY_VALUE_TAG = "value_tag";

    private static DynamicObject getConfigDo(String name) {
        QFilter qFilter = new QFilter(KEY_NAME, "=", (Object)name);
        DynamicObject[] configDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_N2A_PARAM_CONFIG.getId(), (String)"name,type,desc,value,value_tag,creator", (QFilter[])new QFilter[]{qFilter}, (String)"id desc", (int)1);
        if (configDoArr.length > 0) {
            return configDoArr[0];
        }
        return null;
    }

    public static String getConfigValue(String name) {
        DynamicObject configDo = GaiParamConfigService.getConfigDo(name);
        if (configDo != null) {
            String value = configDo.getString(KEY_VALUE);
            String valueTag = configDo.getString(KEY_VALUE_TAG);
            return StringUtils.isNotEmpty((String)valueTag) ? valueTag : value;
        }
        return "";
    }

    public static DynamicObject save(String name, String value, String desc) {
        DynamicObject configDo = GaiParamConfigService.getConfigDo(name);
        if (configDo == null) {
            configDo = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_N2A_PARAM_CONFIG.getId());
        }
        configDo.set(KEY_NAME, (Object)name);
        configDo.set(KEY_VALUE, (Object)"");
        configDo.set(KEY_VALUE_TAG, (Object)value);
        configDo.set(KEY_DESC, (Object)desc);
        configDo.set(KEY_TYPE, (Object)"String");
        configDo.set("creator", (Object)RequestContext.get().getCurrUserId());
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{configDo});
        return saveObjs != null && saveObjs.length > 0 ? (DynamicObject)saveObjs[0] : null;
    }

    public static int delete(String name) {
        return DeleteServiceHelper.delete((String)GaiFormIdEnum.GAI_N2A_PARAM_CONFIG.getId(), (QFilter[])new QFilter(KEY_NAME, "=", (Object)name).toArray());
    }
}

