/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.embedding;

import java.util.EnumMap;
import java.util.Map;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.service.embedding.AzureEmbeddingAda002NewService;
import kd.ai.gai.core.service.embedding.AzureEmbeddingAda002Service;
import kd.ai.gai.core.service.embedding.BaiduEmbeddingService;
import kd.ai.gai.core.service.embedding.DouBaoEmbeddingLargeService;
import kd.ai.gai.core.service.embedding.DouBaoEmbeddingService;
import kd.ai.gai.core.service.embedding.EmbeddingService;
import kd.ai.gai.core.service.embedding.KingdeeEmbeddingNewService;
import kd.ai.gai.core.service.embedding.KingdeeEmbeddingService;
import kd.ai.gai.core.service.embedding.TEIEmbeddingService;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class EmbeddingServiceFactory {
    private static final Log logger = LogFactory.getLog(EmbeddingServiceFactory.class);

    public static EmbeddingService getExecutor(LLM llm, VectorMetricType metricType) {
        EmbeddingService embeddingService;
        if (metricType == VectorMetricType.L2) {
            EmbeddingService embeddingService2 = (EmbeddingService)Holder.L2_map.get((Object)llm);
            if (embeddingService2 != null) {
                return embeddingService2;
            }
        } else if (metricType == VectorMetricType.COSINE && (embeddingService = (EmbeddingService)Holder.cosine_map.get((Object)llm)) != null) {
            return embeddingService;
        }
        throw new KDBizException("\u4e0d\u652f\u6301\u7684Embedding\u6a21\u578b");
    }

    private static class Holder {
        private static final Map<LLM, EmbeddingService> L2_map = new EnumMap<LLM, EmbeddingService>(LLM.class);
        private static final Map<LLM, EmbeddingService> cosine_map;

        private Holder() {
        }

        static {
            L2_map.put(LLM.AZURE_EMBEDDING_ADA_002, new AzureEmbeddingAda002Service(LLM.AZURE_EMBEDDING_ADA_002, 1536, VectorMetricType.L2));
            L2_map.put(LLM.AZURE_EMBEDDING_ADA_002_BATCH, new AzureEmbeddingAda002NewService(LLM.AZURE_EMBEDDING_ADA_002_BATCH, 1536, VectorMetricType.L2));
            L2_map.put(LLM.KINGDEE_EMBEDDING, new KingdeeEmbeddingService(LLM.KINGDEE_EMBEDDING, 768, VectorMetricType.L2));
            L2_map.put(LLM.BAIDU_EMBEDDING_V1, new BaiduEmbeddingService(LLM.BAIDU_EMBEDDING_V1, 384, VectorMetricType.L2));
            L2_map.put(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, new BaiduEmbeddingService(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, 1024, VectorMetricType.L2));
            L2_map.put(LLM.BAIDU_EMBEDDING_TAO_8K, new BaiduEmbeddingService(LLM.BAIDU_EMBEDDING_TAO_8K, 1024, VectorMetricType.L2));
            L2_map.put(LLM.KINGDEE_EMBEDDING_NEW, new KingdeeEmbeddingNewService(LLM.KINGDEE_EMBEDDING_NEW, 1024, VectorMetricType.L2));
            L2_map.put(LLM.DOUBAO_EMBEDDING, new DouBaoEmbeddingService(LLM.DOUBAO_EMBEDDING, 2560, VectorMetricType.L2));
            L2_map.put(LLM.DOUBAO_EMBEDDING_LARGE, new DouBaoEmbeddingLargeService(LLM.DOUBAO_EMBEDDING_LARGE, 2048, VectorMetricType.L2));
            L2_map.put(LLM.SHENGTENG_EMBEDDING, new TEIEmbeddingService(LLM.SHENGTENG_EMBEDDING, 1024, VectorMetricType.L2));
            cosine_map = new EnumMap<LLM, EmbeddingService>(LLM.class);
            cosine_map.put(LLM.AZURE_EMBEDDING_ADA_002, new AzureEmbeddingAda002Service(LLM.AZURE_EMBEDDING_ADA_002, 1536, VectorMetricType.COSINE));
            cosine_map.put(LLM.AZURE_EMBEDDING_ADA_002_BATCH, new AzureEmbeddingAda002NewService(LLM.AZURE_EMBEDDING_ADA_002_BATCH, 1536, VectorMetricType.COSINE));
            cosine_map.put(LLM.KINGDEE_EMBEDDING, new KingdeeEmbeddingService(LLM.KINGDEE_EMBEDDING, 768, VectorMetricType.COSINE));
            cosine_map.put(LLM.BAIDU_EMBEDDING_V1, new BaiduEmbeddingService(LLM.BAIDU_EMBEDDING_V1, 384, VectorMetricType.COSINE));
            cosine_map.put(LLM.DOUBAO_EMBEDDING, new DouBaoEmbeddingService(LLM.DOUBAO_EMBEDDING, 2560, VectorMetricType.COSINE));
            cosine_map.put(LLM.DOUBAO_EMBEDDING_LARGE, new DouBaoEmbeddingLargeService(LLM.DOUBAO_EMBEDDING_LARGE, 2048, VectorMetricType.COSINE));
            cosine_map.put(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, new BaiduEmbeddingService(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, 1024, VectorMetricType.COSINE));
            cosine_map.put(LLM.BAIDU_EMBEDDING_TAO_8K, new BaiduEmbeddingService(LLM.BAIDU_EMBEDDING_TAO_8K, 1024, VectorMetricType.COSINE));
            cosine_map.put(LLM.KINGDEE_EMBEDDING_NEW, new KingdeeEmbeddingNewService(LLM.KINGDEE_EMBEDDING_NEW, 1024, VectorMetricType.COSINE));
            cosine_map.put(LLM.SHENGTENG_EMBEDDING, new TEIEmbeddingService(LLM.SHENGTENG_EMBEDDING, 1024, VectorMetricType.COSINE));
        }
    }
}

