/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.embedding;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.domain.llm.base.Result4Embedding;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.service.embedding.EmbeddingService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;

public class TEIEmbeddingService
extends EmbeddingService {
    public TEIEmbeddingService(LLM llm, int dimension, VectorMetricType metricType) {
        super(llm, dimension, metricType);
    }

    @Override
    public Result4Embedding resultParse(Result2User result2User) {
        String content = result2User.getContent();
        JSONArray jsonArray = this.resultAnalyzer(content);
        ArrayList<List<Float>> vectorList = new ArrayList<List<Float>>(this.getDimension());
        try {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONArray arrayItem = jsonArray.getJSONArray(i);
                List vectors = arrayItem.toJavaList(Float.class);
                vectorList.add(vectors);
            }
        }
        catch (Exception e) {
            String errorMeg = "\u89e3\u6790embedding\u670d\u52a1\u8c03\u7528\u8fd4\u56de\u503c\u53d1\u751f\u9519\u8bef\uff0c\u8fd4\u56de\u503c\uff1a" + content;
            throw new KDBizException((Throwable)e, new ErrorCode(Errors.EMBEDDING_ERROR.getCode(), errorMeg), new Object[0]);
        }
        return new Result4Embedding(result2User, vectorList, 0);
    }

    @Override
    public List<Chunk> search(List<Long> repoIdList, String text) {
        Result4Embedding result4Embedding = this.embedding(Collections.singletonList(text));
        if (!result4Embedding.getCode().equals(Errors.OK.getCode())) {
            throw new KDBizException(new ErrorCode(result4Embedding.getCode(), result4Embedding.getErrMsg()), new Object[]{result4Embedding.getErrMsg()});
        }
        return this.search(repoIdList, result4Embedding.getVectorList().get(0));
    }

    @Override
    public List<Chunk> search(List<Long> repoIdList, String text, int topK) {
        Result4Embedding result4Embedding = this.embedding(Collections.singletonList(text));
        if (!result4Embedding.getCode().equals(Errors.OK.getCode())) {
            throw new KDBizException(new ErrorCode(result4Embedding.getCode(), result4Embedding.getErrMsg()), new Object[]{result4Embedding.getErrMsg()});
        }
        return this.search(repoIdList, result4Embedding.getVectorList().get(0), topK);
    }

    @Override
    protected Map<String, Object> buildEmbeddingParam(List<String> chunkTextList) {
        HashMap<String, Object> paramList = new HashMap<String, Object>();
        paramList.put("inputs", chunkTextList);
        return paramList;
    }

    private JSONArray resultAnalyzer(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new KDBizException("embedding\u670d\u52a1\u8c03\u7528\u8fd4\u56de\u503c\u4e3a\u7a7a");
        }
        Object json = null;
        try {
            json = JSON.parse((String)content);
        }
        catch (Exception e) {
            String errorMeg = "\u89e3\u6790embedding\u670d\u52a1\u8c03\u7528\u8fd4\u56de\u503c\u53d1\u751f\u9519\u8bef\uff0c\u8fd4\u56de\u503c\uff1a" + content;
            throw new KDBizException((Throwable)e, new ErrorCode(Errors.EMBEDDING_ERROR.getCode(), errorMeg), new Object[0]);
        }
        if (json instanceof JSONArray) {
            return (JSONArray)json;
        }
        if (json instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)json;
            String error = jsonObject.getString("error");
            String errorType = jsonObject.getString("error_type");
            throw new KDBizException("embedding\u670d\u52a1\u8c03\u7528\u53d1\u751f\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + error + "\uff0c\u9519\u8bef\u7c7b\u578b\uff1a" + errorType);
        }
        throw new KDBizException("\u89e3\u6790embedding\u670d\u52a1\u8c03\u7528\u8fd4\u56de\u503c\u5f02\u5e38\uff0c\u8fd4\u56de\u503c\uff1a" + content);
    }
}

