/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.es;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.jetbrains.annotations.NotNull;

public class ESClientFactory {
    private static final Log log = LogFactory.getLog(ESClientFactory.class);
    private static ConcurrentHashMap<String, RestHighLevelClient> highLevelMap = new ConcurrentHashMap();
    private static int DEFAULT_TOTAL_FIELDS = 8000;
    private static int DEFAULT_SHARDS_NUMBER = 20;
    private static int DEFAULT_REPLICAS_NUMBER = 2;

    public static RestHighLevelClient getEsClient() throws IOException {
        RestHighLevelClient restHighLevelClient = highLevelMap.get("gaisearch");
        if (restHighLevelClient != null) {
            boolean isAlive = restHighLevelClient.ping(RequestOptions.DEFAULT);
            log.info("elasticSearch connection alive status: {} ", (Object)isAlive);
            if (isAlive) {
                return restHighLevelClient;
            }
            restHighLevelClient.close();
        }
        return highLevelMap.computeIfAbsent("gaisearch", k -> ESClientFactory.getRestHighLevelClient("gaisearch"));
    }

    private static RestHighLevelClient getRestHighLevelClient(String region) {
        String[] hostArr;
        Map<String, String> configMap = ESClientFactory.getServerConfig(region);
        String host = configMap.get("host");
        String userName = configMap.get("username");
        String pwd = configMap.get("password");
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(3);
        for (String s : hostArr = host.split(",")) {
            String[] ipAndPort = s.split(":");
            hosts.add(new HttpHost(ipAndPort[0], Integer.parseInt(ipAndPort[1]), "http"));
        }
        return ESClientFactory.createRestHighLevelClient(hosts.toArray(new HttpHost[hosts.size()]), userName, pwd);
    }

    @NotNull
    private static RestHighLevelClient createRestHighLevelClient(HttpHost[] httpHosts, String userName, String pwd) {
        if (userName != null && pwd != null) {
            String password = Encrypters.decode((String)pwd);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
            return new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                final /* synthetic */ CredentialsProvider val$credentialsProvider;
                {
                    this.val$credentialsProvider = credentialsProvider;
                }

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                    httpClientBuilder.disableAuthCaching();
                    return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                }
            }).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                    return requestConfigBuilder.setConnectTimeout(ESClientFactory.getEsConnectTimeOut()).setSocketTimeout(ESClientFactory.getEsSocketTimeOut());
                }
            }));
        }
        return new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                return requestConfigBuilder.setConnectTimeout(ESClientFactory.getEsConnectTimeOut()).setSocketTimeout(ESClientFactory.getEsSocketTimeOut());
            }
        }));
    }

    public static Map<String, String> getServerConfig(String region) {
        String password;
        String key = "elasticsearch.server." + region;
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, key + " the fulltext service is not configured."), new Object[0]);
        }
        HashMap<String, String> result = new HashMap<String, String>(12);
        Properties prop = new Properties();
        StringReader reader = new StringReader(value);
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, key + " configuration resolution error."), new Object[]{e});
        }
        String host = prop.getProperty("host");
        if (StringUtils.isEmpty((CharSequence)host)) {
            String ipStr = prop.getProperty("ip");
            if (StringUtils.isEmpty((CharSequence)ipStr)) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, key + " configuration error: ip or host can't be  all empty."), new Object[0]);
            }
            result.put("ip", ipStr.trim().toLowerCase());
            String httpPortStr = prop.getProperty("httpport");
            if (StringUtils.isEmpty((CharSequence)httpPortStr)) {
                httpPortStr = prop.getProperty("port");
                if (StringUtils.isEmpty((CharSequence)httpPortStr)) {
                    throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, key + " configuration error: port or httpport can't be all empty."), new Object[0]);
                }
                result.put("port", httpPortStr.trim());
            } else {
                result.put("httpport", httpPortStr.trim());
            }
            String serverPort = prop.getProperty("port");
            if (StringUtils.isNotEmpty((CharSequence)serverPort)) {
                result.put("port", httpPortStr.trim());
            }
            host = ipStr + ":" + httpPortStr;
        }
        result.put("host", host.trim().toLowerCase());
        String username = prop.getProperty("username");
        if (username != null) {
            result.put("username", username);
        }
        if ((password = prop.getProperty("password")) != null) {
            result.put("password", password);
        }
        String enableStr = prop.getProperty("enable", "true");
        result.put("enable", enableStr.trim().toLowerCase());
        String indexStr = prop.getProperty("index", region);
        result.put("index", indexStr.trim().toLowerCase());
        String clusterNameStr = prop.getProperty("clustername", "elasticsearch");
        result.put("clustername", clusterNameStr);
        String totalFieldsStr = prop.getProperty("totalfields", String.valueOf(DEFAULT_TOTAL_FIELDS));
        result.put("totalfields", totalFieldsStr);
        String shardsNumberStr = prop.getProperty("shardsnumber", String.valueOf(DEFAULT_SHARDS_NUMBER));
        result.put("shardsnumber", shardsNumberStr);
        String perlicasNumverStr = prop.getProperty("replicasnumber", String.valueOf(DEFAULT_REPLICAS_NUMBER));
        result.put("replicasnumber", perlicasNumverStr);
        return result;
    }

    public static Map<String, Integer> getDefaultIndexSettings() {
        HashMap<String, Integer> result = new HashMap<String, Integer>(16);
        Map<String, String> configMap = ESClientFactory.getServerConfig("gaisearch");
        result.put("index.mapping.total_fields.limit", Integer.valueOf(configMap.get("totalfields")));
        result.put("number_of_replicas", Integer.valueOf(configMap.get("replicasnumber")));
        result.put("number_of_shards", Integer.valueOf(configMap.get("shardsnumber")));
        return result;
    }

    public static int getEsConnectTimeOut() {
        return Integer.getInteger("elasticsearch.server.connectTimeOut", 30000);
    }

    public static int getEsSocketTimeOut() {
        return Integer.getInteger("elasticsearch.server.socketTimeOut", 60000);
    }
}

