/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.es;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.repo.RepoFulltextIndex;
import kd.ai.gai.core.enuz.es.ESDataType;
import kd.ai.gai.core.enuz.es.ESFilterType;
import kd.ai.gai.core.enuz.es.ESIndexType;
import kd.ai.gai.core.enuz.es.ESTokenizerType;
import kd.ai.gai.core.service.es.ESClientFactory;
import kd.ai.gai.core.service.es.ESFilterEntity;
import kd.ai.gai.core.service.es.ESQueryParam;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;

public class ESService {
    private static final Log log = LogFactory.getLog(ESService.class);
    private static final int defaultSocketTimeOut = 600;
    private static final int defaultMasterTimeOut = 3;

    private ESService() {
    }

    public static ESService getInstance() {
        return Holder.es;
    }

    public void createIndex(RestHighLevelClient client, String index, String indexType, String indexMapping) {
        Map<String, Integer> defaultIndexSettings = ESClientFactory.getDefaultIndexSettings();
        this.createIndex(client, index, indexType, defaultIndexSettings, indexMapping);
    }

    public void createIndex(RestHighLevelClient client, String index, String indexType, Map<String, Integer> indexSetting, String indexMapping) {
        log.info("creat index config info, index:{},indexType:{},indexSetting:{},indexMapping{}", new Object[]{index, indexType, indexSetting, indexMapping});
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(index);
        try {
            createIndexRequest.setMasterTimeout(TimeValue.timeValueMinutes((long)3L));
            ESClientFactory.getEsClient().indices().create(createIndexRequest.settings(indexSetting), RequestOptions.DEFAULT);
            if (StringUtils.isNotEmpty((CharSequence)indexMapping)) {
                PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{index});
                putMappingRequest.masterNodeTimeout(TimeValue.timeValueMinutes((long)3L));
                putMappingRequest.type(indexType);
                putMappingRequest.source(indexMapping, XContentType.JSON);
                AcknowledgedResponse acknowledgedResponse = client.indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
                if (!acknowledgedResponse.isAcknowledged()) {
                    throw new KDException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, "Failed to create index: " + index + acknowledgedResponse), new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            if (ex instanceof ElasticsearchException && this.isIndexExist(client, index)) {
                log.error("fullText index is ceate , delete Index");
                this.deleteIndex(client, index);
            }
            throw new KDException((Throwable)ex, GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, "Failed to create index: " + index + ex.getMessage()), new Object[0]);
        }
    }

    public boolean isIndexExist(RestHighLevelClient client, String index) {
        GetIndexRequest req = new GetIndexRequest(new String[]{index});
        try {
            return client.indices().exists(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, "Failed to create index: " + index + e.getMessage()), new Object[0]);
        }
    }

    public boolean deleteIndex(RestHighLevelClient client, String index) {
        try {
            AcknowledgedResponse ds = client.indices().delete(new DeleteIndexRequest(index), RequestOptions.DEFAULT);
            return ds.isAcknowledged();
        }
        catch (IOException e) {
            log.error(String.format("failed to execute ES delete,inde:%s", index), (Throwable)e);
            throw new KDException((Throwable)e, GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, "Failed to create index: " + index + e.getMessage()), new Object[0]);
        }
    }

    public boolean batchInsertDoc(RestHighLevelClient client, String index, List<XContentBuilder> list) {
        try {
            boolean success;
            if (list == null || list.isEmpty()) {
                return true;
            }
            BulkRequest bulkRequest = new BulkRequest();
            bulkRequest.timeout(TimeValue.timeValueSeconds((long)600L));
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (XContentBuilder source : list) {
                bulkRequest.add(new IndexRequest(index).source(source).type(ESIndexType.DOC.toString()));
            }
            BulkResponse bulkResponse = client.bulk(bulkRequest, RequestOptions.DEFAULT);
            boolean bl = success = !bulkResponse.hasFailures();
            if (!success) {
                log.error("failed to batch insert data to es:status:{},msg:{}", (Object)bulkResponse.status(), (Object)bulkResponse.buildFailureMessage());
                throw new KDException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.GAI_ES_ERR, "failed to batch insert data to es: " + bulkResponse.buildFailureMessage()), new Object[0]);
            }
            return true;
        }
        catch (IOException e) {
            log.error("failed to batch insert data to es msg:{}", (Object)e.getMessage(), (Object)e);
            throw new KDException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.GAI_ES_ERR, "failed to batch insert data to es: " + e.getMessage()), new Object[]{e});
        }
    }

    public long deleteByQuery(RestHighLevelClient client, String index, String indexType, QueryBuilder filterQb) {
        DeleteByQueryRequest req = new DeleteByQueryRequest(new String[]{index});
        req.setTimeout(TimeValue.timeValueSeconds((long)600L));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.typeQuery((String)indexType));
        queryBuilder.must(filterQb);
        ((DeleteByQueryRequest)req.setQuery((QueryBuilder)queryBuilder).setRefresh(true)).indices(new String[]{index});
        BulkByScrollResponse res = null;
        try {
            res = client.deleteByQuery(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
        return res.getDeleted();
    }

    public SearchHits search(RestHighLevelClient client, SearchRequest request) {
        try {
            RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
            builder.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(0x40000000));
            RequestOptions requestOptions = builder.build();
            return client.search(request, requestOptions).getHits();
        }
        catch (IOException e) {
            log.error("failed to execute ES search", (Throwable)e);
            throw new KDException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.GAI_ES_ERR, "failed search data to es: " + e.getMessage()), new Object[]{e});
        }
    }

    public long queryCountByIndexName(RestHighLevelClient client, String indexName) {
        try {
            CountRequest countRequest = new CountRequest(new String[]{indexName});
            CountResponse countResponse = client.count(countRequest, RequestOptions.DEFAULT);
            return countResponse.getCount();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, "Failed to query count index: " + indexName + e.getMessage()), new Object[0]);
        }
    }

    public SearchRequest buildSearchRequest(ESQueryParam queryParams) {
        String index = queryParams.getIndexName();
        SearchRequest request = new SearchRequest(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        List<ESFilterEntity> paramsFilters = queryParams.getFilters();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (ESFilterEntity e : paramsFilters) {
            Object filterValue = e.getFilterValue();
            if (ESFilterType.MATCH == e.getFilterType()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)e.getFilterKey(), (Object)filterValue));
                continue;
            }
            if (ESFilterType.TERMS == e.getFilterType()) {
                if (filterValue instanceof List) {
                    Object[] objects = ((List)filterValue).toArray();
                    boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)e.getFilterKey(), (Object[])objects));
                    continue;
                }
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)e.getFilterKey(), (Object[])new Object[]{filterValue}));
                continue;
            }
            throw new KDBizException(GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.REPO_FT_ERR, String.format("not found ESFilterType: %s ", new Object[]{e.getFilterType()})), new Object[0]);
        }
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)queryParams.getSort()).order(queryParams.getOrder());
        String[] returnFields = queryParams.getReturnFields();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder).fetchSource(returnFields, null).sort((SortBuilder)sortBuilder).size(queryParams.getTopK());
        request.types(new String[]{queryParams.getIndexType()});
        request.source(searchSourceBuilder);
        return request;
    }

    public String buildMappingIndex(String type, RepoFulltextIndex ... fulltextIndexs) {
        StringBuilder paramSb = new StringBuilder();
        paramSb.append("{\"");
        paramSb.append(type);
        paramSb.append("\":{ \"properties\": { ");
        int i = 0;
        int len = fulltextIndexs.length;
        for (RepoFulltextIndex fieldIndexInfo : fulltextIndexs) {
            String filedType = fieldIndexInfo.getDataType().toString();
            String filedName = fieldIndexInfo.getName();
            String fieldTokenizer = fieldIndexInfo.getTokenizerType().toString();
            if (ESDataType.STRING.toString().equals(filedType)) {
                if (ESTokenizerType.STANDARD.toString().endsWith(fieldTokenizer)) {
                    paramSb.append('\"');
                    paramSb.append(filedName);
                    paramSb.append("\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\"}}}");
                } else if (ESTokenizerType.IKMAXWORD.toString().endsWith(fieldTokenizer)) {
                    paramSb.append('\"');
                    paramSb.append(filedName);
                    paramSb.append("\":{\"type\":\"text\",\"analyzer\":\"");
                    paramSb.append(fieldTokenizer);
                    paramSb.append("\",\"fields\":{\"keyword\":{\"type\":\"keyword\"}}}");
                } else if (ESTokenizerType.IKSMART.toString().equalsIgnoreCase(fieldTokenizer)) {
                    paramSb.append('\"');
                    paramSb.append(filedName);
                    paramSb.append("\":{\"type\":\"text\",\"analyzer\":\"");
                    paramSb.append(fieldTokenizer);
                    paramSb.append("\",\"fields\":{\"keyword\":{\"type\":\"keyword\"}}}");
                } else {
                    paramSb.append('\"');
                    paramSb.append(filedName);
                    paramSb.append("\":{\"type\":\"keyword\",\"index\":\"true\"}");
                }
            } else {
                paramSb.append('\"');
                paramSb.append(filedName);
                paramSb.append("\":{\"type\":\"");
                paramSb.append(filedType);
                paramSb.append("\"}");
            }
            if (i < len - 1) {
                paramSb.append(',');
            }
            ++i;
        }
        paramSb.append("}}}");
        return paramSb.toString();
    }

    private static class Holder {
        private static ESService es = new ESService();

        private Holder() {
        }
    }
}

