/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.AliLlmParam;
import kd.ai.gai.core.domain.llm.PromptBuildParam;
import kd.ai.gai.core.domain.llm.base.AliLlmParamInput;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmRole;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AliQWService
extends LlmService<AliLlmParam> {
    private static final Log logger = LogFactory.getLog(AliQWService.class);
    private String botEnsure = "\u6211\u4f1a\u786e\u4fdd\u9996\u5148\u4e25\u683c\u9075\u5b88\u4ee5\u4e0a\u63d0\u793a\u3002";

    public AliQWService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(PromptBuildParam promptBuildParam) {
        boolean stream = promptBuildParam.isStream();
        Boolean reference = promptBuildParam.getReference();
        String systemPromptTemplate = promptBuildParam.getSystemPromptTemplate();
        Map<String, String> variableMap = promptBuildParam.getVariableMap();
        List<UserHistoryMessage> history = promptBuildParam.getHistory();
        List<Chunk> chunkList = promptBuildParam.getChunkList();
        String userInput = promptBuildParam.getUserInput();
        String customParamJson = promptBuildParam.getCustomParamJson();
        logger.info("\u6784\u5efaAliQWService\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = AliQWService.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(reference, systemContent, chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = reference == null ? systemContent + context : context;
        int tokenCount = 0;
        tokenCount = this.getTokenCount(systemContent) + this.getTokenCount(context);
        int total = userInput.length() + systemContent.length() + context.length();
        if (total > this.getInputLimit()) {
            logger.info("\u8f93\u5165\u53ef\u80fd\u8d85\u957f,\u8bf7\u5173\u6ce8\uff1a{}", (Object)total);
        }
        ArrayList<MessageItem4AzureBaiduTencentXf> list = new ArrayList<MessageItem4AzureBaiduTencentXf>(16);
        MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
        messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
        messageItem4AzureBaiduTencentXf.setContent(userInput);
        tokenCount += this.getTokenCount(userInput);
        list.add(messageItem4AzureBaiduTencentXf);
        if (history != null && !history.isEmpty()) {
            Collections.reverse(history);
            for (UserHistoryMessage item : history) {
                MessageItem4AzureBaiduTencentXf lastItem = (MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1);
                LlmRole lastRole = lastItem.getRole();
                if (StringUtils.isNotEmpty((CharSequence)item.getAssistant())) {
                    if (lastRole == LlmRole.assistant || (total += item.getAssistant().length()) > this.getInputLimit()) break;
                    tokenCount += this.getTokenCount(item.getAssistant());
                    messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                    messageItem4AzureBaiduTencentXf.setRole(LlmRole.assistant);
                    messageItem4AzureBaiduTencentXf.setContent(item.getAssistant());
                    list.add(messageItem4AzureBaiduTencentXf);
                    continue;
                }
                if (lastRole == LlmRole.user || (total += item.getUser().length()) > this.getInputLimit()) break;
                tokenCount += this.getTokenCount(item.getUser());
                messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
                messageItem4AzureBaiduTencentXf.setContent(item.getUser());
                list.add(messageItem4AzureBaiduTencentXf);
            }
        }
        messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
        messageItem4AzureBaiduTencentXf.setRole(LlmRole.system);
        messageItem4AzureBaiduTencentXf.setContent(systemContent);
        list.add(messageItem4AzureBaiduTencentXf);
        if (reference == null && !StringUtils.isEmpty((CharSequence)context)) {
            messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
            messageItem4AzureBaiduTencentXf.setRole(LlmRole.system);
            messageItem4AzureBaiduTencentXf.setContent(context);
            list.add(messageItem4AzureBaiduTencentXf);
        }
        Collections.reverse(list);
        AliLlmParam aliLlmParam = new AliLlmParam();
        aliLlmParam.setInPutToken(tokenCount);
        aliLlmParam.setStream(stream);
        AliLlmParamInput aliLlmParamInput = new AliLlmParamInput();
        aliLlmParamInput.setMessages(list);
        aliLlmParam.setInput(aliLlmParamInput);
        return aliLlmParam;
    }

    @Override
    public ModelResult getResult(ModelResultParam modelResultParam) {
        boolean stream = modelResultParam.isStream();
        String result = modelResultParam.getResult();
        ModelResult modelResult = new ModelResult();
        if (stream) {
            if (StringUtils.isEmpty((CharSequence)result)) {
                modelResult.setContent("");
                return modelResult;
            }
            String string = result = result.startsWith("data: ") ? result.substring(6) : result;
            if (JSONPath.contains((Object)result, (String)"$.prompt_filter_results")) {
                modelResult.setContent("");
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.output.text")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.output.text", String.class);
                modelResult.setContent(msg == null ? "" : msg);
                return modelResult;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return modelResult;
            }
            throw new KDBizException((Object)((Object)this.getLlm()) + "\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        if (StringUtils.isEmpty((CharSequence)result) || !JSONPath.contains((Object)result, (String)"$.output.text")) {
            throw new KDBizException((Object)((Object)this.getLlm()) + "\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        modelResult.setContent((String)JSONPath.read((String)result, (String)"$.output.text", String.class));
        return modelResult;
    }

    @Override
    public int getTokenCount(String text) {
        return (int)Math.ceil((double)GaiUtils.countEnglishWords(text) * 1.3) + GaiUtils.countChineseCharacters(text);
    }

    @Override
    public JSONObject getTypeParam(LlmStyle llmStyle) {
        AliLlmParam aliLlmParam = new AliLlmParam();
        JSONObject reultJson = aliLlmParam.getDefaultTypeParam(llmStyle);
        return reultJson;
    }
}

