/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.AzureLlmParam;
import kd.ai.gai.core.domain.llm.PromptBuildParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmRole;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.util.TokenUtil;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class Azure40Service
extends LlmService<AzureLlmParam> {
    private static final Log logger = LogFactory.getLog(Azure40Service.class);

    public Azure40Service(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(PromptBuildParam promptBuildParam) {
        String user = promptBuildParam.getUser();
        boolean stream = promptBuildParam.isStream();
        Boolean reference = promptBuildParam.getReference();
        String systemPromptTemplate = promptBuildParam.getSystemPromptTemplate();
        Map<String, String> variableMap = promptBuildParam.getVariableMap();
        List<UserHistoryMessage> history = promptBuildParam.getHistory();
        List<Chunk> chunkList = promptBuildParam.getChunkList();
        String userInput = promptBuildParam.getUserInput();
        String customParamJson = promptBuildParam.getCustomParamJson();
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        AzureLlmParam azureGptParam = new AzureLlmParam(promptBuildParam.getLlmStyle(), customParamJson);
        azureGptParam.setStream(stream);
        azureGptParam.setUser(user);
        ArrayList<MessageItem4AzureBaiduTencentXf> list = new ArrayList<MessageItem4AzureBaiduTencentXf>(16);
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = Azure40Service.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(reference, systemContent, chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = reference == null ? systemContent + context : context;
        String tools = variableMap.get("function");
        int tokenCount = this.getTokenCount(systemContent) + this.getTokenCount(context);
        int total = userInput.length() + systemContent.length() + context.length();
        if (total > this.getInputLimit()) {
            logger.info("\u8f93\u5165\u53ef\u80fd\u8d85\u957f,\u8bf7\u5173\u6ce8\uff1a{}", (Object)total);
        }
        MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
        if (userInput.startsWith("functioncall")) {
            String name = userInput.split("&")[1];
            userInput = userInput.split("&")[2];
            messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
            messageItem4AzureBaiduTencentXf.setName(name);
        } else {
            messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
        }
        messageItem4AzureBaiduTencentXf.setContent(userInput);
        tokenCount += this.getTokenCount(userInput);
        list.add(messageItem4AzureBaiduTencentXf);
        if (history != null && !history.isEmpty()) {
            Collections.reverse(history);
            for (UserHistoryMessage item : history) {
                MessageItem4AzureBaiduTencentXf lastItem = (MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1);
                LlmRole lastRole = lastItem.getRole();
                if (kd.bos.util.StringUtils.isNotEmpty((String)item.getAssistant())) {
                    if (LlmRole.assistant == lastRole || (total += item.getAssistant().length()) > this.getInputLimit()) break;
                    tokenCount += this.getTokenCount(item.getAssistant());
                    messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                    messageItem4AzureBaiduTencentXf.setRole(LlmRole.assistant);
                    messageItem4AzureBaiduTencentXf.setContent(item.getAssistant());
                    list.add(messageItem4AzureBaiduTencentXf);
                    continue;
                }
                if (LlmRole.user == lastRole || (total += item.getUser().length()) > this.getInputLimit()) break;
                tokenCount += this.getTokenCount(item.getUser());
                messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
                messageItem4AzureBaiduTencentXf.setContent("########" + item.getUser() + "########");
                list.add(messageItem4AzureBaiduTencentXf);
            }
        }
        if (reference == null && !kd.bos.util.StringUtils.isEmpty((String)context)) {
            messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
            messageItem4AzureBaiduTencentXf.setRole(LlmRole.system);
            messageItem4AzureBaiduTencentXf.setContent(context);
            list.add(messageItem4AzureBaiduTencentXf);
        }
        messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
        messageItem4AzureBaiduTencentXf.setRole(LlmRole.system);
        messageItem4AzureBaiduTencentXf.setContent(systemContent);
        list.add(messageItem4AzureBaiduTencentXf);
        Collections.reverse(list);
        azureGptParam.setInPutToken(tokenCount);
        azureGptParam.setMessages(list);
        JSONArray function = new JSONArray();
        if (tools != null && tools.length() > 0) {
            JSONArray jsonArray = JSONArray.parseArray((String)tools);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject tool = jsonArray.getJSONObject(i);
                JSONObject toolFunction = new JSONObject();
                toolFunction.put("type", (Object)"function");
                toolFunction.put("function", (Object)tool);
                function.add((Object)toolFunction);
            }
            azureGptParam.setTools(function);
        }
        return azureGptParam;
    }

    @Override
    public ModelResult getResult(ModelResultParam modelResultParam) {
        boolean stream = modelResultParam.isStream();
        String result = modelResultParam.getResult();
        ModelResult modelResult = new ModelResult();
        if (stream) {
            if (kd.bos.util.StringUtils.isEmpty((String)result)) {
                modelResult.setContent("");
                return modelResult;
            }
            String string = result.startsWith("data:") ? (result.indexOf("{") != -1 ? result.substring(result.indexOf("{")) : result) : (result = result);
            if (JSONPath.contains((Object)result, (String)"$.prompt_filter_results")) {
                modelResult.setContent("");
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.choices") && (Integer)JSONPath.read((String)result, (String)"$.choices.size()", Integer.TYPE) == 0) {
                modelResult.setContent("");
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.choices[0].delta")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.content", String.class);
                if (msg == null && JSONPath.contains((Object)result, (String)"$.choices[0].delta.tool_calls[0]") && JSONPath.contains((Object)result, (String)"$.choices[0].delta.tool_calls[0].function")) {
                    String msgArguments;
                    if (msg == null && JSONPath.contains((Object)result, (String)"$.choices[0].delta.tool_calls[0].function.name") && (msg = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.tool_calls[0].function.name", String.class)) != null) {
                        msg = "function.name&" + msg;
                    }
                    if (JSONPath.contains((Object)result, (String)"$.choices[0].delta.tool_calls[0].function.arguments") && (msgArguments = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.tool_calls[0].function.arguments", String.class)) != null && msgArguments.length() > 0) {
                        msg = (msg != null ? msg : "") + "function.arguments&" + msgArguments;
                    }
                }
                modelResult.setContent(msg == null ? "" : msg);
                return modelResult;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.choices")) {
                modelResult.setContent("");
                return modelResult;
            }
            throw new KDBizException("azure40\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        if (JSONPath.contains((Object)result, (String)"$.choices[0].message.tool_calls[0]")) {
            String msg = (String)JSONPath.read((String)result, (String)"$.choices[0].message.tool_calls[0]", String.class);
            modelResult.setContent(msg == null ? "" : msg);
            return modelResult;
        }
        if (!JSONPath.contains((Object)result, (String)"$.choices[0].message.content")) {
            throw new KDBizException("azure40\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        modelResult.setContent((String)JSONPath.read((String)result, (String)"$.choices[0].message.content", String.class));
        return modelResult;
    }

    @Override
    public int getTokenCount(String text) {
        return TokenUtil.c100Tokenizer.countTokens(text);
    }

    @Override
    public JSONObject getTypeParam(LlmStyle llmStyle) {
        AzureLlmParam azureLlmParam = new AzureLlmParam();
        JSONObject reultJson = azureLlmParam.getDefaultTypeParam(llmStyle);
        return reultJson;
    }
}

